/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class SubjectCleanup {
    public static List<MatchTuple> match(List<Subject> schedulerSubjectList, List<EmpiSubjectDto.Patient> empiSubjectList, String institution) {
        ArrayList matchTuples = Lists.newArrayList();
        if (schedulerSubjectList.isEmpty()) {
            schedulerSubjectList.add(null);
        }
        if (empiSubjectList.isEmpty()) {
            empiSubjectList.add(null);
        }
        for (Subject schedulerSubject : schedulerSubjectList) {
            for (EmpiSubjectDto.Patient empiSubject : empiSubjectList) {
                matchTuples.add(new MatchTuple(schedulerSubject, empiSubject, SubjectCleanup.match(schedulerSubject, empiSubject, institution)));
            }
        }
        return matchTuples;
    }

    public static MatchType match(Subject schedulerSubject, EmpiSubjectDto.Patient empiPatient, String institution) {
        MatchType result = schedulerSubject == null && empiPatient == null ? MatchType.bothNull : (empiPatient == null ? MatchType.schedulerOnly : (schedulerSubject == null ? MatchType.empiOnly : (SubjectCleanup.mrnsMatch(schedulerSubject, empiPatient, institution) ? MatchType.exactMatch : (SubjectCleanup.partialMatchOrBetter(schedulerSubject, empiPatient, institution) ? MatchType.partialMatch : MatchType.noMatch))));
        return result;
    }

    static boolean mrnsMatch(Subject schedulerSubject, EmpiSubjectDto.Patient empiPatient, String institution) {
        Predicate<EmpiSubjectDto.Mrn> mrnPredicate = m -> {
            boolean result = m.getSite().equalsIgnoreCase(institution) && m.getValue().equals(schedulerSubject.getMrn(institution));
            return result;
        };
        Optional<EmpiSubjectDto.Mrn> empiMrnOptional = empiPatient.getMrns().getMrnList().stream().filter(mrnPredicate).findFirst();
        return empiMrnOptional.isPresent();
    }

    static boolean partialMatchOrBetter(Subject schedulerSubject, EmpiSubjectDto.Patient empiPatient, String institution) {
        String empiDob = empiPatient.getDobString();
        String empiLastName = empiPatient.getName().getLast();
        String schedulerDob = DateUtility.format(DateUtility.monthDayYear(), schedulerSubject.getBirthdate());
        String schedulerLastName = schedulerSubject.getLastName();
        return empiDob.equalsIgnoreCase(schedulerDob) && empiLastName.equalsIgnoreCase(schedulerLastName);
    }

    public static class MatchTuple {
        Subject schedulerSubject;
        EmpiSubjectDto.Patient empiSubject;
        MatchType matchType;

        public MatchTuple(Subject schedulerSubject, EmpiSubjectDto.Patient empiSubject, MatchType matchType) {
            this.schedulerSubject = schedulerSubject;
            this.empiSubject = empiSubject;
            this.matchType = matchType;
        }

        public Subject getSchedulerSubject() {
            return this.schedulerSubject;
        }

        public EmpiSubjectDto.Patient getEmpiSubject() {
            return this.empiSubject;
        }

        public MatchType getMatchType() {
            return this.matchType;
        }
    }

    public static enum MatchType {
        schedulerOnly,
        empiOnly,
        exactMatch,
        partialMatch,
        bothNull,
        noMatch;

    }
}

