/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service.cleanup;

import com.google.common.base.Joiner;
import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.service.cleanup.SubjectEmpiFieldMatcher;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MrnMatcher
extends SubjectEmpiFieldMatcher {
    public MrnMatcher(Subject schedulerSubject, EmpiSubjectDto.Patient empiSubject) {
        super(10.0f, schedulerSubject, empiSubject);
    }

    @Override
    SubjectEmpiFieldMatcher.MatchInfo computeMatchInfo(String institution) {
        Predicate<EmpiSubjectDto.Mrn> mrnExactPredicate = m -> m.getSite().equalsIgnoreCase(institution) && m.getValue().equals(this.schedulerSubject.getMrn(institution));
        Predicate<EmpiSubjectDto.Mrn> mrnPartialPredicate = m -> m.getValue().equalsIgnoreCase(this.schedulerSubject.getMrn(institution));
        List mrnStringList = this.empiSubject.getMrns().getMrnList().stream().map(mrn -> mrn.getValue() + "." + mrn.getSite()).collect(Collectors.toList());
        String mrnCommaList = Joiner.on((String)",").join(mrnStringList);
        Optional<EmpiSubjectDto.Mrn> empiMrnOptional = this.empiSubject.getMrns().getMrnList().stream().filter(mrnExactPredicate).findFirst();
        if (empiMrnOptional.isPresent()) {
            this.matchInfo.setPoints(Float.valueOf(this.weightedPoints(100.0f)));
            this.matchInfo.setMatchLabel("Exact Match!");
        } else {
            empiMrnOptional = this.empiSubject.getMrns().getMrnList().stream().filter(mrnPartialPredicate).findFirst();
            if (empiMrnOptional.isPresent()) {
                this.matchInfo.setPoints(Float.valueOf(this.weightedPoints(50.0f)));
                this.matchInfo.setComment(mrnCommaList + " (empi) vs (sched) " + this.schedulerSubject.getMrn(institution));
                this.matchInfo.setMatchLabel("Partial Match");
            } else {
                this.matchInfo.setComment(mrnCommaList + " (empi) vs (sched) " + this.schedulerSubject.getMrn(institution));
                this.matchInfo.setMatchLabel("No Match");
            }
        }
        return this.matchInfo;
    }
}

