/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.security;

import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class SchedulerUserDetails
implements UserDetails {
    private User user;
    private UserSession userSession;
    private List<GrantedAuthority> authorities;

    public SchedulerUserDetails(User user, UserSession userSession) {
        this.user = user;
        this.userSession = userSession;
        this.authorities = this.initAuthorities(user);
    }

    private List<GrantedAuthority> initAuthorities(User user) {
        ArrayList<GrantedAuthority> authList = new ArrayList<GrantedAuthority>();
        authList.add(user.getInstitutionRole().getType());
        return authList;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public User getUser() {
        return this.user;
    }

    public UserSession getUserSession() {
        return this.userSession;
    }

    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getEcommonsId();
    }

    public boolean isAccountNonExpired() {
        return this.user.getActive();
    }

    public boolean isAccountNonLocked() {
        return this.user.getActive();
    }

    public boolean isCredentialsNonExpired() {
        return this.user.getActive();
    }

    public boolean isEnabled() {
        return this.user.getActive();
    }

    public String getSalt() {
        return this.user.getSalt();
    }
}

