/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import edu.harvard.catalyst.scheduler.dto.DTO;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;

public class VisitRenderSummaryDTO
extends DTO {
    private String id;
    private String localId;
    private String piName;
    private String visitName;
    private String room;
    private String title;
    private String startDate;
    private String endDate;
    private String className;
    private boolean inpatientVisitType;
    private boolean allDay;

    public VisitRenderSummaryDTO(BookedVisit bookedVisit, String className, boolean homeScreen) {
        this.className = className;
        this.room = bookedVisit.getRooms() == null ? "" : bookedVisit.getRooms();
        this.title = bookedVisit.getSubjectMrn() != null ? SubjectDataEncryptor.decrypt(bookedVisit.getSubjectMrn().getSubject().getLastName()) : "No Subject Assigned";
        this.id = bookedVisit.getId().toString();
        this.localId = bookedVisit.getStudy().getLocalId();
        this.piName = bookedVisit.getStudy().getInvestigatorLastNameOrNA();
        this.visitName = bookedVisit.getName();
        this.startDate = DateUtility.format(DateUtility.dateHourMinSec(), bookedVisit.getScheduledStartTime());
        this.endDate = DateUtility.format(DateUtility.dateHourMinSec(), bookedVisit.getScheduledEndTime());
        this.inpatientVisitType = bookedVisit.getVisitTemplate().getVisitType().isInpatient();
        this.allDay = homeScreen && bookedVisit.getVisitType().isInpatient();
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAllDay() {
        return this.allDay;
    }

    public String getId() {
        return this.id;
    }

    public String getRoom() {
        return this.room;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getPiName() {
        return this.piName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public boolean isInpatientVisitType() {
        return this.inpatientVisitType;
    }
}

