/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.gson.Gson;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;

public final class GanttEventsResponseDTO
extends GanttResponseDTO {
    private final List<GanttEventDetail> ganttEventDetailList;

    public List<GanttEventDetail> getGanttEventDetailList() {
        return this.ganttEventDetailList;
    }

    public GanttEventsResponseDTO(List<TemplateResource> allTemplateResourcesFromVisit, Predicate<? super TemplateResource> relevancePredicate) {
        List<TemplateResource> relevantTemplateResourcesFromVisit = this.getRelevantTemplateResources(allTemplateResourcesFromVisit, relevancePredicate);
        this.ganttEventDetailList = RichList.enrich(relevantTemplateResourcesFromVisit).map(tr -> new GanttEventDetail((TemplateResource)tr)).toList();
    }

    @Override
    public String jsonify(Gson gson) {
        return gson.toJson(this.ganttEventDetailList);
    }

    public static final class GanttEventDetail {
        private final int id;
        private final int resourceId;
        private final String resourceName;
        private final String groupId;
        private final Boolean billable;
        private final Boolean alternate;
        private final Boolean floatable;
        private final Boolean flexible;
        private final String annotations;
        private final String start;
        private final String end;
        private final String displayStart;
        private final String displayEnd;
        private final int duration;
        private final Integer floatStart;
        private final Integer floatEnd;
        private String displayFloatStart = "";
        private String displayFloatEnd = "";
        private Date floatStartPreferred = null;
        private Date floatEndPreferred = null;
        private Date floatStartDate = null;
        private final String color;

        GanttEventDetail(TemplateResource templateResource) {
            if (templateResource == null || templateResource.getResource() == null) {
                SchedulerRuntimeException.logAndThrow("TemplateResource and Resource should be non-null");
            }
            Resource itsResource = templateResource.getResource();
            this.id = templateResource.getId();
            this.billable = templateResource.getBillable();
            this.alternate = templateResource.getAlternate();
            boolean isGrouped = templateResource.getGroupId() != null;
            this.resourceId = isGrouped ? this.id : itsResource.getId();
            this.resourceName = itsResource.getName();
            this.groupId = templateResource.getGroupId();
            this.floatable = templateResource.getFloatable();
            this.flexible = templateResource.getFlexible();
            this.annotations = templateResource.getAnnotations();
            boolean isFloatable = templateResource.getFloatable();
            this.floatStart = DateUtility.minutesIntoDay(templateResource.getStartMinutes());
            this.floatEnd = DateUtility.minutesIntoDay(templateResource.getEndMinutes());
            this.duration = templateResource.getDuration();
            Date templateResourceStartDate = templateResource.getStartDate();
            Date templateResourceEndDate = templateResource.getEndDate();
            templateResourceEndDate.setSeconds(59);
            String startDate = DateUtility.format(DateUtility.dateHourMinSec(), templateResourceStartDate);
            String endDate = DateUtility.format(DateUtility.dateHourMinSec(), templateResourceEndDate);
            this.displayStart = this.dateToDisplayDate(templateResourceStartDate);
            this.displayEnd = this.dateToDisplayDate(templateResourceEndDate);
            if (isFloatable) {
                int startDays = DateUtility.convertMinutesToStartDayZeroOffset(templateResource.getFloatStart());
                int startHours = DateUtility.convertMinutesToHourInDay(templateResource.getFloatStart());
                int startMinutes = DateUtility.convertTotalMinutesToMinutesInHour(templateResource.getFloatStart());
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(DateUtility.TEMPLATE_RESOURCE_DATE_ORIGIN);
                startCalendar.add(5, startDays);
                startCalendar.set(11, startHours);
                startCalendar.add(12, startMinutes);
                Date startTime = startCalendar.getTime();
                int endDays = DateUtility.convertMinutesToStartDayZeroOffset(templateResource.getFloatEnd());
                int endHours = DateUtility.convertMinutesToHourInDay(templateResource.getFloatEnd());
                int endMinutes = DateUtility.convertTotalMinutesToMinutesInHour(templateResource.getFloatEnd());
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.setTime(DateUtility.TEMPLATE_RESOURCE_DATE_ORIGIN);
                endCalendar.add(5, endDays);
                endCalendar.set(11, endHours);
                endCalendar.add(12, endMinutes);
                endCalendar.add(13, 59);
                Date endTime = endCalendar.getTime();
                this.floatStartDate = startTime;
                this.floatStartPreferred = templateResource.getStartDate();
                this.floatEndPreferred = templateResource.getEndDate();
                startDate = DateUtility.format(DateUtility.dateHourMinSec(), startTime);
                endDate = DateUtility.format(DateUtility.dateHourMinSec(), endTime);
                this.displayFloatStart = this.dateToDisplayDate(DateUtility.minutesFromOriginToDate(templateResource.getFloatStart().intValue()));
                this.displayFloatEnd = this.dateToDisplayDate(DateUtility.minutesFromOriginToDate(templateResource.getFloatEnd().intValue()));
            }
            this.start = startDate;
            this.end = endDate;
            boolean isFlexible = templateResource.getFlexible();
            this.color = isFloatable ? "#D8BFD8" : (isFlexible ? "#7EB035" : "#F8931D");
        }

        String dateToDisplayDate(Date date) {
            return "Day " + DateUtility.dateToDayNumber(date) + " : " + DateUtility.format(DateUtility.hourMin(), date);
        }
    }
}

