/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Country;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.GenderType;
import edu.harvard.catalyst.scheduler.entity.Race;
import edu.harvard.catalyst.scheduler.entity.State;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import edu.harvard.catalyst.scheduler.web.BaseResource;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="subject")
public class Subject
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String firstName;
    private String middleName;
    private String lastName;
    private String fullName;
    private Ethnicity ethnicity;
    private Date birthdate;
    private Race race;
    private Gender gender;
    private String genderEmpi;
    private GenderType genderType;
    private String streetAddress1;
    private String streetAddress2;
    private String city;
    private State state;
    private String zip;
    private String comment;
    private Country country;
    private String primaryContactNumber;
    private String secondaryContactNumber;
    private Date createdDate;
    private boolean secure;
    private boolean active;
    private Date latestSsotRefresh;
    private String puid;
    private ArchivalStatus archivalStatus;
    @BaseResource.Exclude
    private Set<SubjectMrn> subjectMrnSet = new HashSet<SubjectMrn>();

    public static Subject defensiveCopy(Subject original) {
        Subject copy = new Subject();
        copy.id = original.id;
        copy.firstName = original.firstName;
        copy.middleName = original.middleName;
        copy.lastName = original.lastName;
        copy.fullName = original.fullName;
        copy.ethnicity = original.ethnicity;
        copy.birthdate = original.birthdate;
        copy.race = original.race;
        copy.gender = original.gender;
        copy.genderEmpi = original.genderEmpi;
        copy.genderType = original.genderType;
        copy.streetAddress1 = original.streetAddress1;
        copy.streetAddress2 = original.streetAddress2;
        copy.city = original.city;
        copy.state = original.state;
        copy.zip = original.zip;
        copy.comment = original.comment;
        copy.country = original.country;
        copy.primaryContactNumber = original.primaryContactNumber;
        copy.secondaryContactNumber = original.secondaryContactNumber;
        copy.createdDate = original.createdDate;
        copy.secure = original.secure;
        copy.active = original.active;
        copy.latestSsotRefresh = original.latestSsotRefresh;
        copy.archivalStatus = original.archivalStatus;
        copy.subjectMrnSet = new HashSet<SubjectMrn>(original.getSubjectMrnSet());
        copy.puid = original.puid;
        return copy;
    }

    public Subject() {
        super(null);
    }

    public Subject(String dummyValue) {
        super(0);
        this.race = new Race();
        this.gender = new Gender();
        this.genderType = GenderType.UNREPORTED;
        this.genderEmpi = dummyValue;
        this.ethnicity = new Ethnicity();
        this.state = new State();
        this.country = new Country();
        this.secure = false;
        this.active = false;
        this.birthdate = new Date();
        this.latestSsotRefresh = new Date();
        this.createdDate = new Date();
        this.firstName = dummyValue;
        this.middleName = dummyValue;
        this.lastName = dummyValue;
        this.fullName = dummyValue;
        this.streetAddress1 = dummyValue;
        this.streetAddress2 = dummyValue;
        this.city = dummyValue;
        this.zip = dummyValue;
        this.comment = dummyValue;
        this.primaryContactNumber = dummyValue;
        this.secondaryContactNumber = dummyValue;
        this.archivalStatus = null;
    }

    @Column(name="first_name")
    @Basic(optional=false)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="middle_name")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Column(name="last_name")
    @Basic(optional=false)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="full_name")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Column(name="birthdate")
    @Basic(optional=false)
    public Date getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    @JoinColumn(name="ethnicity", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Ethnicity getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(Ethnicity ethnicity) {
        this.ethnicity = ethnicity;
    }

    @JoinColumn(name="gender", referencedColumnName="id")
    @ManyToOne(optional=false)
    @Basic(optional=false)
    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @Column(name="gender_enum")
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    public GenderType getGenderType() {
        return this.genderType;
    }

    public void setGenderType(GenderType genderType) {
        this.genderType = genderType;
    }

    @Column(name="gender_empi")
    public String getGenderEmpi() {
        return this.genderEmpi;
    }

    public void setGenderEmpi(String genderEmpi) {
        this.genderEmpi = genderEmpi;
    }

    @JoinColumn(name="race", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Race getRace() {
        return this.race;
    }

    public void setRace(Race race) {
        this.race = race;
    }

    @Column(name="primary_contact_number")
    @Basic(optional=true)
    public String getPrimaryContactNumber() {
        return this.primaryContactNumber;
    }

    public void setPrimaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
    }

    @Column(name="secondary_contact_number")
    public String getSecondaryContactNumber() {
        return this.secondaryContactNumber;
    }

    public void setSecondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = secondaryContactNumber;
    }

    @Column(name="street_address1")
    public String getStreetAddress1() {
        return this.streetAddress1;
    }

    public void setStreetAddress1(String streetAddress1) {
        this.streetAddress1 = streetAddress1;
    }

    @Column(name="street_address2")
    public String getStreetAddress2() {
        return this.streetAddress2;
    }

    public void setStreetAddress2(String streetAddress2) {
        this.streetAddress2 = streetAddress2;
    }

    @Column(name="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @JoinColumn(name="state", referencedColumnName="id")
    @ManyToOne(optional=true)
    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    @Column(name="zip")
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @JoinColumn(name="country", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    @Column(name="created_date")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Column(name="secure")
    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Column(name="active")
    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="latest_ssot_refresh")
    public Date getLatestSsotRefresh() {
        return this.latestSsotRefresh;
    }

    public void setLatestSsotRefresh(Date latestSsotRefresh) {
        this.latestSsotRefresh = latestSsotRefresh;
    }

    @Column(name="archival_status")
    @Basic(optional=true)
    @Enumerated(value=EnumType.STRING)
    public ArchivalStatus getArchivalStatus() {
        return this.archivalStatus;
    }

    public void setArchivalStatus(ArchivalStatus archivalStatus) {
        this.archivalStatus = archivalStatus;
    }

    @Column(name="puid")
    public String getPuid() {
        return this.puid;
    }

    public void setPuid(String puid) {
        this.puid = puid;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="subject")
    public Set<SubjectMrn> getSubjectMrnSet() {
        return this.subjectMrnSet;
    }

    public void setSubjectMrnSet(Set<SubjectMrn> subjectMrnSet) {
        this.subjectMrnSet = subjectMrnSet;
    }

    @Transient
    public Optional<SubjectMrn> getFirstSubjectMrn(String site) {
        Optional<Object> result = Optional.ofNullable(null);
        if (this.getSubjectMrnSet() != null) {
            result = this.getSubjectMrnSet().stream().filter(sm -> sm.getSite() == null || sm.getSite().equalsIgnoreCase(site)).findFirst();
        }
        return result;
    }

    @Transient
    public Set<SubjectMrn> getDecryptedSubjectMrnSet() {
        return this.getSubjectMrnSet().stream().map(sm -> new SubjectMrn(sm.getSubject(), SubjectDataEncryptor.decrypt(sm.getMrn()), sm.getSite(), sm.getStatus(), sm.getId())).collect(Collectors.toSet());
    }

    public String toString() {
        return "Subject [id=" + this.id + ", getId()=" + this.getId() + "]";
    }

    public void setDerivedFullName() {
        this.setFullName(this.firstName + " " + this.lastName);
    }

    public boolean canShareResource() {
        return this.getGenderType().canShareResource();
    }
}

