/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.harvard.catalyst.hccrc.core.util.LazyList;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.scheduler.core.BookedVisitActivityLogStatics;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.BookedVisitDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.GetTemplateResourceGroupDTO;
import edu.harvard.catalyst.scheduler.dto.ScheduledVisitHistoryDTO;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.SwitchSubjectResultDTO;
import edu.harvard.catalyst.scheduler.dto.TemplateResourceDTO;
import edu.harvard.catalyst.scheduler.dto.VisitCancelStatus;
import edu.harvard.catalyst.scheduler.dto.VisitRenderSummaryDTO;
import edu.harvard.catalyst.scheduler.dto.VisitSpecsDTO;
import edu.harvard.catalyst.scheduler.dto.response.BookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.CalendarVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.GanttComboResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttGroupablesResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResourceInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.GanttResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.GetSearchVisitResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudyVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.OverbookTimelineDataResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.OverbookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourceTimeBoundsAndCountResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithLlaListDTO;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithTraListDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplatesResponse;
import edu.harvard.catalyst.scheduler.dto.statics.CalendarFilter;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.BookedVisitActivityLog;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.GenderType;
import edu.harvard.catalyst.scheduler.entity.HasEmail;
import edu.harvard.catalyst.scheduler.entity.HasFirstName;
import edu.harvard.catalyst.scheduler.entity.HasLastName;
import edu.harvard.catalyst.scheduler.entity.LineLevelAnnotations;
import edu.harvard.catalyst.scheduler.entity.OverrideBookedResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceAnnotation;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.TimeBoundedIdentity;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.AppointmentDAO;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.persistence.TemplateResourceDAO;
import edu.harvard.catalyst.scheduler.service.AppointmentConfirmer;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.service.ConfirmationStatus;
import edu.harvard.catalyst.scheduler.service.ConflictChecker;
import edu.harvard.catalyst.scheduler.service.GanttInfoSortType;
import edu.harvard.catalyst.scheduler.service.SearchAlgorithmService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MailHandler;
import edu.harvard.catalyst.scheduler.util.MailMessageBuilder;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Component;

@Component
public class AppointmentService {
    private static final int INCREMENT_FACTOR = 30;
    private final MailHandler mailHandler;
    private final AuthDAO authDAO;
    private final AuditService auditService;
    private final AppointmentDAO appointmentDAO;
    private final ResourceDAO resourceDAO;
    private final StudyDAO studyDAO;
    private final SubjectDAO subjectDAO;
    private final TemplateResourceDAO templateResourceDAO;
    private final SearchAlgorithmService searchAlgorithmService;
    private final ConflictChecker conflictChecker;
    private final AppointmentConfirmer appointmentConfirmer;
    private final Object confirmationLock = new Object();
    static final Comparator<BookedResource> resourceTimeComparator = SearchAlgorithmService.resourceTimeComparator;
    final ConflictChecker defaultConflictChecker = (candidateVisitSpecs, userSession, isInpatient) -> {
        List<BookedVisit> candidateVisits = this.findCandidateVisits(candidateVisitSpecs, userSession, true, false, isInpatient);
        boolean resourcesAvailable = false;
        BookedVisit bookedVisit = candidateVisits.get(0);
        List<BookedResource> bookedResourceList = bookedVisit.getBookedResourceList();
        if (MiscUtil.isNonNullNonEmpty(bookedResourceList)) {
            resourcesAvailable = true;
            for (BookedResource br : bookedResourceList) {
                Boolean alternateResourceUsed = br.getTemplateResource().getAlternateResourceUsed();
                if (alternateResourceUsed == null || !alternateResourceUsed.booleanValue()) continue;
                candidateVisitSpecs.setAlternateResourceUsed("During the confirmation process, one or more of the resources you were trying to schedule became unavailable. Good news! A standard alternate was substituted and your appointment was confirmed. Please review the booked visit by clicking on the appointment block.");
            }
        }
        return resourcesAvailable;
    };

    @Autowired
    public AppointmentService(AppointmentDAO appointmentDAO, ResourceDAO resourceDAO, StudyDAO studyDAO, AuthDAO authDAO, AuditService auditService, MailHandler mailHandler, SubjectDAO subjectDAO, TemplateResourceDAO templateResourceDAO, SearchAlgorithmService searchAlgorithmService) {
        this(appointmentDAO, resourceDAO, studyDAO, authDAO, auditService, mailHandler, subjectDAO, templateResourceDAO, Optional.empty(), Optional.empty(), searchAlgorithmService);
    }

    public AppointmentService(AppointmentDAO appointmentDAO, ResourceDAO resourceDAO, StudyDAO studyDAO, AuthDAO authDAO, AuditService auditService, MailHandler mailHandler, SubjectDAO subjectDAO, TemplateResourceDAO templateResourceDAO, Optional<ConflictChecker> conflictChecker, Optional<AppointmentConfirmer> appointmentConfirmer, SearchAlgorithmService searchAlgorithmService) {
        this.appointmentDAO = appointmentDAO;
        this.resourceDAO = resourceDAO;
        this.studyDAO = studyDAO;
        this.authDAO = authDAO;
        this.auditService = auditService;
        this.mailHandler = mailHandler;
        this.subjectDAO = subjectDAO;
        this.templateResourceDAO = templateResourceDAO;
        this.conflictChecker = MiscUtil.nullToEmpty(conflictChecker).orElse(this.defaultConflictChecker);
        this.appointmentConfirmer = MiscUtil.nullToEmpty(appointmentConfirmer).orElseGet(() -> new DefaultAppointmentConfirmer());
        this.searchAlgorithmService = searchAlgorithmService;
    }

    AppointmentService() {
        this(null, null, null, null, null, null, null, null, null, null, null);
    }

    public GetStudyVisitsResponse getStudyVisits(String nullableFilterString, String ofSortBy, String ofOrderBy, Integer ofPage, Integer ofMaxResults, Integer ofStudyId, Boolean ofApproved) {
        return this.studyDAO.getStudyVisits(nullableFilterString, ofSortBy, ofOrderBy, ofPage, ofMaxResults, ofStudyId, ofApproved);
    }

    public GetSearchVisitResourceResponse getVisitResources(String ofSortBy, String ofOrderBy, Integer ofPage, Integer ofMaxResults, Integer ofVisitId) {
        return this.templateResourceDAO.findTemplateResourcesByVisit(ofVisitId, ofSortBy, ofOrderBy, ofPage, ofMaxResults);
    }

    public List<VisitCommentsResponse.VisitComment> getAppointmentComments(int bookedVisitId) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        return this.appointmentDAO.findAppointmentCommentsByVisit(bookedVisit);
    }

    public Long getTotalAppointmentComments(int bookedVisitId) {
        return this.appointmentDAO.findTotalAppointmentCommentsByVisit(bookedVisitId);
    }

    public BookedVisitDTO logViewBookedVisit(BookedVisitDTO bookedVisitDTO, User user, String ipAddress) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitDTO.getId());
        this.auditService.logAppointmentActivity(ipAddress, bookedVisit, user, BookedVisitActivityLogStatics.VIEWED_DETAILS_FROM_APPOINTMENT_LIST);
        return bookedVisitDTO;
    }

    public BookedVisitDTO logIncompleteOverrideActions(BookedVisitDTO bv, User user, String ipAddress, String action) {
        BookedResource bookedResource = this.appointmentDAO.findBookedResourceById(bv.getId());
        this.auditService.logAppointmentOverrideActivity(ipAddress, bookedResource.getBookedVisit(), bookedResource.getResource(), user, action, null, null);
        return bv;
    }

    public List<CalendarVisitsResponse> getCalendarBookedVisits(int userId, CalendarFilter calendarFilter, String filterString, String sublocationName, Date startMonth, Date endMonth, String remoteHost, boolean homeView) {
        User user = this.authDAO.findUserById(userId);
        List<CalendarVisitsResponse> visits = this.getCalendarBookedVisitsByFilter(filterString, calendarFilter, sublocationName, user, startMonth, endMonth, homeView);
        String action = "Appointment Calendar Viewed";
        if (homeView) {
            action = "HOME SCREEN - Appointment Calendar View.";
        }
        this.auditService.logViewActivity(remoteHost, user, action);
        return visits;
    }

    void setRooms(List<BookedVisit> visits) {
        if (visits != null) {
            for (BookedVisit bookedVisit : visits) {
                Object rooms = " ";
                List<BookedResource> bookedResources = this.appointmentDAO.findRoomBookedResourcesByBookedVisit(bookedVisit.getId());
                if (bookedResources == null) continue;
                for (BookedResource bookedResource : bookedResources) {
                    if (!bookedResource.getResource().getResourceType().getName().equalsIgnoreCase("Room")) continue;
                    rooms = (String)rooms + bookedResource.getResource().getName() + ", ";
                    bookedVisit.setRooms((String)rooms);
                }
            }
        }
    }

    List<CalendarVisitsResponse> getCalendarBookedVisitsByFilter(String filterString, CalendarFilter calendarFilter, String sublocationName, User user, Date startMonth, Date endMonth, boolean homeView) {
        List<Object> result = Lists.newArrayList();
        List<Study> userAccessibleStudies = null;
        if (user.isStudyStaff()) {
            userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
        }
        result = !calendarFilter.equals((Object)CalendarFilter.NO_FILTER) ? this.filterCalendarVisitsResponses(filterString, calendarFilter, sublocationName, user, startMonth, endMonth, homeView, result, userAccessibleStudies) : this.appointmentDAO.getCalendarBookedVisits(sublocationName, startMonth, endMonth, homeView, userAccessibleStudies, user.isStudyStaff());
        return result;
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponses(String filterString, CalendarFilter calendarFilter, String sublocationName, User user, Date startMonth, Date endMonth, boolean homeView, List<CalendarVisitsResponse> result, List<Study> userAccessibleStudies) {
        List<CalendarVisitsResponse> filteredResult = calendarFilter.equals((Object)CalendarFilter.BY_SUBJECT_LAST_NAME) ? this.filterCalendarVisitsResponsesBySubjectLastName(user, filterString, sublocationName, startMonth, endMonth, homeView, result, userAccessibleStudies) : (calendarFilter.equals((Object)CalendarFilter.BY_STUDY_LOCAL_ID) ? this.filterCalendarVisitsResponsesByStudyLocalId(filterString, sublocationName, user, startMonth, endMonth, homeView, result) : (calendarFilter.equals((Object)CalendarFilter.BY_RESOURCE_NAME) ? this.filterCalendarVisitsResponsesByResourceName(filterString, sublocationName, user, startMonth, endMonth, homeView, userAccessibleStudies) : this.filterBookedVisitsByAppointmentStatus(calendarFilter, sublocationName, user, startMonth, endMonth, homeView, userAccessibleStudies)));
        return filteredResult;
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponsesByResourceName(String filterString, String sublocationName, User user, Date startMonth, Date endMonth, boolean homeView, List<Study> userAccessibleStudies) {
        return this.appointmentDAO.findBookedVisitsByResource(filterString, user, userAccessibleStudies, startMonth, endMonth, homeView, sublocationName);
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponsesByStudyLocalId(String filterString, String sublocationName, User user, Date startMonth, Date endMonth, boolean homeView, List<CalendarVisitsResponse> result) {
        List<Study> studyList = this.studyDAO.findStudyListByPersonAndLocalID(user, filterString);
        if (studyList.size() > 0) {
            return this.appointmentDAO.findAllBookedVisitsByStudy(studyList, startMonth, endMonth, homeView, sublocationName);
        }
        return result;
    }

    public List<CalendarVisitsResponse> filterCalendarVisitsResponsesBySubjectLastName(User user, String filterString, String sublocationName, Date startMonth, Date endMonth, boolean homeView, List<CalendarVisitsResponse> result, List<Study> userAccessibleStudies) {
        List<Subject> subjects = this.subjectDAO.filterSubjectByLastNames(filterString);
        if (subjects.size() > 0) {
            return this.appointmentDAO.findAllBookedVisitsBySubject(user, userAccessibleStudies, subjects, sublocationName, startMonth, endMonth, homeView);
        }
        return result;
    }

    public List<CalendarVisitsResponse> filterBookedVisitsByAppointmentStatus(CalendarFilter calendarFilter, String sublocationName, User user, Date startMonth, Date endMonth, boolean homeView, List<Study> userAccessibleStudies) {
        return this.appointmentDAO.findBookedVisitsByApppointmentStatus(calendarFilter, startMonth, endMonth, homeView, userAccessibleStudies, user.isStudyStaff(), sublocationName);
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisitsHomeList(Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults, int userId, String remoteHost) {
        List<BookedVisitsResponse> visits;
        User user = this.authDAO.findUserById(userId);
        if (user.isStudyStaff()) {
            List<Study> userAccessibleStudies = this.studyDAO.findStudyListByPerson(user);
            visits = this.appointmentDAO.getOnlyTodaysBookedVisitsByStudy(userAccessibleStudies, startDate, endDate, sortBy, orderBy, page, maxResults);
        } else {
            visits = this.appointmentDAO.getOnlyTodaysBookedVisits(startDate, endDate, sortBy, orderBy, page, maxResults);
        }
        this.auditService.logViewActivity(remoteHost, user, "HOME SCREEN - Appointment List View.");
        return visits;
    }

    AppointmentStatus scheduledStatus() {
        return this.appointmentDAO.findScheduledStatus();
    }

    AppointmentStatus holdStatus() {
        return this.appointmentDAO.findHoldStatus();
    }

    AppointmentStatus checkedInStatus() {
        return this.appointmentDAO.findCheckedInStatus();
    }

    AppointmentStatus checkedOutStatus() {
        return this.appointmentDAO.findCheckedOutStatus();
    }

    AppointmentStatus cancelledStatus() {
        return this.appointmentDAO.findCancelledStatus();
    }

    public BooleanResultDTO crudTemplateResources(TemplateResourceDTO trDto, String institution, String templatePath, String actionType, User user, String host) {
        trDto.setResult(true);
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(trDto.getVisitTemplate());
        if (actionType.equalsIgnoreCase("add_template_resource") || actionType.equalsIgnoreCase("copy_template_resource")) {
            Resource resource = this.resourceDAO.findResourceById(trDto.getResource());
            TemplateResource templateResource = new TemplateResource(trDto, resource, visitTemplate);
            this.appointmentDAO.createEntity(templateResource);
            this.createTemplateAnnotations(trDto, templateResource);
            this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
            this.auditService.logTemplateResourceActivity(host, user, visitTemplate, "UPDATE TEMPLATE CREATE", null, null);
        } else if (actionType.equalsIgnoreCase("edit_template_resource")) {
            this.editTemplateResource(trDto, institution, templatePath, user, host, false);
        } else if (actionType.equalsIgnoreCase("edit_template_resource_check_diff_only")) {
            boolean updated = this.editTemplateResource(trDto, institution, templatePath, user, host, true);
            trDto.setResult(updated);
        } else if (actionType.equalsIgnoreCase("delete_template_resource")) {
            this.deleteTemplateResource(trDto, institution, templatePath);
            if (trDto.isResult()) {
                this.auditService.logTemplateResourceActivity(host, user, visitTemplate, "UPDATE TEMPLATE DELETE", null, null);
            }
        }
        if (trDto.isResult()) {
            visitTemplate = this.studyDAO.findVisitById(trDto.getVisitTemplate());
            trDto.setInfoMsg(visitTemplate.getApproved() != false ? "Approved" : "Not Approved");
        }
        return trDto;
    }

    public void deleteTemplateResource(TemplateResourceDTO trDto, String institution, String templatePath) {
        TemplateResource selectedTemplateResource = this.appointmentDAO.findTemplateResourceById(trDto.getId());
        VisitTemplate visitTemplate = selectedTemplateResource.getVisitTemplate();
        if (this.deleteTemplateResourceValidation(trDto, selectedTemplateResource)) {
            if (AppointmentService.hasGroupId(selectedTemplateResource)) {
                List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(selectedTemplateResource.getGroupId());
                if (!selectedTemplateResource.getFloatable().booleanValue()) {
                    List<TemplateResource> remainingTrs = trgList.stream().map(trg -> trg.getTemplateResource()).filter(tr -> !tr.getId().equals(selectedTemplateResource.getId())).collect(Collectors.toList());
                    if (this.areFlexResourcesLinkable(trDto, remainingTrs)) {
                        TemplateResourceGroup templateResourceGroup = this.appointmentDAO.findTemplateResourceGroup(selectedTemplateResource);
                        this.deleteTemplateResourceAnnotations(selectedTemplateResource);
                        this.appointmentDAO.deleteEntity(templateResourceGroup);
                        this.appointmentDAO.deleteEntity(selectedTemplateResource);
                        this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
                    }
                } else {
                    this.deleteTemplateResourceAnnotations(selectedTemplateResource);
                    this.deleteTemplateResourceGroups(selectedTemplateResource, trgList);
                    this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
                }
            } else {
                this.deleteTemplateResourceAnnotations(selectedTemplateResource);
                this.appointmentDAO.deleteEntity(selectedTemplateResource);
                this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
            }
        } else {
            trDto.setResult(false);
        }
    }

    public BooleanResultDTO checkIfResourcesLinkableOnDeleteUnlink(Integer templateResourceId) {
        BooleanResultDTO dto = new BooleanResultDTO();
        dto.setResult(true);
        TemplateResource selectedTemplateResource = this.appointmentDAO.findTemplateResourceById(templateResourceId);
        List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(selectedTemplateResource.getGroupId());
        List<TemplateResource> remainingTrs = trgList.stream().map(trg -> trg.getTemplateResource()).filter(tr -> !tr.getId().equals(selectedTemplateResource.getId())).collect(Collectors.toList());
        this.areFlexResourcesLinkable(dto, remainingTrs);
        Integer size = trgList.size();
        dto.setErrorMsg(size.toString());
        return dto;
    }

    void deleteTemplateResourceGroups(TemplateResource selectedTemplateResource, List<TemplateResourceGroup> trgList) {
        trgList.forEach(i -> {
            TemplateResource tr = this.templateResourceDAO.findTemplateResourceById(i.getTemplateResource().getId());
            tr.setGroupId(null);
            this.appointmentDAO.updateEntity(tr);
            this.appointmentDAO.deleteEntity((BaseEntity)i);
        });
        this.appointmentDAO.deleteEntity(selectedTemplateResource);
    }

    public boolean editTemplateResource(TemplateResourceDTO newTrDto, String institution, String templatePath, User user, String host, Boolean diffCheckOnly) {
        TemplateResource tr = this.appointmentDAO.findTemplateResourceById(newTrDto.getId());
        TemplateResourceDTO oldTrDto = new TemplateResourceDTO(tr, this.templateResourceDAO);
        String updateString = oldTrDto.diffFromThisToOther(newTrDto);
        if (diffCheckOnly.booleanValue()) {
            return !updateString.equals("No Change");
        }
        boolean userUpdated = tr.possiblyUpdateMyNonResourceFields(newTrDto);
        userUpdated = this.possiblyUpdateThisTrsResourceField(newTrDto, tr) || userUpdated;
        userUpdated = this.possiblyUpdateThisTrsAnnotations(newTrDto, tr) || userUpdated;
        Date now = new Date();
        tr.setLastUpdateTime(now);
        this.appointmentDAO.updateEntity(tr);
        VisitTemplate visitTemplate = tr.getVisitTemplate();
        if (userUpdated) {
            this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
        }
        this.auditService.logTemplateResourceActivity(host, user, visitTemplate, "UPDATE TEMPLATE RESOURCE", updateString, null);
        return userUpdated;
    }

    boolean possiblyUpdateThisTrsResourceField(TemplateResourceDTO trDto, TemplateResource tr) {
        boolean updated = false;
        if (tr.getResource().getId().intValue() != trDto.getResource()) {
            List<TemplateResourceAnnotations> currentTRAs = this.resourceDAO.findTemplateAnnotationsByTemplateResource(tr);
            currentTRAs.forEach(this.appointmentDAO::deleteEntity);
            Resource resource = this.resourceDAO.findResourceById(trDto.getResource());
            tr.setResource(resource);
            updated = true;
        }
        return updated;
    }

    public TemplateResource createTemplateResource(TemplateResourceDTO tr, String institution, String templatePath) {
        Resource resource = this.resourceDAO.findResourceById(tr.getResource());
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(tr.getVisitTemplate());
        TemplateResource templateResource = new TemplateResource(tr, resource, visitTemplate);
        this.appointmentDAO.createEntity(templateResource);
        this.createTemplateAnnotations(tr, templateResource);
        this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, visitTemplate);
        return templateResource;
    }

    public void createTemplateAnnotations(TemplateResourceDTO tr, TemplateResource templateResource) {
        if (!tr.getSelectedAnnotations().isEmpty()) {
            for (int i = 0; i < tr.getSelectedAnnotations().size(); ++i) {
                TemplateResourceAnnotations tra = new TemplateResourceAnnotations();
                tra.setTemplateResource(templateResource);
                tra.setLineLevelAnnotations(this.resourceDAO.findLineLevelAnnotationsById(tr.getSelectedAnnotations().get(i)));
                tra.setQuantity(tr.getSelectedAnnotationsQuantity().get(i));
                tra.setComment(tr.getSelectedAnnotationsComment().get(i));
                this.appointmentDAO.createEntity(tra);
            }
        }
    }

    void sendVisitTemplateResourceUpdatedEmail(VisitTemplate visit, String institution, boolean newVisitResource, String templatePath) {
        String visitName = visit.getName();
        Study study = visit.getStudy();
        String studyName = study.getName();
        String localId = study.getLocalId();
        String catalystId = study.getCatalystId();
        String irb = study.getIrb();
        String prefix = newVisitResource ? "New Resource added to the visit Template : " : "Visit Template Resource has been updated : ";
        String title = prefix + visit.getName();
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate newVisit = group.getInstanceOf("visitCreatedEmail");
        newVisit.setAttribute("institution", (Object)institution);
        newVisit.setAttribute("visitName", (Object)visitName);
        newVisit.setAttribute("studyName", (Object)studyName);
        newVisit.setAttribute("localId", (Object)localId);
        newVisit.setAttribute("catalystId", (Object)catalystId);
        newVisit.setAttribute("irb", (Object)irb);
        List<User> adminDirector = this.authDAO.findAdminDirectorUserByRole();
        List<User> nurseManager = this.authDAO.findNurseManagerUserByRole();
        List<User> nutritionManager = this.authDAO.findNutritionManagerUserByRole();
        List<User> finalApprover = this.authDAO.findFinalApproverByRole();
        boolean noProtocolNutritionist = study.getProtocolNutritionist() == null || study.getProtocolNutritionistString() == "N/A";
        boolean hasProtocolNutritionist = !noProtocolNutritionist;
        boolean noProtocolNurse = study.getProtocolNurse() == null || study.getProtocolNurseString() == "N/A";
        boolean hasProtocolNurse = !noProtocolNurse;
        boolean noScheduler = study.getScheduler() == null;
        boolean hasScheduler = !noScheduler;
        String schedulerEmail = hasScheduler ? study.getScheduler().getPreferredNotificationEmail() : "";
        String protocolNutritionistEmail = hasProtocolNutritionist ? study.getProtocolNutritionist().getPreferredNotificationEmail() : "";
        String protocolNurseEmail = hasProtocolNurse ? study.getProtocolNurse().getPreferredNotificationEmail() : "";
        Optional<String> none = Optional.empty();
        if (hasScheduler && noProtocolNutritionist && noProtocolNurse) {
            this.sendMessage(schedulerEmail, title, newVisit, none, none);
        } else if (noScheduler && hasProtocolNutritionist && noProtocolNurse) {
            this.sendMessage(protocolNutritionistEmail, title, newVisit, none, none);
        } else if (noScheduler && noProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(protocolNurseEmail, title, newVisit, none, none);
        } else if (hasScheduler && hasProtocolNutritionist && noProtocolNurse) {
            this.sendMessage(schedulerEmail, title, newVisit, Optional.of(protocolNutritionistEmail), none);
        } else if (hasScheduler && noProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(protocolNurseEmail, title, newVisit, Optional.of(schedulerEmail), none);
        } else if (noScheduler && hasProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(protocolNurseEmail, title, newVisit, Optional.of(protocolNutritionistEmail), none);
        } else if (hasScheduler && hasProtocolNutritionist && hasProtocolNurse) {
            this.sendMessage(schedulerEmail, title, newVisit, Optional.of(protocolNurseEmail), Optional.of(study.getProtocolNutritionist().getEmail()));
        }
        this.sendMessagesToHigherUps(adminDirector, title, newVisit);
        this.sendMessagesToHigherUps(nurseManager, title, newVisit);
        this.sendMessagesToHigherUps(nutritionManager, title, newVisit);
        this.sendMessagesToHigherUps(finalApprover, title, newVisit);
    }

    private void sendMessagesToHigherUps(List<User> managers, String title, StringTemplate newVisit) {
        Function<User, SimpleMailMessage> toMessage = u -> new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(newVisit.toString()).build();
        ListUtils.enrich(managers).map(toMessage).forEach(this.mailHandler::sendOptionalEmails);
    }

    private void sendMessage(String recipient, String title, StringTemplate newVisit, Optional<String> ccRecipient, Optional<String> bccRecipient) {
        MailMessageBuilder builder = new MailMessageBuilder().to(recipient).subject(title).text(newVisit.toString());
        ccRecipient.ifPresent(builder::cc);
        bccRecipient.ifPresent(builder::bcc);
        this.mailHandler.sendOptionalEmails(builder.build());
    }

    public BooleanResultDTO updateTemplateResourcesBillable(Integer visitId, String templateResourcesCommaString, boolean isBillable) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        VisitTemplate visitTemplate = this.studyDAO.findVisitTemplateById(visitId);
        List templateResourcesId = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)templateResourcesCommaString)).stream().map(Integer::parseInt).collect(Collectors.toList());
        templateResourcesId.stream().forEach(trId -> {
            TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById((int)trId);
            templateResource.setBillable(isBillable);
            Date now = new Date();
            templateResource.setLastUpdateTime(now);
            this.appointmentDAO.updateEntity(templateResource);
        });
        if (visitTemplate.getApproved().booleanValue()) {
            visitTemplate.setApproved(Boolean.FALSE);
            visitTemplate.setLastUpdateTime(new Date());
            this.appointmentDAO.updateEntity(visitTemplate);
        }
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public BooleanResultDTO updateTemplateResourceTime(Integer templateResourceId, Integer startMinutes, Integer endMinutes) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById(templateResourceId);
        VisitTemplate visitTemplate = this.studyDAO.findVisitTemplateById(templateResource.getVisitTemplate().getId());
        if (templateResource.getFloatable().booleanValue()) {
            templateResource.setFloatStart(startMinutes);
            templateResource.setFloatEnd(endMinutes);
        } else {
            templateResource.setStartMinutes(startMinutes);
            templateResource.setEndMinutes(endMinutes);
            this.computeAndSetDuration(templateResource);
        }
        templateResource.setLastUpdateTime(new Date());
        this.appointmentDAO.updateEntity(templateResource);
        if (visitTemplate.getApproved().booleanValue()) {
            visitTemplate.setApproved(Boolean.FALSE);
            visitTemplate.setLastUpdateTime(new Date());
        }
        List<TemplateResource> templateResourcesByVisit = this.templateResourceDAO.findTemplateResourcesByVisit(visitTemplate);
        int totalDuration = this.computeTotalDuration(visitTemplate, templateResourcesByVisit);
        visitTemplate.setDuration(totalDuration);
        this.appointmentDAO.updateEntity(visitTemplate);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public GanttResourceInfoDTO getGanttResourceInfo(Integer visitId, Integer trId, int dayOffset) {
        TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById(trId);
        List<TemplateResource> allTrsForResourceAndVisit = this.templateResourceDAO.findTemplateResourcesByVisitAndResource(visitId, templateResource.getResource().getId());
        GanttResourceInfoDTO ganttResourceInfo = new GanttResourceInfoDTO(allTrsForResourceAndVisit, dayOffset);
        return ganttResourceInfo;
    }

    void sendOverBookedVisitEmail(BookedVisit visit, String institution, String templatePath, List<String> conditions) {
        String visitName = visit.getName();
        Study study = visit.getStudy();
        String localId = study.getLocalId();
        String visitTypeName = visit.getVisitType().getName();
        String sublocation = visit.getVisitTemplate().getSublocation().getName();
        Date startTime = visit.getScheduledStartTime();
        Date endTime = visit.getScheduledEndTime();
        NameAndEmail pi = NameAndEmail.of(study.getInvestigator());
        NameAndEmail primarySchedulingContact = NameAndEmail.of(study.getScheduler());
        NameAndEmail protoNurse = NameAndEmail.of(study.getProtocolNurse());
        NameAndEmail protoNutritionist = NameAndEmail.of(study.getProtocolNutritionist());
        String title = visitName + ",Local ID " + localId + ",was overbooked for " + visit.getScheduledStartTime();
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate stringTemplate = group.getInstanceOf("overbookEmail");
        stringTemplate.setAttribute("institution", (Object)institution);
        stringTemplate.setAttribute("visitName", (Object)visitName);
        stringTemplate.setAttribute("localId", (Object)localId);
        stringTemplate.setAttribute("visitType", (Object)visitTypeName);
        stringTemplate.setAttribute("sublocation", (Object)sublocation);
        stringTemplate.setAttribute("startTime", (Object)startTime);
        stringTemplate.setAttribute("endTime", (Object)endTime);
        stringTemplate.setAttribute("piName", (Object)pi.name);
        stringTemplate.setAttribute("piEmail", (Object)pi.email);
        stringTemplate.setAttribute("primarySchedulingContactName", (Object)primarySchedulingContact.name);
        stringTemplate.setAttribute("primarySchedulingContactEmail", (Object)primarySchedulingContact.email);
        stringTemplate.setAttribute("protoNurseName", (Object)protoNurse.name);
        stringTemplate.setAttribute("protoNurseEmail", (Object)protoNurse.email);
        stringTemplate.setAttribute("protoNutritionistName", (Object)protoNutritionist.name);
        stringTemplate.setAttribute("protoNutritionistEmail", (Object)protoNutritionist.email);
        stringTemplate.setAttribute("conditions", conditions);
        this.sendEmailNotifications(study, title, stringTemplate);
    }

    public void copyTemplateAnnotations(List<TemplateResourceAnnotations> tras, TemplateResource clonedRes) {
        ListUtils.enrich(tras).map(tra -> {
            TemplateResourceAnnotations clonedResAnn = new TemplateResourceAnnotations();
            clonedResAnn.setComment(tra.getComment());
            clonedResAnn.setLineLevelAnnotations(tra.getLineLevelAnnotations());
            clonedResAnn.setTemplateResource(clonedRes);
            clonedResAnn.setQuantity(tra.getQuantity());
            return clonedResAnn;
        }).forEach(this.studyDAO::createEntity);
    }

    int computeTotalDuration(VisitTemplate visitTemplate, List<TemplateResource> templateResourceList) {
        int latestEndTime;
        int earliestStartTime;
        if (templateResourceList.isEmpty()) {
            return 0;
        }
        if (visitTemplate.getRelativeTime().booleanValue()) {
            earliestStartTime = this.findEarliestInpatientStartTime(templateResourceList);
            latestEndTime = this.findLatestInpatientEndTime(templateResourceList);
        } else {
            earliestStartTime = this.findEarliestInpatientClockStartTime(templateResourceList);
            latestEndTime = this.findLatestInpatientEndTime(templateResourceList);
        }
        return latestEndTime - earliestStartTime;
    }

    public boolean populateCurrentDayCopyables(int visitId, int currentDay, List<TemplateResource> nonGroupTrsToCopy, List<TemplateResource> flexGroupedTrsToCopy, List<TemplateResource> floatGroupedTrsToCopy, List<TemplateResource> trsCandidatesForCopy) {
        int selectedDateInMinutes = (currentDay - 1) * 1440;
        int nextDateInMinutes = currentDay * 1440;
        trsCandidatesForCopy.addAll(this.getTemplateResourcesUsedBetween(visitId, selectedDateInMinutes, nextDateInMinutes));
        trsCandidatesForCopy.stream().forEach(tr -> {
            if (tr.getGroupId() == null) {
                if (tr.getFloatable().booleanValue()) {
                    this.checkIfSingleDayFloatResources(nonGroupTrsToCopy, selectedDateInMinutes, nextDateInMinutes, (TemplateResource)tr);
                } else {
                    nonGroupTrsToCopy.add((TemplateResource)tr);
                }
            } else if (tr.getFlexible().booleanValue()) {
                flexGroupedTrsToCopy.add((TemplateResource)tr);
            } else {
                this.checkIfSingleDayFloatResources(floatGroupedTrsToCopy, selectedDateInMinutes, nextDateInMinutes, (TemplateResource)tr);
            }
        });
        return nonGroupTrsToCopy.size() + floatGroupedTrsToCopy.size() > 0 || this.dayHasCopyableFlexGroups(flexGroupedTrsToCopy);
    }

    private void checkIfSingleDayFloatResources(List<TemplateResource> floatTrsToCopy, int selectedDateInMinutes, int nextDateInMinutes, TemplateResource tr) {
        int floatStart = tr.getFloatStart();
        int floatEnd = tr.getFloatEnd();
        if ((floatStart > selectedDateInMinutes || floatStart == selectedDateInMinutes) && floatEnd < nextDateInMinutes) {
            floatTrsToCopy.add(tr);
        }
    }

    public boolean isDayCopyable(int visitId, int currentDay) {
        return this.populateCurrentDayCopyables(visitId, currentDay, Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList());
    }

    public void copyDayVisitResources(int visitId, int currentDay, String targetDaysCommaString, String institution, String templatePath) {
        ArrayList trsCandidatesForCopy;
        ArrayList floatGroupedTrsToCopy;
        ArrayList flexGroupedTrsToCopy;
        ArrayList nonGroupTrsToCopy = Lists.newArrayList();
        boolean doCopy = this.populateCurrentDayCopyables(visitId, currentDay, nonGroupTrsToCopy, flexGroupedTrsToCopy = Lists.newArrayList(), floatGroupedTrsToCopy = Lists.newArrayList(), trsCandidatesForCopy = Lists.newArrayList());
        if (!doCopy) {
            return;
        }
        List<Integer> targetDayOffsets = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)targetDaysCommaString)).stream().map(Integer::parseInt).collect(Collectors.toList());
        this.copyNonGroupTrs(currentDay, nonGroupTrsToCopy, targetDayOffsets);
        this.copyFlexGroupTrs(currentDay, flexGroupedTrsToCopy, targetDayOffsets);
        this.copyFloatGroupTrs(currentDay, floatGroupedTrsToCopy, targetDayOffsets);
        VisitTemplate theVisit = ((TemplateResource)trsCandidatesForCopy.get(0)).getVisitTemplate();
        this.adjustDurationUnapproveAndUpdateVisitTemplate(institution, templatePath, theVisit);
    }

    Map<String, List<TemplateResource>> groupTrsToGroupIdMapToLists(List<TemplateResource> groupedTrs) {
        HashMap result = Maps.newHashMap();
        groupedTrs.stream().forEach(tr -> {
            String groupId = tr.getGroupId();
            List trList = (List)result.get(groupId);
            if (trList == null) {
                trList = Lists.newArrayList();
                result.put(groupId, trList);
            }
            trList.add(tr);
        });
        return result;
    }

    void copyFloatGroupTrs(int currentDay, List<TemplateResource> floatGroupedTrsToCopy, List<Integer> targetDayOffsets) {
        Map<String, List<TemplateResource>> groupIdToTrList = this.groupTrsToGroupIdMapToLists(floatGroupedTrsToCopy);
        for (String groupId : groupIdToTrList.keySet()) {
            List<TemplateResource> aGroupsTrList = groupIdToTrList.get(groupId);
            this.copyGroupResources(currentDay, targetDayOffsets, aGroupsTrList);
        }
    }

    boolean flexGroupIsCopyable(List<TemplateResource> theGroupsTrgListFromThisDay, String groupId) {
        List<TemplateResourceGroup> theGroupsTrListFromTotalVisit = this.appointmentDAO.findTrgListByGroupId(groupId);
        return theGroupsTrgListFromThisDay.size() == theGroupsTrListFromTotalVisit.size();
    }

    boolean dayHasCopyableFlexGroups(List<TemplateResource> flexGroupedTrsToCopy) {
        Map<String, List<TemplateResource>> groupIdToTrList = this.groupTrsToGroupIdMapToLists(flexGroupedTrsToCopy);
        for (String groupId : groupIdToTrList.keySet()) {
            List<TemplateResource> theGroupsTrgListFromThisDay = groupIdToTrList.get(groupId);
            if (!this.flexGroupIsCopyable(theGroupsTrgListFromThisDay, groupId)) continue;
            return true;
        }
        return false;
    }

    void copyFlexGroupTrs(int currentDay, List<TemplateResource> flexGroupedTrsToCopy, List<Integer> targetDayOffsets) {
        Map<String, List<TemplateResource>> groupIdToTrList = this.groupTrsToGroupIdMapToLists(flexGroupedTrsToCopy);
        for (String groupId : groupIdToTrList.keySet()) {
            List<TemplateResource> theGroupsTrgListFromThisDay = groupIdToTrList.get(groupId);
            if (!this.flexGroupIsCopyable(theGroupsTrgListFromThisDay, groupId)) continue;
            this.copyGroupResources(currentDay, targetDayOffsets, theGroupsTrgListFromThisDay);
        }
    }

    void copyGroupResources(int currentDay, List<Integer> targetDayOffsets, List<TemplateResource> theGroupsTrgListFromThisDay) {
        for (Integer dayOffset : targetDayOffsets) {
            String newGroupId = UUID.randomUUID().toString();
            for (TemplateResource trToCopy : theGroupsTrgListFromThisDay) {
                List<TemplateResourceAnnotations> traList = this.templateResourceDAO.findTemplateResourceAnnotationsByTemplateResource(trToCopy);
                TemplateResource clonedTr = this.copyTemplateResourceMostOfTheWay(currentDay, trToCopy, dayOffset);
                clonedTr.setGroupId(newGroupId);
                this.copyTemplateResourceFinalSteps(traList, clonedTr);
                TemplateResourceGroup templateResourceGroup = new TemplateResourceGroup();
                templateResourceGroup.setTemplateResource(clonedTr);
                templateResourceGroup.setGroupId(newGroupId);
                templateResourceGroup.setFlexGroup(clonedTr.getFlexible());
                templateResourceGroup.setVisit(clonedTr.getVisitTemplate());
                this.create(templateResourceGroup);
            }
        }
    }

    void copyNonGroupTrs(int currentDay, List<TemplateResource> nonGroupTrsToCopy, List<Integer> targetDayOffsets) {
        for (TemplateResource trToCopy : nonGroupTrsToCopy) {
            List<TemplateResourceAnnotations> traList = this.templateResourceDAO.findTemplateResourceAnnotationsByTemplateResource(trToCopy);
            for (Integer dayOffset : targetDayOffsets) {
                TemplateResource clonedTr = this.copyTemplateResourceMostOfTheWay(currentDay, trToCopy, dayOffset);
                this.copyTemplateResourceFinalSteps(traList, clonedTr);
            }
        }
    }

    void copyTemplateResourceFinalSteps(List<TemplateResourceAnnotations> traList, TemplateResource clonedTr) {
        clonedTr.setId(null);
        this.studyDAO.createEntity(clonedTr);
        this.copyTemplateAnnotations(traList, clonedTr);
    }

    TemplateResource copyTemplateResourceMostOfTheWay(int currentDay, TemplateResource trToCopy, Integer dayOffset) {
        int dayDelta = dayOffset - currentDay;
        int minutesDelta = 1440 * dayDelta;
        TemplateResource clonedTr = trToCopy.cloneTemplateResource();
        clonedTr.setStartMinutes(trToCopy.getStartMinutes() + minutesDelta);
        clonedTr.setEndMinutes(trToCopy.getEndMinutes() + minutesDelta);
        Date now = new Date();
        clonedTr.setCreatedDate(now);
        clonedTr.setLastUpdateTime(now);
        if (trToCopy.getFloatable().booleanValue()) {
            clonedTr.setFloatStart(trToCopy.getFloatStart() + minutesDelta);
            clonedTr.setFloatEnd(trToCopy.getFloatEnd() + minutesDelta);
        }
        return clonedTr;
    }

    public ResourceTimeBoundsAndCountResponseDTO findTemplateResourceCountEarliestLatest(int visitId) {
        return this.templateResourceDAO.findTemplateResourceCountEarliestLatest(visitId);
    }

    public List<TemplateResource> getTemplateResourcesUsedBetween(int visitId, int selectedDayInMinutes, int nextDayInMinutes) {
        List<TemplateResource> templateResourceResultList = this.templateResourceDAO.getTemplateResourcesUsedOnDay(visitId, selectedDayInMinutes, nextDayInMinutes);
        return templateResourceResultList;
    }

    public List<TemplateResource> getSelectableTemplateResources(int visitId, boolean isBillable, String sortBy, String orderBy, int page, int maxResults) {
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(visitId);
        return this.templateResourceDAO.findTemplateResourcesByVisitAndBillable(visitTemplate, isBillable, sortBy, orderBy, page, maxResults);
    }

    public List<TemplateResource> getTemplateResources(int visitId, boolean addQuantities) {
        return this.getTemplateResources(visitId, addQuantities, "");
    }

    public List<TemplateResource> getTemplateResources(int visitId, boolean addQuantities, String sortExpression) {
        List<TemplateResourceWithTraListDTO> trWithAnnotationsDtoList = this.templateResourceDAO.findTemplateResourcesAndAnnotationsByVisit(visitId, sortExpression);
        ArrayList trsWithAnnotationsString = Lists.newArrayList();
        for (TemplateResourceWithTraListDTO trwaDto : trWithAnnotationsDtoList) {
            TemplateResource tr = trwaDto.getTemplateResource();
            tr.determineAnnotationsString(trwaDto.getTraList(), addQuantities);
            trsWithAnnotationsString.add(tr);
        }
        return trsWithAnnotationsString;
    }

    private static boolean hasGroupId(TemplateResource r) {
        return SearchAlgorithmService.hasGroupId(r);
    }

    public TemplateResourceWithLlaListDTO getTemplateResourceDataWithAnnotations(int templateResourceId) {
        TemplateResource templateResource = this.appointmentDAO.findTemplateResourceById(templateResourceId);
        List<TemplateResourceAnnotations> traList = this.resourceDAO.findTemplateAnnotationsByTemplateResource(templateResource);
        List<LineLevelAnnotations> llaList = this.getResourceAnnotations(templateResource.getResource().getId());
        for (int i = 0; i < traList.size(); ++i) {
            int indexOf = llaList.indexOf(traList.get(i).getLineLevelAnnotations());
            llaList.get(indexOf).setSelected(true);
            llaList.get(indexOf).setQuantity(traList.get(i).getQuantity());
            llaList.get(indexOf).setComment(traList.get(i).getComment());
            llaList.get(indexOf).setResourceAnnotations(traList.get(i).getId());
        }
        Collections.sort(llaList, new LineLevelAnnotations.AnnotationsComparator());
        TemplateResourceWithLlaListDTO templateResourceWithLlaListDTO = new TemplateResourceWithLlaListDTO(templateResource, llaList);
        return templateResourceWithLlaListDTO;
    }

    public List<TemplateResource> getUngroupedTemplateResourcesByType(int visitId, String templateResourceType) {
        VisitTemplate visit = this.studyDAO.findVisitById(visitId);
        return this.templateResourceDAO.findUngroupedTemplateResourcesTypeByVisit(visit, templateResourceType);
    }

    public GanttComboResponseDTO getTemplateResourcesForGanttCombo(Integer visitId, int dayOffset, GanttInfoSortType sortType) {
        GanttComboResponseDTO result = new GanttComboResponseDTO();
        List<TemplateResource> allTrsForVisit = this.getTemplateResources(visitId, true, sortType.getSortClause());
        result.setInfoDayResources(this.getGanttInfoDay(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Resources));
        result.setInfoDayEvents(this.getGanttInfoDay(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        result.setInfoMultiResources(this.getGanttInfoMulti(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Resources));
        result.setInfoMultiEvents(this.getGanttInfoMulti(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        result.setInfoFloatResources(this.getGanttInfoFloat(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.ResourcesGroup));
        result.setInfoFloatEvents(this.getGanttInfoFloat(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        result.setInfoFlexResources(this.getGanttInfoFlex(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.ResourcesGroup));
        result.setInfoFlexEvents(this.getGanttInfoFlex(allTrsForVisit, dayOffset, GanttResponseDTO.GanttInfoType.Events));
        return result;
    }

    public GanttResponseDTO getGanttInfoDay(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> tr.occursInOneDay() && tr.startDayOffsetMatches(dayOffset) && !tr.isGrouped());
        return ganttResponseDTO;
    }

    public GanttResponseDTO getGanttInfoMulti(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> !tr.occursInOneDay() && tr.resourceOverlapsDayOffset(dayOffset) && !tr.isGrouped());
        return ganttResponseDTO;
    }

    public GanttResponseDTO getGanttInfoFloat(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> tr.isGrouped() && tr.resourceOverlapsDayOffset(dayOffset) && tr.getFloatable() != false);
        return ganttResponseDTO;
    }

    public GanttResponseDTO getGanttInfoFlex(List<TemplateResource> allTrsForTheVisit, int dayOffset, GanttResponseDTO.GanttInfoType ganttInfoType) {
        GanttResponseDTO ganttResponseDTO = ganttInfoType.create(allTrsForTheVisit, dayOffset, (? super TemplateResource tr) -> tr.isGrouped() && tr.resourceOverlapsDayOffset(dayOffset) && tr.getFlexible() != false);
        return ganttResponseDTO;
    }

    public GanttGroupablesResponseDTO getGanttInfoCandidateGroupables(Integer visitId, Integer templateResourceId, GanttResponseDTO.GanttGroupingType groupingType) {
        GanttGroupablesResponseDTO ganttGroupablesResponseDTO = groupingType.create(this.getTemplateResources(visitId, true), templateResourceId);
        return ganttGroupablesResponseDTO;
    }

    boolean possiblyUpdateThisTrsAnnotations(TemplateResourceDTO trDto, TemplateResource templateResource) {
        List<TemplateResourceAnnotations> currentTRAs = this.resourceDAO.findTemplateAnnotationsByTemplateResource(templateResource);
        ArrayList candidateTRAs = Lists.newArrayList();
        List<Integer> selectedAnnotationIDs = trDto.getSelectedAnnotations();
        for (int i = 0; i < selectedAnnotationIDs.size(); ++i) {
            LineLevelAnnotations lla = this.resourceDAO.findLineLevelAnnotationsById(selectedAnnotationIDs.get(i));
            TemplateResourceAnnotations tra = new TemplateResourceAnnotations();
            tra.setTemplateResource(templateResource);
            tra.setLineLevelAnnotations(lla);
            tra.setQuantity(trDto.getSelectedAnnotationsQuantity().get(i));
            tra.setComment(trDto.getSelectedAnnotationsComment().get(i));
            candidateTRAs.add(tra);
        }
        boolean updated = this.nonCoextensionalLists(candidateTRAs, currentTRAs);
        if (updated) {
            currentTRAs.forEach(this.appointmentDAO::deleteEntity);
            candidateTRAs.forEach(this.appointmentDAO::createEntity);
        }
        return updated;
    }

    <T> boolean nonCoextensionalLists(List<T> list1, List<T> list2) {
        HashSet set2;
        HashSet set1 = Sets.newHashSet(list1);
        return !set1.equals(set2 = Sets.newHashSet(list2));
    }

    public BooleanResultDTO unlinkOneResource(Integer deserterId, String institution, String templatePath) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(true);
        TemplateResource deserterTr = this.appointmentDAO.findTemplateResourceById(deserterId);
        if (deserterTr == null || deserterTr.getGroupId() == null) {
            booleanResultDTO.setResult(false);
            booleanResultDTO.setErrorMsg("Selected Resource does not exist, or is not linked in a group.");
            return booleanResultDTO;
        }
        List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(deserterTr.getGroupId());
        if (!trgList.isEmpty()) {
            if (trgList.get(0).getTemplateResource().getFloatable().booleanValue()) {
                this.unlinkDyadicGroup(institution, templatePath, trgList);
            } else {
                this.unlinkOneFromNonDyadicGroup(booleanResultDTO, institution, templatePath, deserterTr, trgList);
            }
        }
        return booleanResultDTO;
    }

    void unlinkDyadicGroup(String institution, String templatePath, List<TemplateResourceGroup> trgList) {
        for (TemplateResourceGroup trg : trgList) {
            this.lowLevelUnlinkOneTr(institution, templatePath, trg);
        }
    }

    void lowLevelUnlinkOneTr(String institution, String templatePath, TemplateResourceGroup theTrg) {
        Date now = new Date();
        VisitTemplate visitTemplate = theTrg.getVisit();
        TemplateResource theTr = theTrg.getTemplateResource();
        theTr.setGroupId(null);
        theTr.setLastUpdateTime(now);
        if (visitTemplate.getApproved().booleanValue()) {
            this.sendVisitTemplateResourceUpdatedEmail(theTr.getVisitTemplate(), institution, false, templatePath);
        }
        visitTemplate.setApproved(false);
        visitTemplate.setLastUpdateTime(now);
        this.update(visitTemplate, theTr);
        this.delete(theTrg);
    }

    BooleanResultDTO unlinkOneFromNonDyadicGroup(BooleanResultDTO booleanResultDTO, String institution, String templatePath, TemplateResource deserterTr, List<TemplateResourceGroup> trgList) {
        List<TemplateResource> remainingTrs = trgList.stream().map(trg -> trg.getTemplateResource()).filter(tr -> !tr.getId().equals(deserterTr.getId())).collect(Collectors.toList());
        List deserterTrgsUnitList = trgList.stream().filter(trg -> trg.getTemplateResource().getId().equals(deserterTr.getId())).collect(Collectors.toList());
        if (this.similarResourcesAreLinkable(booleanResultDTO, remainingTrs)) {
            this.lowLevelUnlinkOneTr(institution, templatePath, (TemplateResourceGroup)deserterTrgsUnitList.get(0));
        }
        return booleanResultDTO;
    }

    public BooleanResultDTO unlinkGroup(String groupId, String institution, String templatePath) {
        List<TemplateResourceGroup> trgList = this.appointmentDAO.findTrgListByGroupId(groupId);
        if (!trgList.isEmpty()) {
            trgList.stream().forEach(trg -> this.lowLevelUnlinkOneTr(institution, templatePath, (TemplateResourceGroup)trg));
        }
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO(true);
        return booleanResultDTO;
    }

    private void update(BaseEntity ... es) {
        this.doDaoOp(this.appointmentDAO::updateEntity, es);
    }

    private void delete(BaseEntity ... es) {
        this.doDaoOp(this.appointmentDAO::deleteEntity, es);
    }

    private void create(BaseEntity ... es) {
        this.doDaoOp(this.appointmentDAO::createEntity, es);
    }

    private void doDaoOp(Consumer<? super BaseEntity> op, BaseEntity ... es) {
        for (BaseEntity e : es) {
            op.accept(e);
        }
    }

    public BooleanResultDTO linkTemplateResourcesAsNewGroup(GetTemplateResourceGroupDTO booleanResultDTO, String institution, String templatePath) {
        boolean result = true;
        List<TemplateResource> templateResourceList = booleanResultDTO.getLinkResources().stream().map(this.appointmentDAO::findTemplateResourceById).collect(Collectors.toList());
        if (templateResourceList.isEmpty() || templateResourceList.contains(null)) {
            result = false;
        } else if (!this.similarResourcesAreLinkable(booleanResultDTO, templateResourceList)) {
            result = false;
        } else {
            this.linkTemplateResourcesAsNewGroup(templateResourceList, institution, templatePath);
        }
        booleanResultDTO.setResult(result);
        return booleanResultDTO;
    }

    void linkTemplateResourcesAsNewGroup(List<TemplateResource> templateResourceList, String institution, String templatePath) {
        String groupId = UUID.randomUUID().toString();
        for (TemplateResource templateResource : templateResourceList) {
            TemplateResourceGroup templateResourceGroup = new TemplateResourceGroup();
            VisitTemplate visitTemplate = this.studyDAO.findVisitTemplateById(templateResource.getVisitTemplate().getId());
            templateResourceGroup.setTemplateResource(templateResource);
            templateResource.setGroupId(groupId);
            if (visitTemplate.getApproved().booleanValue()) {
                this.sendVisitTemplateResourceUpdatedEmail(visitTemplate, institution, false, templatePath);
            }
            Date now = new Date();
            templateResource.setLastUpdateTime(now);
            visitTemplate.setLastUpdateTime(now);
            visitTemplate.setApproved(Boolean.FALSE);
            templateResourceGroup.setGroupId(groupId);
            templateResourceGroup.setFlexGroup(templateResource.getFlexible());
            templateResourceGroup.setVisit(visitTemplate);
            this.update(visitTemplate, templateResource);
            this.create(templateResourceGroup);
        }
    }

    boolean similarResourcesAreLinkable(BooleanResultDTO booleanResultDTO, List<TemplateResource> templateResourceList) {
        boolean floatables = templateResourceList.get(0).getFloatable();
        if (floatables) {
            return this.areFloatResourcesLinkable(booleanResultDTO, templateResourceList);
        }
        return this.areFlexResourcesLinkable(booleanResultDTO, templateResourceList);
    }

    boolean areFlexResourcesLinkable(BooleanResultDTO booleanResultDTO, List<TemplateResource> templateResourceList) {
        String statusMsg = TemplateResource.isValidFlexGroup(templateResourceList);
        return this.isLinkableResourcesMsg(booleanResultDTO, statusMsg, templateResourceList.get(0));
    }

    boolean areFloatResourcesLinkable(BooleanResultDTO booleanResultDTO, List<TemplateResource> templateResourceList) {
        String statusMsg = TemplateResource.isValidFloatGroup(templateResourceList);
        return this.isLinkableResourcesMsg(booleanResultDTO, statusMsg, templateResourceList.get(0));
    }

    private boolean isLinkableResourcesMsg(BooleanResultDTO booleanResultDTO, String statusMsg, TemplateResource templateResource) {
        if (!statusMsg.equalsIgnoreCase("OK")) {
            booleanResultDTO.setResult(false);
            booleanResultDTO.setErrorMsg(statusMsg);
            booleanResultDTO.setInfoMsg(templateResource.getGroupId());
            return false;
        }
        return true;
    }

    private void deleteTemplateResourceAnnotations(TemplateResource selectedTemplateResource) {
        List<TemplateResourceAnnotations> templateResourceAnnotations = this.templateResourceDAO.findTemplateResourceAnnotationsByTemplateResource(selectedTemplateResource);
        templateResourceAnnotations.forEach(this.appointmentDAO::deleteEntity);
    }

    boolean deleteTemplateResourceValidation(TemplateResourceDTO templateResourceDTO, TemplateResource selectedTemplateResource) {
        boolean isResourceBooked = this.appointmentDAO.findBookedResourcesByBookedVisit(selectedTemplateResource);
        if (isResourceBooked) {
            templateResourceDTO.setInfoMsg("resource is booked");
            templateResourceDTO.setErrorMsg("At least one visit has been scheduled from this visit template, so you cannot delete a resource. Please create a new visit template with the current list of resources.");
            return false;
        }
        return true;
    }

    void adjustDurationUnapproveAndUpdateVisitTemplate(String institution, String templatePath, VisitTemplate visitTemplate) {
        List<TemplateResource> templateResourcesByVisit = this.templateResourceDAO.findTemplateResourcesByVisit(visitTemplate);
        int totalDuration = this.computeTotalDuration(visitTemplate, templateResourcesByVisit);
        visitTemplate.setDuration(totalDuration);
        if (visitTemplate.getApproved().booleanValue()) {
            visitTemplate.setApproved(Boolean.FALSE);
            this.sendVisitTemplateResourceUpdatedEmail(visitTemplate, institution, true, templatePath);
        }
        visitTemplate.setLastUpdateTime(new Date());
        this.appointmentDAO.updateEntity(visitTemplate);
    }

    TemplateResource createTempResourceSlot(Resource selectedResource, TemplateResource templateResource) {
        return this.searchAlgorithmService.createTempResourceSlot(selectedResource, templateResource);
    }

    Map<Date, List<ResourceSchedule>> retrieveResourceOverrideSchedule(Resource resource, Date startTime, Date endTime) {
        HashMap<Date, List<ResourceSchedule>> dayOfWeekSchedule = new HashMap<Date, List<ResourceSchedule>>();
        List<ResourceSchedule> overrideScheduleList = this.resourceDAO.findExceptionSchedule(resource, startTime, endTime, true);
        if (!overrideScheduleList.isEmpty()) {
            this.populateOverrideScheduleByDate(overrideScheduleList, dayOfWeekSchedule);
        }
        return dayOfWeekSchedule;
    }

    void populateSublocationClosureIntervalScheduleByDate(List<SublocationClosureInterval> resourceScheduleCollection, Map<Date, List<SublocationClosureInterval>> dayOfWeekSchedule) {
        if (MiscUtil.isNonNullNonEmpty(resourceScheduleCollection)) {
            for (SublocationClosureInterval rs : resourceScheduleCollection) {
                Map<Date, String> weekDays = this.retrieveDaysOfWeek(rs.getStartTime(), rs.getEndTime());
                if (weekDays == null) continue;
                for (Map.Entry<Date, String> entry : weekDays.entrySet()) {
                    Date dayOfWeek = entry.getKey();
                    List<Object> schedules = dayOfWeekSchedule.containsKey(dayOfWeek) ? dayOfWeekSchedule.get(dayOfWeek) : new ArrayList();
                    SublocationClosureInterval es = this.createNewSublocationClosureIntervalByDate(rs, entry.getKey());
                    schedules.add(es);
                    dayOfWeekSchedule.put(dayOfWeek, schedules);
                }
            }
        }
    }

    void populateOverrideScheduleByDate(List<ResourceSchedule> resourceScheduleCollection, Map<Date, List<ResourceSchedule>> dayOfWeekSchedule) {
        if (MiscUtil.isNonNullNonEmpty(resourceScheduleCollection)) {
            for (ResourceSchedule rs : resourceScheduleCollection) {
                Map<Date, String> weekDays = this.retrieveDaysOfWeek(rs.getStartTime(), rs.getEndTime());
                if (weekDays == null) continue;
                for (Map.Entry<Date, String> entry : weekDays.entrySet()) {
                    Date dayOfWeek = entry.getKey();
                    List<Object> schedules = dayOfWeekSchedule.containsKey(dayOfWeek) ? dayOfWeekSchedule.get(dayOfWeek) : new ArrayList();
                    ResourceSchedule es = this.createNewExceptionScheduleByDate(rs, entry.getKey());
                    schedules.add(es);
                    dayOfWeekSchedule.put(dayOfWeek, schedules);
                }
            }
        }
    }

    Map<Date, String> retrieveDaysOfWeek(Date startDate, Date endDate) {
        return this.searchAlgorithmService.retrieveDaysOfWeek(startDate, endDate);
    }

    ResourceSchedule createNewExceptionScheduleByDate(ResourceSchedule curSchedule, Date startDate) {
        ResourceSchedule es = new ResourceSchedule();
        es.setDayOfWeek(null);
        es.setEndTime(startDate);
        es.setEndTime(curSchedule.getEndTime());
        es.setId(curSchedule.getId());
        es.setQuantity(curSchedule.getQuantity());
        es.setStartTime(startDate);
        es.setStartTime(curSchedule.getStartTime());
        return es;
    }

    SublocationClosureInterval createNewSublocationClosureIntervalByDate(SublocationClosureInterval curSchedule, Date startDate) {
        SublocationClosureInterval es = new SublocationClosureInterval();
        es.setEndTime(startDate);
        es.setEndTime(curSchedule.getEndTime());
        es.setId(curSchedule.getId());
        es.setStartTime(startDate);
        es.setStartTime(curSchedule.getStartTime());
        return es;
    }

    boolean checkAvailability(TemplateResource requestResource, List<BookedResource> availableBookedResourceSlots, List<TemplateResource> availableResourceSlots) {
        return this.searchAlgorithmService.checkAvailability(requestResource, availableBookedResourceSlots, availableResourceSlots);
    }

    int computePeriodOfDate(Date date) {
        return this.searchAlgorithmService.computePeriodOfDate(date);
    }

    int computeLastPeriod(Date date1, Date date2) {
        return this.searchAlgorithmService.computeLastPeriod(date1, date2);
    }

    void adjustMapsForBookedResources(Map<Integer, Integer> candidatePeriodToQtyMap, Date reservedStartDate, Date reservedEndDate, Date candidateStartDate) {
        this.searchAlgorithmService.adjustMapsForBookedResources(candidatePeriodToQtyMap, reservedStartDate, reservedEndDate, candidateStartDate);
    }

    void loadIntoPeriodToQuantityMap(int resourceQuantity, int firstPeriod, int lastPeriod, Map<Integer, Integer> periodToQuantityMap) {
        this.searchAlgorithmService.loadIntoPeriodToQuantityMap(resourceQuantity, firstPeriod, lastPeriod, periodToQuantityMap);
    }

    float computeTotalResources(Date scheduledStartTime, Date scheduledEndTime, List<TimeBoundedIdentity> scheduleList, Map<Integer, Integer> periodToQuantityMap) {
        float totalResources = -1.0f;
        int day = 0;
        for (TimeBoundedIdentity schedule : scheduleList) {
            Date startTimeDate = schedule.getStartTime();
            Date endTimeDate = schedule.getEndTime();
            int firstPeriod = this.computePeriodOfDate(startTimeDate) + 96 * day;
            int lastPeriod = this.computeLastPeriod(startTimeDate, endTimeDate) + 96 * day;
            this.loadIntoPeriodToQuantityMap(schedule.getQuantity(), firstPeriod, lastPeriod, periodToQuantityMap);
            ++day;
        }
        int firstPeriod = this.computePeriodOfDate(scheduledStartTime);
        int lastPeriod = this.computeLastPeriod(scheduledStartTime, scheduledEndTime);
        for (int i = firstPeriod; i <= lastPeriod; ++i) {
            Integer currentQuantity = periodToQuantityMap.get(i);
            if ((currentQuantity == null || currentQuantity < 0) && totalResources == -1.0f) {
                return -1.0f;
            }
            if (currentQuantity == null || currentQuantity < 0 && totalResources != -1.0f) {
                return totalResources;
            }
            if (currentQuantity != null && totalResources == -1.0f) {
                totalResources = currentQuantity.intValue();
                continue;
            }
            if (currentQuantity == null || !((float)currentQuantity.intValue() < totalResources)) continue;
            totalResources = currentQuantity.intValue();
        }
        return totalResources;
    }

    float retrieveTotalResourcesFromOverrideSchedule(List<ResourceSchedule> scheduleListParam, Date scheduledStartTime, Date scheduledEndTime, Map<Integer, Integer> periodToQuantityMap) {
        ArrayList<TimeBoundedIdentity> finalScheduleList = new ArrayList<TimeBoundedIdentity>();
        List<TimeBoundedIdentity> scheduleList = ResourceSchedule.toTimeBoundedIdentityList(scheduleListParam);
        if (scheduleList != null) {
            finalScheduleList.addAll(scheduleList);
        }
        return this.computeTotalResources(scheduledStartTime, scheduledEndTime, finalScheduleList, periodToQuantityMap);
    }

    Date modifyDateFieldPlusAmtSetHourMinute(Date date, int field, int amount, int hour, int minute) {
        return this.searchAlgorithmService.modifyDateFieldPlusAmtSetHourMinute(date, field, amount, hour, minute);
    }

    Date beginningOfDayPlus(Date date, int deltaDays) {
        LocalDateTime ldt = DateUtility.dateToLocalDateTime(date);
        LocalDateTime cleared = ldt.withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime adjusted = cleared.plusDays(deltaDays);
        return DateUtility.toDate(adjusted);
    }

    Date beginningOfDay(Date date) {
        return this.beginningOfDayPlus(date, 0);
    }

    int findEarliestInpatientStartTime(List<TemplateResource> resources) {
        int earliestStartTimeInMin = 0;
        int currentStartTimeInMin = 0;
        for (TemplateResource r : resources) {
            if (r.getStartMinutes() != null) {
                currentStartTimeInMin = r.getStartMinutes();
            }
            if (earliestStartTimeInMin == 0 || currentStartTimeInMin == 0) {
                earliestStartTimeInMin = 0;
                continue;
            }
            if (earliestStartTimeInMin <= 0 || currentStartTimeInMin >= earliestStartTimeInMin) continue;
            earliestStartTimeInMin = currentStartTimeInMin;
        }
        return earliestStartTimeInMin;
    }

    int findEarliestInpatientClockStartTime(List<TemplateResource> resources) {
        return this.searchAlgorithmService.findEarliestInpatientClockStartTime(resources);
    }

    int findLatestInpatientEndTime(List<TemplateResource> resources) {
        return this.searchAlgorithmService.findLatestInpatientEndTime(resources);
    }

    public List<BookedVisit> findCandidateVisits(VisitSpecsDTO visitSpecsDTO, UserSession userSession, boolean confirmEvent, boolean rejectedCheck, boolean isInpatient) {
        return this.searchAlgorithmService.findCandidateVisits(visitSpecsDTO, userSession, confirmEvent, rejectedCheck, isInpatient);
    }

    String checkForGenderBlock(Subject subject, List<BookedResource> bookedResources) {
        Object genderBlockDetailsMessage = "";
        for (BookedResource bookedResource : bookedResources) {
            if (!this.isSharedRoom(bookedResource.getResource())) continue;
            genderBlockDetailsMessage = (String)genderBlockDetailsMessage + this.checkForGenderBlockInBookingsOfSharedResource(bookedResource, subject);
        }
        return ((String)genderBlockDetailsMessage).length() == 0 ? null : genderBlockDetailsMessage;
    }

    String checkForGenderBlockInBookingsOfSharedResource(BookedResource newResourceBookingAttempt, Subject subjectInNewResourceBooking) {
        Object genderBlockDetailsMessage = "";
        Resource sharedResource = this.resourceDAO.findResourceById(newResourceBookingAttempt.getResource().getSharedResource());
        List<BookedResource> existingBookingsOfSharedResource = this.appointmentDAO.findBookedResources(sharedResource);
        for (BookedResource existingBookingOfSharedResource : existingBookingsOfSharedResource) {
            SubjectMrn subjectMrnInExistingBooking;
            if (!newResourceBookingAttempt.overlapsWith(existingBookingOfSharedResource) || (subjectMrnInExistingBooking = existingBookingOfSharedResource.getBookedVisit().getSubjectMrn()) == null) continue;
            Subject subjectInExistingBooking = subjectMrnInExistingBooking.getSubject();
            GenderType genderTypeOfSubjectInExistingBooking = subjectInExistingBooking.getGenderType();
            GenderType genderTypeOfSubjectInNewBooking = subjectInNewResourceBooking.getGenderType();
            if (genderTypeOfSubjectInNewBooking.equals(genderTypeOfSubjectInExistingBooking) && subjectInExistingBooking.canShareResource()) continue;
            genderBlockDetailsMessage = (String)genderBlockDetailsMessage + sharedResource.getName() + " (Shared Private room) has been booked for a Subject whose Sex is " + genderTypeOfSubjectInExistingBooking.getGenderName();
        }
        return genderBlockDetailsMessage;
    }

    boolean isSharedRoom(Resource resource) {
        if (!resource.getResourceType().isRoom()) {
            return false;
        }
        Integer sharedResourceId = resource.getSharedResource();
        if (sharedResourceId == null || sharedResourceId.equals(0)) {
            return false;
        }
        return this.resourceDAO.findResourceById(sharedResourceId) != null;
    }

    public List<LineLevelAnnotations> getResourceAnnotations(int resource) {
        Resource r = this.resourceDAO.findResourceById(resource);
        ArrayList<LineLevelAnnotations> rs = new ArrayList<LineLevelAnnotations>();
        List<ResourceAnnotation> ra = this.resourceDAO.findResourcesAnnotationsByResource(r);
        if (MiscUtil.isNonNullNonEmpty(ra)) {
            for (int i = 0; i < ra.size(); ++i) {
                rs.add(ra.get(i).getLineLevelAnnotations());
            }
        }
        Collections.sort(rs, new LineLevelAnnotations.AnnotationsComparator());
        return rs;
    }

    void computeAndSetDuration(TemplateResource templateResource) {
        this.searchAlgorithmService.computeAndSetDuration(templateResource);
    }

    public BookedVisit rescheduleData(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress, String templatePath, Boolean followOriginalTemplate) {
        BookedVisit result = followOriginalTemplate != null && followOriginalTemplate != false ? this.rescheduleDataFromTemplate(visitSpecsDTO, user, ipAddress, templatePath) : this.rescheduleDataFromVisit(visitSpecsDTO, user, ipAddress);
        return result;
    }

    public BookedVisit rescheduleDataFromTemplate(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress, String templatePath) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getBookedvisit());
        VisitTemplate visitTemplate = bookedVisit.getVisitTemplate();
        Date eventDate = new Date(visitSpecsDTO.getStartDate());
        AppointmentOverrideReason overrideReason = this.appointmentDAO.findAppointmentOverrideReasonById(visitSpecsDTO.getOverrideReason());
        TemplateResource templateResourceLowest = this.templateResourceDAO.findTemplateResourceLowest(visitTemplate);
        Date lowestStartDate = templateResourceLowest.getStartDate();
        Calendar scheduledEndTimeCal = this.updateDatesForBV(visitTemplate, eventDate, lowestStartDate);
        BookedVisit clonedVisit = this.createClonedBookedVisit(user, bookedVisit, eventDate, scheduledEndTimeCal);
        List<TemplateResource> templateResourceList = this.templateResourceDAO.findTemplateResourcesByVisit(visitTemplate);
        this.setRoomsForBVFromTemplate(clonedVisit, templateResourceList);
        this.createBookedVisitComments(visitSpecsDTO, user, ipAddress, clonedVisit);
        int eventDateMinutesDelta = 0;
        if (visitTemplate.getVisitType().isInpatient() && !visitTemplate.getRelativeTime().booleanValue()) {
            eventDate.setHours(lowestStartDate.getHours());
            eventDate.setMinutes(lowestStartDate.getMinutes());
            eventDate.setSeconds(0);
        } else {
            eventDateMinutesDelta = eventDate.getHours() * 60 + eventDate.getMinutes();
        }
        this.setupBookedResourcesForBookedVisit(user, templatePath, templateResourceList, eventDate, clonedVisit, eventDateMinutesDelta);
        this.auditService.logAppointmentActivity(ipAddress, clonedVisit, user, BookedVisitActivityLogStatics.RESCHEDULED, overrideReason);
        return clonedVisit;
    }

    protected void setRoomsForBVFromTemplate(BookedVisit clonedVisit, List<TemplateResource> templateResourceList) {
        Object rooms = " ";
        for (TemplateResource templateResource : templateResourceList) {
            Resource resource = templateResource.getResource();
            if (!resource.getResourceType().getName().equalsIgnoreCase("Room")) continue;
            rooms = resource.getName() + ", ";
        }
        clonedVisit.setRooms((String)rooms);
    }

    protected Calendar updateDatesForBV(VisitTemplate visitTemplate, Date eventDate, Date lowestStartDate) {
        if (visitTemplate.getVisitType().isInpatient() && !visitTemplate.getRelativeTime().booleanValue()) {
            eventDate.setHours(lowestStartDate.getHours());
            eventDate.setMinutes(lowestStartDate.getMinutes());
            eventDate.setSeconds(0);
        }
        Calendar scheduledEndTimeCal = Calendar.getInstance();
        scheduledEndTimeCal.clear();
        scheduledEndTimeCal.setTime(eventDate);
        scheduledEndTimeCal.add(12, visitTemplate.getDuration());
        scheduledEndTimeCal.set(13, 0);
        scheduledEndTimeCal.set(14, 0);
        return scheduledEndTimeCal;
    }

    BookedVisit tryCloneVisit(BookedVisit bookedVisit) {
        return bookedVisit.cloneBookedVisit();
    }

    public BookedVisit rescheduleDataFromVisit(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getBookedvisit());
        VisitTemplate visitTemplate = bookedVisit.getVisitTemplate();
        Date eventDate = new Date(visitSpecsDTO.getStartDate());
        AppointmentOverrideReason overrideReason = this.appointmentDAO.findAppointmentOverrideReasonById(visitSpecsDTO.getOverrideReason());
        BookedResource bookedResourceLowest = this.studyDAO.findBookedResourceLowest(bookedVisit);
        List<BookedResource> bookedResourceList = this.appointmentDAO.findBookedResourcesByBookedVisit(bookedVisit);
        Date earliestBookedResourceTime = bookedResourceLowest.getScheduledStartTime();
        Date latestBookedResourceTime = this.appointmentDAO.findLatestBookedResourcesByBookedVisit(bookedVisit);
        int visitDuration = (int)(latestBookedResourceTime.getTime() / 60000L - earliestBookedResourceTime.getTime() / 60000L);
        VisitType visitType = visitTemplate.getVisitType();
        Calendar scheduledEndTimeCal = this.createStartAndEndDateForBV(visitTemplate, eventDate, bookedResourceLowest, visitDuration, visitType);
        Date originalVisitStartDate = bookedVisit.getScheduledStartTime();
        BookedVisit clonedVisit = this.createClonedBookedVisit(user, bookedVisit, eventDate, scheduledEndTimeCal);
        this.setRoomsForBVFromBookedVisit(bookedResourceList, clonedVisit);
        this.createBookedVisitComments(visitSpecsDTO, user, ipAddress, clonedVisit);
        this.setupResourcesForRescheduledByVisit(bookedResourceList, clonedVisit, eventDate, originalVisitStartDate);
        this.auditService.logAppointmentActivity(ipAddress, clonedVisit, user, BookedVisitActivityLogStatics.RESCHEDULED, overrideReason);
        return clonedVisit;
    }

    private void setRoomsForBVFromBookedVisit(List<BookedResource> bookedResourceList, BookedVisit clonedVisit) {
        Object rooms = " ";
        for (BookedResource bookedResource : bookedResourceList) {
            Resource resource = bookedResource.getResource();
            if (!resource.getResourceType().getName().equalsIgnoreCase("Room")) continue;
            rooms = resource.getName() + ", ";
        }
        clonedVisit.setRooms((String)rooms);
    }

    private Calendar createStartAndEndDateForBV(VisitTemplate visitTemplate, Date eventDate, BookedResource bookedResourceLowest, int visitDuration, VisitType visitType) {
        if (visitType.isInpatient() && !visitTemplate.getRelativeTime().booleanValue()) {
            Date lowestStartDate = bookedResourceLowest.getScheduledStartTime();
            eventDate.setHours(lowestStartDate.getHours());
            eventDate.setMinutes(lowestStartDate.getMinutes());
            eventDate.setSeconds(0);
        }
        Calendar scheduledEndTimeCal = Calendar.getInstance();
        scheduledEndTimeCal.clear();
        scheduledEndTimeCal.setTime(eventDate);
        scheduledEndTimeCal.add(12, visitDuration);
        scheduledEndTimeCal.set(13, 0);
        scheduledEndTimeCal.set(14, 0);
        return scheduledEndTimeCal;
    }

    protected void createBookedVisitComments(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress, BookedVisit clonedVisit) {
        if (MiscUtil.isNonNullNonEmpty(visitSpecsDTO.getComment())) {
            Comments comments = new Comments();
            comments.setComment(visitSpecsDTO.getComment());
            comments.setBookedVisit(clonedVisit);
            comments.setUser(user);
            comments.setDate(new Date());
            this.appointmentDAO.createEntity(comments);
            this.auditService.logAppointmentActivity(ipAddress, clonedVisit, user, BookedVisitActivityLogStatics.COMMENTED);
        }
    }

    protected BookedVisit createClonedBookedVisit(User user, BookedVisit bookedVisit, Date eventDate, Calendar scheduledEndTimeCal) {
        BookedVisit clonedVisit = this.tryCloneVisit(bookedVisit);
        clonedVisit.setId(null);
        clonedVisit.setAppointmentStatusReason(null);
        clonedVisit.setCancelStatus(null);
        if (null == clonedVisit.getSubjectMrn()) {
            clonedVisit.setAppointmentStatus(this.holdStatus());
        } else {
            clonedVisit.setAppointmentStatus(this.scheduledStatus());
        }
        clonedVisit.setScheduledStartTime(eventDate);
        clonedVisit.setScheduledEndTime(scheduledEndTimeCal.getTime());
        clonedVisit.setCancelDate(null);
        clonedVisit.setCancelUser(null);
        clonedVisit.setCancelStatusReason(null);
        clonedVisit.setComment("");
        clonedVisit.setSchedulingTime(new Date());
        clonedVisit.setSchedulingUser(user);
        clonedVisit.setSchedulingFlavor(BookedVisitActivityLogStatics.RESCHEDULED.getLogString());
        this.appointmentDAO.createEntity(clonedVisit);
        return clonedVisit;
    }

    void setupResourcesForRescheduledByVisit(List<BookedResource> bookedResourceList, BookedVisit clonedVisit, Date eventDate, Date originalVisitStartDate) {
        ArrayList clonedBookedResourceList = Lists.newArrayList();
        for (BookedResource bookedResource : bookedResourceList) {
            BookedResource clonedBookedResource = bookedResource.cloneBookedResource();
            clonedBookedResource.setId(null);
            clonedBookedResource.setBookedVisit(clonedVisit);
            clonedBookedResourceList.add(clonedBookedResource);
            Integer deltaStartTime = (int)(clonedBookedResource.getScheduledStartTime().getTime() - originalVisitStartDate.getTime());
            Date newStartTime = new Date(eventDate.getTime() + (long)deltaStartTime.intValue());
            clonedBookedResource.setScheduledStartTime(newStartTime);
            long endDuration = clonedBookedResource.getDuration().intValue();
            long endDurationMillis = endDuration * 60L * 1000L;
            long newEndTimeMillis = newStartTime.getTime();
            Date newEndTime = new Date(newEndTimeMillis + endDurationMillis);
            clonedBookedResource.setScheduledEndTime(newEndTime);
            this.appointmentDAO.createEntity(clonedBookedResource);
            List<OverrideBookedResourceAnnotations> obrasToClone = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(bookedResource);
            for (OverrideBookedResourceAnnotations obraToClone : obrasToClone) {
                OverrideBookedResourceAnnotations clonedObra = obraToClone.cloneObra();
                clonedObra.setBookedResource(clonedBookedResource);
                this.appointmentDAO.createEntity(clonedObra);
            }
        }
    }

    boolean overbookTimeWithin24Hours(Date visitStartTime, Date overbookTime) {
        long diff = visitStartTime.getTime() - overbookTime.getTime();
        long diffHours = diff / 3600000L;
        return diffHours <= 24L;
    }

    void persistBookedResources(List<BookedResource> resources, BookedVisit bookedVisit) {
        if (MiscUtil.isNullOrEmpty(resources)) {
            return;
        }
        for (BookedResource resource : resources) {
            resource.setBookedVisit(bookedVisit);
            resource.setBillable(resource.getTemplateResource().getBillable());
            this.appointmentDAO.createEntity(resource);
            List<TemplateResourceAnnotations> tr = this.templateResourceDAO.findTemplateResourceAnnotationsByTemplateResource(resource.getTemplateResource());
            if (tr.size() <= 0) continue;
            for (TemplateResourceAnnotations tra : tr) {
                OverrideBookedResourceAnnotations bookedResourceAnnotations = new OverrideBookedResourceAnnotations();
                bookedResourceAnnotations.setBookedResource(resource);
                bookedResourceAnnotations.setLineLevelAnnotations(tra.getLineLevelAnnotations());
                bookedResourceAnnotations.setComment(tra.getComment());
                bookedResourceAnnotations.setQuantity(tra.getQuantity());
                this.appointmentDAO.createEntity(bookedResourceAnnotations);
            }
        }
    }

    void persistVisit(BookedVisit visit, UserSession user, String ipAddress) {
        visit.setSchedulingTime(new Date());
        visit.setSchedulingUser(user.getUser());
        visit.setSchedulingFlavor(BookedVisitActivityLogStatics.SCHEDULED.getLogString());
        this.appointmentDAO.createEntity(visit);
        this.auditService.logAppointmentActivity(ipAddress, visit, user.getUser(), BookedVisitActivityLogStatics.SCHEDULED);
    }

    public BookedVisit confirmOverbookRoomData(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress, String templatePath) {
        Date eventDate = new Date(visitSpecsDTO.getStartDate());
        SubjectMrn selectedSubjectMrn = this.subjectDAO.findSubjectMrnById(visitSpecsDTO.getSubjectMrnId());
        VisitTemplate selectedVisit = this.studyDAO.findVisitTemplateById(visitSpecsDTO.getVisit());
        TemplateResource templateResourceLowest = this.templateResourceDAO.findTemplateResourceLowest(selectedVisit);
        int eventDateMinutesDelta = 0;
        if (selectedVisit.getVisitType().isInpatient() && !selectedVisit.getRelativeTime().booleanValue()) {
            eventDate.setHours(templateResourceLowest.getStartDate().getHours());
            eventDate.setMinutes(templateResourceLowest.getStartDate().getMinutes());
            eventDate.setSeconds(0);
        } else {
            eventDateMinutesDelta = eventDate.getHours() * 60 + eventDate.getMinutes();
        }
        AppointmentOverrideReason overrideReason = this.appointmentDAO.findAppointmentOverrideReasonById(visitSpecsDTO.getOverrideReason());
        BookedVisit independentVisit = new BookedVisit();
        independentVisit.setAppointmentStatus(selectedSubjectMrn == null ? this.holdStatus() : this.scheduledStatus());
        independentVisit.setAppointmentStatusReason(null);
        independentVisit.setBookedResourceList(null);
        independentVisit.setCancelDate(null);
        independentVisit.setCancelUser(null);
        independentVisit.setCancelStatus(null);
        independentVisit.setCancelStatusReason(null);
        independentVisit.setCheckInDate(null);
        independentVisit.setCheckInUser(null);
        independentVisit.setCheckOutDate(null);
        independentVisit.setCheckOutUser(null);
        independentVisit.setCheckoutStatusReason(null);
        independentVisit.setName(selectedVisit.getName());
        independentVisit.setScheduledEndTime(eventDate);
        independentVisit.setScheduledStartTime(eventDate);
        independentVisit.setStudy(selectedVisit.getStudy());
        independentVisit.setSubjectMrn(selectedSubjectMrn);
        independentVisit.setVisitTemplate(selectedVisit);
        independentVisit.setVisitType(selectedVisit.getVisitType());
        independentVisit.setComment(visitSpecsDTO.getComment());
        this.appointmentDAO.createEntity(independentVisit);
        this.createCommentsRecordIfNonemptyComment(independentVisit, user, ipAddress);
        List<TemplateResource> templateResourcesByVisit = this.templateResourceDAO.findTemplateResourcesByVisit(selectedVisit);
        List<Resource> selectedResources = this.setupBookedResourcesForAppointmentWithVisitTime(visitSpecsDTO, user, templatePath, eventDate, independentVisit, templateResourcesByVisit, eventDateMinutesDelta);
        if (!selectedResources.isEmpty()) {
            BookedVisitActivityLog bval = new BookedVisitActivityLog();
            bval.setActionPerformed(BookedVisitActivityLogStatics.OVERBOOKED.getLogString());
            bval.setBookedVisit(independentVisit);
            bval.setPerformingUser(user);
            bval.setDate(new Date());
            bval.setIpAddress(ipAddress);
            bval.setAppointmentOverrideReason(overrideReason);
            this.appointmentDAO.createEntity(bval);
            Object rooms = " ";
            for (Resource resource : selectedResources) {
                if (!resource.getResourceType().getName().equalsIgnoreCase("Room")) continue;
                rooms = (String)rooms + resource.getName() + ", ";
                independentVisit.setRooms((String)rooms);
            }
            independentVisit.setSchedulingTime(new Date());
            independentVisit.setSchedulingUser(user);
            independentVisit.setSchedulingFlavor(BookedVisitActivityLogStatics.OVERBOOKED.getLogString());
            this.appointmentDAO.updateEntity(independentVisit);
            if (this.overbookTimeWithin24Hours(independentVisit.getScheduledStartTime(), Calendar.getInstance().getTime())) {
                List<TemplateResource> trs = this.templateResourceDAO.findTemplateResourcesByVisit(selectedVisit);
                ArrayList<String> conditions = new ArrayList<String>();
                boolean containsNursingResources = ListUtils.enrich(trs).exists(res -> res.getResource().getResourceType().isNursing());
                boolean containsNutritionResources = ListUtils.enrich(trs).exists(res -> res.getResource().getResourceType().isNursing());
                boolean containsLabResources = ListUtils.enrich(trs).exists(res -> res.getResource().getResourceType().isNursing());
                if (containsNursingResources) {
                    conditions.add("This visit contains Nursing resources. ");
                }
                if (containsNutritionResources) {
                    conditions.add("This visit contains Nutrition resources. ");
                }
                if (containsLabResources) {
                    conditions.add("This visit contains Lab resources. ");
                }
                this.sendOverBookedVisitEmail(independentVisit, user.getInstitution().getLongName(), templatePath, conditions);
            }
        }
        return independentVisit;
    }

    public BookedVisit overbookRoomData(VisitSpecsDTO visitSpecsDTO) {
        Date visitStartTime = new Date(visitSpecsDTO.getStartDate());
        SubjectMrn selectedStudyMrn = this.subjectDAO.findSubjectMrnById(visitSpecsDTO.getSubjectMrnId());
        VisitTemplate selectedVisitTemplate = this.studyDAO.findVisitTemplateById(visitSpecsDTO.getVisit());
        TemplateResource templateResourceLowest = this.templateResourceDAO.findTemplateResourceLowest(selectedVisitTemplate);
        if (selectedVisitTemplate.getVisitType().isInpatient() && !selectedVisitTemplate.getRelativeTime().booleanValue()) {
            visitStartTime.setHours(templateResourceLowest.getStartDate().getHours());
            visitStartTime.setMinutes(templateResourceLowest.getStartDate().getMinutes());
            visitStartTime.setSeconds(0);
        }
        AppointmentStatus status = this.scheduledStatus();
        int minutes = visitStartTime.getHours() * 60 + visitStartTime.getMinutes();
        int endMinutes = minutes + selectedVisitTemplate.getDuration();
        int hours = MiscUtil.divideByMinsPerHour(endMinutes);
        int min = MiscUtil.moduloMinsPerHour(endMinutes);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(visitStartTime);
        cal.set(11, hours);
        cal.set(12, min);
        cal.set(13, 0);
        cal.set(14, 0);
        BookedVisit bookedVisit = new BookedVisit();
        bookedVisit.setAppointmentStatus(status);
        bookedVisit.setAppointmentStatusReason(null);
        bookedVisit.setBookedResourceList(null);
        bookedVisit.setCancelDate(null);
        bookedVisit.setCancelUser(null);
        bookedVisit.setCancelStatus(null);
        bookedVisit.setCancelStatusReason(null);
        bookedVisit.setCheckInDate(null);
        bookedVisit.setCheckInUser(null);
        bookedVisit.setCheckOutDate(null);
        bookedVisit.setCheckInUser(null);
        bookedVisit.setCheckoutStatusReason(null);
        bookedVisit.setComment("");
        bookedVisit.setName(selectedVisitTemplate.getName());
        bookedVisit.setScheduledEndTime(cal.getTime());
        bookedVisit.setScheduledStartTime(visitStartTime);
        bookedVisit.setStudy(selectedVisitTemplate.getStudy());
        bookedVisit.setSubjectMrn(selectedStudyMrn);
        bookedVisit.setVisitTemplate(selectedVisitTemplate);
        bookedVisit.setVisitType(selectedVisitTemplate.getVisitType());
        List<TemplateResource> templateResourcesForSelectedVisit = this.templateResourceDAO.findTemplateResourcesByVisit(selectedVisitTemplate);
        List<Resource> roomResources = this.resourceDAO.getRooms();
        if (visitSpecsDTO.getRoomSelected() == 0) {
            TemplateResource templateResource = new TemplateResource();
            this.setupTemplateResource(templateResource, selectedVisitTemplate, bookedVisit);
            for (Resource alternateResource : roomResources) {
                templateResource.setResource(alternateResource);
                TemplateResource altResource = this.createTempResourceSlot(alternateResource, templateResource);
                boolean isAvailable = this.checkAvailability(altResource, bookedVisit.getBookedResourceList(), templateResourcesForSelectedVisit);
                if (!isAvailable) continue;
                templateResource.setResource(altResource.getResource());
                bookedVisit.setSelectedRoom(altResource.getResource());
                break;
            }
        } else if (visitSpecsDTO.getRoomSelected() != 0) {
            Resource room = this.resourceDAO.findResourceById(visitSpecsDTO.getRoomSelected());
            bookedVisit.setSelectedRoom(room);
        }
        this.setTemplateResourceTimes(visitStartTime, templateResourcesForSelectedVisit);
        return bookedVisit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfirmationStatus confirmEvent(VisitSpecsDTO visitSpecsDTO, UserSession user, String ipAddress, String institution, String templatePath, boolean isInpatient) {
        Object object = this.confirmationLock;
        synchronized (object) {
            Date startDate = new Date(visitSpecsDTO.getStartDate());
            Date endDate = new Date(visitSpecsDTO.getEndDate());
            if (this.timeSlotAvailable(visitSpecsDTO, user, isInpatient)) {
                if (visitSpecsDTO.getDoubleRoomMessage() == null) {
                    this.confirmVisitBooking(visitSpecsDTO, user, ipAddress, institution, templatePath, startDate, endDate);
                } else {
                    this.confirmVisitBookingAfterDoubleRoomMessage(visitSpecsDTO, user, ipAddress, institution, templatePath, startDate, endDate);
                }
                return ConfirmationStatus.Confirmed;
            }
            return ConfirmationStatus.NotConfirmed;
        }
    }

    boolean timeSlotAvailable(VisitSpecsDTO visitSpecsDTO, UserSession userSession, boolean isInpatient) {
        return this.conflictChecker.timeSlotAvailable(visitSpecsDTO, userSession, isInpatient);
    }

    void confirmVisitBookingAfterDoubleRoomMessage(VisitSpecsDTO visitSpecsDTO, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
        this.appointmentConfirmer.confirmVisitBookingAfterDoubleRoomMessage(this, visitSpecsDTO, userSession, ipAddress, institution, templatePath, startDate, endDate);
    }

    void confirmVisitBooking(VisitSpecsDTO visitSpecsDTO, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
        this.appointmentConfirmer.confirmVisitBooking(this, visitSpecsDTO, userSession, ipAddress, institution, templatePath, startDate, endDate);
    }

    void sendWeighedMealEmail(BookedVisit resVisit, BookedResource br, String institution, String templatePath) {
        String title = "Weighed Meal booked for : " + br.getScheduledStartTime();
        String visitName = resVisit.getName();
        String studyName = resVisit.getStudy().getName();
        String localId = resVisit.getStudy().getLocalId();
        String catalystId = resVisit.getStudy().getCatalystId();
        String irb = resVisit.getStudy().getIrb();
        String investigator = null;
        if (resVisit.getStudy().getInvestigator() != null) {
            investigator = resVisit.getStudy().getInvestigator().getFirstName() + " " + resVisit.getStudy().getInvestigator().getLastName();
        }
        String startTime = resVisit.getScheduledStartTime().toString();
        String endTime = resVisit.getScheduledEndTime().toString();
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate meal = group.getInstanceOf("weighedMealEmail");
        meal.setAttribute("institution", (Object)institution);
        meal.setAttribute("visitName", (Object)visitName);
        meal.setAttribute("studyName", (Object)studyName);
        meal.setAttribute("investigator", (Object)investigator);
        meal.setAttribute("startTime", (Object)startTime);
        meal.setAttribute("endTime", (Object)endTime);
        meal.setAttribute("localId", (Object)localId);
        meal.setAttribute("catalystId", (Object)catalystId);
        meal.setAttribute("irb", (Object)irb);
        if (resVisit.getStudy().getProtocolNutritionist() == null) {
            List<User> user = this.authDAO.findNutritionManagerUserByRole();
            for (User us : user) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(us.getPreferredNotificationEmail()).subject(title).text(meal.toString()).build());
            }
        } else if (resVisit.getStudy().getProtocolNutritionist() != null) {
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(resVisit.getStudy().getProtocolNutritionist().getPreferredNotificationEmail()).subject(title).text(meal.toString()).build());
        }
    }

    BookedVisit createBookedVisit(VisitSpecsDTO visitSpecsDTO, UserSession userSession, Date startDate, Date endDate) {
        Optional<Object> selectedSubjectMrnOption = visitSpecsDTO.getSubjectMrnId() != 0 ? Optional.ofNullable(this.subjectDAO.findSubjectMrnById(visitSpecsDTO.getSubjectMrnId())) : Optional.empty();
        Optional<VisitTemplate> selectedVisitTemplateOption = Optional.ofNullable(this.studyDAO.findVisitTemplateById(visitSpecsDTO.getVisit()));
        SubjectMrn subjectMrn = selectedSubjectMrnOption.orElse(null);
        VisitTemplate visitTemplate = selectedVisitTemplateOption.orElse(null);
        BookedVisit newVisit = new BookedVisit();
        User user = userSession.getUser();
        newVisit.setVisitTemplate(visitTemplate);
        Study study = this.studyDAO.findStudyById(visitSpecsDTO.getStudy());
        newVisit.setStudy(study);
        AppointmentStatus apptStatus = null;
        apptStatus = null != subjectMrn ? this.scheduledStatus() : this.holdStatus();
        newVisit.setAppointmentStatus(apptStatus);
        newVisit.setScheduledStartTime(startDate);
        newVisit.setScheduledEndTime(endDate);
        newVisit.setBookedResourceList(user.getBookedVisits().get(0).getBookedResourceList());
        if (newVisit.getBookedResourceList() == null) {
            newVisit.setBookedResourceList(Lists.newArrayList());
        }
        newVisit.setSubjectMrn(subjectMrn);
        newVisit.setComment(visitSpecsDTO.getComment());
        newVisit.setName(visitTemplate.getName());
        newVisit.setVisitType(visitTemplate.getVisitType());
        newVisit.setAppointmentStatusReason(null);
        return newVisit;
    }

    Comments createCommentsRecordIfNonemptyComment(BookedVisit bookedVisit, User user, String ipAddress) {
        Comments comments = null;
        String commentString = bookedVisit.getComment();
        if (MiscUtil.isNonNullNonEmpty(commentString)) {
            comments = new Comments();
            comments.setComment(commentString);
            comments.setBookedVisit(bookedVisit);
            comments.setUser(user);
            comments.setDate(new Date());
            this.appointmentDAO.createEntity(comments);
            this.auditService.logAppointmentActivity(ipAddress, bookedVisit, user, BookedVisitActivityLogStatics.COMMENTED);
        }
        return comments;
    }

    VisitCancelStatus calculateVisitCancelStatus(Date visitScheduledStartTime, Date cancelStatusTime, int cancelTimeHr, int cancelTimeMin) {
        Calendar cal = Calendar.getInstance();
        if (cancelStatusTime != null) {
            cal.clear();
            cal.setTime(cancelStatusTime);
        }
        if (cancelTimeHr >= 0) {
            cal.set(11, cancelTimeHr);
        }
        if (cancelTimeMin >= 0) {
            cal.set(12, cancelTimeMin);
        }
        return this.calculateCancellationStatus(visitScheduledStartTime, cal.getTime());
    }

    VisitCancelStatus calculateCancellationStatus(Date visitStartTime, Date cancelTime) {
        VisitCancelStatus status = this.cancelTimeAfterScheduledTime(visitStartTime, cancelTime) ? new VisitCancelStatus(5, "No Show") : (this.cancelTimeWithin48Hours(visitStartTime, cancelTime) ? new VisitCancelStatus(6, "Late Cancellation") : new VisitCancelStatus(7, "Cancellation"));
        return status;
    }

    boolean cancelTimeWithin48Hours(Date visitStartTime, Date cancelTime) {
        long diff = visitStartTime.getTime() - cancelTime.getTime();
        long diffHours = diff / 3600000L;
        return diffHours > 0L && diffHours <= 48L;
    }

    boolean cancelTimeAfterScheduledTime(Date visitStartTime, Date cancelTime) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(visitStartTime);
        cal.set(14, 0);
        Date visTime = cal.getTime();
        cal.clear();
        cal.setTime(cancelTime);
        cal.set(14, 0);
        Date curCancelTime = cal.getTime();
        return !curCancelTime.equals(visTime) && curCancelTime.after(visTime);
    }

    public Comments saveComment(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getId());
        bv.setComment(visitSpecsDTO.getComment());
        this.appointmentDAO.updateEntity(bv);
        return this.createCommentsRecordIfNonemptyComment(bv, user, ipAddress);
    }

    public BookedVisit checkInVisit(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getId());
        if (visitSpecsDTO.getCheckInDate() == 0L) {
            bv.setCheckInDate(Calendar.getInstance().getTime());
        } else {
            bv.setCheckInDate(new Date(visitSpecsDTO.getCheckInDate()));
        }
        bv.setCheckInUser(user);
        bv.setAppointmentStatus(this.checkedInStatus());
        this.appointmentDAO.updateEntity(bv);
        this.auditService.logAppointmentActivity(ipAddress, bv, user, BookedVisitActivityLogStatics.CHECKED_IN);
        return bv;
    }

    public BookedVisit checkOutVisit(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getId());
        if (visitSpecsDTO.getCheckOutDate() == 0L) {
            bv.setCheckOutDate(Calendar.getInstance().getTime());
        } else {
            bv.setCheckOutDate(new Date(visitSpecsDTO.getCheckOutDate()));
        }
        bv.setCheckOutUser(user);
        bv.setOmmittedActivities(visitSpecsDTO.isOmmittedActivities());
        bv.setVaryDuration(visitSpecsDTO.isVaryDuration());
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(visitSpecsDTO.getAppointmentStatusReason());
        bv.setAppointmentStatusReason(reason);
        bv.setAppointmentStatus(this.checkedOutStatus());
        bv.setCheckoutStatusReason(reason);
        this.appointmentDAO.updateEntity(bv);
        ArrayList visits = Lists.newArrayList();
        visits.add(bv);
        this.setRooms(visits);
        this.auditService.logAppointmentActivity(ipAddress, bv, user, BookedVisitActivityLogStatics.CHECKED_OUT);
        return bv;
    }

    public String batchEntryUpdate(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress, String templatePath) {
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getId());
        bv.setErrorMsg("true");
        if (visitSpecsDTO.getCheckOutDate() != 0L) {
            this.setCheckOutDateAndUser(visitSpecsDTO, bv, user);
        }
        if (bv.getErrorMsg().equalsIgnoreCase("true")) {
            if (visitSpecsDTO.getCheckInDate() != 0L) {
                this.setCheckInDateAndUser(visitSpecsDTO, bv, user);
            }
            if (visitSpecsDTO.getCheckoutStatusReason() != 0) {
                this.setCheckOutReason(visitSpecsDTO, bv);
            } else if (visitSpecsDTO.getCancelStatusReason() != 0) {
                this.setCancellationReasonAndUser(visitSpecsDTO, bv, user);
            } else {
                bv.setAppointmentStatus(this.checkedInStatus());
            }
            if (visitSpecsDTO.getCancelDate() != 0L) {
                this.setLateCancellationCalculation(visitSpecsDTO, user, templatePath, bv);
            }
            this.appointmentDAO.updateEntity(bv);
            this.auditService.logAppointmentActivity(ipAddress, bv, user, BookedVisitActivityLogStatics.BATCH_ENTRY);
        }
        return bv.getErrorMsg();
    }

    void setLateCancellationCalculation(VisitSpecsDTO visitSpecsDTO, User user, String templatePath, BookedVisit bv) {
        Date cancelStatusTime = new Date(visitSpecsDTO.getCancelDate());
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(cancelStatusTime);
        cal.set(11, 0);
        cal.set(12, 0);
        VisitCancelStatus visitCancelStatus = this.calculateVisitCancelStatus(bv.getScheduledStartTime(), cancelStatusTime, 0, 0);
        CancellationStatus cancelStatus = this.appointmentDAO.findCancellationStatusById(visitCancelStatus.getId());
        bv.setCancelStatus(cancelStatus);
        if (cancelStatus.getId().equals(6)) {
            this.sendLateCancellationEmail(bv, user.getInstitution().getLongName(), templatePath);
        }
    }

    void setCancellationReasonAndUser(VisitSpecsDTO visitSpecsDTO, BookedVisit bv, User user) {
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(visitSpecsDTO.getCancelStatusReason());
        bv.setCancelStatusReason(reason);
        bv.setAppointmentStatusReason(reason);
        if (visitSpecsDTO.getCancelDate() != 0L) {
            bv.setCancelDate(new Date(visitSpecsDTO.getCancelDate()));
        } else {
            bv.setCancelDate(Calendar.getInstance().getTime());
        }
        bv.setCancelUser(user);
        bv.setAppointmentStatus(this.cancelledStatus());
        bv.setCheckInDate(null);
        bv.setCheckInUser(null);
        bv.setCheckoutStatusReason(null);
        bv.setCheckOutDate(null);
        bv.setCheckOutUser(null);
        bv.setCheckoutStatusReasonName(null);
    }

    void setCheckOutReason(VisitSpecsDTO visitSpecsDTO, BookedVisit bv) {
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(visitSpecsDTO.getCheckoutStatusReason());
        bv.setCheckoutStatusReason(reason);
        bv.setAppointmentStatusReason(reason);
        bv.setAppointmentStatus(this.checkedOutStatus());
        bv.setCancelStatusReason(null);
        bv.setCancelDate(null);
        bv.setCancelUser(null);
    }

    void setCheckOutDateAndUser(VisitSpecsDTO visitSpecsDTO, BookedVisit bv, User user) {
        Date checkout = new Date(visitSpecsDTO.getCheckOutDate());
        Date checkInDate = new Date(visitSpecsDTO.getCheckInDate());
        long checkIn = visitSpecsDTO.getCheckInDate();
        if (checkIn == 0L && bv.getCheckInDate().before(checkout)) {
            bv.setCheckOutDate(checkout);
            bv.setCheckOutUser(user);
        } else if (checkIn != 0L && checkInDate.before(checkout)) {
            bv.setCheckOutDate(checkout);
            bv.setCheckOutUser(user);
        } else {
            bv.setErrorMsg("Please Note: Check-Out Date needs to be greater than Check-In Date.");
        }
    }

    void setCheckInDateAndUser(VisitSpecsDTO visitSpecsDTO, BookedVisit bv, User user) {
        bv.setCheckInDate(new Date(visitSpecsDTO.getCheckInDate()));
        bv.setCheckInUser(user);
        bv.setCancelDate(null);
        bv.setCancelUser(null);
        bv.setCancelStatusReason(null);
    }

    void sendLateCancellationEmail(BookedVisit visit, String institution, String templatePath) {
        String visitName = visit.getName();
        String visitTypeName = visit.getVisitType().getName();
        String sublocation = visit.getVisitTemplate().getSublocation().getName();
        String localId = visit.getStudy().getLocalId();
        String startTime = DateUtility.format(DateUtility.dateHourMin(), visit.getScheduledStartTime());
        String cancellationTime = DateUtility.format(DateUtility.dateHourMin(), new Date());
        Study study = visit.getStudy();
        String title = "Urgent! Late Cancellation of " + visitName;
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate stringTemplate = group.getInstanceOf("lateCancellationEmail");
        stringTemplate.setAttribute("institution", (Object)institution);
        stringTemplate.setAttribute("visitName", (Object)visitName);
        stringTemplate.setAttribute("visitType", (Object)visitTypeName);
        stringTemplate.setAttribute("sublocation", (Object)sublocation);
        stringTemplate.setAttribute("localId", (Object)localId);
        stringTemplate.setAttribute("startTime", (Object)startTime);
        stringTemplate.setAttribute("cancellationTime", (Object)cancellationTime);
        this.sendEmailNotifications(study, title, stringTemplate);
    }

    void sendEmailNotifications(Study study, String title, StringTemplate stringTemplate) {
        ArrayList<User> studyTeam = new ArrayList<User>();
        if (study.getScheduler() != null) {
            studyTeam.add(study.getScheduler());
        }
        if (study.getInvestigator() != null) {
            studyTeam.add(study.getInvestigator());
        }
        if (study.getProtocolNurse() != null) {
            studyTeam.add(study.getProtocolNurse());
        }
        if (study.getProtocolNutritionist() != null) {
            studyTeam.add(study.getProtocolNutritionist());
        }
        if (study.getPhysician() != null) {
            studyTeam.add(study.getPhysician());
        }
        List<User> nurseManager = this.authDAO.findNurseManagerUserByRole();
        List<User> nutritionDirector = this.authDAO.findNutritionManagerUserByRole();
        List<User> scheduler = this.authDAO.findSchedulerUserByInstitutionRole();
        List<User> finalApprover = this.authDAO.findFinalApproverByRole();
        List<User> adminDirector = this.authDAO.findAdminDirectorUserByRole();
        List<User> crcAdmin = this.authDAO.findCRCAdminByRole();
        if (studyTeam.size() > 0 || !studyTeam.isEmpty()) {
            for (User u : studyTeam) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (nurseManager.size() > 0 || !nurseManager.isEmpty()) {
            for (User u : nurseManager) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (nutritionDirector.size() > 0 || !nutritionDirector.isEmpty()) {
            for (User u : nutritionDirector) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (scheduler.size() > 0 || !scheduler.isEmpty()) {
            for (User u : scheduler) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (finalApprover.size() > 0 || !finalApprover.isEmpty()) {
            for (User u : finalApprover) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (adminDirector.size() > 0 || !adminDirector.isEmpty()) {
            for (User u : adminDirector) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
        if (crcAdmin.size() > 0 || !crcAdmin.isEmpty()) {
            for (User u : adminDirector) {
                this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(u.getPreferredNotificationEmail()).subject(title).text(stringTemplate.toString()).build());
            }
        }
    }

    public BookedVisit cancelVisit(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress, String templatePath) {
        BooleanResultDTO result = new BooleanResultDTO();
        result.setResult(false);
        BookedVisit bv = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getId());
        Calendar cal = Calendar.getInstance();
        boolean cancelTimeHr = false;
        boolean cancelTimeMin = false;
        if (visitSpecsDTO.getCancelDate() == 0L) {
            bv.setCancelDate(Calendar.getInstance().getTime());
        } else {
            bv.setCancelDate(new Date(visitSpecsDTO.getCancelDate()));
        }
        bv.setCancelUser(user);
        Date cancelStatusTime = bv.getCancelDate();
        cal.clear();
        cal.setTime(cancelStatusTime);
        cal.set(11, 0);
        cal.set(12, 0);
        VisitCancelStatus visitCancelStatus = this.calculateVisitCancelStatus(bv.getScheduledStartTime(), cancelStatusTime, 0, 0);
        CancellationStatus cancelStatus = this.appointmentDAO.findCancellationStatusById(visitCancelStatus.getId());
        bv.setCancelStatus(cancelStatus);
        if (cancelStatus.getId().equals(6)) {
            this.sendLateCancellationEmail(bv, user.getInstitution().getLongName(), templatePath);
        }
        AppointmentStatusReason reason = this.appointmentDAO.findAppointmentStatusReasonById(visitSpecsDTO.getAppointmentStatusReason());
        bv.setAppointmentStatus(this.cancelledStatus());
        bv.setAppointmentStatusReason(reason);
        bv.setCancelStatusReason(reason);
        this.appointmentDAO.updateEntity(bv);
        ArrayList visits = Lists.newArrayList();
        visits.add(bv);
        this.setRooms(visits);
        if (this.cancelTimeWithin48Hours(bv.getScheduledStartTime(), Calendar.getInstance().getTime())) {
            this.sendLateCancellationEmail(bv, user.getInstitution().getLongName(), templatePath);
        }
        this.auditService.logAppointmentActivity(ipAddress, bv, user, BookedVisitActivityLogStatics.CANCELLED);
        result.setResult(true);
        return bv;
    }

    BookedVisit getVisitDetails(int bookedVisitId, User user, String remoteHost, boolean clicked) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        if (clicked) {
            String statusString = bookedVisit.getAppointmentStatus().getName().equalsIgnoreCase("cancellation") ? "cancelled" : bookedVisit.getAppointmentStatus().getName();
            this.auditService.logAppointmentActivity(remoteHost, bookedVisit, user, BookedVisitActivityLogStatics.getActionForViewedResourcesListForAppointment(statusString));
        }
        bookedVisit.setScheduledata("");
        bookedVisit.setUserdata("");
        Date scheduleDate = null;
        String action = "";
        String performingUser = null;
        if (bookedVisit.getSchedulingFlavor() != null) {
            if (bookedVisit.getSchedulingFlavor().equalsIgnoreCase("OVERBOOK") || bookedVisit.getSchedulingFlavor().equalsIgnoreCase(BookedVisitActivityLogStatics.OVERBOOKED.getLogString())) {
                action = "Overbooked on: ";
            } else if (bookedVisit.getSchedulingFlavor().equalsIgnoreCase("Scheduled Appointment") || bookedVisit.getSchedulingFlavor().equalsIgnoreCase(BookedVisitActivityLogStatics.SCHEDULED.getLogString())) {
                action = "Scheduled on: ";
            }
        }
        if (bookedVisit.getSchedulingTime() != null) {
            scheduleDate = bookedVisit.getSchedulingTime();
        }
        if (bookedVisit.getSchedulingUser() != null) {
            performingUser = bookedVisit.getSchedulingUser().getEcommonsId();
        }
        if (scheduleDate != null) {
            bookedVisit.setScheduleDate(scheduleDate);
            bookedVisit.setActionName(action);
            bookedVisit.setScheduledata(DateUtility.format(DateUtility.dateHourMin(), scheduleDate));
            bookedVisit.setUserdata("by user: " + (performingUser != null ? performingUser : "user data not available."));
        }
        return bookedVisit;
    }

    public BookedVisit getVisitDetails(int bookedVisitId, User user, String remoteHost) {
        boolean permittedToGet = this.appointmentDAO.canUserSeeBookedVisit(user, bookedVisitId);
        if (!permittedToGet) {
            SchedulerRuntimeException.logAndThrow("User not allowed to get details for requested study");
        }
        return this.getVisitDetails(bookedVisitId, user, remoteHost, true);
    }

    public ScheduledVisitHistoryDTO getVisitHistory(int bookedVisitId, User user, String remoteHost) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        String statusString = bookedVisit.getAppointmentStatus().getName().equalsIgnoreCase("cancellation") ? "cancelled" : bookedVisit.getAppointmentStatus().getName();
        this.auditService.logAppointmentActivity(remoteHost, bookedVisit, user, BookedVisitActivityLogStatics.getActionForViewedHistoryForAppointment(statusString));
        ScheduledVisitHistoryDTO scheduledVisitHistoryDTO = this.auditService.getActivityLogForBookedVisit(bookedVisitId);
        return scheduledVisitHistoryDTO;
    }

    public List<BookedResourcesResponse> getBookedResources(int bookedVisitId, String sortBy, String orderBy, int page, int maxResults) {
        return this.appointmentDAO.getBookedResourcesListByBookedVisit(bookedVisitId, sortBy, orderBy, page, maxResults);
    }

    public List<BookedResourcesResponse> getEventResources(String eventId, User user) {
        ArrayList<BookedResourcesResponse> bookedResourcesResponses = new ArrayList<BookedResourcesResponse>();
        for (BookedVisit bookedVisit : user.getBookedVisits()) {
            if (!bookedVisit.getUniquekey().equalsIgnoreCase(eventId)) continue;
            List<BookedResource> resources = bookedVisit.getBookedResourceList();
            boolean subjectAvailable = this.isSubjectAvailable(bookedVisit);
            if (resources != null) {
                for (int i = 0; i < resources.size(); ++i) {
                    resources.get(i).setId(i + 1000);
                }
                Collections.sort(resources, resourceTimeComparator);
            }
            for (BookedResource resource : resources) {
                BookedResourcesResponse bookedResourcesResponse = new BookedResourcesResponse(resource.getId(), resource.getResource().getName(), "", resource.getScheduledStartTime(), resource.getScheduledEndTime(), resource.getRejectedResourceMessage(), resource.getAvailable(), resource.getTemplateResource().getResourceGroupType(), Long.valueOf(resources.size()), subjectAvailable);
                bookedResourcesResponses.add(bookedResourcesResponse);
            }
        }
        return bookedResourcesResponses;
    }

    boolean isSubjectAvailable(BookedVisit bookedVisit) {
        return bookedVisit.getSubjectMrn() == null ? true : this.isSubjectAvailable(bookedVisit.getSubjectMrn().getSubject(), bookedVisit.getScheduledStartTime(), bookedVisit.getScheduledEndTime());
    }

    public boolean isSubjectAvailable(Integer subjectMrnId, Date startTime, Date endTime) {
        if (subjectMrnId == null || subjectMrnId == 0) {
            return true;
        }
        SubjectMrn subjectMrn = this.appointmentDAO.findById(SubjectMrn.class, subjectMrnId);
        Subject subject = subjectMrn.getSubject();
        return this.isSubjectAvailable(subject, startTime, endTime);
    }

    boolean isSubjectAvailable(Subject subject, Date startTime, Date endTime) {
        return !this.appointmentDAO.subjectHasBookedVisitInDateRange(subject.getId(), startTime, endTime);
    }

    public BooleanResultDTO deleteBookedResourceOverride(VisitSpecsDTO tr, User user, String ipAddress) {
        BookedResource br = this.appointmentDAO.findBookedResourceById(tr.getId());
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(br.getBookedVisit().getId());
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        long bookedResourcesCount = this.studyDAO.findBookedResourcesCount(bookedVisit);
        if (bookedResourcesCount <= 1L) {
            booleanResultDTO.setResult(false);
            booleanResultDTO.setErrorMsg("You cannot delete this booked resource. A booked visit must always have at least one booked resource.");
        } else {
            List<OverrideBookedResourceAnnotations> tempAnnotations = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(br);
            for (OverrideBookedResourceAnnotations tempAnnotation : tempAnnotations) {
                this.appointmentDAO.deleteEntity(tempAnnotation);
            }
            ActivityLog al = new ActivityLog();
            AppointmentOverrideReason aor = this.appointmentDAO.findAppointmentOverrideReasonById(tr.getOverrideReason());
            al.setAppointmentOverrideReason(aor);
            al.setAffectedResource(br.getResource());
            al.setActionPerformed(aor.getName());
            al.setDate(new Date());
            al.setPerformingUser(user);
            al.setIpAddress(ipAddress);
            al.setBookedVisit(br.getBookedVisit());
            this.appointmentDAO.deleteEntity(br);
            BookedResource bookedResourceLowest = this.studyDAO.findBookedResourceLowest(bookedVisit);
            Date earliestBookedResourceTime = bookedResourceLowest.getScheduledStartTime();
            Date latestBookedResourceTime = this.appointmentDAO.findLatestBookedResourcesByBookedVisit(bookedVisit);
            bookedVisit.setScheduledStartTime(earliestBookedResourceTime);
            bookedVisit.setScheduledEndTime(latestBookedResourceTime);
            this.appointmentDAO.updateEntity(bookedVisit);
            this.appointmentDAO.createEntity(al);
            booleanResultDTO.setResult(true);
        }
        return booleanResultDTO;
    }

    public BooleanResultDTO editBookedResourceOverride(VisitSpecsDTO tr, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(false);
        BookedResource br = this.appointmentDAO.findBookedResourceById(tr.getId());
        Resource r = this.resourceDAO.findResourceById(tr.getResource());
        ActivityLog al = new ActivityLog();
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(br.getBookedVisit().getId());
        AppointmentOverrideReason aor = this.appointmentDAO.findAppointmentOverrideReasonById(tr.getOverrideReason());
        al.setAppointmentOverrideReason(aor);
        al.setActionPerformed(aor.getName());
        al.setAffectedResource(br.getResource());
        al.setDate(new Date());
        al.setPerformingUser(user);
        al.setIpAddress(ipAddress);
        al.setBookedVisit(bookedVisit);
        al.setChangesDetail("Resource : " + br.getResource().getName() + " to " + r.getName() + ",  Start Time : " + br.getScheduledStartTime() + " to " + new Date(tr.getStartDate()) + ",  End Time : " + br.getScheduledEndTime() + " to " + new Date(tr.getEndDate()));
        br.setResource(r);
        br.setBillable(tr.isBillable());
        br.setScheduledStartTime(new Date(tr.getStartDate()));
        br.setScheduledEndTime(new Date(tr.getEndDate()));
        long start = br.getScheduledStartTime().getTime() / 60000L;
        long end = br.getScheduledEndTime().getTime() / 60000L;
        int intStart = (int)start;
        int intEnd = (int)end;
        int duration = intEnd - intStart;
        br.setDuration(duration);
        this.appointmentDAO.updateEntity(br);
        List<OverrideBookedResourceAnnotations> tempAnnotations = this.resourceDAO.findOverrideBookedResourceAnnotationsByBookedResource(br);
        for (OverrideBookedResourceAnnotations tempAnnotation : tempAnnotations) {
            this.appointmentDAO.deleteEntity(tempAnnotation);
        }
        if (!tr.getSelectedAnnotations().isEmpty()) {
            for (int i = 0; i < tr.getSelectedAnnotations().size(); ++i) {
                LineLevelAnnotations lla = this.resourceDAO.findLineLevelAnnotationsById(tr.getSelectedAnnotations().get(i));
                OverrideBookedResourceAnnotations ann = new OverrideBookedResourceAnnotations();
                ann.setBookedResource(br);
                ann.setLineLevelAnnotations(lla);
                ann.setQuantity(tr.getSelectedAnnotationsQuantity().get(i));
                ann.setComment(tr.getSelectedAnnotationsComment().get(i));
                this.appointmentDAO.createEntity(ann);
            }
        }
        this.adjustAndPersistBookedVisit(bookedVisit, br);
        this.appointmentDAO.createEntity(al);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    public BooleanResultDTO addBookedResourceOverride(VisitSpecsDTO visitSpecsDTO, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(false);
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(visitSpecsDTO.getId());
        Resource r = this.resourceDAO.findResourceById(visitSpecsDTO.getResource());
        BookedResource br = new BookedResource();
        br.setBookedVisit(bookedVisit);
        br.setResource(r);
        br.setBillable(visitSpecsDTO.isBillable());
        br.setScheduledStartTime(new Date(visitSpecsDTO.getStartDate()));
        br.setScheduledEndTime(new Date(visitSpecsDTO.getEndDate()));
        long start = br.getScheduledStartTime().getTime() / 60000L;
        long end = br.getScheduledEndTime().getTime() / 60000L;
        int intStart = (int)start;
        int intEnd = (int)end;
        int duration = intEnd - intStart;
        br.setDuration(duration);
        this.appointmentDAO.createEntity(br);
        this.adjustAndPersistBookedVisit(bookedVisit, br);
        if (!visitSpecsDTO.getSelectedAnnotations().isEmpty()) {
            for (int i = 0; i < visitSpecsDTO.getSelectedAnnotations().size(); ++i) {
                OverrideBookedResourceAnnotations obra = new OverrideBookedResourceAnnotations();
                obra.setBookedResource(br);
                obra.setLineLevelAnnotations(this.resourceDAO.findLineLevelAnnotationsById(visitSpecsDTO.getSelectedAnnotations().get(i)));
                obra.setQuantity(visitSpecsDTO.getSelectedAnnotationsQuantity().get(i));
                obra.setComment(visitSpecsDTO.getSelectedAnnotationsComment().get(i));
                this.appointmentDAO.createEntity(obra);
            }
        }
        ActivityLog al = new ActivityLog();
        AppointmentOverrideReason aor = this.appointmentDAO.findAppointmentOverrideReasonById(visitSpecsDTO.getOverrideReason());
        al.setAppointmentOverrideReason(aor);
        al.setActionPerformed(aor.getName());
        al.setDate(new Date());
        al.setPerformingUser(user);
        al.setIpAddress(ipAddress);
        al.setBookedVisit(bookedVisit);
        al.setAffectedResource(r);
        this.appointmentDAO.createEntity(al);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    void adjustAndPersistBookedVisit(BookedVisit bookedVisit, BookedResource br) {
        BookedResource bookedResourceHighest = this.appointmentDAO.findOrderedBookedResource(br.getBookedVisit(), "a.scheduledEndTime", "DESC");
        BookedResource bookedResourceLowest = this.appointmentDAO.findOrderedBookedResource(br.getBookedVisit(), "a.scheduledStartTime", "ASC");
        bookedVisit.setScheduledEndTime(bookedResourceHighest.getScheduledEndTime());
        bookedVisit.setScheduledStartTime(bookedResourceLowest.getScheduledStartTime());
        this.appointmentDAO.updateEntity(bookedVisit);
    }

    public List<Resource> getResources() {
        return this.resourceDAO.findResourcesActiveInSublocations();
    }

    public List<OverbookedResourcesResponse> selectedVisitForOverbookChecks(int bookedVisitId, String sortOn, String sortBy) {
        List resources;
        HashMap overBookedData = new HashMap();
        float totalOverrideAvailable = 0.0f;
        Map<Date, List<SublocationClosureInterval>> resourceSublocationSchedule = null;
        BookedVisit visit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        List<BookedResource> scheduledResources = this.appointmentDAO.findBookedResourcesByBookedVisit(visit);
        ArrayList<OverbookedResourcesResponse> overbookedResourcesResponseList = new ArrayList<OverbookedResourcesResponse>();
        for (BookedResource bookedResource : scheduledResources) {
            ArrayList filteredScheduledResources = this.appointmentDAO.findOverbookConflictResourcesByVisitStatus(bookedResource.getResource(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            if (filteredScheduledResources.isEmpty()) {
                filteredScheduledResources = Lists.newArrayList();
                filteredScheduledResources.add(bookedResource);
            }
            Map<String, List<ResourceSchedule>> resourceDefaultSchedule = this.retrieveResourceDefaultSchedule(bookedResource.getResource(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            resourceSublocationSchedule = null;
            Map<Date, List<ResourceSchedule>> resourceOverrideSchedule = this.retrieveResourceOverrideSchedule(bookedResource.getResource(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            if (resourceDefaultSchedule == null && resourceOverrideSchedule == null) {
                resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
                if (MiscUtil.isNonNullNonEmpty(filteredScheduledResources)) {
                    resources.addAll(filteredScheduledResources);
                }
                overBookedData.put(bookedResource.getResource().getName(), resources);
            }
            totalOverrideAvailable = this.totalOverrideResourceAvailable(bookedResource, resourceOverrideSchedule);
            ResourceSublocation resourceSublocation = this.studyDAO.findSublocationByResource(bookedResource.getResource());
            if (resourceSublocation != null) {
                resourceSublocationSchedule = this.retrieveSublocationSchedule(resourceSublocation.getSublocation(), bookedResource.getScheduledStartTime(), bookedResource.getScheduledEndTime());
            }
            if (!resourceSublocationSchedule.isEmpty()) {
                resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
                if (MiscUtil.isNonNullNonEmpty(filteredScheduledResources)) {
                    resources.addAll(filteredScheduledResources);
                }
                overBookedData.put(bookedResource.getResource().getName(), resources);
                continue;
            }
            if (totalOverrideAvailable == 0.0f) {
                resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
                if (MiscUtil.isNonNullNonEmpty(filteredScheduledResources)) {
                    resources.addAll(filteredScheduledResources);
                }
                overBookedData.put(bookedResource.getResource().getName(), resources);
                continue;
            }
            TreeMap<Integer, Integer> candidatePeriodToQtyMap = new TreeMap<Integer, Integer>();
            boolean isAvailable = true;
            for (BookedResource reservedTime : filteredScheduledResources) {
                Date reservedStartDate = reservedTime.getScheduledStartTime();
                Date reservedEndDate = reservedTime.getScheduledEndTime();
                Date candidateStartDate = bookedResource.getScheduledStartTime();
                this.adjustMapsForBookedResources(candidatePeriodToQtyMap, reservedStartDate, reservedEndDate, candidateStartDate);
            }
            Date candidateStartDate = bookedResource.getScheduledStartTime();
            Date candidateEndDate = bookedResource.getScheduledEndTime();
            int firstPeriod = this.computePeriodOfDate(candidateStartDate);
            int lastPeriod = this.computeLastPeriod(candidateStartDate, candidateEndDate);
            for (int i = firstPeriod; i <= lastPeriod; ++i) {
                Integer currentQuantity = (Integer)candidatePeriodToQtyMap.get(i);
                if (currentQuantity != null && currentQuantity >= 0) continue;
                isAvailable = false;
                break;
            }
            if (isAvailable) continue;
            resources = overBookedData.containsKey(bookedResource.getResource().getName()) ? (List)overBookedData.get(bookedResource.getResource().getName()) : new ArrayList();
            if (MiscUtil.isNonNullNonEmpty(filteredScheduledResources)) {
                resources.addAll(filteredScheduledResources);
            }
            overBookedData.put(bookedResource.getResource().getName(), resources);
        }
        if (overBookedData != null) {
            for (Map.Entry entry : overBookedData.entrySet()) {
                resources = (ArrayList)entry.getValue();
                if (resources == null || resources.isEmpty()) continue;
                for (BookedResource r : resources) {
                    String conflictedTimePeriod = "";
                    if (!resourceSublocationSchedule.isEmpty()) {
                        r.setConflictedTime("Sublocation Closed.");
                    } else if (totalOverrideAvailable == 0.0f) {
                        r.setConflictedTime("Resource temporarily adjusted.");
                    } else if (resources.size() > 1) {
                        r.setConflictedTime(this.getConflictedTimePeriod(resources));
                    } else {
                        Date end1 = ((BookedResource)resources.get(0)).getScheduledEndTime();
                        Date start1 = ((BookedResource)resources.get(0)).getScheduledStartTime();
                        conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
                        r.setConflictedTime(conflictedTimePeriod);
                    }
                    OverbookedResourcesResponse overbookedResourcesResponse = new OverbookedResourcesResponse(r, resources.size());
                    overbookedResourcesResponseList.add(overbookedResourcesResponse);
                }
            }
        }
        Collections.sort(overbookedResourcesResponseList, OverbookedResourcesResponse.getComparator(sortOn, sortBy));
        return overbookedResourcesResponseList;
    }

    Map<Date, List<SublocationClosureInterval>> retrieveSublocationSchedule(Sublocation sublocations, Date startTime, Date endTime) {
        HashMap<Date, List<SublocationClosureInterval>> dayOfWeekSchedule = new HashMap<Date, List<SublocationClosureInterval>>();
        List<SublocationClosureInterval> sublocationScheduleList = this.appointmentDAO.findSublocationSchedule(sublocations, startTime, endTime);
        if (!sublocationScheduleList.isEmpty()) {
            this.populateSublocationClosureIntervalScheduleByDate(sublocationScheduleList, dayOfWeekSchedule);
        }
        return dayOfWeekSchedule;
    }

    Map<String, List<ResourceSchedule>> retrieveResourceDefaultSchedule(Resource resource, Date startDate, Date endDate) {
        return this.searchAlgorithmService.retrieveResourceDefaultSchedule(resource, startDate, endDate);
    }

    List<Date> buildSearchDate(Date startDate, Date endDate) {
        ArrayList<Date> searchDates = new ArrayList<Date>();
        Calendar cal = Calendar.getInstance();
        int diff = DateUtility.compareDateDifference(startDate, endDate);
        if (diff == 0) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, 0, 0, 0);
            cal.clear();
            cal.setTime(curDate);
            searchDates.add(curDate);
            return searchDates;
        }
        for (int count = 0; count < diff; ++count) {
            Date curDate = this.modifyDateFieldPlusAmtSetHourMinute(startDate, 6, count, 0, 0);
            cal.clear();
            cal.setTime(curDate);
            searchDates.add(curDate);
        }
        return searchDates;
    }

    float totalOverrideResourceAvailable(BookedResource curSelectedResource, Map<Date, List<ResourceSchedule>> resourceOverrideSchedule) {
        if (curSelectedResource == null || resourceOverrideSchedule == null) {
            return 0.0f;
        }
        float totalAvailable = -1.0f;
        Date requestStartDate = this.beginningOfDay(curSelectedResource.getScheduledStartTime());
        Date requestEndDate = this.beginningOfDay(curSelectedResource.getScheduledEndTime());
        List<Date> searchDates = this.buildSearchDate(requestStartDate, requestEndDate);
        ArrayList overrideSchedule = null;
        if (MiscUtil.isNonNullNonEmpty(searchDates)) {
            overrideSchedule = Lists.newArrayList();
            for (Date date : searchDates) {
                List<ResourceSchedule> tempOverrideSchedule = resourceOverrideSchedule.get(date);
                boolean exists = resourceOverrideSchedule.containsKey(date);
                if (!exists) continue;
                overrideSchedule.addAll(tempOverrideSchedule);
            }
        }
        if (overrideSchedule == null) {
            return -1.0f;
        }
        TreeMap<Integer, Integer> candidatePeriodToQtyMap = new TreeMap<Integer, Integer>();
        if (MiscUtil.isNonNullNonEmpty(overrideSchedule)) {
            totalAvailable = this.retrieveTotalResourcesFromOverrideSchedule(overrideSchedule, curSelectedResource.getScheduledStartTime(), curSelectedResource.getScheduledEndTime(), candidatePeriodToQtyMap);
        }
        if (totalAvailable == -1.0f) {
            return -1.0f;
        }
        if (totalAvailable == 0.0f) {
            return 0.0f;
        }
        return totalAvailable;
    }

    String getConflictedTimePeriod(List<BookedResource> resources) {
        String conflictedTimePeriod = "";
        boolean i = false;
        Date start1 = resources.get(0).getScheduledStartTime();
        Date end1 = resources.get(0).getScheduledEndTime();
        Date start2 = resources.get(1).getScheduledStartTime();
        Date end2 = resources.get(1).getScheduledEndTime();
        if (start1.after(start2) && end2.after(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start2.after(start1) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end2);
        } else if (start1.before(start2) && end1.before(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end1);
        } else if (start1.after(start2) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end2);
        } else if (start1.after(start2) && end2.after(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end2);
        } else if (start2.after(start1) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end1);
        } else if (start1.equals(start2) && end2.equals(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start1.before(start2) && end2.equals(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start2, end1);
        } else if (start2.before(start1) && end2.equals(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start2.equals(start1) && end2.after(end1)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end1);
        } else if (start2.equals(start1) && end1.after(end2)) {
            conflictedTimePeriod = this.adjustConflictingTimePeriods(conflictedTimePeriod, start1, end2);
        }
        return conflictedTimePeriod;
    }

    String adjustConflictingTimePeriods(String conflictedTimePeriod, Date start1, Date end1) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(start1);
        String startTimeDate = DateUtility.format(DateUtility.monthDayYear(), cal.getTime());
        String conflictedStartTimePeriod = conflictedTimePeriod + startTimeDate + " ";
        int hr = cal.get(11);
        int min = cal.get(12);
        conflictedStartTimePeriod = conflictedStartTimePeriod + DateUtility.padTime(hr) + ":";
        String conflictedEndTimePeriod = conflictedStartTimePeriod = conflictedStartTimePeriod + DateUtility.padTime(min) + " to ";
        cal.clear();
        cal.setTime(end1);
        String endTimeDate = DateUtility.format(DateUtility.monthDayYear(), cal.getTime());
        conflictedEndTimePeriod = conflictedEndTimePeriod + " " + endTimeDate + " ";
        int min1 = cal.get(12);
        int hr1 = cal.get(11);
        conflictedEndTimePeriod = conflictedEndTimePeriod + DateUtility.padTime(hr1) + ":";
        conflictedEndTimePeriod = conflictedEndTimePeriod + DateUtility.padTime(min1);
        return conflictedEndTimePeriod;
    }

    public void logViewVisits(User user, String ipAddress, String action) {
        this.auditService.logUserActivity(ipAddress, null, user, action, null, null);
    }

    public List<TemplateResource> getRoomResources(int visitId) {
        VisitTemplate v = this.studyDAO.findVisitTemplateById(visitId);
        List<TemplateResource> trs = this.templateResourceDAO.findRoomTemplateResourcesByVisit(v);
        return trs.isEmpty() ? null : trs;
    }

    public List<OverbookTimelineDataResponseDTO> getOverbookTimelineData(Date selectedStartDate, Date selectedEndDate, int resourceTypeId, List<Integer> sublocations, String orderBy, User user) {
        ResourceType resourceType = ResourceType.findById(resourceTypeId).get();
        return this.appointmentDAO.getOverbookTimelineData(selectedStartDate, selectedEndDate, resourceType, sublocations, orderBy, user);
    }

    void checkMealsAndPersistVisit(UserSession userSession, String ipAddress, String institution, String templatePath, BookedVisit resVisit) {
        for (BookedResource br : resVisit.getBookedResourceList()) {
            br.setBookedVisit(resVisit);
            if (!br.getResource().getName().contains("Meal, Weighed/Controlled")) continue;
            this.sendWeighedMealEmail(resVisit, br, institution, templatePath);
        }
        List<BookedResource> resources = resVisit.getBookedResourceList();
        this.persistVisit(resVisit, userSession, ipAddress);
        this.persistBookedResources(resources, resVisit);
        this.createCommentsRecordIfNonemptyComment(resVisit, userSession.getUser(), ipAddress);
    }

    List<Resource> setupBookedResourcesForAppointmentWithVisitTime(VisitSpecsDTO visitSpecsDTO, User user, String templatePath, Date eventDate, BookedVisit bookedVisit, List<TemplateResource> templateResourceList, int eventDateMinutesDelta) {
        ArrayList accumulatedResourceList = Lists.newArrayList();
        for (TemplateResource templateResource : templateResourceList) {
            this.setupOneBookedResourceForAppointment(visitSpecsDTO, user, templatePath, accumulatedResourceList, bookedVisit, templateResource, eventDateMinutesDelta, eventDate);
        }
        return accumulatedResourceList;
    }

    void setupOneBookedResourceForAppointment(VisitSpecsDTO visitSpecsDTO, User user, String templatePath, List<Resource> accumulatedResourceList, BookedVisit bookedVisit, TemplateResource templateResource, int eventDateMinutesDelta, Date eventStartDate) {
        Date trStartDate = templateResource.getStartDate();
        Date trEndDate = templateResource.getEndDate();
        Calendar startCal = this.getDateAdjustedForEvent(eventStartDate, trStartDate, eventDateMinutesDelta);
        Calendar endCal = this.getDateAdjustedForEvent(eventStartDate, trEndDate, eventDateMinutesDelta);
        Resource resource = this.probablyAccumulateResult(visitSpecsDTO, accumulatedResourceList, templateResource);
        Integer duration = (int)((endCal.getTimeInMillis() - startCal.getTimeInMillis()) / 60000L);
        BookedResource bookedResource = new BookedResource();
        bookedResource.setBookedVisit(bookedVisit);
        bookedResource.setDuration(duration);
        bookedResource.setScheduledStartTime(startCal.getTime());
        bookedResource.setScheduledEndTime(endCal.getTime());
        bookedResource.setResource(resource);
        bookedResource.setTemplateResource(templateResource);
        bookedResource.setBillable(templateResource.getBillable());
        this.appointmentDAO.createEntity(bookedResource);
        if (bookedVisit.getScheduledEndTime().before(bookedResource.getScheduledEndTime())) {
            bookedVisit.setScheduledEndTime(bookedResource.getScheduledEndTime());
        }
        this.persistAnnotationsForBookedResource(user, templatePath, bookedVisit, templateResource, bookedResource);
    }

    void setupBookedResourcesForBookedVisit(User user, String templatePath, List<TemplateResource> templateResourceList, Date eventDate, BookedVisit bookedVisit, int eventDateMinutesDelta) {
        LazyList bookedResources = LazyList.lazy(templateResourceList).map(templateResource -> {
            Date trStartDate = templateResource.getStartDate();
            Date trEndDate = templateResource.getEndDate();
            Calendar startCal = this.getDateAdjustedForEvent(eventDate, trStartDate, eventDateMinutesDelta);
            Calendar endCal = this.getDateAdjustedForEvent(eventDate, trEndDate, eventDateMinutesDelta);
            Integer duration = (int)((endCal.getTimeInMillis() - startCal.getTimeInMillis()) / 60000L);
            BookedResource newBookedResource = new BookedResource();
            newBookedResource.setResource(templateResource.getResource());
            newBookedResource.setId(null);
            newBookedResource.setTemplateResource((TemplateResource)templateResource);
            newBookedResource.setBookedVisit(bookedVisit);
            newBookedResource.setDuration(duration);
            newBookedResource.setBillable(templateResource.getBillable());
            newBookedResource.setScheduledStartTime(startCal.getTime());
            newBookedResource.setScheduledEndTime(endCal.getTime());
            return Pair.pair((Object)templateResource, (Object)newBookedResource);
        });
        Consumer<Pair> justCreate = pair -> this.appointmentDAO.createEntity((BaseEntity)pair.second);
        Consumer<Pair> persistAnnotations = pair -> this.persistAnnotationsForBookedResource(user, templatePath, bookedVisit, (TemplateResource)pair.first, (BookedResource)pair.second);
        Consumer<Pair> persist = justCreate.andThen(persistAnnotations);
        bookedResources.forEach(persist);
    }

    Resource probablyAccumulateResult(VisitSpecsDTO visitSpecsDTO, List<Resource> accumulatedResourceList, TemplateResource templateResource) {
        Resource templateResourcesResource;
        Resource resultResource = templateResourcesResource = this.resourceDAO.findResourceById(templateResource.getResource().getId());
        if (templateResourcesResource.getResourceType().getName().equalsIgnoreCase("ROOM")) {
            if (visitSpecsDTO.getRoomSelected() != 0) {
                Resource selectedRoomResource = this.resourceDAO.findResourceById(visitSpecsDTO.getRoomSelected());
                accumulatedResourceList.add(selectedRoomResource);
                resultResource = selectedRoomResource;
            }
        } else {
            accumulatedResourceList.add(templateResourcesResource);
        }
        return resultResource;
    }

    void persistAnnotationsForBookedResource(User user, String templatePath, BookedVisit bookedVisit, TemplateResource templateResource, BookedResource bookedResource) {
        List<Object> la = templateResource != null ? this.templateResourceDAO.findTemplateResourceAnnotationsByTemplateResource(templateResource) : Collections.emptyList();
        ListUtils.enrich(la).map(templateResourceAnnotations -> {
            OverrideBookedResourceAnnotations obra = new OverrideBookedResourceAnnotations();
            obra.setBookedResource(bookedResource);
            obra.setLineLevelAnnotations(templateResourceAnnotations.getLineLevelAnnotations());
            obra.setQuantity(templateResourceAnnotations.getQuantity());
            obra.setComment(templateResourceAnnotations.getComment());
            return obra;
        }).forEach(this.appointmentDAO::createEntity);
        if (bookedResource.getResource().getName().contains("Meal, Weighed/Controlled")) {
            this.sendWeighedMealEmail(bookedVisit, bookedResource, user.getInstitution().getLongName(), templatePath);
        }
    }

    void setTemplateResourceTimes(Date eventStartDate, List<TemplateResource> templateResourceList) {
        for (TemplateResource templateResource : templateResourceList) {
            Date trStartDate = templateResource.getStartDate();
            Date trEndDate = templateResource.getEndDate();
            int eventDateHoursAndMinutesDelta = eventStartDate.getHours() * 60 + eventStartDate.getMinutes();
            Calendar startCal = this.getDateAdjustedForEvent(eventStartDate, trStartDate, eventDateHoursAndMinutesDelta);
            Calendar endCal = this.getDateAdjustedForEvent(eventStartDate, trEndDate, eventDateHoursAndMinutesDelta);
            templateResource.setScheduledStartTime(startCal.getTime());
            templateResource.setScheduledEndTime(endCal.getTime());
            this.computeAndSetDuration(templateResource);
        }
    }

    Calendar getDateAdjustedForEvent(Date eventStartDate, Date templateResourceDate, int resourceMinutesDelta) {
        int resourceStartMinuteAdjusted = templateResourceDate.getHours() * 60 + templateResourceDate.getMinutes() + resourceMinutesDelta;
        int resourceAdjustedStartHour = MiscUtil.divideByMinsPerHour(resourceStartMinuteAdjusted);
        int resourceAdjustedStartMins = MiscUtil.moduloMinsPerHour(resourceStartMinuteAdjusted);
        Calendar templateResourceTime = Calendar.getInstance();
        templateResourceTime.setTimeInMillis(templateResourceDate.getTime());
        templateResourceTime.set(11, 0);
        templateResourceTime.set(12, 0);
        templateResourceTime.set(13, 0);
        templateResourceTime.set(14, 0);
        long templateTime = templateResourceTime.getTimeInMillis();
        long templateResourceStartTime = DateUtility.TEMPLATE_RESOURCE_CALENDAR_ORIGIN.getTimeInMillis();
        long bookedResouceRelativeTime = templateTime - templateResourceStartTime;
        long adjustedBookedResourceStartTime = eventStartDate.getTime() + bookedResouceRelativeTime;
        long daylightSavingsCorrectedABRST = adjustedBookedResourceStartTime + (long)Math.abs(TimeZone.getDefault().getOffset(eventStartDate.getTime()) - TimeZone.getDefault().getOffset(adjustedBookedResourceStartTime));
        Calendar bookedResourceTime = Calendar.getInstance();
        bookedResourceTime.setTimeInMillis(daylightSavingsCorrectedABRST);
        bookedResourceTime.set(11, resourceAdjustedStartHour);
        bookedResourceTime.set(12, resourceAdjustedStartMins);
        bookedResourceTime.set(13, 0);
        bookedResourceTime.set(14, 0);
        return bookedResourceTime;
    }

    TemplateResource setupTemplateResource(TemplateResource templateResource, VisitTemplate visitTemplate, BookedVisit bookedVisit) {
        templateResource.setId(123456);
        templateResource.setVisitTemplate(visitTemplate);
        templateResource.setStartMinutes(DateUtility.minutesSinceOrigin(bookedVisit.getScheduledStartTime()));
        templateResource.setEndMinutes(DateUtility.minutesSinceOrigin(bookedVisit.getScheduledEndTime()));
        Integer startTimeInteger = bookedVisit.getScheduledStartTime().getDay() * 1440 + bookedVisit.getScheduledStartTime().getHours() * 60 + bookedVisit.getScheduledStartTime().getMinutes() - 1440;
        Integer endTimeInteger = bookedVisit.getScheduledEndTime().getDay() * 1440 + bookedVisit.getScheduledEndTime().getHours() * 60 + bookedVisit.getScheduledEndTime().getMinutes() - 1440;
        Integer duration = endTimeInteger - startTimeInteger;
        templateResource.setDuration(duration);
        templateResource.setScheduledStartTime(bookedVisit.getScheduledStartTime());
        templateResource.setScheduledEndTime(bookedVisit.getScheduledEndTime());
        this.computeAndSetDuration(templateResource);
        return templateResource;
    }

    public BookedResource getBookedResourceData(int id, String remoteHost, User user) {
        BookedResource br = this.appointmentDAO.findBookedResourceById(id);
        this.auditService.logAppointmentOverrideActivity(remoteHost, br.getBookedVisit(), br.getResource(), user, "Edit - Overriding an Appointment (Incomplete Action)", null, null);
        return br;
    }

    public List<VisitTemplatesResponse> getVisitsByStudy(int studyId, boolean active, String sortBy, String orderBy, int page, int maxResults, SearchDTO searchDTO) {
        searchDTO.mapSearchItemKeyAndValue("v.visitType", "v.visitType", SearchDTO.visitTypeValueMapper);
        return this.studyDAO.getStudyVisitsByStatus(studyId, active, sortBy, orderBy, page, maxResults, searchDTO);
    }

    public List<BookedVisitsResponse> getBookedVisitsList(int userId, SearchDTO searchDTO, String sortBy, String orderBy, int page, int maxResults, String remoteHost, Date fromDate, Date toDate) {
        User user = this.authDAO.findUserById(userId);
        List<BookedVisitsResponse> visits = this.getBookedVisitsAdjustedForUser(searchDTO, sortBy, orderBy, page, maxResults, user, fromDate, toDate);
        this.auditService.logViewActivity(remoteHost, user, " Appointment Calendar List View.");
        return visits;
    }

    List<BookedVisitsResponse> getBookedVisitsAdjustedForUser(SearchDTO searchDTO, String sortBy, String orderBy, int page, int maxResults, User user, Date fromDate, Date toDate) {
        List<Object> visits = Lists.newArrayList();
        List<Study> studyList = null;
        if (user.isStudyStaff()) {
            studyList = this.studyDAO.findStudyListByPerson(user);
        }
        if (studyList == null || !studyList.isEmpty()) {
            searchDTO.mapSearchItemKeyAndValue("s.firstName", "s.firstName", SubjectDataEncryptor.capitalizeAndEncrypt);
            searchDTO.mapSearchItemKeyAndValue("s.lastName", "s.lastName", SubjectDataEncryptor.capitalizeAndEncrypt);
            searchDTO.mapSearchItemKeyAndValue("sm.mrn", "sm.mrn", SubjectDataEncryptor.capitalizeAndEncrypt);
            visits = this.appointmentDAO.findBookedVisitsForStudyList(studyList, sortBy, orderBy, page, maxResults, fromDate, toDate, searchDTO);
        }
        return visits;
    }

    public BookedVisitDetailResponse getBookedVisitData(int bookedVisitId) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(bookedVisitId);
        return new BookedVisitDetailResponse(bookedVisit);
    }

    public boolean isStudyMember(User user, int id) {
        BookedVisit bookedVisit = this.appointmentDAO.findBookedVisitById(id);
        return this.studyDAO.isStudyByPersonAndStudy(user, bookedVisit.getStudy());
    }

    public SwitchSubjectResultDTO switchVisitSubject(Integer newSubjectMrnId, Integer visitId, boolean homeScreen, String className) {
        List<BookedResource> bookedResources;
        BookedVisit visit = this.appointmentDAO.findBookedVisitById(visitId);
        if (newSubjectMrnId.equals(0)) {
            return this.appointmentDAO.switchVisitSubject(newSubjectMrnId, visit, homeScreen, className);
        }
        SubjectMrn newSubjectMrn = this.subjectDAO.findSubjectMrnById(newSubjectMrnId);
        Subject newSubject = newSubjectMrn.getSubject();
        boolean genderBlockWarning = this.checkForGenderBlock(newSubject, bookedResources = this.appointmentDAO.findBookedResourcesByBookedVisit(visit)) != null;
        boolean doubleBookingWarning = this.appointmentDAO.subjectHasBookedVisitInDateRange(newSubject.getId(), visit.getScheduledStartTime(), visit.getScheduledEndTime());
        if (!genderBlockWarning && !doubleBookingWarning) {
            return this.appointmentDAO.switchVisitSubject(newSubjectMrnId, visit, homeScreen, className);
        }
        VisitRenderSummaryDTO visitRenderSummaryDTO = new VisitRenderSummaryDTO(visit, className, homeScreen);
        return new SwitchSubjectResultDTO(false, newSubjectMrnId, newSubject.getFullName(), visitRenderSummaryDTO, genderBlockWarning, doubleBookingWarning);
    }

    public SwitchSubjectResultDTO confirmSwitchVisitSubject(Integer newSubjectMrnId, Integer visitId, boolean homeScreen, String className) {
        BookedVisit visit = this.appointmentDAO.findBookedVisitById(visitId);
        return this.appointmentDAO.switchVisitSubject(newSubjectMrnId, visit, homeScreen, className);
    }

    public String getRoomString(Integer visitId) {
        return this.appointmentDAO.findRoomString(visitId);
    }

    static final class DefaultAppointmentConfirmer
    implements AppointmentConfirmer {
        DefaultAppointmentConfirmer() {
        }

        @Override
        public void confirmVisitBooking(AppointmentService appointmentService, VisitSpecsDTO visitSpecsDTO, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
            BookedVisit bookedVisit = appointmentService.createBookedVisit(visitSpecsDTO, userSession, startDate, endDate);
            SubjectMrn bvSubjectMrn = bookedVisit.getSubjectMrn();
            String genderBlockMessage = null;
            if (null != bvSubjectMrn) {
                genderBlockMessage = appointmentService.checkForGenderBlock(bvSubjectMrn.getSubject(), bookedVisit.getBookedResourceList());
            }
            if (genderBlockMessage == null) {
                appointmentService.checkMealsAndPersistVisit(userSession, ipAddress, institution, templatePath, bookedVisit);
            } else {
                visitSpecsDTO.setDoubleRoomMessage(genderBlockMessage);
            }
        }

        @Override
        public void confirmVisitBookingAfterDoubleRoomMessage(AppointmentService appointmentService, VisitSpecsDTO visitSpecsDTO, UserSession userSession, String ipAddress, String institution, String templatePath, Date startDate, Date endDate) {
            visitSpecsDTO.setDoubleRoomMessage(null);
            BookedVisit resVisit = appointmentService.createBookedVisit(visitSpecsDTO, userSession, startDate, endDate);
            appointmentService.checkMealsAndPersistVisit(userSession, ipAddress, institution, templatePath, resVisit);
        }
    }

    private static final class NameAndEmail {
        public final String name;
        public final String email;
        private static final NameAndEmail BothNull = new NameAndEmail(null, null);

        private static <A extends HasFirstName & HasLastName> NameAndEmail of(A entity) {
            if (entity == null) {
                return BothNull;
            }
            String name = entity.getFirstName() + " " + ((HasLastName)entity).getLastName();
            return new NameAndEmail(name, ((HasEmail)entity).getEmail());
        }

        private NameAndEmail(String name, String email) {
            this.name = name;
            this.email = email;
        }
    }
}

