/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Role;
import edu.harvard.catalyst.scheduler.persistence.CriteriaQueryHelper;
import edu.harvard.catalyst.scheduler.persistence.ReportDAO;
import edu.harvard.catalyst.scheduler.persistence.UserRoleType;
import java.util.Optional;

public enum UserDataReportFilterStrategy {
    LASTNAME(1){

        @Override
        public void makeCriterion(ReportDAO dao, String filterString, CriteriaQueryHelper criteriaHelper) {
            criteriaHelper.whereLike("lastName", filterString);
        }
    }
    ,
    INSTITUTION_ROLE(2){

        @Override
        public void makeCriterion(ReportDAO dao, String filterString, CriteriaQueryHelper criteriaHelper) {
            InstitutionRoleType institutionRoleType = (InstitutionRoleType)InstitutionRoleType.fromHumanReadableName(filterString).orNull();
            InstitutionRole ap = dao.findInstitutionRoleByType(institutionRoleType);
            criteriaHelper.whereEquals("institutionRole", ap);
        }
    }
    ,
    ROLE(3){

        @Override
        public void makeCriterion(ReportDAO dao, String filterString, CriteriaQueryHelper criteriaHelper) {
            Optional<UserRoleType> roleOption = UserRoleType.fromHumanReadableName(filterString);
            Integer id = roleOption.isPresent() ? Integer.valueOf(roleOption.get().databaseId) : null;
            Role ap = dao.findById(Role.class, id);
            criteriaHelper.whereEquals("role", ap);
        }
    }
    ,
    IS_ACTIVE(4){

        @Override
        public void makeCriterion(ReportDAO dao, String filterString, CriteriaQueryHelper criteriaHelper) {
            criteriaHelper.whereEquals("active", Boolean.TRUE);
        }
    }
    ,
    IS_NOT_ACTIVE(5){

        @Override
        public void makeCriterion(ReportDAO dao, String filterString, CriteriaQueryHelper criteriaHelper) {
            criteriaHelper.whereEquals("active", Boolean.FALSE);
        }
    };

    @Deprecated
    public final int databaseId;

    public abstract void makeCriterion(ReportDAO var1, String var2, CriteriaQueryHelper var3);

    public int getDatabaseId() {
        return this.databaseId;
    }

    private UserDataReportFilterStrategy(int databaseId) {
        this.databaseId = databaseId;
    }

    public static Optional<UserDataReportFilterStrategy> fromIdString(String idString) {
        for (UserDataReportFilterStrategy strategy : UserDataReportFilterStrategy.values()) {
            if (!String.valueOf(strategy.getDatabaseId()).equals(idString)) continue;
            return Optional.of(strategy);
        }
        return Optional.empty();
    }
}

