/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.util.DateUtility;

public class BookedVisitDetailResponse {
    private Integer id;
    private String studyName;
    private int visitDuration;
    private boolean isScheduled;
    private boolean isCheckedIn;
    private boolean isCheckedOut;
    private boolean isCancelled;
    private boolean isHold;
    private String appointmentStatus;
    private String scheduledStartTime;
    private String scheduledEndTime;
    private String checkInDate;
    private String checkOutDate;
    private String cancelDate;
    private String checkOutReason;
    private String cancelReason;
    private String localId;
    private String subjectName;
    private String catID;
    private String subjectMRN;
    private String irb;
    private String genderName;
    private String visitName;
    private String birthDate;
    private String comment;
    private String visitTypeName;

    public BookedVisitDetailResponse(BookedVisit bookedVisit) {
        if (bookedVisit == null) {
            SchedulerRuntimeException.logAndThrow("BookedVisit parameter should be non-null");
        }
        SubjectMrn subjectMrn = bookedVisit.getSubjectMrnDecrypted();
        this.id = bookedVisit.getId();
        AppointmentStatus appointmentStatus = bookedVisit.getAppointmentStatus();
        this.appointmentStatus = appointmentStatus.getName();
        this.isScheduled = appointmentStatus.getIsScheduled();
        this.isCheckedIn = appointmentStatus.getIsCheckedIn();
        this.isCheckedOut = appointmentStatus.getIsCheckedOut();
        this.isCancelled = appointmentStatus.getIsCancelled();
        this.isHold = appointmentStatus.getIsHold();
        this.cancelDate = DateUtility.format(DateUtility.dateTime(), bookedVisit.getCancelDate());
        if (bookedVisit.getCancelStatusReason() != null) {
            this.cancelReason = bookedVisit.getCancelStatusReason().getName();
        }
        this.catID = bookedVisit.getStudy().getCatalystId();
        this.checkInDate = DateUtility.format(DateUtility.dateTime(), bookedVisit.getCheckInDate());
        this.checkOutDate = DateUtility.format(DateUtility.dateTime(), bookedVisit.getCheckOutDate());
        if (bookedVisit.getCheckoutStatusReason() != null) {
            this.checkOutReason = bookedVisit.getCheckoutStatusReason().getName();
        }
        this.comment = bookedVisit.getComment();
        this.irb = bookedVisit.getStudy().getIrb();
        this.localId = bookedVisit.getStudy().getLocalId();
        this.scheduledEndTime = DateUtility.format(DateUtility.dateTime(), bookedVisit.getScheduledEndTime());
        this.scheduledStartTime = DateUtility.format(DateUtility.dateTime(), bookedVisit.getScheduledStartTime());
        this.studyName = bookedVisit.getStudy().getName();
        this.subjectName = "No Subject Assigned";
        this.subjectMRN = "N/A";
        this.birthDate = "N/A";
        this.genderName = "N/A";
        if (subjectMrn != null) {
            this.subjectName = subjectMrn.getSubject().getFirstName() + " " + subjectMrn.getSubject().getLastName();
            this.subjectMRN = subjectMrn.getMrn();
            this.birthDate = DateUtility.format(DateUtility.monthDayYear(), subjectMrn.getSubject().getBirthdate());
            this.genderName = subjectMrn.getSubject().getGender() == null ? "N/A" : subjectMrn.getSubject().getGender().getName();
        }
        this.visitDuration = bookedVisit.getVisitTemplate().getDuration();
        this.visitName = bookedVisit.getVisitTemplate().getName();
        this.visitTypeName = bookedVisit.getVisitTemplate().getVisitType().getName();
    }

    public Integer getId() {
        return this.id;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public int getVisitDuration() {
        return this.visitDuration;
    }

    public boolean getIsScheduled() {
        return this.isScheduled;
    }

    public boolean getIsCheckedIn() {
        return this.isCheckedIn;
    }

    public boolean getIsCheckedOut() {
        return this.isCheckedOut;
    }

    public boolean getIsCancelled() {
        return this.isCancelled;
    }

    public boolean getIsHold() {
        return this.isHold;
    }

    public String getAppointmentStatus() {
        return this.appointmentStatus;
    }

    public String getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public String getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public String getCheckInDate() {
        return this.checkInDate;
    }

    public String getCheckOutDate() {
        return this.checkOutDate;
    }

    public String getCancelDate() {
        return this.cancelDate;
    }

    public String getCheckOutReason() {
        return this.checkOutReason;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getCatID() {
        return this.catID;
    }

    public String getSubjectMRN() {
        return this.subjectMRN;
    }

    public String getIrb() {
        return this.irb;
    }

    public String getGenderName() {
        return this.genderName;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVisitTypeName() {
        return this.visitTypeName;
    }
}

