/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var orderBy;
var sortBy;
var sortByVisitName = "v.name";
var sortByVisitType = "v.visitType.name";
var sortBySublocation = "v.sublocation.name";
var sortByApproved = "v.approved";
var totalPages;
var activeView;
var currentPage;
var selected = new Array();
var activate;


function study_createDateWidgets() {
    $("#study_irbExpirationDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true
    });
    $("#study_irbRenewalDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true
    });
    $("#study_irbApprovalDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true,
        onSelect: function(selectedDate) {
            showError('#study_irbExpirationDateValidation', 'This is a required field.');
        }
    });
    $("#study_expectedEndDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true
    });
    $("#study_expectedStartDate").datepicker({
        numberOfMonths: 3,
        changeYear: true,
        changeMonth: true,
        showOn: "button",
        buttonImage: "images/calendar-button.png",
        buttonImageOnly: true
    });
    for (var i = 1; i < 5; i++) {
        $("#study_projectStartDate"+i).datepicker({
            numberOfMonths: 3,
            changeYear: true,
            changeMonth: true,
            showOn: "button",
            buttonImage: "images/calendar-button.png",
            buttonImageOnly: true
        });
        $("#study_projectEndDate"+i).datepicker({
            numberOfMonths: 3,
            changeYear: true,
            changeMonth: true,
            showOn: "button",
            buttonImage: "images/calendar-button.png",
            buttonImageOnly: true
        });
    }
}


function loadVisitTemplatesData(currentPage, activeView, studyId) {
    $('#study_localId1').html('('+ app_selectedStudy.localId +')');
    $('#study_name1').html(app_selectedStudy.name);
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 25;
    }

    $('.DeactivateliveLink').css({display: "none"});
    $('.ActivateliveLink').css({display: "none"});
    if (user.institutionRole.id == STUDY_STAFF) {
        $('#study_newStudyVisitButton').css({display: "none"});
    }
    $.getJSON("rest/appointment/getVisitsByStudy?study="+app_selectedStudy.id+"&active="+activeView+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 25)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByVisitName), function(data) {
        var iteration = 0;
        var editColumns = " ";
        selected = new Array();
        var sort_header;
        var name_header1 = 'sortable';
        var visitType_header2 = 'sortable';
        var sublocation_header3 = 'sortable';
        var approval_header4 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByVisitName){
            name_header1 = sort_header;
        } else if (sortBy == sortByVisitType){
            visitType_header2 = sort_header;
        } else if (sortBy == sortBySublocation){
            sublocation_header3 = sort_header;
        } else if (sortBy == sortByApproved){
            approval_header4 = sort_header;
        }

        if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == FRONT_DESK || user.institutionRole.id == STUDY_STAFF) {
            editColumns =
                "   <td><strong></strong></td>" ;
        }
        else if (user.institutionRole.id == SUPER_ADMIN) {
            editColumns =
                "   <td><strong></strong></td>" +
                "   <td><strong></strong></td>" +
                "   <td><strong></strong></td>" ;
        } else {
            editColumns =
                "   <td><strong></strong></td>" +
                "   <td><strong></strong></td>";
        }

        var out =
            " <table id='visitTemplates'>" +
            "  <tr>" +
            "   <td class='not_sortable'><input type='checkbox' id='selectAllVisits' class='selectAllVisits' onclick='toggleAll(this)'/></td>" +
            "   <td class= "+ name_header1 + " onclick='sortingFunction(sortByVisitName)'><strong>Name</strong></td> " +
            "   <td class= "+ visitType_header2 + " onclick='sortingFunction(sortByVisitType)'><strong>Visit Type</strong></td>" +
            "   <td class= "+ sublocation_header3 + " onclick='sortingFunction(sortBySublocation)'><strong>Sub-location</strong></td>" +
            "   <td class= "+ approval_header4 + " onclick='sortingFunction(sortByApproved)'><strong>Final Status</strong></td>" +
            editColumns +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;
            if (user.institutionRole.id == GENERAL_VIEW || user.institutionRole.id == FRONT_DESK || user.institutionRole.id == STUDY_STAFF) {
                editColumns = "<td class='editColumn'>" +
                " <a href='javascript:showVisitDetail("+val.id+")'> View Detail </a> " +
                " </td> ";
            }
            else if (user.institutionRole.id == SUPER_ADMIN) {
                editColumns =
                    " <td class='editColumn'> <a href='javascript:showVisitDetail("+val.id+")'> View Detail </a> </td> " +
                    " <td class='editColumn'> <a href='javascript:copyVisitTemplate("+val.id+")'> Copy Visit </a> </td> " +
                    " <td class='editColumn'> <a href='javascript:deleteVisitTemplate("+val.id+")'> Delete Visit </a> </td> ";
            } else {
                editColumns =
                    " <td class='editColumn'> <a href='javascript:showVisitDetail("+val.id+")'> View Detail </a> </td> " +
                    " <td class='editColumn'> <a href='javascript:copyVisitTemplate("+val.id+")'> Copy Visit </a> </td> " ;
            }

            out += "<tr onclick='visitDoubleClick(this,"+val.id+")'>"
            out += "   <td><input type='checkbox' value="+val.id+" class='visitRow' name='visitRow' onclick='getSelectedVisitTemplates(this,"+val.id+","+data.length+");' /></td>" +
            " 	   <td>" + val.visitName + "</td>" +
            "          <td>" + val.visitTypeName + "</td>" +
            "          <td>" + val.sublocationName + "</td>" +
            "          <td>" + val.finalApprovalStatus + "</td>" +
            editColumns +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#inactiveVisitTemplatesData').html(out);
        $('#activeVisitTemplatesData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }

        $(".selectAllVisits").prop('checked', false);
    });
}

function toggleAll(source) {
    if (source.checked == false) {
        $('.DeactivateliveLink').css({display: "none"});
        $('.ActivateliveLink').css({display: "none"});
    } else {
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER){
            $('.DeactivateliveLink').css({display: "inline-block"});
            $('.ActivateliveLink').css({display: "inline-block"});
        }
        else {
            $('.DeactivateliveLink').css({display: "none"});
            $('.ActivateliveLink').css({display: "none"});
        }
    }
    var checkboxes = document.getElementsByName('visitRow');
    for(var i=0; i < checkboxes.length; i++) {
        var visitId = $(checkboxes[i]).val();
        if (source.checked && $.inArray(visitId, selected) == -1) {
            selected.push(visitId);
            $(".visitRow").prop('checked', true);
        }
        else if (!source.checked){
            selected = new Array();
            $(".visitRow").prop('checked', false);
        }
    }
}

function activateVisitsClick() {
    activeView = false;
    activate = true;
    changeVisitStatus();
}

function deactivateVisitsClick() {
    activate = false;
    activeView = true;
    changeVisitStatus();
}

function getSelectedVisitTemplates(source, visitId, totalLength) {
    if (source.checked && $.inArray(visitId, selected) == -1){
        selected.push(visitId);
    }
    else if (!source.checked){
        selected = jQuery.grep(selected, function(value) {
            return value != visitId;
        });
    }
    if (selected.length == totalLength) {
        $(".selectAllVisits").prop('checked', true);
    }
    else {
        $(".selectAllVisits").prop('checked', false);
    }
    if (selected.length == 0) {
        $('.DeactivateliveLink').css({display: "none"});
        $('.ActivateliveLink').css({display: "none"});
    }
    else {
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER){
            $('.DeactivateliveLink').css({display: "inline-block"});
            $('.ActivateliveLink').css({display: "inline-block"});
        }
        else {
            $('.DeactivateliveLink').css({display: "none"});
            $('.ActivateliveLink').css({display: "none"});
        }
    }
    return selected;
}

function visitStatusDialog() {
    $("#visit-status-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                jsonData = JSON.stringify({visitTemplatesId: selected});
                $.post("rest/study/changeVisitTemplateStatus?activate="+activate,{data:jsonData}, function(data) {
                    var confirmationMessage = "";
                    if (activate == true) {
                        confirmationMessage = "Visit(s) Activated.";
                    }
                    else if (activate == false) {
                        confirmationMessage = "Visit(s) Deactivated.";
                    }
                    util_showMainMessage(confirmationMessage);
                    currentPage = 1;
                    loadVisitTemplatesData(currentPage, activeView, app_selectedStudy.id);
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function changeVisitStatus(){
    visitStatusDialog();
}

function getInactiveVisitTemplates() {
    activeView = false;
    resetUI();
    initial_load = true;
    loadVisitTemplatesData(currentPage, activeView, app_selectedStudy.id);
}

function getActiveVisitTemplates() {
    activeView = true;
    resetUI();
    initial_load = true;
    loadVisitTemplatesData(currentPage, activeView, app_selectedStudy.id);
}


/////////////////////////////////////////////////Study Data////////////////////////////////////////////////////////////////////////////////
function filterStudyDataClick() {
    currentPage = 1;
    loadStudyScreenData(currentPage);
}

function resetStudyDataClick() {
    $("#filters_string").val('');
    loadStudyScreenData(currentPage);
}

var sortByStudyName = "s.name";
var sortByPIName = "pi.last_name";
var sortByCatalystId = "s.catalyst_id";
var sortByLocalId = "s.local_id";
var sortByStudyStatus = "ss.short_name";

function loadStudyScreenData(currentPage){
    renderBreadcrumbs('study_screen');
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 50;
    }

    var filterString = $.trim($("#filters_string").val());

    $.getJSON("rest/study/getStudyList?filterString="+filterString+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 50)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByStudyName), function(data) {
        var iteration = 0;
        var editColumns = null;

        var sort_header;
        var studyName_header1 = 'sortable';
        var piName_header2 = 'sortable';
        var catID_header3 = 'sortable';
        var localID_header4 = 'sortable';
        var studyStatus_header5 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByStudyName){
            studyName_header1 = sort_header;
        } else if (sortBy == sortByPIName){
            piName_header2 = sort_header;
        } else if (sortBy == sortByCatalystId){
            catID_header3 = sort_header;
        } else if (sortBy == sortByLocalId){
            localID_header4 = sort_header;
        } else if (sortBy == sortByStudyStatus){
            studyStatus_header5 = sort_header;
        }

        var out =   " <table id='studies'>"
            +  "  <tr>" +
            "   <td class= "+ studyName_header1 + " onclick='sortingFunction(sortByStudyName)'><strong>Name</strong></td>" +
            "   <td class= "+ piName_header2 + " onclick='sortingFunction(sortByPIName)'><strong>PI Name</strong></td> " +
            "   <td class= "+ catID_header3 + " onclick='sortingFunction(sortByCatalystId)'><strong>Catalyst ID</strong></td>" +
            "   <td class= "+ localID_header4 + " onclick='sortingFunction(sortByLocalId)'><strong>Local ID</strong></td>" +
            "   <td class= "+ studyStatus_header5 + " onclick='sortingFunction(sortByStudyStatus)' ><strong>Study Status</strong></td>" +
            "   <td class='not_sortable'></td>" +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;
            out += "<tr onclick='studyDoubleClick(this,"+val.id+")'>"
            out += "   <td>" + val.name + "</td>" +
            "          <td>" + buildPIName(val.investigator.firstName, val.investigator.lastName) + "</td>" +
            "          <td>" + val.catalystId + "</td>" +
            "          <td>" + val.localId + "</td>" +
            "          <td>" + val.studyStatus + "</td>" +
            "<td>" + " <a href='javascript:showStudyDetail("+val.id+")'>View Detail</a>" +" </td> " +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#study_data').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results)
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

function buildPIName(firstName, lastName) {
    if (firstName != null && firstName !== undefined && firstName !== "") {
        return lastName+ ", "+ firstName;
    }
    else {
        return "";
    }
}

/////////////////////////////////////////////////Study Subject Data////////////////////////////////////////////////////////////////////////////////
var sortByStudySubjectMRN = "mrn";
var sortByStudySubjectLastName = "lastName";
var sortByStudySubjectFirstName = "firstName";
var sortByStudySubjectDOB = "birthdate";
var sortByStudySubjectCity = "city";
var sortByStudySubjectState = "state";
var sortByStudySubjectContact = "primaryContactNumber";

function loadStudySubjectData(currentPage){

    isEpicMode = sessionStorage.getItem("subjectMode").toLowerCase() == "epic";

    $('#study_localId2').html('('+ app_selectedStudy.localId +')');
    $('#study_name2').html(app_selectedStudy.name);
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 50;
    }

    $.getJSON("rest/study/getStudySubjects?study="+app_selectedStudy.id+"&inactive=true"+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 50)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByStudySubjectMRN), function(data) {
        var iteration = 0;
        var editColumns = null;

        var sort_header;
        var mrn_header1 = 'sortable';
        var lastName_header2 = 'sortable';
        var firstName_header3 = 'sortable';
        var dob_header4 = 'sortable';
        var city_header5 = 'sortable';
        var state_header6 = 'sortable';
        var contact_header7 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByStudySubjectMRN){
            mrn_header1 = sort_header;
        } else if (sortBy == sortByStudySubjectLastName){
            lastName_header2 = sort_header;
        } else if (sortBy == sortByStudySubjectFirstName){
            firstName_header3 = sort_header;
        } else if (sortBy == sortByStudySubjectDOB){
            dob_header4 = sort_header;
        } else if (sortBy == sortByStudySubjectCity){
            city_header5 = sort_header;
        } else if (sortBy == sortByStudySubjectState){
            state_header6 = sort_header;
        } else if (sortBy == sortByStudySubjectContact){
            contact_header7 = sort_header;
        }

        var out =
            " <table id='studySubjects' width='100%'>" +
            "  <tr>" +
            "   <td class= "+ mrn_header1 + " onclick='sortingFunction(sortByStudySubjectMRN)'><strong>MRN</strong></td>" +
            "   <td class= "+ lastName_header2 + " onclick='sortingFunction(sortByStudySubjectLastName)'><strong>Last Name</strong></td> " +
            "   <td class= "+ firstName_header3 + " onclick='sortingFunction(sortByStudySubjectFirstName)'><strong>First Name</strong></td>" +
            "   <td class= "+ dob_header4 + " onclick='sortingFunction(sortByStudySubjectDOB)'><strong>DOB</strong></td>" +
            "   <td class= "+ city_header5 + " onclick='sortingFunction(sortByStudySubjectCity)'><strong>City</strong></td>" +
            "   <td class= "+ state_header6 + " onclick='sortingFunction(sortByStudySubjectState)'><strong>State</strong></td>" +
            "   <td class= "+ contact_header7 + " onclick='sortingFunction(sortByStudySubjectContact)'><strong>Primary Contact Number</strong></td>" +
            "   <td class='not_sortable'><strong>Study Status</strong></td>" +
            "   <td class='not_sortable'>&nbsp;</td>" +
            "  </tr> ";
        totalData = data.totalCount;
        $.each(data.studySubject1s, function(key, val) {
            out +=
                "  <tr>" +
                "   <td>" + val.subjectMRN + "</td>" +
                "   <td>" + val.subjectLastName + "</td>" +
                "   <td>" + val.subjectFirstName + "</td>" +
                "   <td>" + showDate(val.subjectDOB) + "</td>" +
                "   <td>" + val.subjectCity + "</td>" +
                "   <td>" + val.subjectState + "</td>" +
                "   <td>" + unifiedPhoneNumbersFormat(val.subjectPrimaryContact) + "</td>" +
                "   <td> <a href='javascript:changeStudySubjectStatus("+val.id+")'>"+statusValue(val.subjectStatus)+"</a></td>" +
                "   <td><a href='javascript:goToStudySubjectForm(\"" + val.subjectId + "\",\""  + val.subjectMRN + "\",\"" + val.subjectMRNInstitution +"\")'> View Details</a></td>" +
                "  </tr>";
            iteration++;
        });

        out += " </table>";

        $('#studySubject_data').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results)
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

function studySubjectStatusDialog(id) {
    $("#studySubject-status-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                $.getJSON("rest/study/changeStudySubjectStatus?studySubjectId="+id, function(data) {
                    if (data.result == true) {
                        $('#study_responseLoading').css({visibility: "hidden"});
                        var confirmationMessage = "Study Subject Status changed.";
                        util_showMainMessage(confirmationMessage);
                        loadStudySubjectData(currentPage);
                    }
                    else {
                        var confirmationMessage = "Error: Study Subject Status cannot be changed.";
                        util_showMainMessage(confirmationMessage);
                        loadStudySubjectData(currentPage);
                    }
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function changeStudySubjectStatus(id) {
    studySubjectStatusDialog(id);
}

/////////////////////////////////////////////////Add Study Subject Data////////////////////////////////////////////////////////////////////////////////
var sortBySubjectMRN = "mrn";
var sortBySubjectLastName = "lastName";
var sortBySubjectFirstName = "firstName";
var sortBySubjectDOB = "birthdate";
var sortBySubjectCity = "city";
var sortBySubjectState = "state";
var sortBySubjectContact = "primaryContactNumber";
function loadAddStudySubjectData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 50;
    }

    var filterString = $.trim($("#filters_string").val());
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $('.addStudySubjectLink').css({display: "none"});
    var url;
    if (searchAppointmentWorkflow == true) {
        url = "rest/subject/getSearchSubjects?lastName="+(searchname != "" ? searchname : null)+"&mrn="+(searchmrn != "" ? searchmrn : null)+"&birthdate="+(searchbirthdate != "" ? searchbirthdate : null)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortBySubjectLastName);
    }
    else if (user.institutionRole.id == STUDY_STAFF){
        var name = JSON.parse(sessionStorage.getItem("subject_searchname"));
        var mrn = JSON.parse(sessionStorage.getItem("subject_searchmrn"));
        var birthdate = JSON.parse(sessionStorage.getItem("subject_searchbirthdate"));
        url = "rest/subject/getSearchSubjects?lastName="+(name != "" ? name : null)+"&mrn="+(mrn != "" ? mrn : null)+"&birthdate="+(birthdate != "" ? birthdate : null)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortBySubjectLastName);
    }
    else {
        url = "rest/subject/getSubjects?filterString="+filterString+'&study='+app_selectedStudy.id+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 50)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortBySubjectLastName);
    }

    $.getJSON(url, function(data) {
        var iteration = 0;
        totalData = data.totalCount;
        var sort_header;
        var mrn_header1 = 'sortable';
        var lastName_header2 = 'sortable';
        var firstName_header3 = 'sortable';
        var dob_header4 = 'sortable';
        var city_header5 = 'sortable';
        var state_header6 = 'sortable';
        var contact_header7 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == sortBySubjectMRN){
            mrn_header1 = sort_header;
        } else if (sortBy == undefined || sortBy == sortBySubjectLastName){
            lastName_header2 = sort_header;
        } else if (sortBy == sortBySubjectFirstName){
            firstName_header3 = sort_header;
        } else if (sortBy == sortBySubjectDOB){
            dob_header4 = sort_header;
        } else if (sortBy == sortBySubjectCity){
            city_header5 = sort_header;
        } else if (sortBy == sortBySubjectState){
            state_header6 = sort_header;
        } else if (sortBy == sortBySubjectContact){
            contact_header7 = sort_header;
        }

        if (window.location.href.indexOf("appt_calendar.html") > -1){
            $('#addStudySubjectHeaderData').html("<table id='addStudySubjectHeaderTable'> <thead> <tr>" +
            "   <th width='10%'><input type='checkbox' id='selectall' onclick='toggleAllStudySubjects(this)'/></th>" +
            "   <th width='15%' class= "+ lastName_header2 + " onclick='sortingFunction(sortBySubjectLastName)'><strong>Last Name</strong></th> " +
            "   <th width='15%' class= "+ firstName_header3 + " onclick='sortingFunction(sortBySubjectFirstName)'><strong>First Name</strong></th>" +
            "   <th width='15%' class= "+ mrn_header1 + " onclick='sortingFunction(sortBySubjectMRN)'><strong>MRN</strong></th>" +
            "   <th width='15%' class= "+ dob_header4 + " onclick='sortingFunction(sortBySubjectDOB)'><strong>Date of Birth</strong></th>" +
            "   <th width='15%' class= "+ city_header5 + " onclick='sortingFunction(sortBySubjectCity)'><strong>City</strong></th>" +
            "   <th width='15%' class= "+ state_header6 + " onclick='sortingFunction(sortBySubjectState)'><strong>State</strong></th>" +
            "   <th width='15%' class= "+ contact_header7 + " onclick='sortingFunction(sortBySubjectContact)'><strong>Phone</strong></th>" +
            "  </tr> </thead> </table>");
            var out = " <table id='addStudySubject'>";
        }
        else {
            var out =
                " <table id='addStudySubject'>" +
                "  <tr>" +
                "   <td width='10%'><input type='checkbox' id='selectall' onclick='toggleAllStudySubjects(this)'/></td>" +
                "   <td width='15%' class= "+ lastName_header2 + " onclick='sortingFunction(sortBySubjectLastName)'><strong>Last Name</strong></td> " +
                "   <td width='15%' class= "+ firstName_header3 + " onclick='sortingFunction(sortBySubjectFirstName)'><strong>First Name</strong></td>" +
                "   <td width='15%' class= "+ mrn_header1 + " onclick='sortingFunction(sortBySubjectMRN)'><strong>MRN</strong></td>" +
                "   <td width='15%' class= "+ dob_header4 + " onclick='sortingFunction(sortBySubjectDOB)'><strong>Date of Birth</strong></td>" +
                "   <td width='15%' class= "+ city_header5 + " onclick='sortingFunction(sortBySubjectCity)'><strong>City</strong></td>" +
                "   <td width='15%' class= "+ state_header6 + " onclick='sortingFunction(sortBySubjectState)'><strong>State</strong></td>" +
                "   <td width='15%' class= "+ contact_header7 + " onclick='sortingFunction(sortBySubjectContact)'><strong>Phone</strong></td>" +
                "  </tr> ";
        }

        $.each(data.subjectList, function(key, val) {
            out += "<tr>"
            out += "   <td width='10%'><input type='checkbox' value="+val.id +" class='studySubjectCheckbox' name='studySubjectCheckbox' onclick='getSelectedStudySubjects();' /></td>" +
            " 	   <td width='15%'>" + val.lastName + "</td>" +
            "          <td width='15%'>" + val.firstName + "</td>" +
            "          <td width='15%'>" + val.mrn + "</td>" +
            "          <td width='15%'>" + showDate(val.dob) + "</td>" +
            "          <td width='15%'>" + val.city + "</td>" +
            "          <td width='15%'>" + val.state + "</td>" +
            "          <td width='15%'>" + val.primaryContact + "</td>" +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#addStudySubjectData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        if (totalData == 0 || data.length == 0) {
            if (user.institutionRole.id == STUDY_STAFF && searchAppointmentWorkflow == false){
                alert("Subject not found. Please check the name,mrn,date of birth, or scheduler ID and try again.");
                window.location.href = "study_subject.html";
            }
            util_showMainMessage("Subject not found. Please check the name, mrn, date of birth, or scheduler ID and try again.");
            $('#searchForm').css({display: "block"});
            $("#appt_study_subject_dialog").dialog("close");
            $('#grid').css({display: "none"});
        }

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

function toggleAllStudySubjects(source) {
    if (source.checked == false) {
        $('.addStudySubjectLink').css({display: "none"});
    } else {
        $('.addStudySubjectLink').css({display: "inline-block"});
    }
    var checkboxes = document.getElementsByName('studySubjectCheckbox');
    for(var i=0, n=checkboxes.length;i<n;i++) {
        checkboxes[i].checked = source.checked;
    }
}

function getSelectedStudySubjects() {
    selected = new Array();
    $(".studySubjectCheckbox:checked").each(function() {
        selected.push($(this).val());
    });
    if (selected.length == 0) {
        $('.addStudySubjectLink').css({display: "none"});
    }
    else {
        $('.addStudySubjectLink').css({display: "inline-block"});
    }
    return selected;
}

/////////////////////////////////////////////////Study Member Data////////////////////////////////////////////////////////////////////////////////
var sortByMemberLastName = "su.user.lastName";
var sortByMemberFirstName = "su.user.firstName";
var sortByMemberTitle = "su.user.title.name";

function loadStudyMemberData(currentPage){
    $('#study_localId3').html('('+ app_selectedStudy.localId +')');
    $('#study_name3').html(app_selectedStudy.name);
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 50;
    }

    $.getJSON("rest/study/getStudyMembers?study="+app_selectedStudy.id+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 50)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByMemberLastName), function(data) {
        var iteration = 0;
        var editColumns = null;

        var sort_header;
        var memberLastName_header1 = 'sortable';
        var memberFirstName_header2 = 'sortable';
        var memberTitle_header3 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByMemberLastName){
            memberLastName_header1 = sort_header;
        } else if (sortBy == sortByMemberFirstName){
            memberFirstName_header2 = sort_header;
        } else if (sortBy == sortByMemberTitle){
            memberTitle_header3 = sort_header;
        }

        var out =   " <table id='studyMember'>"
            +  "  <tr>" +
            "   <td class= "+ memberLastName_header1 + " onclick='sortingFunction(sortByMemberLastName)'><strong>Last Name</strong></td>" +
            "   <td class= "+ memberFirstName_header2 + " onclick='sortingFunction(sortByMemberFirstName)'><strong>First Name</strong></td> " +
            "   <td class= "+ memberTitle_header3 + " onclick='sortingFunction(sortByMemberTitle)'><strong>Title</strong></td>" +
            "   <td class='not_sortable'><strong>Status</strong></td>" +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;

            if (user.institutionRole.id != STUDY_STAFF){
                editColumns = "<td>" + " <a href='javascript:changeStudyMemberStatus("+val.id+")'>"+statusValue(val.status)+"</a>" + "</td>";
            }
            else {
                editColumns = "<td><strong>"+statusValue(val.status)+"</strong></td>";
            }

            out += "<tr>"
            out += "   <td>" + val.lastName + "</td>" +
            "          <td>" + val.firstName + "</td>" +
            "          <td>" + val.title + "</td>" +
            editColumns +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#studyMember_data').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results)
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

function studyMemberStatusDialog(id) {
    $("#studyMember-status-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                $.getJSON("rest/study/changeStudyMemberStatus?studyMemberId="+id, function(data) {
                    if (data.result == true) {
                        $('#study_responseLoading').css({visibility: "hidden"});
                        var confirmationMessage = "Study Member Status changed.";
                        util_showMainMessage(confirmationMessage);
                        loadStudyMemberData(currentPage);
                    }
                    else {
                        var confirmationMessage = "Error: Study Member Status cannot be changed.";
                        util_showMainMessage(confirmationMessage);
                        loadStudyMemberData(currentPage);
                    }
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function changeStudyMemberStatus(id) {
    studyMemberStatusDialog(id);
}

/////////////////////////////////////////////////Add Study Subject Data////////////////////////////////////////////////////////////////////////////////
function loadAddStudyMemberData(currentPage) {
    var filterString = $.trim($("#filter_studymember_string").val());
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $('.addStudyMemberLink').css({display: "none"});
    $.getJSON("rest/management/getStudyMembersStudyScreen?filterString="+filterString+"&orderBy=ASC&sortBy=u.lastName", function(data) {
        var iteration = 0;
        var editColumns = " ";

        var out =
            " <table id='addStudyMember'>" +
            "  <tr>" +
            "   <td><input type='checkbox' id='selectall' onclick='toggleAllStudyMembers(this)'/></td>" +
            "   <td><strong>Last Name</strong></td> " +
            "   <td><strong>First Name</strong></td>" +
            "   <td><strong>Title</strong></td>" +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;

            out += "<tr>"
            out += "   <td><input type='checkbox' value="+val.id +" class='studyMemberCheckbox' name='studyMemberCheckbox' onclick='getSelectedStudyMembers();' /></td>" +
            " 	   <td>" + val.lastName + "</td>" +
            "          <td>" + val.firstName + "</td>" +
            "          <td>" + val.title + "</td>" +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#addStudyMemberData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");
    });
    $("#filter_studymember_string").val('');
}

function toggleAllStudyMembers(source) {
    if (source.checked == false) {
        $('.addStudyMemberLink').css({display: "none"});
    } else {
        $('.addStudyMemberLink').css({display: "inline-block"});
    }
    var checkboxes = document.getElementsByName('studyMemberCheckbox');
    for(var i=0, n=checkboxes.length;i<n;i++) {
        checkboxes[i].checked = source.checked;
    }
}

function addStudyMembersClick() {
    getSelectedStudyMembers();
    addStudyMembers();
}

function addStudyMemberStatusDialog() {
    $("#add-studyMember-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                jsonData = JSON.stringify({ studyId: app_selectedStudy.id, studyMembers: selected});
                $.post("rest/study/addStudyMember",{data:jsonData}, function(data) {
                    var confirmationMessage = "Study Member Added.";
                    var parsedData = $.parseJSON(data);
                    if (parsedData.result == false) {
                        confirmationMessage = "Study Member exists on the study.";
                    }
                    $('#study_responseLoading').css({visibility: "hidden"});
                    util_showMainMessage(confirmationMessage);
                    $('#addStudyMemberData').css({display: "none"});
                    $('.addStudyMemberLink').css({display: "none"});
                    currentPage = 1;
                    loadAddStudyMemberData(currentPage);
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function addStudyMembers() {
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    addStudyMemberStatusDialog();
}

function getSelectedStudyMembers() {
    selected = new Array();
    $(".studyMemberCheckbox:checked").each(function() {
        selected.push($(this).val());
    });
    if (selected.length == 0) {
        $('.addStudyMemberLink').css({display: "none"});
    }
    else {
        $('.addStudyMemberLink').css({display: "inline-block"});
    }
    return selected;
}


function showStudyDetail(id) {
    $.getJSON("rest/study/getStudyData?study="+id, function(data) {
        sessionStorage.setItem("studyData", JSON.stringify(data));
        sessionStorage.setItem("mode", JSON.stringify('view'));
        window.location.href="study_detail.html#StudyDetail";
    });
}

function studyDoubleClick(row, id) {
    $(row).bind("dblclick", function(){return showStudyDetail(id);});
}

function loadVisitTemplatesTab() {
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (typeof app_selectedStudy == 'undefined') {
        return;
    }
    else {
        parent.location.hash = "VisitTemplates";
        resetUI();
        initial_load = true;
        activeView = true;
        loadVisitTemplatesData(currentPage, activeView, app_selectedStudy.id);
    }
}

function loadStudySubjectsTab() {
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (typeof app_selectedStudy == 'undefined') {
        return;
    }
    else {
        parent.location.hash = "StudySubjects";
        initial_load = true;
        resetUI();
        loadStudySubjectData(currentPage);
    }
}

function loadStudyMembersTab() {
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    user = JSON.parse(sessionStorage.getItem("userData"));
    if (typeof app_selectedStudy == 'undefined') {
        return;
    }
    else {
        parent.location.hash = "StudyMembers";
        resetUI();
        initial_load = true;
        if (user.institutionRole.id == STUDY_STAFF){
            $('.study_newStudyMemberButton').css({visibility: "hidden"});
        }
        else {
            $('.study_newStudyMemberButton').css({visibility: "visible"});
        }
        loadStudyMemberData(currentPage);
    }
}

function copyVisitTemplate(id) {
    $.getJSON("rest/study/getVisitTemplateData?visit="+id, function(data) {
        sessionStorage.setItem("visitData", JSON.stringify(data));
        sessionStorage.setItem("selectedTab", 0);
        sessionStorage.setItem("mode", JSON.stringify('copy'));
        window.location.href="create_visit.html";
    });
}

function deleteVisitDialog(id) {
    $("#delete-visit-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                $.getJSON("rest/study/deleteVisit?visitId="+id, function(data) {
                    if (data.result == true) {
                        $('#study_responseLoading').css({visibility: "hidden"});
                        var confirmationMessage = "Visit Deleted.";
                        util_showMainMessage(confirmationMessage);
                    }
                    else {
                        var confirmationMessage = "Visit is currently being used or has been used in the past.";
                        util_showMainMessage(confirmationMessage);
                        return;
                    }
                    resetUI();
                    initial_load = true;
                    loadVisitTemplatesData(currentPage, activeView, app_selectedStudy.id);
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function deleteVisitTemplate(id) {
    deleteVisitDialog(id);
}

function study_setFormMode(mode) {
    study_mode = mode;
    study_clearErrors();
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $('.formElementRequired').css({display: "none"});
    if (mode == 'view') {
        app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
        renderBreadcrumbs('study_view_form');
        loadStudyData();
    }
    else if (mode == 'new') {
        renderBreadcrumbs('study_new_form');
        $('#study_form_title').text('Create New Study');
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.study_confirmFormItem').css({visibility: "visible"});
        $('#study_restoreButton').css({display: "none"});
        $('#editStudyLink').css({visibility: "hidden"});
        $('#studyVisitLink').css({visibility: "hidden"});
        $('.formTextReadOnly').css({display: "none"});
        $('#studySubjectLink').css({visibility: "hidden"});
        $('#study_contacts').css({display: "none"});
        $('#study_visit_main_screen').css({display: "none"});
        $('#study_subject_main_screen').css({display: "none"});
        $('#study_member_main_screen').css({display: "none"});
        $('#studyDetails').css({display: "none"});
        $('#study_contacts_details').css({display: "none"});
        $('#study_form_buttons').css({visibility: "visible"});
        $('.formTextInput').css({display: "inline"});
        $('.formSelectInput').css({display: "inline"});
        $('.formTextAreaSmaller').css({display: "inline"});
        $('#study_confirmFormItem').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});

        $('#study_status').css({display: "none"});
        $('#study_statusReadOnly').css({display: "inline"});
        $('#study_statusReadOnly').text('PENDING');
        document.study_form.study_CRCFunded.checked = true;
        study_clearForm();
        study_createDateWidgets();
    }
    else if (mode == 'edit') {
        renderBreadcrumbs('study_edit_form');
        $('#study_form_title').text('Edit study');
        $('#studyDetails').css({display: "none"});
        $('#study_name').text(app_selectedStudy.name);
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.study_confirmFormItem').css({visibility: "visible"});
        $('#editStudyLink').css({visibility: "hidden"});
        $('#studyVisitLink').css({visibility: "visible"});
        $('#studySubjectLink').css({visibility: "visible"});
        $('#study_form_buttons').css({visibility: "visible"});
        $('.formTextReadOnly').css({display: "none"});
        $('.formTextInput').css({display: "inline"});
        $('.formSelectInput').css({display: "inline"});
        $('.formTextAreaSmaller').css({display: "inline"});
        $('#study_confirmFormItem').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});
        $('#study_restoreButton').css({display: "inline"});
        $('#study_contacts').css({display: "block"});
        $('#study_visit_main_screen').css({display: "none"});
        $('#study_subject_main_screen').css({display: "none"});
        $('#study_member_main_screen').css({display: "none"});
        $('#study_contacts_details').css({display: "none"});
        study_createDateWidgets();
        study_loadEditForm();
    }
}

function study_clearForm() {
    $('#study_name').text('');
    $('#study_studyName').val('');
    $('#study_institution').val('');
    $('#study_status').val('');
    $('#study_industryInitiated').val('');
    $('#study_localId').val('');
    $('#study_catalystId').val('');
    $('#study_irb').val('');
    $('#study_shortName').val('');
    $('#study_clinicalTrial').val('');
    $('#study_newDrug').val('');
    $('#study_deviceExemption').val('');
    $('#study_abstract').val('');
    $('#study_pediatric').val('');
    $('#study_crcCategory').val('');
    $('#study_irbInstitution').val('');
    $("#study_investigator").val('');
    $("#study_primaryscheduling").val('');
    $("#study_secondaryscheduling").val('');
    $("#study_thirdscheduling").val('');
    $("#study_physician1").val('');
    $("#study_physician2").val('');
    $("#study_protocolNurse").val('');
    $("#study_associateProtocolNurse").val('');
    $("#study_protocolNutritionist").val('');
    $("#study_associateProtocolNutritionist").val('');

    $('#study_irbExpirationDate').val('');
    $('#study_irbRenewalDate').val('');
    $('#study_irbApprovalDate').val('');
    $('#study_expectedEndDate').val('');
    $('#study_expectedStartDate').val('');
    $('#study_totalSubj').val('');
    $('#study_totalOutpatients').val('');
    $('#study_totalInpatients').val('');
    $("#study_CRCFunded").val('');
    document.study_form.study_CRCFunded.checked = true;

    for (var i = 1; i < 5; i++) {
        var fundingSourceLabel = 'study_fundingSource'+i;
        var fundingCommentLabel = 'study_fundingComment'+i;
        var fundingInstitutionLabel = 'study_fundingInstitution'+i;
        var fundingGrantLabel = 'study_grantId'+i;
        var fundingSiteCostCenterLabel = 'study_siteCostCenter'+i;
        var fundingTotalDirectAwardLabel = 'study_totalDirectDollarAward'+i;
        var fundingTotalIndirectAwardLabel = 'study_totalIndirectDollarAward'+i;
        var fundingProjectStartDateLabel = 'study_projectStartDate'+i;
        var fundingProjectEndDateLabel = 'study_projectEndDate'+i;
        $('#'+fundingSourceLabel).val('');
        $('#'+fundingInstitutionLabel).val('');
        $('#'+fundingGrantLabel).val('');
        $('#'+fundingSiteCostCenterLabel).val('');
        $('#'+fundingTotalDirectAwardLabel).val('');
        $('#'+fundingTotalIndirectAwardLabel).val('');
        $('#'+fundingProjectStartDateLabel).val('');
        $('#'+fundingProjectEndDateLabel).val('');
        $('#'+fundingCommentLabel).val('');
    }
}

function study_loadEditForm() {
    getBrowserVersion();
    sessionStorage.setItem("previousMode", JSON.stringify('edit'));
    $('#study_studyName').val(app_selectedStudy.name);
    $('#study_institution').val(app_selectedStudy.institutionId);
    $('#study_status').val(app_selectedStudy.studyStatusId);
    if (app_selectedStudy.studyStatusId == 1){
        $('#study_contacts').css({display: "none"});
    }
    else {
        $('#study_contacts').css({display: "block"});
    }
    $('#study_industryInitiated').val(app_selectedStudy.industryInitiated == true ? 'Yes' : 'No');
    $('#study_localId').val(app_selectedStudy.localId);
    $('#study_catalystId').val(app_selectedStudy.catalystId);
    $('#study_irb').val(app_selectedStudy.irb);
    $('#study_shortName').val(app_selectedStudy.shortTitle);

    if (app_selectedStudy.crcFunded == true)  {
        document.study_form.study_CRCFunded.checked = true;
    }
    else {
        document.study_form.study_CRCFunded.checked = false;
    }
    $('#study_abstract').val(app_selectedStudy.studyAbstract);
    $('#study_pediatric').val(app_selectedStudy.pediatric);
    $('#study_crcCategory').val(app_selectedStudy.crcCategory);
    $('#study_clinicalTrial').val(app_selectedStudy.clinicalTrial);
    $('#study_newDrug').val(app_selectedStudy.newDrug);
    $('#study_deviceExemption').val(app_selectedStudy.deviceExemption);

    if (app_selectedStudy.irbInstitutionId == 0) {
        $('#study_irbInstitution').val('');
    }
    else {
        $('#study_irbInstitution').val(app_selectedStudy.irbInstitutionId);
    }

    $('#study_fundingSource1').val('');
    $('#study_fundingSource2').val('');
    $('#study_fundingSource3').val('');
    $('#study_fundingSource4').val('');

    for (var i = 0; i < app_selectedStudy.fundingSourceInfoList.length; i++) {
        var fundingSource = app_selectedStudy.fundingSourceInfoList[i];
        var fundingSourceLabel = 'study_fundingSource'+fundingSource.oneToFour;
        var fundingCommentLabel = 'study_fundingComment'+fundingSource.oneToFour;
        var fundingInstitutionLabel = 'study_fundingInstitution'+fundingSource.oneToFour;
        var fundingGrantLabel = 'study_grantId'+fundingSource.oneToFour;
        var fundingSiteCostCenterLabel = 'study_siteCostCenter'+fundingSource.oneToFour;
        var fundingTotalDirectAwardLabel = 'study_totalDirectDollarAward'+fundingSource.oneToFour;
        var fundingTotalIndirectAwardLabel = 'study_totalIndirectDollarAward'+fundingSource.oneToFour;
        var fundingProjectStartDateLabel = 'study_projectStartDate'+fundingSource.oneToFour;
        var fundingProjectEndDateLabel = 'study_projectEndDate'+fundingSource.oneToFour;
        $('#'+fundingSourceLabel).val(fundingSource.id);
        $('#'+fundingInstitutionLabel).val(fundingSource.centerAndInstitutionId);
        $('#'+fundingGrantLabel).val(fundingSource.grant);
        $('#'+fundingSiteCostCenterLabel).val(fundingSource.center);
        $('#'+fundingTotalDirectAwardLabel).val(fundingSource.directAward);
        $('#'+fundingTotalIndirectAwardLabel).val(fundingSource.indirectAward);
        var study_projectStartDateVal = fundingSource.start;
        if (study_projectStartDateVal != null) {
            if (majorVersion == "8"){
                var removeDash = study_projectStartDateVal.replace(/-/g, '/');
                var removeTime = removeDash.replace(/T.*/,'');
                var newDate =  new Date(removeTime);
                var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();

                $('#'+fundingProjectStartDateLabel).val(format_date);
            }
            else {
                $('#'+fundingProjectStartDateLabel).val(dateFormat(study_projectStartDateVal, 'mm/dd/yyyy'));
            }
        }

        var study_projectEndDateVal = fundingSource.end;
        if (study_projectEndDateVal != null) {
            if (majorVersion == "8"){
                var removeDash = study_projectEndDateVal.replace(/-/g, '/');
                var removeTime = removeDash.replace(/T.*/,'');
                var newDate =  new Date(removeTime);
                var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();

                $('#'+fundingProjectEndDateLabel).val(format_date);
            }
            else {
                $('#'+fundingProjectEndDateLabel).val(dateFormat(study_projectEndDateVal, 'mm/dd/yyyy'));
            }
        }
        $('#'+fundingCommentLabel).val(fundingSource.comment);
        toggleFundingSourcesDetail(fundingSourceLabel, fundingSource.id, 'edit');
    }

    $('#study_totalSubj').val(app_selectedStudy.totalSubjects);
    $('#study_totalOutpatients').val(app_selectedStudy.totalOutpatientVisits);
    $('#study_totalInpatients').val(app_selectedStudy.totalInpatientVisits);

    var study_irbExpirationDateVal = app_selectedStudy.irbExpiration;
    if (study_irbExpirationDateVal != null) {
        if (majorVersion == "8"){
            var removeDash = study_irbExpirationDateVal.replace(/-/g, '/');
            var removeTime = removeDash.replace(/T.*/,'');
            var newDate =  new Date(removeTime);
            var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();
            $('#study_irbExpirationDate').val(format_date);
        }
        else {
            $('#study_irbExpirationDate').val(dateFormat(study_irbExpirationDateVal, 'mm/dd/yyyy'));
        }
    }

    var study_irbRenewalDateVal = app_selectedStudy.irbRenewalDate;
    if (study_irbRenewalDateVal != null) {
        if (majorVersion == "8"){
            var removeDash = study_irbRenewalDateVal.replace(/-/g, '/');
            var removeTime = removeDash.replace(/T.*/,'');
            var newDate =  new Date(removeTime);
            var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();
            $('#study_irbRenewalDate').val(format_date);
        }
        else {
            $('#study_irbRenewalDate').val(dateFormat(study_irbRenewalDateVal, 'mm/dd/yyyy'));
        }
    }

    var study_irbApprovalDateVal = app_selectedStudy.irbApprovalDate;
    if (study_irbApprovalDateVal != null) {
        if (majorVersion == "8"){
            var removeDash = study_irbApprovalDateVal.replace(/-/g, '/');
            var removeTime = removeDash.replace(/T.*/,'');
            var newDate =  new Date(removeTime);
            var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();
            $('#study_irbApprovalDate').val(format_date);
        }
        else {
            $('#study_irbApprovalDate').val(dateFormat(study_irbApprovalDateVal, 'mm/dd/yyyy'));
        }
    }

    var study_expectedEndDateVal = app_selectedStudy.expectedEndDate;
    if (study_expectedEndDateVal != null) {
        if (majorVersion == "8"){
            var removeDash = study_expectedEndDateVal.replace(/-/g, '/');
            var removeTime = removeDash.replace(/T.*/,'');
            var newDate =  new Date(removeTime);
            var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();
            $('#study_expectedEndDate').val(format_date);
        }
        else {
            $('#study_expectedEndDate').val(dateFormat(study_expectedEndDateVal, 'mm/dd/yyyy'));
        }
    }

    var study_expectedStartDateVal = app_selectedStudy.expectedStartDate;
    if (study_expectedStartDateVal != null) {
        if (majorVersion == "8"){
            var removeDash = study_expectedStartDateVal.replace(/-/g, '/');
            var removeTime = removeDash.replace(/T.*/,'');
            var newDate =  new Date(removeTime);
            var format_date =  (newDate.getMonth() + 1) +"/"+ newDate.getDate() + "/" + newDate.getFullYear();
            $('#study_expectedStartDate').val(format_date);
        }
        else {
            $('#study_expectedStartDate').val(dateFormat(study_expectedStartDateVal, 'mm/dd/yyyy'));
        }
    }

    $("#study_investigator").val(app_selectedStudy.investigator.id == 0 ? '' : app_selectedStudy.investigator.id);
    $("#study_primaryscheduling").val(app_selectedStudy.scheduler.id == 0 ? '' : app_selectedStudy.scheduler.id);

    if (app_selectedStudy.secondaryScheduler.id == 0) {
        $('#study_secondaryscheduling').val('');
    }
    else {
        $("#study_secondaryscheduling").val(app_selectedStudy.secondaryScheduler.id);
    }

    if (app_selectedStudy.scheduler3.id == 0) {
        $('#study_thirdscheduling').val('');
    }
    else {
        $("#study_thirdscheduling").val(app_selectedStudy.scheduler3.id);
    }

    if (app_selectedStudy.physician.id == 0) {
        $('#study_physician1').val('');
    }
    else {
        $("#study_physician1").val(app_selectedStudy.physician.id);
    }

    if (app_selectedStudy.physician2.id == 0) {
        $('#study_physician2').val('');
    }
    else {
        $("#study_physician2").val(app_selectedStudy.physician2.id);
    }

    if (app_selectedStudy.protocolNurseString == "N/A"){
        $("#study_protocolNurse").val(-1);
    }
    else {
        $("#study_protocolNurse").val(app_selectedStudy.protocolNurse.id == 0 ? '' : app_selectedStudy.protocolNurse.id);
    }

    if (app_selectedStudy.associateNurse.id == 0) {
        $('#study_associateProtocolNurse').val('');
    }
    else {
        $("#study_associateProtocolNurse").val(app_selectedStudy.associateNurse.id);
    }

    if (app_selectedStudy.protocolNutritionistString == "N/A"){
        $("#study_protocolNutritionist").val(-1);
    }
    else {
        $("#study_protocolNutritionist").val(app_selectedStudy.protocolNutritionist.id == 0 ? '' : app_selectedStudy.protocolNutritionist.id);
    }

    if (app_selectedStudy.associateProtocolNutritionist.id == 0) {
        $('#study_associateProtocolNutritionist').val('');
    }
    else {
        $("#study_associateProtocolNutritionist").val(app_selectedStudy.associateProtocolNutritionist.id);
    }
}

function changeStudyStatusClick() {
    if($.trim($("#study_status").val()) == 2 || $.trim($("#study_status").val()) == 3) {
        $('#study_contacts').css({display: "block"});
    }
    else {
        $('#study_contacts').css({display: "none"});
    }
}

//display Funding Source details
function displayFundingSourceDetails(obj, id) {
    var selectedValue = $.trim($("#"+obj.id).val());
    if (selectedValue != 2) {
        $('#study_fundingInstitution'+id).val('');
    }
    var fundingCommentLabel = 'study_fundingComment'+id;
    var fundingInstitutionLabel = 'study_fundingInstitution'+id;
    var fundingGrantLabel = 'study_grantId'+id;
    var fundingSiteCostCenterLabel = 'study_siteCostCenter'+id;
    var fundingTotalDirectAwardLabel = 'study_totalDirectDollarAward'+id;
    var fundingTotalIndirectAwardLabel = 'study_totalIndirectDollarAward'+id;
    var fundingProjectStartDateLabel = 'study_projectStartDate'+id;
    var fundingProjectEndDateLabel = 'study_projectEndDate'+id;
    $('#'+fundingInstitutionLabel).val('');
    $('#'+fundingGrantLabel).val('');
    $('#'+fundingSiteCostCenterLabel).val('');
    $('#'+fundingTotalDirectAwardLabel).val('');
    $('#'+fundingTotalIndirectAwardLabel).val('');
    $('#'+fundingProjectStartDateLabel).val('');
    $('#'+fundingProjectEndDateLabel).val('');
    $('#'+fundingCommentLabel).val('');
    toggleFundingSourcesDetail(obj.id, selectedValue, 'create');
}

function toggleFundingSourcesDetail(id, selectedValue, displayMode) {
    var elements = $("." + id.replace(/\s/g, "."));
    var elementId = 0;
    if (displayMode == 'view') {
        elementId = 1;
    }
    for(var index = 0; index < elements.length; index++){
        if((selectedValue != 2 && index == elementId) || selectedValue == '') {
            elements[index].style.display = "none";
        }
        else {
            elements[index].style.display = "";
        }
    }
}

function study_clearErrors() {
    $('#study_institutionValidation').css({visibility: "hidden"});
    $('#study_studyNameValidation').css({visibility: "hidden"});
    $('#study_statusValidation').css({visibility: "hidden"});
    $('#study_industryInitiatedValidation').css({visibility: "hidden"});
    $('#study_expectedStartDateValidation').css({visibility: "hidden"});
    $('#study_expectedEndDateValidation').css({visibility: "hidden"});
    $('#study_irbApprovalDateValidation').css({visibility: "hidden"});
    $('#study_irbRenewalDateValidation').css({visibility: "hidden"});
    $('#study_irbExpirationDateValidation').css({visibility: "hidden"});
    $('#study_investigatorValidation').css({visibility: "hidden"});
    $('#study_primaryschedulingValidation').css({visibility: "hidden"});
    $('#study_protocolNurseValidation').css({visibility: "hidden"});
    $('#study_protocolNutritionistValidation').css({visibility: "hidden"});
    $('#study_localIdValidation').css({visibility: "hidden"});
    $('#study_fundingSourceValidation').css({display: "none"});
    $('#study_fundingSourceValidation').text('');
    for (var i = 1; i < 5; i++) {
        $('#study_fundingInstitution'+i+'Validation').css({visibility: "hidden"});
        $('#study_totalDirectDollarAward'+i+'Validation').css({visibility: "hidden"});
        $('#study_totalIndirectDollarAward'+i+'Validation').css({visibility: "hidden"});
        $('#study_projectStartDate'+i+'Validation').css({visibility: "hidden"});
        $('#study_projectEndDate'+i+'Validation').css({visibility: "hidden"});
    }
    $('.formElementRequired').css({display: "none"});
}

function getStudyMemberLists() {
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $.getJSON("rest/study/getStudyMembersList?studyId="+(app_selectedStudy != null ? app_selectedStudy.id : 0), function(data) {
        studyMembersSelectOptions = buildSelectsOptions(data, 'id', 'choose');
        var protocolNutritionistSelectOptions = protocolNutritionistBuildSelectsOptions(data, 'id', 'choose', 'N/A');
        $("#study_investigator").html(studyMembersSelectOptions);
        $("#study_primaryscheduling").html(studyMembersSelectOptions);
        $("#study_secondaryscheduling").html(studyMembersSelectOptions);
        $("#study_thirdscheduling").html(studyMembersSelectOptions);
        $("#study_physician1").html(studyMembersSelectOptions);
        $("#study_physician2").html(studyMembersSelectOptions);
        $("#study_protocolNurse").html(protocolNutritionistSelectOptions);
        $("#study_associateProtocolNurse").html(studyMembersSelectOptions);
        $("#study_protocolNutritionist").html(protocolNutritionistSelectOptions);
        $("#study_associateProtocolNutritionist").html(studyMembersSelectOptions);
    });
}

function buildSelectsOptions(list, optionTextProperty, choiceLabel, choiceLabel2) {
    var html = [];
    html[html.length] = "<option value=''>" + choiceLabel + "</option>";
    for (var i = 0, len = list.length; i < len; i++) {
        html[html.length] = "<option value='";
        html[html.length] = list[i].user.id;
        html[html.length] = "'>";
        html[html.length] = list[i].user.firstName + " " + list[i].user.lastName;
        html[html.length] = "</option>";
    }
    return html.join('');
}

function protocolNutritionistBuildSelectsOptions(list, optionTextProperty, choiceLabel, choiceLabel2) {
    var html = [];
    html[html.length] = "<option value=''>" + choiceLabel + "</option>";
    html[html.length] = "<option value='-1'>" + choiceLabel2 + "</option>";
    for (var i = 0, len = list.length; i < len; i++) {
        html[html.length] = "<option value='";
        html[html.length] = list[i].user.id;
        html[html.length] = "'>";
        html[html.length] = list[i].user.firstName + " " + list[i].user.lastName;
        html[html.length] = "</option>";
    }
    return html.join('');
}

function filterStudyMemberClick() {
    $('#addStudyMember').css({display: "block"});
    $('#addStudyMemberData').css({display: "block"});
    resetUI();
    initial_load = true;
    var filterString = $.trim($("#filter_studymember_string").val());
    if (filterString == '') {
        $('#addStudyMemberData').css({display: "none"});
        util_showMainMessage("Please enter the filter string.");
        return;
    }
    loadAddStudyMemberData(currentPage);
}

function filterStudySubjectsClick() {
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $('#addStudySubject').css({display: "block"});
    $('#addStudySubjectData').css({display: "block"});
    initial_load = true;
    resetUI();
    searchAppointmentWorkflow = false;
    var filterString = $.trim($("#filters_string").val());
    if (filterString == '') {
        $('#addStudySubjectData').css({display: "none"});
        util_showMainMessage("Please enter the filter string.");
        return;
    }
    loadAddStudySubjectData(currentPage);
}

function emptyOrNull(theField) {

    var result = false;

    if (theField == null || theField.length < 1) {
        result = true;
    }

    return result;
}

function processStudyForm() {
    var isValid = true;
    study_clearErrors();
    if(emptyOrNull($("#study_institution").val())) { showError('#study_institutionValidation'); isValid = false; }
    if(emptyOrNull($.trim($("#study_studyName").val()))) { showError('#study_studyNameValidation'); isValid = false; }

    if (study_mode == 'edit') {
        if(emptyOrNull($("#study_status").val())) { showError('#study_statusValidation'); isValid = false; }
    }

    if(emptyOrNull($("#study_industryInitiated").val())) { showError('#study_industryInitiatedValidation'); isValid = false; }

    if(emptyOrNull($.trim($("#study_localId").val()))) { showError('#study_localIdValidation'); isValid = false; }

    if ($('#study_fundingSource1').val() == '' && $('#study_fundingSource2').val() == '' &&
        $('#study_fundingSource3').val() == '' && $('#study_fundingSource4').val() == ''){
        alert("Please select at least one Funding Source.");
        $('#study_fundingSourceValidation').text(' Please select at least one Funding Source.');
        $('#study_fundingSourceValidation').css({opacity: 0.0, display: "inline-block"}).animate({opacity: 1.0});
        isValid = false;
    }

    if($("#study_status").val() == 2 || $("#study_status").val() == 3) {
        if(emptyOrNull($("#study_investigator").val())) { showError('#study_investigatorValidation'); isValid = false; }
        if(emptyOrNull($("#study_primaryscheduling").val())) { showError('#study_primaryschedulingValidation'); isValid = false; }
        if(emptyOrNull($("#study_protocolNurse").val())) { showError('#study_protocolNurseValidation'); isValid = false; }
        if(emptyOrNull($("#study_protocolNutritionist").val())) { showError('#study_protocolNutritionistValidation'); isValid = false; }
    }

    var study_irbExpirationDateVal = $('#study_irbExpirationDate').val();
    var study_irbRenewalDateVal = $('#study_irbRenewalDate').val();
    var study_irbApprovalDateVal = $('#study_irbApprovalDate').val();
    var study_expectedEndDateVal = $('#study_expectedEndDate').val();
    var study_expectedStartDateVal = $('#study_expectedStartDate').val();

    if (study_irbApprovalDateVal != "" && study_irbExpirationDateVal == "") {
        showError('#study_irbExpirationDateValidation', 'Please enter IRB Expiration Date');
        isValid = false;
    }

    if (study_irbApprovalDateVal == "" && study_irbExpirationDateVal != "") {
        showError('#study_irbApprovalDateValidation', 'Please enter IRB Approval Date');
        isValid = false;
    }

    if (study_irbRenewalDateVal != "" && study_irbExpirationDateVal == "" && study_irbApprovalDateVal != "") {
        showError('#study_irbExpirationDateValidation', 'Please enter IRB Expiration Date');
        isValid = false;
    }

    if (study_irbRenewalDateVal != "" && study_irbExpirationDateVal != "" && study_irbApprovalDateVal == "") {
        showError('#study_irbApprovalDateValidation', 'Please enter IRB Approval Date');
        isValid = false;
    }

    if (study_irbRenewalDateVal != "" && study_irbExpirationDateVal == "" && study_irbApprovalDateVal == "") {
        showError('#study_irbApprovalDateValidation', 'Please enter IRB Approval Date');
        showError('#study_irbExpirationDateValidation', 'Please enter IRB Expiration Date');
        isValid = false;
    }


    if (study_irbRenewalDateVal == "" && study_irbExpirationDateVal != "" && study_irbApprovalDateVal != "") {
        if (($('#study_irbExpirationDate').datepicker('getDate') <=
            $('#study_irbApprovalDate').datepicker('getDate'))) {
            showError('#study_irbApprovalDateValidation', 'IRB Approval Date should be smaller than IRB Expiration Date.');
            showError('#study_irbExpirationDateValidation', 'IRB Expiration Date should be greater than IRB Approval Date.');
            isValid = false;
        }
    }

    if (study_irbRenewalDateVal != "" && study_irbExpirationDateVal != "" && study_irbApprovalDateVal != "") {
        if (($('#study_irbApprovalDate').datepicker('getDate') <=
            $('#study_irbRenewalDate').datepicker('getDate'))
            && ($('#study_irbRenewalDate').datepicker('getDate') <
            $('#study_irbExpirationDate').datepicker('getDate'))) {
        }
        else {
            showError('#study_irbRenewalDateValidation', 'Please enter valid date range');
            showError('#study_irbApprovalDateValidation', 'Please enter valid date range');
            showError('#study_irbExpirationDateValidation', 'Please enter valid date range');
            isValid = false;
        }
    }

    if ($('#study_expectedStartDate').datepicker('getDate') == "" && $('#study_expectedEndDate').datepicker('getDate') != "") {
        showError('#study_expectedStartDateValidation');
        isValid = false;
    }

    if ($('#study_expectedStartDate').datepicker('getDate') != "" && $('#study_expectedEndDate').datepicker('getDate') == "") {
        showError('#study_expectedEndDateValidation');
        isValid = false;
    }

    if ($('#study_expectedStartDate').datepicker('getDate') != "" && $('#study_expectedEndDate').datepicker('getDate') != ""
        && $('#study_expectedStartDate').datepicker('getDate') > $('#study_expectedEndDate').datepicker('getDate')) {
        showError('#study_expectedStartDateValidation', 'invalid date range');
        isValid = false;
    }

    if (study_expectedStartDateVal != "") {
        var expectedStartDate = new Date(study_expectedStartDateVal);
        expectedStartDate.setHours(0, 0, 0, 0);
        expectedStartDate.setHours(10);
        expectedStartDate.setMinutes(0);
    }
    if (study_expectedEndDateVal != "") {
        var expectedEndDate = new Date(study_expectedEndDateVal);
        expectedEndDate.setHours(0, 0, 0, 0);
        expectedEndDate.setHours(10);
        expectedEndDate.setMinutes(0);
    }
    if (study_irbApprovalDateVal != "") {
        var irbApprovalDate = new Date(study_irbApprovalDateVal);
        irbApprovalDate.setHours(0,0,0,0);
        irbApprovalDate.setHours(10);
        irbApprovalDate.setMinutes(0);
    }
    if (study_irbRenewalDateVal != "") {
        var irbRenewalDate = new Date(study_irbRenewalDateVal);
        irbRenewalDate.setHours(0,0,0,0);
        irbRenewalDate.setHours(10);
        irbRenewalDate.setMinutes(0);
    }
    if (study_irbExpirationDateVal != "") {
        var irbExpirationDate = new Date(study_irbExpirationDateVal);
        irbExpirationDate.setHours(0,0,0,0);
        irbExpirationDate.setHours(10);
        irbExpirationDate.setMinutes(0);
    }


    var irbInstitutionValue = $.trim($('#study_irbInstitution').val());

    if (isValid == false) {
        return;
    }

    var fundingSourceList = [];

    for (var i = 1; i < 5; i++) {
        var fundingSourceValue = $('#study_fundingSource'+i).val();
        var study_centerInstitutionVal = $.trim($('#study_fundingInstitution'+i).val());
        if (fundingSourceValue == 2 && study_centerInstitutionVal == '') {
            showError('#study_fundingInstitution'+i+'Validation', 'Please select Center and Institutes for the Funding Source.');
            isValid = false;
            return;
        }

        if ($.trim($('#study_totalDirectDollarAward' + i).val()) != "" && !isNumber($.trim($('#study_totalDirectDollarAward' + i).val()))) {
            showError('#study_totalDirectDollarAward'+i+'Validation', 'Please enter valid Total Direct Dollar Award.');
            isValid = false;
            return;
        }

        if ($.trim($('#study_totalIndirectDollarAward' + i).val()) != "" && !isNumber($.trim($('#study_totalIndirectDollarAward' + i).val()))) {
            showError('#study_totalIndirectDollarAward'+i+'Validation', 'Please enter valid Total Indirect Dollar Award.');
            isValid = false;
            return;
        }

        if (($('#study_projectStartDate'+ i).val() != "" && $('#study_projectEndDate'+ i).val() != "") &&
            (new Date($('#study_projectStartDate' + i).val())) >= (new Date($('#study_projectEndDate'+ i).val()))) {
            showError('#study_projectStartDate'+i+'Validation', 'Please enter valid Project Start Date.');
            showError('#study_projectEndDate'+i+'Validation', 'Please enter valid Project End Date.');
            isValid = false;
            return;
        }

        if (fundingSourceValue != '') {
            var fundingData = {
                id : fundingSourceValue,
                comment : $.trim($('#study_fundingComment' + i).val()),
                oneToFour : i,
                grant: $('#study_grantId' + i).val(),
                center: $('#study_siteCostCenter' + i).val(),
                directAward : ($('#study_totalDirectDollarAward' + i).val() != "" ? $('#study_totalDirectDollarAward' + i).val() : null),
                indirectAward : ($('#study_totalIndirectDollarAward' + i).val() != "" ? $('#study_totalIndirectDollarAward' + i).val() : null),
                start : $('#study_projectStartDate'+ i).val() != "" ? (new Date($('#study_projectStartDate' + i).val())).valueOf() : null,
                end : $('#study_projectEndDate'+ i).val() != "" ? (new Date($('#study_projectEndDate'+ i).val())).valueOf() : null,
                centerAndInstitutionId : (study_centerInstitutionVal != "" ? study_centerInstitutionVal : null)
            };
            fundingSourceList.push(fundingData);
        }
    }

    var investigatorValue = $.trim($('#study_investigator').val());
    var physicianValue = $.trim($('#study_physician1').val());
    var physician2Value = $.trim($('#study_physician2').val());
    var schedulerValue = $.trim($('#study_primaryscheduling').val());
    var secondarySchedulerValue = $.trim($('#study_secondaryscheduling').val());
    var thirdSchedulerValue = $.trim($('#study_thirdscheduling').val());
    var protocolNurseValue = $.trim($('#study_protocolNurse').val());
    var associateNurseValue = $.trim($('#study_associateProtocolNurse').val());
    var protocolNutritionistValue = $.trim($('#study_protocolNutritionist').val());
    var associateProtocolNutritionistValue = $.trim($('#study_associateProtocolNutritionist').val());
    var totalSubjectsValue = $.trim($('#study_totalSubj').val());
    var totalOutpatientVisitsValue = $.trim($('#study_totalOutpatients').val());
    var totalInpatientVisitsValue = $.trim($('#study_totalInpatients').val());
    var crcFunded = null;
    if ($('#study_CRCFunded').is(':checked')) {
        crcFunded = true;
    }
    else {
        crcFunded = false;
    }

    $('#study_responseLoading').css({visibility: "visible"});
    jsonData = JSON.stringify({
        id: (app_selectedStudy != null ? app_selectedStudy.id : 0),
        name: $.trim($("#study_studyName").val()),
        institution: $.trim($("#study_institution").val()),
        studyStatus: (study_mode == 'edit' ? $('#study_status').val() : 1),
        industryInitiated: $('#study_industryInitiated').val(),
        localId:  $.trim($("#study_localId").val()),
        catalystId: $.trim($('#study_catalystId').val()),
        irb:   $.trim($('#study_irb').val()),
        shortTitle:  $.trim($('#study_shortName').val()),
        pediatric: $.trim($('#study_pediatric').val()),
        crcCategory :  $.trim($('#study_crcCategory').val()),
        fundingSourceInfoList: fundingSourceList,
        studyAbstract: $.trim($('#study_abstract').val()),
        clinicalTrial: $.trim($('#study_clinicalTrial').val()),
        newDrug: $.trim($('#study_newDrug').val()),
        deviceExemption: $.trim($('#study_deviceExemption').val()),
        irbInstitution: (irbInstitutionValue != "" ? irbInstitutionValue : null),
        investigator: (investigatorValue != "" ? investigatorValue : null),
        crcFunded: crcFunded,
        physician: (physicianValue != "" ? physicianValue : null),
        physician2: (physician2Value != "" ? physician2Value : null),
        scheduler: (schedulerValue != "" ? schedulerValue : null),
        secondaryScheduler: (secondarySchedulerValue != "" ? secondarySchedulerValue : null),
        scheduler3 : (thirdSchedulerValue != "" ? thirdSchedulerValue : null),
        protocolNurse: (protocolNurseValue != "" ? protocolNurseValue : null),
        associateNurse: (associateNurseValue != "" ? associateNurseValue : null),
        protocolNutritionist: (protocolNutritionistValue != "" ? protocolNutritionistValue : null),
        associateProtocolNutritionist: (associateProtocolNutritionistValue != "" ? associateProtocolNutritionistValue : null),
        irbExpiration: (study_irbExpirationDateVal != "" ? irbExpirationDate.valueOf() : null),
        irbRenewalDate: (study_irbRenewalDateVal != "" ? irbRenewalDate.valueOf() : null),
        irbApprovalDate: (study_irbApprovalDateVal != "" ? irbApprovalDate.valueOf() : null),
        expectedStartDate: (study_expectedStartDateVal != "" ? expectedStartDate.valueOf() : null),
        expectedEndDate: (study_expectedEndDateVal != "" ? expectedEndDate.valueOf() : null),
        totalSubjects: (totalSubjectsValue != "" ? totalSubjectsValue : 0),
        totalOutpatientVisits: (totalOutpatientVisitsValue != "" ? totalOutpatientVisitsValue : 0),
        totalInpatientVisits: (totalInpatientVisitsValue != "" ? totalInpatientVisitsValue : 0)
    });

    var url = "rest/study/createStudy";

    if (study_mode == 'edit') {
        url = "rest/study/editstudy";
    }
    $.post(url, {data:jsonData},
        function(data) {
            var parsedData = $.parseJSON(data);
            var confirmationMessage = "";
            if (parsedData.result == true) {
                confirmationMessage = "New Study created";
                if (study_mode == 'edit') {
                    confirmationMessage = "Study updated";
                }
                study_clearErrors();
                $('#study_responseLoading').css({visibility: "hidden"});
                alert(confirmationMessage);
                showStudyDetail(parsedData.id);
                util_showMainMessage(confirmationMessage);
            }
            else if (parsedData.result == false) {
                util_showMainMessage("Local ID already exists.");
                $('#study_responseLoading').css({visibility: "hidden"});
                return;
            }
            else {
                confirmationMessage = "New Study created";
                if (study_mode == 'edit') {
                    confirmationMessage = "Study updated";
                }
                study_clearErrors();
                $('#study_responseLoading').css({visibility: "hidden"});
                alert(confirmationMessage);
                showStudyDetail(parsedData.id);
                util_showMainMessage(confirmationMessage);
            }
        });
}

function isNumber(n) {
    return !isNaN(parseFloat(n));
}

function study_visit_setFormMode(mode) {
    study_visit_mode = mode;
    app_selectedVisit = JSON.parse(sessionStorage.getItem("visitData"));
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $('.formElementRequired').css({visibility: "hidden"});
    if (mode == 'view') {
        renderBreadcrumbs('study_visit_view_form');
        $('#study_visit_form_title').text('Additional Details');
        $('#study_visit_name').html('('+app_selectedStudy.localId+')' + '<br> <div style="padding: 3px;"></div>' + app_selectedVisit.studyName);
        $('#visit_name').text(app_selectedVisit.visitName);
        if (user.institutionRole.id == STUDY_STAFF){
            $('#editStudyVisitLink').css({visibility: "hidden"});
        }
        else {
            $('#editStudyVisitLink').css({visibility: "visible"});
        }
        $('#editStudyLink').css({visibility: "visible"});
        $('.requiredFieldKey').css({visibility: "hidden"});
        $('#study_visit_form_buttons').css({visibility: "hidden"});
        $('.requiredIcon').css({visibility: "hidden"});
        $('.numbersOnly').css({display: "none"});
        $('.formTextReadOnly').css({display: "inline-block"});
        $('.formTextInput').css({display: "none"});
        $('.formSelectInput').css({display: "none"});
        $('.formTextAreaSmaller').css({display: "none"});
        $('.formCheckBox').css({display: "none"});
        $('.formCheckBoxReadOnly').css({display: "inline"});
        $('.study_confirmFormItem').css({visibility: "hidden"});
        $('#study_visitNameReadOnly').text(app_selectedVisit.visitName);
        $('#study_shortVisitNameReadOnly').text(app_selectedVisit.shortName);
        $('#study_visitSublocationReadOnly').text(app_selectedVisit.sublocationName);
        $('#study_visitTypeReadOnly').text(app_selectedVisit.visitTypeName);
        $('#inpatient_relative_time').css((app_selectedVisit.visitTypeId == 1 || app_selectedVisit.visitTypeId == 2 || app_selectedVisit.visitTypeId == 3) ? {display: "none"} : {display: "block"});

        if (app_selectedVisit.relativeTime == true)  {
            document.visit_form.study_relativeTimeReadOnly.checked = true;
        }
        else {
            document.visit_form.study_relativeTimeReadOnly.checked = false;
        }

        if (app_selectedVisit.researchPharmacy == true)  {
            document.visit_form.study_researchPharmacyReadOnly.checked = true;
        }
        else {
            document.visit_form.study_researchPharmacyReadOnly.checked = false;
        }
        if (app_selectedVisit.institutionNonCrc == true)  {
            document.visit_form.study_institution_noncrcReadOnly.checked = true;
        }
        else {
            document.visit_form.study_institution_noncrcReadOnly.checked = false;
        }
        if (app_selectedVisit.nonInstitutionNonCrc == true)  {
            document.visit_form.study_nonInstitution_nonCrcReadOnly.checked = true;
        }
        else {
            document.visit_form.study_nonInstitution_nonCrcReadOnly.checked = false;
        }

        $('#study_visitCommentReadOnly').text(app_selectedVisit.comment);

        $('#study_nursingReadOnly').text(app_selectedVisit.nursing);
        $('#study_nutritionReadOnly').text(app_selectedVisit.nutrition);
        $('#study_processingReadOnly').text(app_selectedVisit.processing);
        $('#study_setupReadOnly').text(app_selectedVisit.setup);
        $('#visitgrid_finalApprovalStatus').text(app_selectedVisit.approved);
    }
    else if (mode == 'new') {
        renderBreadcrumbs('study_visit_new_form');
        $('#visit_name').text('');
        $('#study_visit_name').text('');
        $('#study_visit_form_title').text('Create New Visit Template');
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.study_confirmFormItem').css({visibility: "visible"});
        $('.formTextReadOnly').css({display: "none"});
        $('#study_visit_restoreButton').css({display: "none"});
        $('#editStudyVisitLink').css({visibility: "hidden"});
        $('.requiredIcon').css({visibility: "hidden"});
        $('.numbersOnly').css({display: "inline"});
        $('#study_visit_form_buttons').css({visibility: "visible"});
        $('.formTextInput').css({display: "inline"});
        $('.formSelectInput').css({display: "inline"});
        $('.formTextAreaSmaller').css({display: "inline"});
        $('.formCheckBox').css({display: "inline"});
        $('.formCheckBoxReadOnly').css({display: "none"});
        $('#study_confirmFormItem').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});
        $('#editStudyLink').css({visibility: "hidden"});
        $('#visit_approval_screen').css({display: "none"});
        $('#scheduler_form_screen').css({display: "none"});
        $('#inpatient_relative_time').css({display: "none"});
        study_visit_clearForm();
    }
    else if (mode == 'edit') {
        renderBreadcrumbs('study_visit_edit_form');
        $('#study_visit_form_title').text('Edit Visit');
        $('#study_visit_name').text(app_selectedVisit.studyName);
        $('#visit_name').text(app_selectedVisit.visitName);
        $('.requiredFieldKey').css({visibility: "visible"});
        $('.study_confirmFormItem').css({visibility: "visible"});
        $('#editStudyVisitLink').css({visibility: "hidden"});
        $('#editStudyLink').css({visibility: "hidden"});
        $('#study_visit_form_buttons').css({visibility: "visible"});
        $('.numbersOnly').css({display: "inline"});
        $('.formTextReadOnly').css({display: "none"});
        $('.formTextInput').css({display: "inline"});
        $('.requiredIcon').css({visibility: "hidden"});
        $('.formCheckBox').css({display: "inline"});
        $('.formCheckBoxReadOnly').css({display: "none"});
        $('.formSelectInput').css({display: "inline"});
        $('.formTextAreaSmaller').css({display: "inline"});
        $('#study_confirmFormItem').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "visible"});
        $('#study_restoreButton').css({display: "inline"});
        $('#visit_approval_screen').css({display: "none"});
        $('#scheduler_form_screen').css({display: "none"});
        $('#inpatient_relative_time').css((app_selectedVisit.visitTypeId == 1 || app_selectedVisit.visitTypeId == 2 || app_selectedVisit.visitTypeId == 3) ? {display: "none"} : {display: "block"});
        study_visit_loadEditForm();
    }
    else if (mode == 'copy') {
        renderBreadcrumbs('study_visit_copy_form');
        $('#study_visit_form_title').text('Copying Visit Template: ' + app_selectedVisit.visitName);
        $('#study_visit_name').text(app_selectedVisit.studyName);
        $('#visit_name').text(app_selectedVisit.visitName);
        $('#editStudyVisitLink').css({visibility: "hidden"});
        $('#editStudyLink').css({visibility: "hidden"});
        $('.requiredFieldKey').css({visibility: "visible"});
        $('#study_visit_form_buttons').css({visibility: "visible"});
        $('.requiredIcon').css({visibility: "hidden"});
        $('.formTextInput').css({display: "inline"});
        $('.formTextReadOnly').css({display: "inline"});
        $('.formSelectInput').css({display: "none"});
        $('.numbersOnly').css({display: "none"});
        $('.formTextAreaSmaller').css({display: "inline"});
        $('#study_confirmFormItem').css({visibility: "visible"});
        $('.formCheckBox').css({display: "none"});
        $('.formCheckBoxReadOnly').css({display: "inline"});
        $('.requiredIcon').css({visibility: "visible"});
        $('#study_restoreButton').css({display: "inline"});
        $('#study_visit_restoreButton').css({display: "none"});
        $('#visit_approval_screen').css({display: "none"});
        $('#scheduler_form_screen').css({display: "none"});
        $('#inpatient_relative_time').css((app_selectedVisit.visitTypeId == 1 || app_selectedVisit.visitTypeId == 2 || app_selectedVisit.visitTypeId == 3) ? {display: "none"} : {display: "block"});

        $('#study_visitNameReadOnly').text('');
        $('#study_visitName').val(app_selectedVisit.visitName);
        $('#study_shortVisitName').val(app_selectedVisit.shortName);

        $('#study_visitSublocationReadOnly').text(app_selectedVisit.sublocationName);
        $('#study_visitTypeReadOnly').text(app_selectedVisit.visitTypeName);


        if (app_selectedVisit.relativeTime == true)  {
            document.visit_form.study_relativeTimeReadOnly.checked = true;
        }
        else {
            document.visit_form.study_relativeTimeReadOnly.checked = false;
        }

        if (app_selectedVisit.researchPharmacy == true)  {
            document.visit_form.study_researchPharmacyReadOnly.checked = true;
        }
        else {
            document.visit_form.study_researchPharmacyReadOnly.checked = false;
        }
        if (app_selectedVisit.institutionNonCRC == true)  {
            document.visit_form.study_institution_noncrcReadOnly.checked = true;
        }
        else {
            document.visit_form.study_institution_noncrcReadOnly.checked = false;
        }
        if (app_selectedVisit.nonInstitutionNonCRC == true)  {
            document.visit_form.study_nonInstitution_nonCrcReadOnly.checked = true;
        }
        else {
            document.visit_form.study_nonInstitution_nonCrcReadOnly.checked = false;
        }

        $('#study_visitComment').text('');

        if (app_selectedVisit.nursing > 0 || app_selectedVisit.nursing == 0){
            $('#study_nursingReadOnly').text(app_selectedVisit.nursing);
        }
        else {
            $('#study_nursingReadOnly').text('');
        }

        if (app_selectedVisit.nutrition > 0 || app_selectedVisit.nutrition == 0){
            $('#study_nutritionReadOnly').text(app_selectedVisit.nutrition);
        }
        else {
            $('#study_nutritionReadOnly').text('');
        }

        if (app_selectedVisit.processing == 0 || app_selectedVisit.processing > 0 ){
            $('#study_processingReadOnly').text(app_selectedVisit.processing);
        }
        else {
            $('#study_processingReadOnly').text('');
        }

        if (app_selectedVisit.setup == 0 || app_selectedVisit.setup > 0){
            $('#study_setupReadOnly').text(app_selectedVisit.setup);
        }
        else {
            $('#study_setupReadOnly').text('');
        }
    }
}

function study_visit_clearForm() {
    $('#study_visitName').val('');
    $('#study_shortVisitName').val('');
    $('#study_visitSublocation').val('');
    $('#study_visitType').val('');
    $('#study_researchPharmacy').val('');
    $('#study_institution_noncrc').val('');
    $('#study_nonInstitution_nonCrc').val('');
    $('#study_visitComment').val('');
    $('#study_nursing').val('');
    $('#study_nutrition').val('');
    $('#study_processing').val('');
    $('#study_setup').val('');
    $('#study_relative_time').val('');
}

function study_visit_loadEditForm() {
    sessionStorage.setItem("previousMode", JSON.stringify('edit'));
    $('#study_visitName').val(app_selectedVisit.visitName);
    $('#study_shortVisitName').val(app_selectedVisit.shortName);
    $('#study_visitSublocation').val(app_selectedVisit.sublocationId);
    $('#study_visitType').val(app_selectedVisit.visitTypeId);

    if (app_selectedVisit.relativeTime == true)  {
        document.visit_form.study_relativeTime.checked = true;
    }
    else {
        document.visit_form.study_relativeTime.checked = false;
    }

    if (app_selectedVisit.researchPharmacy == true)  {
        document.visit_form.study_researchPharmacy.checked = true;
    }
    else {
        document.visit_form.study_researchPharmacy.checked = false;
    }
    if (app_selectedVisit.institutionNonCrc == true)  {
        document.visit_form.study_institution_noncrc.checked = true;
    }
    else {
        document.visit_form.study_institution_noncrc.checked = false;
    }
    if (app_selectedVisit.nonInstitutionNonCrc == true)  {
        document.visit_form.study_nonInstitution_nonCrc.checked = true;
    }
    else {
        document.visit_form.study_nonInstitution_nonCrc.checked = false;
    }
    $('#study_visitComment').val('');

    if (app_selectedVisit.nursing == 0 || app_selectedVisit.nursing > 0){
        $('#study_nursing').val(app_selectedVisit.nursing);
    }
    else {
        $('#study_nursing').val('');
    }

    if (app_selectedVisit.nutrition == 0 || app_selectedVisit.nutrition > 0){
        $('#study_nutrition').val(app_selectedVisit.nutrition);
    }
    else {
        $('#study_nutrition').val('');
    }

    if (app_selectedVisit.processing == 0 || app_selectedVisit.processing > 0){
        $('#study_processing').val(app_selectedVisit.processing);
    }
    else {
        $('#study_processing').val('');
    }

    if (app_selectedVisit.setup == 0 || app_selectedVisit.setup > 0){
        $('#study_setup').val(app_selectedVisit.setup);
    }
    else {
        $('#study_setup').val('');
    }
}

function loadVisitTemplateApprovalsTab() {
    sessionStorage.setItem("selectedTab", 0);
    initial_load = true;
    resetUI();
    loadVisitApprovalTable(currentPage);
}

var sortByUserFullName = "u.lastName";
var sortByStatusChangeTime = "tah.statusChangeTime";
var sortByVisitCreatedDate = "v.createdDate";
var sortByUserRole = "u.role.name";
var sortByUserTitle = "u.institutionRole.name";

function loadVisitApprovalTable(currentPage){
    app_selectedVisit = JSON.parse(sessionStorage.getItem("visitData"));
    app_selectedStudy = JSON.parse(sessionStorage.getItem("studyData"));
    $('#study_visit_name1').html('('+app_selectedStudy.localId+')' + '<br> <div style="padding: 3px;"></div>' + app_selectedVisit.studyName);
    $('#visit_name1').text(app_selectedVisit.visitName);
    renderBreadcrumbs('study_visit_view_form');
    commonData();
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 50;
    }

    if (user.institutionRole.id == STUDY_STAFF) {
        $('#study_newVisitApprovalButton').css({visibility: "hidden"});
    }

    $.getJSON("rest/study/getVisitApprovals?visit="+app_selectedVisit.id+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 50)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByUserFullName), function(data) {
        var iteration = 0;

        var sort_header;
        var userFullName_header1 = 'sortable';
        var statusChangeTime_header2 = 'sortable';
        var createdDate_header3 = 'sortable';
        var userRole_header4 = 'sortable';
        var userTitle_header5 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByUserFullName){
            userFullName_header1 = sort_header;
        } else if (sortBy == sortByStatusChangeTime){
            statusChangeTime_header2 = sort_header;
        } else if (sortBy == sortByVisitCreatedDate){
            createdDate_header3 = sort_header;
        } else if (sortBy == sortByUserRole){
            userRole_header4 = sort_header;
        } else if (sortBy == sortByUserTitle){
            userTitle_header5 = sort_header;
        }

        var out =   " <table id='visitApproval'>"
            +  " <tr>" +
            "   <td class= "+ userFullName_header1 + " onclick='sortingFunction(sortByUserFullName)'><strong>User Full Name</strong></td>" +
            "   <td class= "+ statusChangeTime_header2 + " onclick='sortingFunction(sortByStatusChangeTime)'><strong>Last Edited</strong></td> " +
            "   <td class='not_sortable'><strong>Comment</strong></td>" +
            "   <td class= "+ createdDate_header3 + " onclick='sortingFunction(sortByVisitCreatedDate)'><strong>Template Created</strong></td>" +
            "   <td class= "+ userRole_header4 + " onclick='sortingFunction(sortByUserRole)'><strong>User Role</strong></td>" +
            "   <td class= "+ userTitle_header5 + " onclick='sortingFunction(sortByUserTitle)'><strong>User Title</strong></td>" +
            "   <td class='not_sortable'><strong>User Approval Status</strong></td>" +
            "  </tr> ";

        sessionStorage.setItem("finalApproval", app_selectedVisit.approved);

        $.each(data, function(key, val) {
            totalData = val.totalCount;
            $('#visit_finalApprovalStatus').text(val.finalApproval);
            $('#visitgrid_finalApprovalStatus').text(val.finalApproval);

            sessionStorage.setItem("finalApproval", val.finalApproval);
            out += "<tr>"
            out += "   <td>" + val.userFullName + "</td>" +
            "          <td>" + showDateTime(val.statusChangeTime) + "</td>" +
            "          <td>" + showValue(val.comment) + "</td>" +
            "          <td>" + showDateTime(val.visitCreatedDate) + "</td>" +
            "          <td>" + val.userTitle + "</td>" +
            "          <td>" + val.userRole + "</td>" +
            "          <td>" + val.approved + "</td>" +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#visitApproval_data').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results)
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

function viewVisitCommentClick() {
    $("#visit_comment_dialog").dialog({modal: true, height:460, width:700});
    loadVisitTemplateComments();
}

function loadVisitTemplateComments(){
    app_selectedVisit = JSON.parse(sessionStorage.getItem("visitData"));
    commonData();
    $.getJSON("rest/study/getVisitComments?id=" + app_selectedVisit.id, function(data) {
        var iteration = 0;

        var out =   " <table id='visitComments'>"
            +  " <tr>" +
            "   <td class='not_sortable'><strong>User ID</strong></td>" +
            "   <td class='not_sortable'><strong>Date</strong></td> " +
            "   <td class='not_sortable'><strong>Comment</strong></td>" +
            "  </tr> ";

        $.each(data, function(key, val) {
            out += "<tr>"
            out += "   <td>" + showValue(val.ecommonsId) + "</td>" +
            "          <td>" + showClockDateTime(val.commentDate) + "</td>" +
            "          <td>" + showValue(val.comment) + "</td>" +
            " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#visitComments_data').html(out);
    });
}

function viewBookedVisitCommentClick() {
    $("#appt_visit_comment_dialog").dialog({modal: true, height:460, width:703});
    loadBookedVisitComments();
}

function loadBookedVisitComments(){
    $.getJSON("rest/appointment/getAppointmentComments?id="+eventid, function(data) {
        var iteration = 0;
        if (window.location.href.indexOf("appt_calendar.html") > -1){
            $('#bookedVisitCommentHeaderData').html("<table id='bookedVisitCommentHeaderData'> <thead> <tr>" +
            "   <th width='30%' class='not_sortable'>User ID</th>" +
            "   <th width='30%' class='not_sortable'>Date</th>" +
            "   <th width='40%' class='not_sortable'>Comment</th>" +
            "  </tr> </thead> </table>");
            var out = " <table id='bookedVisitComments'>";
        }
        else {
            var out = " <table id='bookedVisitComments'>" +
                " <tr>" +
                "   <td class='not_sortable'><strong>User ID</strong></td>" +
                "   <td class='not_sortable'><strong>Date</strong></td> " +
                "   <td class='not_sortable'><strong>Comment</strong></td>" +
                "  </tr> ";
        }

        if (data.total == 0) {
            out += "<tr> <td> There are no comments to display. </td> </tr>";
        }
        else {
            $.each(data.visitComments, function(key, val) {
                out +=  ((iteration % 2 == 1) ? "<tbody> <tr class='altRow'>" : "<tr>");
                out += "   <td width='30%'>" + showValue(val.ecommonsId) + "</td>" +
                "          <td width='30%'>" + showDateTime(val.commentDate) + "</td>" +
                "          <td width='40%'>" + showValue(val.comment) + "</td>" +
                " </tr>";
                iteration++;
            });
        }

        out += " </tbody> </table>";

        $('#bookedVisitCommentData').html(out);
    });
}

var nursingData = ['None', '5 – 15 min', '16 – 30 min', '31 – 60 min', '61 – 120 min', '121 – 240 min', '241 – 420 min', 'Over 420 min'];

var nutritionData = ['0', 'None', '5 – 15 min', '16 – 30 min', '31 – 60 min', '61 – 90 min', '91 – 150 min', '151 – 240 min', 'Over 240 min'];

var processingData = ['None', '1 – 15 min', '16 – 30 min', '31 – 60 min', '61 – 180 min', '181 – 300 min', '301 – 480 min', 'Over 480 min'];

var setupData = ['None', '2.5 – 15 min', '16 – 30 min', '31 – 60 min', '60 - 120 min', '120+ min', 'N/A', 'N/A'];

function loadLevelOfServices(lineLevelData, columnName){
    app_selectedVisit = JSON.parse(sessionStorage.getItem("visitData"));
    commonData();
    var iteration = 0;
    var out =   " <table id='lineLevelService'>"
        +  " <tr>" +
        "   <td class='not_sortable'><strong>Level</strong></td>" +
        "   <td class='not_sortable'><strong>"+ columnName +"</strong></td> " +
        "  </tr> ";

    $.each(nursingData, function(index, val) {
        out += "<tr>"
        out += "   <td>" + index + "</td>" +
        "          <td>" + lineLevelData[index] + "</td>" +
        " </tr>";
        iteration++;
    });

    out += " </table>";

    $('#nursing_data').html(out);
    $('#nutrition_data').html(out);
    $('#processing_data').html(out);
    $('#setup_data').html(out);
}

function nursingIntensityClick() {
    $("#nursingLevelOfService_dialog").dialog({modal: true, height:350, width:335});
    loadLevelOfServices(nursingData, "Nursing Time Required");
}

function nutritionIntensityClick() {
    $("#nutritionLevelOfService_dialog").dialog({modal: true, height:350, width:335});
    loadLevelOfServices(nutritionData, "Nutrition Time Required");
}


function processingIntensityClick() {
    $("#processingLevelOfService_dialog").dialog({modal: true, height:350, width:335});
    loadLevelOfServices(processingData, "Processing Time Required");
}

function setupIntensityClick() {
    $("#setupLevelOfService_dialog").dialog({modal: true, height:350, width:335});
    loadLevelOfServices(setupData, "Setup Time Required");
}

function loadBuildVisitTemplateData() {
    $.blockUI();
    sessionStorage.setItem("selectedTab", 2);
    window.location.href = "visit_detail.html";
}

function loadVisitTemplateDetailData() {
    sessionStorage.setItem("selectedTab", 0);
    commonVisitDetailData();
}

function commonStudySubjectGridData(){
    commonData();
    renderBreadcrumbs('study_staff_subject_form_screen');
    initial_load = true;
    resetUI();
    searchAppointmentWorkflow = false;
    loadAddStudySubjectData(currentPage);
}

function createAnnotationsTable(responseData) {
    var iteration = 0;

    var header_table =
        " <table id='overrideAnnotations' rules='cols' width='100%' border='0' cellspacing='0'>" +
        "  <thead> <tr>" +
        "   <th width='7%' style='padding: 5px; border: 1px solid #CCC;'>Select</th> " +
        "   <th width='34%' style='padding: 5px; border: 1px solid #CCC;'><strong>Resource Activity</strong></th> " +
        "   <th width='9%' style='padding: 5px; border: 1px solid #CCC;'><strong>Quantity</strong></th>" +
        "   <th width='50%' style='padding: 5px; border: 1px solid #CCC;'><strong>Comment</strong></th>" +
        "  </tr> </thead> <table>";

    $('#resourceAnnotationsHeaderData').html(header_table);

    var out = " <table id='overrideAnnotations' class='overrideTableClass'> <tbody>";

    $.each(responseData, function (key, val) {
        var annotationsId = val.id;
        var quantityCellId = 'q' + annotationsId;
        var commentCellId = 'c' + annotationsId;
        out += ((iteration % 2 == 1) ? "<tr class='altRow'>" : "<tr> ");
        var selected = " <input type='checkbox' class='form-checkbox' ";
        if (val.selected) {
            selected = " <input type='checkbox' class='form-checkbox' checked='checked' ";
        }

        var disableCell = "disabledCell";
        var defaultQuantity = val.quantity;

        if (defaultQuantity == 0) {
            defaultQuantity = 1;
        }

        if (val.quantifiable) {
            disableCell = "";
        }

        out +=
            "   <td width='7%' style='text-align:center;'> " +
            selected +
            " onclick='updateOverrideRow(" + annotationsId + "," + val.quantifiable + ")' " +
            "   id=" + annotationsId + " value=" + annotationsId + "/> " +
            "   </td>" +

            "   <td width='34%' align='left' valign='top' id='" + annotationsId + "'>" + val.name + "</td>" +

            "   <td width='9%' align='left' valign='top' id='" + quantityCellId + "' class='" + disableCell + "'" +
            "   onclick='return inlineOverrideEdit(this, event, 40, 3, " + annotationsId + "," + val.quantifiable + ");'>"
            + defaultQuantity +
            "   </td>" +

            "   <td width='50%' align='left' valign='top' id=" + commentCellId +
            "   onclick='return inlineOverrideEdit(this, event, 400, 255, " + annotationsId + "," + val.quantifiable + ");'>"
            + showValue(val.comment) +
            "   </td>" +

            " </tr>";
        iteration++;
    });

    out += "</tbody> </table>";

    $('#resourceAnnotationsData').html(out);
    responseData.length > 0 ? $('#resourceAnnotationsData').css({display: "inline-block"}) :  $('#resourceAnnotationsData').css({display: "none"});
    $('.annotationsTable').css({display: "inline-block"});
}

function filterAnnotations(obj) {
    $.blockUI();
    if (obj.value == "All") {
        $(".form-checkbox").closest("tr").show();
        $(".form-checkbox:checked").closest("tr").show();
    }
    else if (obj.value == "Yes") {
        $(".form-checkbox").closest("tr").hide();
        $(".form-checkbox:checked").closest("tr").show();
    }
    else if (obj.value == "No") {
        $(".form-checkbox").closest("tr").show();
        $(".form-checkbox:checked").closest("tr").hide();
    }
    $.unblockUI();
}

function updateOverrideRow(id, quantifiable) {
    var checkbox = document.getElementById(id);
    var quantityId = 'q' + id;
    var commentId = 'c' + id;

    if (checkbox.checked) {
        checkbox.checked = true;
        var commentValue = document.getElementById(commentId).innerHTML;
        updateOverrideVal('#' + commentId, commentValue, 400, 255, "text");
        if (quantifiable) {
            var quantityValue = document.getElementById(quantityId).innerHTML;
            updateOverrideVal('#' + quantityId, quantityValue, 40, 3, "number");
        }
        document.getElementById(commentId).innerHTML = "";
    }
    else {
        checkbox.checked = false;
        document.getElementById(quantityId).innerHTML = "1";
        document.getElementById(commentId).innerHTML = "";
    }
}

function inlineOverrideEdit(cell, event, columnSize, maxlength, id, quantifiable) {
    preventDefaultAction(event);
    validateInlineEditing(id);
    var value = $('#' + cell.id).html();
    var cellId = '#' + cell.id;
    var columnType = columnSize > 40 ? columnType = 'text' : columnType = 'number';
    if (columnType == 'number' && !quantifiable) {
        return false;
    }
    else {
        updateOverrideVal(cellId, value, columnSize, maxlength, columnType);
    }
}

function validateInlineEditing(id) {
    var checkbox = document.getElementById(id);
    if (!checkbox.checked) {
        checkbox.checked = true;
    }
}

function updateOverrideVal(currentEle, value, columnSize, maxlength, columnType) {
    getBrowserVersion();

    var validations = "";
    if (columnType == 'number') {
        validations = ' min="1" max="99999999999" ';
    }

    if (value.indexOf("<input") >= 0 || value.indexOf("<INPUT") >= 0) {
        return false;
    }
    var maxLength = "";
    if (majorVersion != "8") {
        maxLength = " maxlength='"+maxlength+"' ";
    }

    $(currentEle).html('<input class="inlineVal" style="width: ' + columnSize + 'px' +
        '" value="' + $.trim(value) + '" type="' + columnType + '"' + validations + '' + maxLength+'/>');

    $(".inlineVal").focus();
    $(".inlineVal").keyup(function (event) {
        if (event.keyCode == 13) {
            var inputValue = $(".inlineVal").val();
            if (columnType == 'number') {
                if (inputValue == "" || inputValue <= 0) {
                    $(currentEle).html("1");
                }
                else {
                    $(currentEle).html(parseInt(inputValue.replace(/^0+/, '')));
                }
            }
            else {
                $(currentEle).html(inputValue);
            }
        }
    });
    $(".inlineVal").focusout(function () {
        var inputValue = $(".inlineVal").val();
        if (columnType == 'number') {
            if (inputValue == "" || inputValue <= 0) {
                $(currentEle).html("1");
            }
            else {
                $(currentEle).html(parseInt(inputValue.replace(/^0+/, '')));
            }
        }
        else {
            $(currentEle).html(inputValue);
        }
    });
}
