/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var roles;
var institutions;
var credentials;
var departments;
var divisions;
var facultyRanks;

var roleSelectOptions;
var institutionSelectOptions;
var credentialSelectOptions;
var departmentSelectOptions;
var divisionSelectOptions;
var facultyRankSelectOptions;

debug("console debugging enabled.");

function getStaticLists() {
    $.get("rest/app/getStaticLists", {}, function(data) {

	parsedData = $.parseJSON(data);

	roles = parsedData.roles;
	credentials = parsedData.credentials;
	divisions = parsedData.divisions;
	departments = parsedData.departments;
	facultyRanks = parsedData.facultyRanks;
	institutions = parsedData.institutions;

	roleSelectOptions = buildSelectOptions(roles, 'name', 'choose');
	institutionSelectOptions = buildSelectOptions(institutions, 'longName', 'choose');
	credentialSelectOptions = buildSelectOptions(credentials, 'name', 'choose');
	departmentSelectOptions = buildSelectOptions(departments, 'name', 'choose');
	divisionSelectOptions = buildSelectOptions(divisions, 'name', 'choose');
	facultyRankSelectOptions = buildSelectOptions(facultyRanks, 'name', 'choose');
	
	$("#registration_role").html(roleSelectOptions);
	$("#registration_institution").html(institutionSelectOptions);
	$("#registration_credential").html(credentialSelectOptions);
	$("#registration_division").html(divisionSelectOptions);
	$("#registration_department").html(departmentSelectOptions);
	$("#registration_facultyRank").html(facultyRankSelectOptions);

    });
}

