/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var sublocationClosureToDelete;
var prevTotalPages = -1;
var resource_sublocations = [];
var resource_da_days = [];
var resource_ra_ids = [];
var resource_daToRemove;
var resource_taToRemove;
var resource_raToRemove;

var resource_formMode;
var resource_da_formMode;
var resource_ta_formMode;

function resource_showResourceDetail() {
    $('#resource_resourceDetailName').text(app_selectedResource.resource);
    $('#resource_resourceDetailType').text(app_selectedResource.resourceType);
    $('#resource_resourceDetailSublocations').text(app_selectedResource.sublocation);
}

function resource_handleResourceSelection(id) {
    $.getJSON("rest/resource/getResourceDetail?resourceId="+id, function(data) {
        sessionStorage.setItem("resourceData", JSON.stringify(data));
        sessionStorage.setItem("mode", JSON.stringify('view'));
        window.location.href="resource_detail.html#DefaultAvailability";
    });
}

function addAlternateDialog() {
    $("#add-alternate-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                jsonData = JSON.stringify({resourceId: app_selectedResource.resourceId, alternatives: resource_ra_ids});
                $.post("rest/resource/assignResourceAlternatives",{data:jsonData}, function(data) {
                    $('#resource_ra_responseLoading').css({visibility: "hidden"});
                    resource_ra_ids = [];
                    window.location.href = "resource_detail.html#ResourceAlternate";
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function deleteTempAjustmentDialog(id) {
    $("#delete-adjustment-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                resource_taToRemove = id;
                $.getJSON("rest/resource/deleteTemporaryAdjustment?id="+resource_taToRemove, function(data) {
                    if (data.result == true) {
                        $('#resource_deleteTempAdjLoading').css({visibility: "hidden"});
                        var confirmationMessage = 'Temporary Adjustment Deleted.';
                        util_showMainMessage(confirmationMessage);
                        currentPage = 1;
                        loadTemporaryAdjustmentsData(currentPage);
                    }
                    else {
                        var confirmationMessage = 'There was an error in deleting temporary adjustment.';
                        util_showMainMessage(confirmationMessage);
                        return;
                    }
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function deleteDefaultDialog(id) {
    $("#delete-default-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                resource_daToRemove = id;
                $.getJSON("rest/resource/deleteDefaultSchedule?id="+resource_daToRemove, function(data) {
                    if (data.result == true) {
                        $('#resource_deleteDefaultScheduleLoading').css({visibility: "hidden"});
                        var confirmationMessage = 'Default Availability Deleted.';
                        util_showMainMessage(confirmationMessage);
                        currentPage = 1;
                        loadDefaultResourcesData(currentPage);
                    }
                    else {
                        var confirmationMessage = 'There was an error in deleting default availability.';
                        util_showMainMessage(confirmationMessage);
                        return;
                    }
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function deleteAlternateDialog(id) {
    $("#delete-alternate-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                resource_raToRemove = id;
                $.getJSON("rest/resource/removeResourceAlternative?resourceId="+app_selectedResource.resourceId+"&alternateResourceId="+resource_raToRemove, function(data) {
                    if (data.result == true) {
                        $('#resource_removeAlternativeLoading').css({visibility: "hidden"});
                        var confirmationMessage = 'Alternate Resource Removed.';
                        util_showMainMessage(confirmationMessage);
                        currentPage = 1;
                        loadAlternateResourcesData(currentPage);
                    }
                    else {
                        var confirmationMessage = 'There was an error in removing the alternate resource.';
                        util_showMainMessage(confirmationMessage);
                        return;
                    }
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function deleteSublocationDialog(id) {
    $("#delete-sublocation-dialog-confirm").dialog({
        resizable: true,
        height:100,
        width: 600,
        modal: true,
        buttons: {
            "Yes": function() {
                sublocationClosureToDelete = id;
                jsonData = JSON.stringify({
                    sublocationClosureIntervalId: sublocationClosureToDelete,
                    userId: user.id
                });

                $.post("rest/resource/deleteSublocationClosureInterval",{data:jsonData}, function(data) {
                    $('#sublocationLoading').css({visibility: "hidden"});
                    var confirmationMessage = 'Sublocation Closure Deleted.';
                    util_showMainMessage(confirmationMessage);
                    currentPage = 1;
                    loadSublocationClosureData(currentPage);
                });
                $( this ).dialog( "close" );
            },
            "No": function() {
                $( this ).dialog( "close" );
                return;
            }
        }
    });
}

function resource_assignAlternatives() {
    addAlternateDialog();
}

function deleteTempAdjConfirmation(id) {
    deleteTempAjustmentDialog(id);
}

function deleteDefaultConfirmation(id) {
    deleteDefaultDialog(id);
}

function removeResourceAlternateConfirmation(id) {
    deleteAlternateDialog(id);
}

function deleteSublocationClosureIntervalConfirmation(id) {
    deleteSublocationDialog(id);
}

function editResourceSchedule(id) {
    var selectedDAPage = $('.input_page').val();
    sessionStorage.setItem("DASelectedPage", selectedDAPage);
    $.getJSON("rest/resource/getDefaultSchedule?id="+id, function(data) {
        sessionStorage.setItem("selectedResourceSchedule", JSON.stringify(data));
        sessionStorage.setItem("mode", JSON.stringify('edit'));
        window.location.href="default_availability.html";
    });
}

function editTempAdj(id) {
    var selectedTAPage = $('.input_page').val();
    sessionStorage.setItem("TASelectedPage", selectedTAPage);
    $.getJSON("rest/resource/getDefaultSchedule?id="+id, function(data) {
        sessionStorage.setItem("mode", JSON.stringify('edit'));
        sessionStorage.setItem("selectedTempAdj", JSON.stringify(data));
        window.location.href = "temporary_adjustment.html";
    });
}

//////////////////////Resource directory/////////////////////////////////////////////////////

var sortByResourceName = "r.name";
var sortByResourceType = "r.resourceType.name";
var sortByResourceSublocation = "rs.sublocation.name";
function loadResourcesData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if(max_results == undefined) {
        max_results = 100;
    }

    $.getJSON("rest/resource/getResourcesData?page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 100)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByResourceName), function(data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var resourceName_header1 = 'sortable';
        var resourceType_header2 = 'sortable';
        var resourceSublocation_header3 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByResourceName){
            resourceName_header1 = sort_header;
        } else if (sortBy == sortByResourceType){
            resourceType_header2 = sort_header;
        } else if (sortBy == sortByResourceSublocation){
            resourceSublocation_header3 = sort_header;
        }

        var out =
            " <table id='visitTemplates'>" +
            "  <tr>" +
            "   <td class= "+ resourceName_header1 + " onclick='sortingFunction(sortByResourceName)'><strong>Resource Name</strong></td> " +
            "   <td class= "+ resourceType_header2 + " onclick='sortingFunction(sortByResourceType)'><strong>Resource Type</strong></td>" +
            "   <td class= "+ resourceSublocation_header3 + " onclick='sortingFunction(sortByResourceSublocation)'><strong>Sub-location</strong></td>" +
            "   <td class='not_sortable'><strong></strong></td>" +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;

            out +=  "<tr>"
            out += "   <td>" + val.resource + "</td>" +
                "          <td>" + val.resourceType + "</td>" +
                "          <td>" + val.sublocation + "</td>" +
                " <td> <a href='javascript:resource_handleResourceSelection("+val.id+")'> View Detail </a> </td> "
            " </tr>";
            iteration++;
        });

        out += "  </table>";

        $('#resourcesData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");
        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}

///////////////////////////Default Availability/////////////////////////////////////////////////////////////////////

var sortByDayOfWeek = "da.dayOfWeek";
var sortByResourceStartTime = "da.startTime";
var sortByResourceEndTime = "da.endTime";
var sortByQuantity = "da.quantity";

function loadDefaultResourcesData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if (prevTotalPages != -1 && currentPage > prevTotalPages) {
        currentPage = 1;
    }

    if(max_results == undefined) {
        max_results = 25;
    }

    $.getJSON("rest/resource/getResourceSchedules?resourceId="+app_selectedResource.resourceId+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 25)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByDayOfWeek), function(data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var day_header1 = 'sortable';
        var start_header2 = 'sortable';
        var end_header3 = 'sortable';
        var quantity_header4 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByDayOfWeek){
            day_header1 = sort_header;
        } else if (sortBy == sortByResourceStartTime){
            start_header2 = sort_header;
        } else if (sortBy == sortByResourceEndTime){
            end_header3 = sort_header;
        } else if (sortBy == sortByQuantity){
            quantity_header4 = sort_header;
        }
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
            editColumns =
                "   <td class='not_sortable' width='15%'><strong></strong></td>" +
                "   <td class='not_sortable' width='15%'><strong></strong></td>";
        }
        var out =
            " <table id='defaultSchedule'>" +
            "  <tr>" +
            "   <td class= "+ day_header1 + " onclick='sortingFunction(sortByDayOfWeek)'><strong>Day Of Week</strong></td> " +
            "   <td class= "+ start_header2 + " onclick='sortingFunction(sortByResourceStartTime)'><strong>Start Time</strong></td>" +
            "   <td class= "+ end_header3 + " onclick='sortingFunction(sortByResourceEndTime)'><strong>End Time</strong></td>" +
            "   <td class= "+ quantity_header4 + " onclick='sortingFunction(sortByQuantity)'><strong>Quantity</strong></td>" +
            editColumns +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;
            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
                editColumns =
                    " <td class='editColumn'> <a href='javascript:editResourceSchedule("+val.id+")'> Edit </a> </td> " +
                    " <td class='editColumn'> <a href='javascript:deleteDefaultConfirmation("+val.id+")'> Delete </a> </td> " ;
            }

            out +=  "<tr>"
            out += " 	   <td>" + util_day(val.dayOfWeek) + "</td>" +
                "          <td>" + showStandardTime(val.startTime) + "</td>" +
                "          <td>" + showStandardTime(val.endTime) + "</td>" +
                "          <td>" + val.quantity + "</td>" +
                editColumns +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#defaultResourcesData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);
        if (data.length == 0) {
            remainder = 0;
            totalPages = 1;
        }
        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        if (currentPage > totalPages) {
            currentPage = totalPages;
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
        prevTotalPages = totalPages;
    });
}


///////////////////////////Alternate Resources/////////////////////////////////////////////////////////////////////

var sortByAltResourceName = "ra.alternateResource.name";
var sortByAltSublocation = "rs.sublocation.name";

function loadAlternateResourcesData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if (prevTotalPages != -1 && currentPage > prevTotalPages) {
        currentPage = 1;
    }

    if(max_results == undefined) {
        max_results = 5;
    }

    $.getJSON("rest/resource/getResourceAlternates?resourceId="+app_selectedResource.resourceId+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 5)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByAltResourceName), function(data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var altResource_header1 = 'sortable';
        var altSublocation_header2 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByAltResourceName){
            altResource_header1 = sort_header;
        } else if (sortBy == sortByAltSublocation){
            altSublocation_header2 = sort_header;
        }
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
            editColumns =
                "   <td class='not_sortable'><strong>Action</strong></td>"  ;
        }
        var out =
            " <table id='alternateResource'>" +
            " <tr>" +
            "   <td class= "+ altResource_header1 + " onclick='sortingFunction(sortByAltResourceName)'><strong>Resource Name</strong></td> " +
            "   <td class= "+ altSublocation_header2 + " onclick='sortingFunction(sortByAltSublocation)'><strong>Sub-location</strong></td>" +
            editColumns +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;

            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
                editColumns =
                    " <td class='editColumn'> <a href='javascript:removeResourceAlternateConfirmation("+val.id+")'> Remove </a> </td> " ;
            }

            out +=  "<tr>"
            out +=
                " 	   <td align='left' valign='top'>" + val.resource + "</td>" +
                "          <td align='left' valign='top'>" + val.sublocation + "</td>" +
                editColumns +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#alternateResourcesData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);
        if (data.length == 0) {
            remainder = 0;
            totalPages = 1;
        }
        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        if (currentPage > totalPages) {
            currentPage = totalPages;
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }

        prevTotalPages = totalPages;
    });
}

var sortByAlternateResourceName = "r.name";
var sortByAlternateResourceType = "r.resourceType.name";
var sortByAlternateResourceSublocation = "rs.sublocation.name";

function loadAddAlternateResourcesData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if (prevTotalPages != -1 && currentPage > prevTotalPages) {
        currentPage = 1;
    }

    if(max_results == undefined) {
        max_results = 100;
    }

    $.getJSON("rest/resource/getAlternateResources?resourceId="+app_selectedResource.resourceId+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 100)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByAlternateResourceName), function(data) {
        var iteration = 0;
        var sort_header;
        var alternateResource_header1 = 'sortable';
        var alternateResourceType_header2 = 'sortable';
        var alternateSublocationName_header3 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByAlternateResourceName){
            alternateResource_header1 = sort_header;
        } else if (sortBy == sortByAlternateResourceType){
            alternateResourceType_header2 = sort_header;
        } else if (sortBy == sortByAlternateResourceSublocation){
            alternateSublocationName_header3 = sort_header;
        }

        var out =
            " <table id='addAlternateResources'>" +
            "  <tr>" +
            "   <td class='not_sortable'><input type='checkbox' id='selectall' onclick='toggleAll(this)'/></td>" +
            "   <td class= "+ alternateResource_header1 + " onclick='sortingFunction(sortByAlternateResourceName)'><strong>Resource Name</strong></td> " +
            "   <td class= "+ alternateResourceType_header2 + " onclick='sortingFunction(sortByAlternateResourceType)'><strong>Resource Type</strong></td>" +
            "   <td class= "+ alternateSublocationName_header3 + " onclick='sortingFunction(sortByAlternateResourceSublocation)'><strong>Sub-location</strong></td>" +
            "  </tr> ";

        $.each(data, function(key, val) {
            totalData = val.totalCount;

            out += "<tr>"
            out += "   <td><input type='checkbox' value="+val.id +" class='case' name='case' onclick='getSelectedAlternateResources();' /></td>" +
                " 	       <td>" + val.resource + "</td>" +
                "          <td>" + val.resourceType + "</td>" +
                "          <td>" + val.sublocation + "</td>" +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#addAlternateResourcesData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);
        if (data.length == 0) {
            remainder = 0;
            totalPages = 1;
        }
        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        if (currentPage > totalPages) {
            currentPage = totalPages;
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }

        prevTotalPages = totalPages;
    });
}


function toggleAll(source) {
    if (source.checked == false) {
        $('#saveAlternateResources').css({display: "none"});
    } else {
        $('#saveAlternateResources').css({display: "inline-block"});
    }
    var checkboxes = document.getElementsByName('case');
    for(var i=0, n=checkboxes.length;i<n;i++) {
        checkboxes[i].checked = source.checked;
    }
}

function getSelectedAlternateResources() {
    resource_ra_ids = new Array();
    $(".case:checked").each(function() {
        resource_ra_ids.push($(this).val());
    });
    if (resource_ra_ids.length == 0) {
        $('#saveAlternateResources').css({display: "none"});
    }
    else {
        $('#saveAlternateResources').css({display: "inline-block"});
    }
    return resource_ra_ids;
}

///////////////////////////Temporary Adjustment/////////////////////////////////////////////////////////////////////

var sortByTAStartTime = "da.startTime";
var sortByTAEndTime = "da.endTime";
var sortByTAQuantity = "da.quantity";

function loadTemporaryAdjustmentsData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }

    if (prevTotalPages != -1 && currentPage > prevTotalPages) {
        currentPage = 1;
    }

    if(max_results == undefined) {
        max_results = 5;
    }

    $.getJSON("rest/resource/getTemporaryAdjustments?resourceId="+app_selectedResource.resourceId+"&page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 5)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortByTAStartTime), function(data) {
        var iteration = 0;
        var editColumns = " ";

        var sort_header;
        var start_header1 = 'sortable';
        var end_header2 = 'sortable';
        var quantity_header3 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortByTAStartTime){
            start_header1 = sort_header;
        } else if (sortBy == sortByTAEndTime){
            end_header2 = sort_header;
        } else if (sortBy == sortByTAQuantity){
            quantity_header3 = sort_header;
        }
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
            editColumns =
                "   <td class='not_sortable' width='20%'><strong></strong></td>" +
                "   <td class='not_sortable' width='20%'><strong></strong></td>";
        }
        var out =
            " <table id='temporarySchedule'>" +
            "   <tr>" +
            "   <td class= "+ start_header1 + " onclick='sortingFunction(sortByTAStartTime)'><strong>Start Date</strong></td>" +
            "   <td class= "+ end_header2 + " onclick='sortingFunction(sortByTAEndTime)'><strong>End Date</strong></td>" +
            "   <td class= "+ quantity_header3 + " onclick='sortingFunction(sortByTAQuantity)'><strong>Quantity</strong></td>" +
            editColumns +
            "  </tr>";

        $.each(data, function(key, val) {
            totalData = val.totalCount;
            if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
                editColumns =
                    " <td> <a href='javascript:editTempAdj("+val.id+")'> Edit </a> </td> " +
                    " <td> <a href='javascript:deleteTempAdjConfirmation("+val.id+")'> Delete </a> </td> " ;
            }

            out +=  "<tr>"
            out += "       <td>" + val.startTime + "</td>" +
                "          <td>" + val.endTime + "</td>" +
                "          <td>" + val.quantity + "</td>" +
                editColumns +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#temporaryAdjustmentData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);
        if (data.length == 0) {
            remainder = 0;
            totalPages = 1;
        }

        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        if (currentPage > totalPages) {
            currentPage = totalPages;
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }

        prevTotalPages = totalPages;
    });
}


///////////////////////////Sublocation Closure/////////////////////////////////////////////////////////////////////

var sortBySublocationClosure = "sci.sublocation.name";
var sortBySublocationStartTime = "sci.startTime";
var sortBySublocationEndTime = "sci.endTime";
var sortBySublocationReason = "sci.reason";

function loadSublocationClosureData(currentPage) {
    if (initial_load == true) {
        createPageDropDownList();
        initial_load = false;
    }
    if(max_results == undefined) {
        max_results = 5;
    }

    $.getJSON("rest/resource/getSublocationClosureIntervals?page="+(currentPage != undefined ? currentPage : 1)+"&maxResults="+(max_results != undefined ? max_results : 5)+"&orderBy="+(orderBy != undefined ? orderBy : "ASC")+"&sortBy="+(sortBy != undefined ? sortBy : sortBySublocationClosure), function(data) {
        var iteration = 0;

        var sort_header;
        var name_header1 = 'sortable';
        var start_header2 = 'sortable';
        var end_header3 = 'sortable';
        var reason_header4 = 'sortable';

        if (orderBy == 'ASC') {
            sort_header='sorting_asc';
        }
        else if (orderBy == 'DESC') {
            sort_header='sorting_desc';
        }

        if (sortBy == undefined || sortBy == sortBySublocationClosure){
            name_header1 = sort_header;
        } else if (sortBy == sortBySublocationStartTime){
            start_header2 = sort_header;
        } else if (sortBy == sortBySublocationEndTime){
            end_header3 = sort_header;
        } else if (sortBy == sortBySublocationReason){
            reason_header4 = sort_header;
        }

        var out =
            " <table id='sublocationClosure'>" +
            " <tr>" +
            "   <td class= "+ name_header1 + " onclick='sortingFunction(sortBySublocationClosure)'><strong>Sub-location</strong></td>" +
            "   <td class= "+ start_header2 + " onclick='sortingFunction(sortBySublocationStartTime)'><strong>Start Date</strong></td>" +
            "   <td class= "+ end_header3 + " onclick='sortingFunction(sortBySublocationEndTime)'><strong>End Date</strong></td>" +
            "   <td class= "+ reason_header4 + " onclick='sortingFunction(sortBySublocationReason)'><strong>Reason</strong></td>" +
            "   <td class='not_sortable'><strong></strong></td>" +
            "  </tr>";

        $.each(data, function(key, val) {
            totalData = val.totalCount;

            out +=  "<tr>"
            out += "       <td>" + val.sublocation + "</td>" +
                "          <td>" + showStandardDateTime(val.startDate) + "</td>" +
                "          <td>" + showStandardDateTime(val.endDate) + "</td>" +
                "          <td>" + val.reason + "</td>" +
                " 	   <td> <a href='javascript:deleteSublocationClosureIntervalConfirmation("+val.id+")'> Delete </a> </td> " +
                " </tr>";
            iteration++;
        });

        out += " </table>";

        $('#sublocationClosureData').html(out);
        $("#selectRecords > [value='"+max_results+"']").attr("selected", "true");

        var remainder = totalData % max_results;

        totalPages = Math.floor(totalData/max_results);
        if (data.length == 0) {
            remainder = 0;
            totalPages = 1;
        }
        if (remainder > 0 ){
            totalPages = totalPages + 1;
        }

        var page_limit = totalData;

        if (totalData > max_results) {
            page_limit =  (currentPage * max_results);
        }

        createPaginationLinks(currentPage, totalPages);

        if (page_limit > totalData) {
            page_limit = totalData;
        }
    });
}
