/*
 * Copyright (c) 2015-2016, President and Fellows of Harvard College
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

var VisitTables = {};

VisitTables.dbColumnVisitName = "v.name";
VisitTables.dbColumnVisitType = "v.visitType";
VisitTables.dbColumnSublocation = "v.sublocation.name";
VisitTables.dbColumnApproved = "v.approved";

VisitTables.uiColumnVisitName = "Name";
VisitTables.uiColumnVisitType = "Visit Type";
VisitTables.uiColumnSublocation = "Sub-location";
VisitTables.uiColumnApproved = "Final Status";

VisitTables.activeVisitTemplates = "activeVisitTemplates";
VisitTables.inactiveVisitTemplates = "inactiveVisitTemplates";

VisitTables.activeOrInactiveTableElementId = {
    true : VisitTables.activeVisitTemplates,
    false : VisitTables.inactiveVisitTemplates
};

VisitTables.activeOrInactivePaginationId = {
    true : VisitTables.activeVisitTemplates + PaginationHelper.suffix,
    false : VisitTables.inactiveVisitTemplates + PaginationHelper.suffix
};
VisitTables.isActiveView;
VisitTables.defaultActive = true;

VisitTables.pushSortableColumns = function(columns) {
    columns.push(new Column({
        dbColumn: VisitTables.dbColumnVisitName,
        columnName: VisitTables.uiColumnVisitName,
        columnType: Column.Text,
        width:22,
        defaultSortOrder: Column.ASC,
        extractDataFunction: function (val) {return val.visitName;},
        defaultAscOrDesc: Column.ASC,
        filter: {
            name: VisitTables.dbColumnVisitName,
            onFilter: VisitTables.populateVisitTemplatesTable
        }
    }));

    columns.push(new Column({
        dbColumn: VisitTables.dbColumnVisitType,
        columnName: VisitTables.uiColumnVisitType,
        width:15,
        extractDataFunction: function (val) {return val.visitTypeName;},
        filter: {
            name: VisitTables.dbColumnVisitType,
            onFilter: VisitTables.populateVisitTemplatesTable
        }
    }));

    columns.push(new Column({
        dbColumn: VisitTables.dbColumnSublocation,
        columnName: VisitTables.uiColumnSublocation,
        width:20,
        extractDataFunction: function (val) {return val.sublocationName;},
        filter: {
            name: VisitTables.dbColumnSublocation,
            onFilter: VisitTables.populateVisitTemplatesTable
        }
    }));

    columns.push(new Column({
        dbColumn: VisitTables.dbColumnApproved,
        columnName: VisitTables.uiColumnApproved,
        width:13,
        extractDataFunction: function (val) {return val.finalApprovalStatus;}
    }));
};

VisitTables.pushEditColumns = function(user, columns) {
    var viewLinkColumn = new Column({
        columnType: Column.Hyperlink,
        rowElementClass: 'editColumn',
        width:9,
        rowElementHyperLink: function (val) {
            return 'showVisitDetail(' + val.id + ')';
        },
        extractDataFunction: function () {
            return " View Detail ";
        }
    });
    var copyLinkColumn = new Column({
        columnType: Column.Hyperlink,
        rowElementClass: 'editColumn',
        width:8,
        rowElementHyperLink: function (val) {
            return 'copyVisitTemplate(' + val.id + ')';
        },
        extractDataFunction: function () {
            return " Copy Visit ";
        }
    });
    var deleteLinkColumn = new Column({
        columnType: Column.Hyperlink,
        rowElementClass: 'editColumn',
        width:9,
        rowElementHyperLink: function (val) {
            return 'deleteVisitTemplate(' + val.id + ')';
        },
        extractDataFunction: function () {
            return " Delete Visit ";
        }
    });

    if (UserRoleUtil.isGeneralFrontOrStaff(user)) {
        columns.push(viewLinkColumn);
    }
    else if (UserRoleUtil.isAdminUser(user)) {
        columns.push(viewLinkColumn, copyLinkColumn, deleteLinkColumn);
    } else {
        columns.push(viewLinkColumn, copyLinkColumn);
    }
};
VisitTables.pushCheckboxColumn = function(columns) {
    columns.push(new Column({
        columnType: Column.Checkbox,
        onChange: VisitTables.toggleActivationButton,
        width: 5,
        extractDataFunction: function (val) {return val.id;},
    }));
}
VisitTables.toggleActivationButton = function(source) {
    var selectedRows = VisitTables.currentTable.getSelectedRows();
    var hide = selectedRows.length === 0;

    if (hide) {
        $('.DeactivateliveLink').css({display: "none"});
        $('.ActivateliveLink').css({display: "none"});
    } else {
        if (user.institutionRole.id == SUPER_ADMIN || user.institutionRole.id == RESOURCE_MANAGER) {
            $('.DeactivateliveLink').css({display: "inline-block"});
            $('.ActivateliveLink').css({display: "inline-block"});
        }
        else {
            $('.DeactivateliveLink').css({display: "none"});
            $('.ActivateliveLink').css({display: "none"});
        }
    }
};

function loadVisitTemplatesDataIntoTablesWidget(activeView) {
    $('#study_localId1').html('(' + app_selectedStudy.localId + ')');
    $('#study_name1').html(app_selectedStudy.name);

    $('.DeactivateliveLink').css({display: "none"});
    $('.ActivateliveLink').css({display: "none"});
    if (UserRoleUtil.isStaff(user)) {
        $('#study_newStudyVisitButton').css({display: "none"});
    }

    VisitTables.isActiveView = activeView;

    var columns = [];
    VisitTables.pushCheckboxColumn(columns);
    VisitTables.pushSortableColumns(columns);
    VisitTables.pushEditColumns(user, columns);

    VisitTables.currentTable = new SchedulerTables({
        tableId: VisitTables.activeOrInactiveTableElementId[activeView],
        columns: columns,
        reloadFn: VisitTables.populateVisitTemplatesTable,
        doubleClickRowIdCallback: showVisitDetail
    });

    VisitTables.currentTable.generateTable(
        [],
        PaginationHelper.defaultPerPage,
        VisitTables.activeOrInactivePaginationId[activeView],
        VisitTables.populateVisitTemplatesTable);

    VisitTables.populateVisitTemplatesTable();
}

VisitTables.populateVisitTemplatesTable = function() {

    var whichTable = VisitTables.currentTable;
    var activeView = VisitTables.isActiveView;

    var keyValuePairs = { searchItems : whichTable.getAllFilterKeyValuePairs() };
    var stringifiedPairs = JSON.stringify(keyValuePairs);

    var restUrl = "rest/appointment/getVisitsByStudy?study=" + app_selectedStudy.id +
        "&active=" +        activeView +
        "&page=" +          whichTable.getCurrentPage() +
        "&maxResults=" +    whichTable.getRecordsPerPage() +
        "&orderBy=" +       (whichTable.getSortOrder() || Column.ASC) +
        "&sortBy=" +        (whichTable.getSortColumn() || VisitTables.dbColumnVisitName) +
        "&search=" +        encodeURIComponent(stringifiedPairs);

    $.getJSON(restUrl, function(data) {
        whichTable.refreshTableBody(data);
    });
};

var StudiesTable = {};
StudiesTable.id = "studiesTable";
StudiesTable.dbColumnStudyName = "s.name";
StudiesTable.dbColumnPILastName = "pi.last_name";
StudiesTable.dbColumnIRBNumber = "s.irb";
StudiesTable.dbColumnLocalIdName = "s.local_id";
StudiesTable.dbColumnStudyStatus = "ss.short_name";
StudiesTable.defaultPerPage = 50;
StudiesTable.paginationId = StudiesTable.id + PaginationHelper.suffix;

StudiesTable.createStudiesTable = function()
{
    var columns = [];

    StudiesTable.pushSortableColumns(columns);
    StudiesTable.pushEditColumns(columns);

    var args = {
        tableId: StudiesTable.id,
        columns: columns,
        reloadFn: function() { StudiesTable.populateStudiesTable(); }
    };

    StudiesTable.currentTable = new SchedulerTables(args);

    StudiesTable.currentTable.generateTable(
        [],
        StudiesTable.defaultPerPage,
        StudiesTable.paginationId,
        function() { StudiesTable.populateStudiesTable.call(this); });
};

StudiesTable.pushSortableColumns = function(columns)
{
    columns.push(new Column({
        dbColumn: StudiesTable.dbColumnStudyName,
        columnName: "Name",
        width: 28,
        extractDataFunction: function (val) {
            return val.name;
        },
        defaultSortOrder: Column.ASC,
        filter: {
            name: StudiesTable.dbColumnStudyName,
            onFilter: function (value) {
                StudiesTable.populateStudiesTable(1);
            }
        }
    }));

    columns.push(new Column({
        dbColumn: StudiesTable.dbColumnPILastName,
        columnName: "PI Name",
        width: 19,
        extractDataFunction: function (val) {
            return buildPIName(val.investigator.firstName, val.investigator.lastName);
        },
        filter: {
            name: StudiesTable.dbColumnPILastName,
            onFilter: function (value) {
                StudiesTable.populateStudiesTable(1);
            }
        }
    }));

    columns.push(new Column({
        dbColumn: StudiesTable.dbColumnIRBNumber,
        columnName: "IRB Number",
        width: 16,
        extractDataFunction: function (val) {
            return val.irbNumber;
        },
        filter: {
            name: StudiesTable.dbColumnIRBNumber,
            onFilter: function (value) {
                StudiesTable.populateStudiesTable(1);
            }
        }
    }));

    columns.push(new Column({
        dbColumn: StudiesTable.dbColumnLocalIdName,
        columnName: "Local ID",
        width: 16,
        extractDataFunction: function (val) {
            return val.localId;
        },
        filter: {
            name: StudiesTable.dbColumnLocalIdName,
            onFilter: function (value) {
                StudiesTable.populateStudiesTable(1);
            }
        }
    }));

    columns.push(new Column({
        dbColumn: StudiesTable.dbColumnStudyStatus,
        columnName: "Study Status",
        width: 11,
        extractDataFunction: function (val) {
            return val.studyStatus;
        }
    }));
};

StudiesTable.pushEditColumns = function(columns) {
    if (!UserRoleUtil.isGeneralView(user)) {
        var viewLinkColumn = new Column({
            columnType: Column.Hyperlink,
            width: 10,
            rowElementHyperLink: function (val) {
                return 'showStudyDetail(' + val.id + ')';
            },
            extractDataFunction: function () {
                return " View Detail ";
            }
        });

        columns.push(viewLinkColumn);
    }
};

StudiesTable.populateStudiesTable = function(currentPage)
{
    var filterString = $.trim($("#filters_string").val());
    var searchItemsList = { searchItems : StudiesTable.currentTable.getAllFilterKeyValuePairs() };

    var searchQuery = JSON.stringify(searchItemsList);
    $.getJSON("rest/study/getStudyList?filterString=" + filterString +
        "&page=" + (currentPage || StudiesTable.currentTable.getCurrentPage()) +
        "&maxResults=" + StudiesTable.currentTable.getRecordsPerPage() +
        "&orderBy=" + (StudiesTable.currentTable.getSortOrder() || Column.ASC) +
        "&sortBy=" + (StudiesTable.currentTable.getSortColumn() || StudiesTable.dbColumnStudyName) +
        "&search=" + encodeURIComponent(searchQuery),function (data) {
        StudiesTable.currentTable.refreshTableBody(data);
    });
};

//The below 'commented' sourceURL specifies a name for this piece of code which
//  will appear if debugging in the browser
//This is needed because this file is loaded programatically
//# sourceURL=study_tables.js
