/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.dao.CourseBuildingDAO;
import edu.harvard.med.countway.dl.dao.CourseTypeDAO;
import edu.harvard.med.countway.dl.model.SelectClassListParams;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.IntegerUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ClassesServlet
extends AbstractServlet {
    private static final long serialVersionUID = 945717297527766341L;
    private static final Logger log = Logger.getLogger(ClassesServlet.class);
    private static final String countwayInstitutionIdString = CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.COUNTWAY_INSTITUTION_ID);
    private static final String jspUrl = "classes.jspx";
    private static final String errorUrl = "../../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Integer countwayInstitutionId = Integer.parseInt(countwayInstitutionIdString);
            ClassesServlet.setDummySessionAttributes(request);
            ClassDAO classDao = new ClassDAO();
            CourseTypeDAO courseTypeDao = new CourseTypeDAO();
            CourseBuildingDAO courseBuildingDao = new CourseBuildingDAO();
            String institutionId = request.getParameter("institutionId");
            String[] typeId = request.getParameterValues("typeId");
            String[] buildingId = request.getParameterValues("buildingId");
            String query = request.getParameter("query");
            String search = request.getParameter("search");
            request.setAttribute("countwayInstitutionId", (Object)countwayInstitutionId);
            request.setAttribute("courseTypeList", (Object)courseTypeDao.selectCourseTypeList());
            request.setAttribute("courseBuildingList", (Object)courseBuildingDao.selectCourseBuildingList());
            SelectClassListParams select = new SelectClassListParams();
            if (search != null) {
                if (institutionId != null && IntegerUtil.isValidInteger((String)institutionId) && Integer.parseInt(institutionId) == countwayInstitutionId) {
                    select.setInstitutionId(new Integer[]{countwayInstitutionId});
                }
                if (typeId != null && typeId.length != 0) {
                    ArrayList<Integer> newTypeId = new ArrayList<Integer>();
                    for (String tid : typeId) {
                        if (tid != null && tid.equals("0")) {
                            newTypeId.clear();
                            break;
                        }
                        if (tid == null || !IntegerUtil.isValidInteger((String)tid) || !courseTypeDao.courseTypeExists(Integer.valueOf(Integer.parseInt(tid))).booleanValue()) continue;
                        newTypeId.add(Integer.parseInt(tid));
                    }
                    select.setTypeId(newTypeId);
                }
                if (buildingId != null && buildingId.length != 0) {
                    ArrayList<Integer> newBuildingId = new ArrayList<Integer>();
                    for (String bid : buildingId) {
                        if (bid != null && bid.equals("0")) {
                            newBuildingId.clear();
                            break;
                        }
                        if (bid == null || !IntegerUtil.isValidInteger((String)bid) || !courseBuildingDao.courseBuildingExists(Integer.valueOf(Integer.parseInt(bid))).booleanValue()) continue;
                        newBuildingId.add(Integer.parseInt(bid));
                    }
                    select.setBuildingId(newBuildingId);
                }
                if (query != null && !query.trim().equals("")) {
                    select.setQuery(query);
                }
            }
            select.setActive(Boolean.valueOf(true));
            select.setFuture(Boolean.valueOf(true));
            select.setNow(new Date());
            select.setSort(SelectClassListParams.Sort.Title);
            request.setAttribute("classList", (Object)classDao.selectClassList(select));
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

