/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.auth.ldap.HarvardLdapAuthorizer;
import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.LoginType;
import edu.harvard.med.countway.dl.dao.EcommonsUserDAO;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.MailUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class HuidauthzrequestServlet
extends AbstractServlet {
    private static final long serialVersionUID = 276398509918120902L;
    private static final Logger log = Logger.getLogger(HuidauthzrequestServlet.class);
    private static final String loginUrl = "login.html?url=huidauthzrequest.html";
    private static final String jspUrl = "huidauthzrequest.jspx";
    private static final String errorUrl = "error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            HarvardLdapAuthorizer authz;
            String associatedHuid;
            HuidauthzrequestServlet.setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            EcommonsUserDAO ecuserDao = new EcommonsUserDAO();
            String uid = (String)session.getAttribute("uid");
            LoginType loginType = (LoginType)session.getAttribute("loginType");
            String email = (String)session.getAttribute("email");
            String huid = request.getParameter("huid");
            String submit = request.getParameter("submit");
            ArrayList<String> messages = new ArrayList<String>();
            if (uid == null || uid.trim().equals("")) {
                response.sendRedirect(loginUrl);
                return;
            }
            if (!loginType.equals((Object)LoginType.ecid)) {
                messages.add("This request mechanism does not apply to you since you are not logged in with an eCommons ID");
                request.setAttribute("messages", messages);
                request.setAttribute("printform", (Object)false);
                request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (email == null || email.trim().equals("")) {
                messages.add("This request can't be completed because an e-mail address was not associated with your login session");
                request.setAttribute("messages", messages);
                request.setAttribute("printform", (Object)false);
                request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (!CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DUMMY_SESSION).equals("true") && (associatedHuid = ecuserDao.getHuidFromEcid(uid)) != null && (authz = new HarvardLdapAuthorizer(associatedHuid)).isAuthorized().booleanValue()) {
                messages.add("The HUID (" + associatedHuid + ") associated with the eCommons ID (" + uid + ") you used to login is already authorized for access to licensed electronic library resources.  As such you should already have access to licensed resources.  If you don't seem to have access, please <a href=\"logout.html\">logout</a> and then <a href=\"login.html\">login</a> with this HUID to access licensed resources.");
                request.setAttribute("messages", messages);
                request.setAttribute("printform", (Object)false);
                request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (submit != null) {
                String associatedEcid;
                if (huid == null || huid.trim().equals("")) {
                    messages.add("A valid HUID is required to proceed");
                    request.setAttribute("messages", messages);
                    request.setAttribute("printform", (Object)true);
                    request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (!CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DUMMY_SESSION).equals("true") && (associatedEcid = ecuserDao.getEcidFromHuid(huid)) != null) {
                    messages.add("The HUID you entered is already associated with another eCommons ID");
                    request.setAttribute("messages", messages);
                    request.setAttribute("printform", (Object)true);
                    request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                HarvardLdapAuthorizer authz2 = new HarvardLdapAuthorizer(huid);
                if (!authz2.isAuthorized().booleanValue()) {
                    messages.add("The HUID you entered is either invalid or not authorized for access to licensed electronic library resources");
                    request.setAttribute("messages", messages);
                    request.setAttribute("printform", (Object)true);
                    request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                HarvardLdapAuthorizer.UserClass userClass = authz2.getUserClass();
                HashMap ecAttrs = ecuserDao.selectHuidAuthzAttributes(uid);
                HashMap huAttrs = authz2.getAttributes();
                StringBuffer body = new StringBuffer();
                body.append("A Countway user with eCommons ID:\n\n");
                body.append("  " + uid + "\n\n");
                body.append("has requested that the following DL-authorized Harvard ID be associated with their eCommons account:\n\n");
                body.append("  " + huid + "\n\n");
                body.append("This Harvard ID has the following HUL/OIS eligible user class:\n\n");
                body.append("  " + userClass + "\n\n");
                body.append("ECOMMONS ATTRIBUTES\n\n");
                HuidauthzrequestServlet.appendEcommonsAttribute("addr_num", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("ldap_username", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("harvard_id", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("full_name", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("institution", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("prime_dept_desc50", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("academic_title", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("administrative_title", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("line1", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("line2", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("line3", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("city", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("state", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("telephone", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("email", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("data_source", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("data_source_detail", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("is_active", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("created_dt", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("updated_dt", body, ecAttrs);
                HuidauthzrequestServlet.appendEcommonsAttribute("inactivated_dt", body, ecAttrs);
                body.append("\n");
                body.append("HU-LDAP ATTRIBUTES\n\n");
                HuidauthzrequestServlet.appendHarvardLdapAttribute("harvardeduidnumber", body, huAttrs);
                HuidauthzrequestServlet.appendHarvardLdapAttribute("cn", body, huAttrs);
                HuidauthzrequestServlet.appendHarvardLdapAttribute("title", body, huAttrs);
                HuidauthzrequestServlet.appendHarvardLdapAttribute("edupersonaffiliation", body, huAttrs);
                HuidauthzrequestServlet.appendHarvardLdapAttribute("harvardedudepartmentaffiliation", body, huAttrs);
                HuidauthzrequestServlet.appendHarvardLdapAttribute("postalAddress", body, huAttrs);
                HuidauthzrequestServlet.appendHarvardLdapAttribute("mail", body, huAttrs);
                String to = !CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DEPLOY_TIER).equals("prod") && !CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DEPLOY_TIER).equals("stage") ? CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL) : CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.HUID_AUTHZ_REQUEST_EMAIL);
                MailUtil.sendMail((String)email, (String)to, (String)("Countway request for association of Harvard ID [" + huid + "] with eCommons ID [" + uid + "]"), (String)body.toString(), (String)CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL));
                messages.add("Your request has been successfully submitted to the HMS IT help desk.  Someone will follow up with you shortly.");
                request.setAttribute("messages", messages);
                request.setAttribute("printform", (Object)false);
            } else {
                request.setAttribute("printform", (Object)true);
            }
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (NamingException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static void appendEcommonsAttribute(String attr, StringBuffer buffer, HashMap<String, Object> ecAttrs) {
        String value;
        if (ecAttrs.containsKey(attr) && (value = ecAttrs.get(attr).toString()) != null && !value.trim().equals("")) {
            buffer.append(attr + ": " + value + "\n");
        }
    }

    private static void appendHarvardLdapAttribute(String attr, StringBuffer buffer, HashMap<String, ArrayList<String>> huAttrs) {
        if (huAttrs.containsKey(attr)) {
            ArrayList<String> values = huAttrs.get(attr);
            if (values.size() == 1) {
                buffer.append(attr + ": " + values.get(0) + "\n");
            } else if (values.size() > 1) {
                buffer.append(attr + ":\n");
                for (String value : values) {
                    buffer.append("  " + value + "\n");
                }
            }
        }
    }
}

