/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.dl.dao.ClassUserDAO;
import edu.harvard.med.countway.dl.model.ClassUser;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.IntegerUtil;
import edu.harvard.med.countway.tools.MailUtil;
import edu.harvard.med.countway.tools.TemplateUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class RegistrationsServlet
extends AbstractServlet {
    private static final long serialVersionUID = -5207319248653362642L;
    private static final Logger log = Logger.getLogger(RegistrationsServlet.class);
    private static final String loginUrl = "../../../login.html?url=menuNavigation/libraryServices/classes/registrations.html";
    private static final String jspUrl = "registrations.jspx";
    private static final String errorUrl = "../../../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            RegistrationsServlet.setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            ClassUserDAO classUserDao = new ClassUserDAO();
            String uid = (String)session.getAttribute("uid");
            Integer dluid = (Integer)session.getAttribute("dluid");
            String delete = request.getParameter("delete");
            String[] classUserId = request.getParameterValues("classUserId");
            ArrayList<String> messages = new ArrayList<String>();
            if (uid == null || uid.trim().equals("")) {
                response.sendRedirect(loginUrl);
                return;
            }
            if (delete != null && classUserId != null && classUserId.length > 0) {
                for (String cuid : classUserId) {
                    ClassUser classUser;
                    if (cuid.trim().equals("") || !IntegerUtil.isValidInteger((String)cuid) || !classUserDao.classUserExists(Integer.valueOf(Integer.parseInt(cuid))).booleanValue() || !classUserDao.classUserExists((classUser = classUserDao.selectClassUser(Integer.valueOf(Integer.parseInt(cuid)))).getClazz().getId(), dluid).booleanValue()) continue;
                    if (classUserDao.deleteClassUser(Integer.valueOf(Integer.parseInt(cuid))) != null) {
                        String msg = TemplateUtil.getClassRegisterMsg((String)"de-registered", (String)classUser.getClazz().getCourse().getTitle(), (Date)classUser.getClazz().getTime(), (String)classUser.getClazz().getLocation().getConcat());
                        messages.add(msg);
                        try {
                            String to = !CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DEPLOY_TIER).equals("prod") && !CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.DEPLOY_TIER).equals("stage") ? CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL) : classUser.getEmail();
                            String emailmsg = TemplateUtil.getClassRegisterEmail((String)"de-registered", (String)classUser.getClazz().getCourse().getTitle(), (Date)classUser.getClazz().getTime(), (Integer)classUser.getClazz().getDuration(), (String)classUser.getClazz().getLocation().getConcat(), (String)request.getScheme(), (String)request.getServerName());
                            MailUtil.sendMail((String)CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.CLASS_NOTIFICATION_FROM_EMAIL), (String)to, (String)"Countway Class De-Registration Notification", (String)emailmsg, (String)CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.GENERAL_NOTIFICATION_TO_EMAIL));
                            messages.add("A de-registration confirmation has been e-mailed to: " + to);
                        }
                        catch (IOException e) {
                            messages.add("Error sending de-registration confirmation e-mail");
                        }
                        continue;
                    }
                    messages.add("Couldn't de-register you for \"" + classUser.getClazz().getCourse().getTitle() + "\"");
                }
            }
            request.setAttribute("messages", messages);
            request.setAttribute("classUserList", (Object)classUserDao.selectClassUserListByUserId(dluid));
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

