/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.dl.dao.ResourceDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.IntegerUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;

public class ResourcesServlet
extends AbstractServlet {
    private static final long serialVersionUID = -1870608692044548014L;
    private static final Logger log = Logger.getLogger(ResourcesServlet.class);
    private static final String journalResourceTypeIdString = CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.JOURNAL_RESOURCE_TYPE_ID);
    private static final String jspUrl = "resources.jspx";
    private static final String errorUrl = "../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            Integer journalResourceTypeId = Integer.parseInt(journalResourceTypeIdString);
            ResourcesServlet.setDummySessionAttributes(request);
            ResourceDAO resourceDao = new ResourceDAO();
            ResourceTypeDAO resourceTypeDao = new ResourceTypeDAO();
            String query = request.getParameter("query");
            String[] typeId = request.getParameterValues("typeId");
            String historical = request.getParameter("historical");
            String offset = request.getParameter("offset");
            String search = request.getParameter("search");
            request.setAttribute("journalResourceTypeId", (Object)journalResourceTypeId);
            request.setAttribute("resourceTypeList", (Object)resourceTypeDao.selectResourceTypeList());
            if (search != null) {
                SelectResourceListParams select = new SelectResourceListParams();
                if (query != null && !query.trim().equals("")) {
                    select.setQuery(query);
                    select.setSort(SelectResourceListParams.Sort.Score);
                } else {
                    select.setSort(SelectResourceListParams.Sort.Title);
                }
                if (typeId != null && typeId.length != 0) {
                    ArrayList<Integer> newTypeId = new ArrayList<Integer>();
                    for (String tid : typeId) {
                        if (tid != null && tid.equals("0")) {
                            newTypeId.clear();
                            break;
                        }
                        if (tid == null || tid.trim().equals("") || !IntegerUtil.isValidInteger((String)tid) || !resourceTypeDao.resourceTypeExists(Integer.valueOf(Integer.parseInt(tid))).booleanValue()) continue;
                        newTypeId.add(Integer.parseInt(tid));
                    }
                    select.setTypeId(newTypeId);
                }
                if (historical == null || historical.equals("false")) {
                    select.setHistorical(Boolean.valueOf(false));
                }
                if (offset != null && !offset.trim().equals("") && IntegerUtil.isValidInteger((String)offset)) {
                    select.setOffset(Integer.valueOf(Integer.parseInt(offset)));
                } else {
                    select.setOffset(Integer.valueOf(0));
                }
                request.setAttribute("resourceList", (Object)resourceDao.selectResourceList(select));
            }
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SolrServerException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

