/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.auth.AuthResponseCode;
import edu.harvard.med.countway.auth.ecommons.HmsaccessAuthenticator;
import edu.harvard.med.countway.auth.ecommons.HmsaccessCookie;
import edu.harvard.med.countway.auth.ecommons.HmsaccessCookieValue;
import edu.harvard.med.countway.auth.hul.HulaccessCookie;
import edu.harvard.med.countway.auth.pin.HarvardPinAuthenticator;
import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.config.LoginType;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LoginServlet
extends AbstractServlet {
    private static final long serialVersionUID = 7379082040779683863L;
    private static final Logger log = Logger.getLogger(LoginServlet.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final String jspUrl = "login.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LoginServlet.setDummySessionAttributes(request);
        HttpSession session = request.getSession();
        String pinUrl = "https://www.pin1.harvard.edu/pin/authenticate?__authen_application=" + CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.PIN_APP_NAME);
        String uid = (String)session.getAttribute("uid");
        String url = request.getParameter("url");
        String pinParams = request.getParameter("__authen_parameters");
        String pinPgpSig = request.getParameter("__authen_pgp_signature");
        Cookie hmsaccess = LoginServlet.getHmsaccessCookie(request);
        try {
            if (url != null && !url.trim().equals("")) {
                pinUrl = pinUrl + "&url=" + URLEncoder.encode(url, "UTF-8");
            } else {
                pinUrl = pinUrl + "&url=" + URLEncoder.encode("index.html", "UTF-8");
                url = "index.html";
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (uid != null && !uid.trim().equals("")) {
            response.sendRedirect(url);
            return;
        }
        if (pinParams != null && !pinParams.trim().equals("") && pinPgpSig != null && !pinPgpSig.trim().equals("")) {
            HarvardPinAuthenticator authn = new HarvardPinAuthenticator(pinParams, pinPgpSig, request.getRemoteAddr());
            AuthResponseCode responseCode = authn.getResponseCode();
            Boolean dlaccess = authn.getDlaccess();
            LoginType loginType = authn.getLoginType();
            if (responseCode.equals((Object)AuthResponseCode.INVALID_PIN_TOKEN) || responseCode.equals((Object)AuthResponseCode.EXPIRED_PIN_TOKEN) || responseCode.equals((Object)AuthResponseCode.INVALID_IP_ADDRESS)) {
                response.sendRedirect(pinUrl);
                return;
            }
            if (responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_LOOKUP_FAILED) || responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_NOT_AVAILABLE) || responseCode.equals((Object)AuthResponseCode.HUID_LDAP_AUTH_FAILED) || responseCode.equals((Object)AuthResponseCode.DL_ACCESS_DENIED) || responseCode.equals((Object)AuthResponseCode.SUCCESS)) {
                session.setAttribute("uid", (Object)authn.getUid());
                session.setAttribute("loginType", (Object)authn.getLoginType());
                session.setAttribute("firstName", (Object)authn.getFirstName());
                session.setAttribute("lastName", (Object)authn.getLastName());
                session.setAttribute("name", (Object)authn.getName());
                session.setAttribute("email", (Object)authn.getEmail());
                session.setAttribute("dluid", (Object)authn.getDluid());
                session.setAttribute("dlaccess", (Object)(dlaccess != false ? "true" : "false"));
                response.addCookie(new Cookie("login", "login"));
                if (dlaccess.booleanValue()) {
                    response.addCookie((Cookie)new HulaccessCookie(request.getRemoteAddr(), authn.getLoginType(), authn.getUid(), session.getId()));
                }
                if (loginType != null && loginType.equals((Object)LoginType.ecid)) {
                    response.addCookie((Cookie)new HmsaccessCookie(authn.getUid(), request.getRemoteAddr()));
                }
                if (responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_LOOKUP_FAILED) || responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_NOT_AVAILABLE) || responseCode.equals((Object)AuthResponseCode.HUID_LDAP_AUTH_FAILED) || responseCode.equals((Object)AuthResponseCode.DL_ACCESS_DENIED)) {
                    request.setAttribute("responseCode", (Object)responseCode);
                } else if (responseCode.equals((Object)AuthResponseCode.SUCCESS)) {
                    response.sendRedirect(url);
                    return;
                }
            } else {
                request.setAttribute("responseCode", (Object)responseCode);
            }
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (hmsaccess != null) {
            HmsaccessAuthenticator authn = new HmsaccessAuthenticator(hmsaccess, request.getRemoteAddr());
            AuthResponseCode responseCode = authn.getResponseCode();
            Boolean dlaccess = authn.getDlaccess();
            if (responseCode.equals((Object)AuthResponseCode.INVALID_HMSACCESS_COOKIE) || responseCode.equals((Object)AuthResponseCode.EXPIRED_HMSACCESS_COOKIE) || responseCode.equals((Object)AuthResponseCode.INVALID_IP_ADDRESS)) {
                response.sendRedirect(pinUrl);
                return;
            }
            if (responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_LOOKUP_FAILED) || responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_NOT_AVAILABLE) || responseCode.equals((Object)AuthResponseCode.HUID_LDAP_AUTH_FAILED) || responseCode.equals((Object)AuthResponseCode.DL_ACCESS_DENIED) || responseCode.equals((Object)AuthResponseCode.SUCCESS)) {
                session.setAttribute("uid", (Object)authn.getUid());
                session.setAttribute("loginType", (Object)authn.getLoginType());
                session.setAttribute("firstName", (Object)authn.getFirstName());
                session.setAttribute("lastName", (Object)authn.getLastName());
                session.setAttribute("name", (Object)authn.getName());
                session.setAttribute("email", (Object)authn.getEmail());
                session.setAttribute("dluid", (Object)authn.getDluid());
                session.setAttribute("dlaccess", (Object)(dlaccess != false ? "true" : "false"));
                response.addCookie(new Cookie("login", "login"));
                if (dlaccess.booleanValue()) {
                    response.addCookie((Cookie)new HulaccessCookie(request.getRemoteAddr(), authn.getLoginType(), authn.getUid(), session.getId()));
                }
                response.addCookie((Cookie)new HmsaccessCookie(authn.getUid(), request.getRemoteAddr()));
                if (responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_LOOKUP_FAILED) || responseCode.equals((Object)AuthResponseCode.ECOMMONS_HUID_NOT_AVAILABLE) || responseCode.equals((Object)AuthResponseCode.HUID_LDAP_AUTH_FAILED) || responseCode.equals((Object)AuthResponseCode.DL_ACCESS_DENIED)) {
                    request.setAttribute("responseCode", (Object)responseCode);
                } else if (responseCode.equals((Object)AuthResponseCode.SUCCESS)) {
                    response.sendRedirect(url);
                    return;
                }
            } else {
                request.setAttribute("responseCode", (Object)responseCode);
            }
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.sendRedirect(pinUrl);
    }

    private static Cookie getHmsaccessCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie hmsaccess = null;
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            String value = cookie.getValue();
            if (name == null || !name.equals("hmsaccess") || value == null) continue;
            if (DEBUG) {
                log.debug((Object)("hmsaccess encoded value: " + value));
                log.debug((Object)("hmsaccess decoded value: " + HmsaccessCookieValue.decodeValue((String)value)));
            }
            hmsaccess = cookie;
            break;
        }
        return hmsaccess;
    }
}

