/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.dl.servlet;

import edu.harvard.med.countway.dl.dao.UserResourceDAO;
import edu.harvard.med.countway.dl.model.Resource;
import edu.harvard.med.countway.dl.model.SelectUserResourceListParams;
import edu.harvard.med.countway.dl.model.User;
import edu.harvard.med.countway.dl.model.UserResource;
import edu.harvard.med.countway.dl.servlet.AbstractServlet;
import edu.harvard.med.countway.tools.IntegerUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class MydlServlet
extends AbstractServlet {
    private static final long serialVersionUID = -3696987136139567861L;
    private static final Logger log = Logger.getLogger(MydlServlet.class);
    private static final String loginUrl = "../login.html?url=dl/mydl.html";
    private static final String jspUrl = "mydl.jspx";
    private static final String errorUrl = "../error.jspx";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            ArrayList<UserResource> userResourceList;
            MydlServlet.setDummySessionAttributes(request);
            HttpSession session = request.getSession();
            UserResourceDAO userResourceDao = new UserResourceDAO();
            Integer dluid = (Integer)session.getAttribute("dluid");
            String uid = (String)session.getAttribute("uid");
            String view = request.getParameter("view");
            String insert = request.getParameter("insert");
            String[] resourceId = request.getParameterValues("resourceId");
            String delete = request.getParameter("delete");
            String[] userResourceId = request.getParameterValues("userResourceId");
            String offset = request.getParameter("offset");
            String search = request.getParameter("search");
            ArrayList<String> messages = new ArrayList<String>();
            if (uid == null || uid.trim().equals("")) {
                String url = loginUrl;
                if (view != null && view.equals("ec")) {
                    url = url + "%3Fview=ec";
                }
                response.sendRedirect(url);
                return;
            }
            if (insert != null && resourceId != null && resourceId.length > 0) {
                userResourceList = new ArrayList<UserResource>();
                for (String rid : resourceId) {
                    if (rid.trim().equals("") || !IntegerUtil.isValidInteger((String)rid)) continue;
                    User user = new User();
                    user.setId(dluid);
                    Resource resource = new Resource();
                    resource.setId(Integer.valueOf(Integer.parseInt(rid)));
                    UserResource userResource = new UserResource();
                    userResource.setUser(user);
                    userResource.setResource(resource);
                    userResourceList.add(userResource);
                }
                Integer insertCount = userResourceDao.insertUserResource(userResourceList);
                if (insertCount > 0) {
                    messages.add("Successfully added " + insertCount + " new Resource(s)");
                }
            }
            if (delete != null && userResourceId != null && userResourceId.length > 0) {
                userResourceList = new ArrayList();
                for (String urid : userResourceId) {
                    UserResource userResource;
                    if (urid.trim().equals("") || !IntegerUtil.isValidInteger((String)urid) || (userResource = userResourceDao.selectUserResource(Integer.valueOf(Integer.parseInt(urid)))) == null || !userResource.getUser().getId().equals(dluid)) continue;
                    userResourceList.add(userResource);
                }
                Integer deleteCount = userResourceDao.deleteUserResource(userResourceList);
                if (deleteCount > 0) {
                    messages.add("Successfully deleted " + deleteCount + " Resource(s)");
                }
            }
            SelectUserResourceListParams select = new SelectUserResourceListParams();
            select.setUserId(dluid);
            if (search != null && offset != null && !offset.trim().equals("") && IntegerUtil.isValidInteger((String)offset)) {
                select.setOffset(Integer.valueOf(Integer.parseInt(offset)));
            }
            request.setAttribute("messages", messages);
            request.setAttribute("userResourceList", (Object)userResourceDao.selectUserResourceList(select));
            request.getRequestDispatcher(jspUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (SQLException e) {
            request.setAttribute("javax.servlet.error.exception", (Object)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            request.getRequestDispatcher(errorUrl).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

