/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.med.countway.taglib;

import edu.harvard.med.countway.auth.AuthResponseCode;
import edu.harvard.med.countway.auth.ldap.HarvardLdapAuthorizer;
import edu.harvard.med.countway.config.CountwayConfig;
import edu.harvard.med.countway.dl.dao.ClassDAO;
import edu.harvard.med.countway.dl.dao.ClassUserDAO;
import edu.harvard.med.countway.dl.dao.CourseBuildingDAO;
import edu.harvard.med.countway.dl.dao.CourseTypeDAO;
import edu.harvard.med.countway.dl.dao.ResourceTypeDAO;
import edu.harvard.med.countway.dl.dao.UserResourceDAO;
import edu.harvard.med.countway.dl.model.Class;
import edu.harvard.med.countway.dl.model.ClassList;
import edu.harvard.med.countway.dl.model.ClassUser;
import edu.harvard.med.countway.dl.model.ClassUserList;
import edu.harvard.med.countway.dl.model.CourseBuildingList;
import edu.harvard.med.countway.dl.model.CourseTypeList;
import edu.harvard.med.countway.dl.model.ResourceTypeList;
import edu.harvard.med.countway.dl.model.SelectResourceListParams;
import edu.harvard.med.countway.tools.ExceptionUtil;
import edu.harvard.med.countway.tools.MailUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;

public class Functions {
    private static final Logger log = Logger.getLogger(Functions.class);
    private static final boolean DEBUG = log.isDebugEnabled();

    public static SelectResourceListParams.Field getResourceSelectFieldByValue(String value) {
        return SelectResourceListParams.Field.getByValue((String)value);
    }

    public static SelectResourceListParams.Sort getResourceSelectSortByValue(String value) {
        return SelectResourceListParams.Sort.getByValue((String)value);
    }

    public static Class selectClass(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.selectClass(classId);
    }

    public static Integer selectEnrolledCount(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.selectEnrolledCount(classId);
    }

    public static Integer selectWaitlistedCount(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.selectWaitlistedCount(classId);
    }

    public static Integer selectAvailableEnrolledCount(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.selectAvailableEnrolledCount(classId);
    }

    public static Integer selectAvailableWaitlistedCount(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.selectAvailableWaitlistedCount(classId);
    }

    public static boolean classIsOpen(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.classIsOpen(classId);
    }

    public static boolean classIsWaitlisted(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.classIsWaitlisted(classId);
    }

    public static boolean classIsClosed(Integer classId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.classIsClosed(classId);
    }

    public static ClassList selectClassListByUserId(Integer userId) throws SQLException {
        ClassDAO dao = new ClassDAO();
        return dao.selectClassListByUserId(userId);
    }

    public static ClassUserList selectClassUserListByUserId(Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.selectClassUserListByUserId(userId);
    }

    public static ClassUser selectClassUser(Integer classId, Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.selectClassUser(classId, userId);
    }

    public static boolean classUserExists(Integer classId, Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.classUserExists(classId, userId);
    }

    public static boolean classUserIsEnrolled(Integer classId, Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.classUserIsEnrolled(classId, userId);
    }

    public static boolean classUserIsWaitlisted(Integer classId, Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.classUserIsWaitlisted(classId, userId);
    }

    public static Integer selectClassUserWaitlistPosition(Integer classId, Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.selectClassUserWaitlistPosition(classId, userId);
    }

    public static boolean classUserIsCancelled(Integer classId, Integer userId) throws SQLException {
        ClassUserDAO dao = new ClassUserDAO();
        return dao.classUserIsCancelled(classId, userId);
    }

    public static boolean sendMail(String from, String to, String cc, String subj, String body, String bcc) {
        try {
            MailUtil.sendMail((String)from, (String)to, (String)cc, (String)subj, (String)body, (String)bcc);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int ru(double a) {
        return (int)Math.ceil(a);
    }

    public static int rd(double a) {
        return (int)Math.floor(a);
    }

    public static String getStackTrace(Throwable thr) {
        return ExceptionUtil.getStackTrace((Throwable)thr);
    }

    public static ResourceTypeList getResourceTypesByResourceId(Integer resourceId) throws SQLException {
        ResourceTypeDAO dao = new ResourceTypeDAO();
        return dao.selectResourceTypeListByResourceId(resourceId);
    }

    public static CourseTypeList selectCourseTypeList(boolean doit) throws SQLException {
        CourseTypeDAO dao = new CourseTypeDAO();
        return dao.selectCourseTypeList();
    }

    public static CourseBuildingList selectCourseBuildingList(boolean doit) throws SQLException {
        CourseBuildingDAO dao = new CourseBuildingDAO();
        return dao.selectCourseBuildingList();
    }

    public static boolean userResourceExists(Integer userId, Integer resourceId) throws SQLException {
        UserResourceDAO dao = new UserResourceDAO();
        return dao.userResourceExists(userId, resourceId);
    }

    public static String getConfigProperty(String key) {
        return CountwayConfig.getProperty((String)key);
    }

    public static AuthResponseCode getAuthResponseCode(String value) {
        return AuthResponseCode.getByValue((String)value);
    }

    public static HarvardLdapAuthorizer.UserClass getHarvardLdapAuthzUserClass(String huid) throws NamingException {
        HarvardLdapAuthorizer authz = new HarvardLdapAuthorizer(huid);
        return authz.getUserClass();
    }

    public static String getCountwayDocumentId(PageContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        String path = request.getServletPath();
        path = path.replaceFirst("^/", "");
        path = path.replaceFirst("\\.html$", "");
        path = path.replaceFirst("\\.jspx$", "");
        return path;
    }

    public static void logJspException(PageContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        Throwable throwable = context.getErrorData().getThrowable();
        String scheme = request.getScheme();
        String server = request.getServerName();
        int port = request.getServerPort();
        String uri = context.getErrorData().getRequestURI();
        Map params = request.getParameterMap();
        response.setStatus(200);
        String url = scheme + "://" + server;
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url = url + ":" + port;
        }
        url = url + uri;
        log.error((Object)("jsp exception url: " + url));
        log.error((Object)"jsp exception params:");
        for (String key : params.keySet()) {
            String[] values;
            for (String value : values = (String[])params.get(key)) {
                log.error((Object)("  <" + key + "> = <" + value + ">"));
            }
        }
        log.error((Object)"jsp exception throwable: ", throwable);
        StringBuffer body = new StringBuffer();
        body.append("url: " + url + "\n");
        body.append("params:\n");
        for (String key : params.keySet()) {
            String[] values;
            for (String value : values = (String[])params.get(key)) {
                body.append("  <" + key + "> = <" + value + ">\n");
            }
        }
        body.append("throwable: " + ExceptionUtil.getStackTrace((Throwable)throwable));
        try {
            MailUtil.sendMail((String)"noreply@countway.med.harvard.edu", (String)CountwayConfig.getProperty((CountwayConfig.PropertyKey)CountwayConfig.PropertyKey.ERROR_NOTIFICATION_TO_EMAIL), null, (String)"jsp exception", (String)body.toString(), null);
        }
        catch (IOException e) {
            log.error((Object)"error sending jsp exception notification", (Throwable)e);
        }
    }
}

