/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.DDS;
import opendap.dap.DDSException;
import opendap.dap.DataDDS;
import opendap.dap.DefaultFactory;
import opendap.dap.HeaderInputStream;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;
import opendap.dap.parser.ParseException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;

public class DConnect2 {
    private static boolean allowSessions = false;
    private static HttpClient _httpClient;
    private String urlString;
    private String projString;
    private String selString;
    private boolean acceptCompress;
    private String lastModified = null;
    private String lastExtended = null;
    private String lastModifiedInvalid = null;
    private boolean hasSession = false;
    private ServerVersion ver;
    private boolean debugHeaders = false;
    private boolean debugStream = false;

    public static void setAllowSessions(boolean b) {
        allowSessions = b;
    }

    public static void setHttpClient(HttpClient client) {
        _httpClient = client;
    }

    public static HttpClient getHttpClient() {
        return _httpClient;
    }

    private synchronized void initHttpClient() {
        if (_httpClient != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        _httpClient = new HttpClient(connectionManager);
    }

    public void setServerVersion(int major, int minor) {
        this.ver = new ServerVersion(major, minor);
    }

    public DConnect2(String urlString) throws FileNotFoundException {
        this(urlString, true);
    }

    public DConnect2(String urlString, boolean acceptCompress) throws FileNotFoundException {
        int ceIndex = urlString.indexOf(63);
        if (ceIndex != -1) {
            this.urlString = urlString.substring(0, ceIndex);
            String expr = urlString.substring(ceIndex);
            int selIndex = expr.indexOf(38);
            if (selIndex != -1) {
                this.projString = expr.substring(0, selIndex);
                this.selString = expr.substring(selIndex);
            } else {
                this.projString = expr;
                this.selString = "";
            }
        } else {
            this.urlString = urlString;
            this.selString = "";
            this.projString = "";
        }
        this.acceptCompress = acceptCompress;
    }

    public final String CE() {
        return this.projString + this.selString;
    }

    public final String URL() {
        return this.urlString;
    }

    private void openConnection(String urlString, Command command) throws IOException, DAP2Exception, ParseException {
        this.initHttpClient();
        GetMethod method = new GetMethod(urlString);
        method.setFollowRedirects(true);
        if (this.acceptCompress) {
            method.setRequestHeader(new Header("Accept-Encoding", "deflate,gzip"));
        }
        if (allowSessions) {
            method.setRequestHeader(new Header("X-Accept-Session", "true"));
        }
        InputStream is = null;
        try {
            String encoding;
            int statusCode = _httpClient.executeMethod(method);
            if (statusCode == 404) {
                throw new DAP2Exception(1, method.getStatusLine().toString());
            }
            if (statusCode == 401) {
                throw new CredentialsNotAvailableException(method.getStatusLine().toString());
            }
            if (statusCode != 200) {
                throw new DAP2Exception("Method failed:" + method.getStatusLine());
            }
            is = method.getResponseBodyAsStream();
            Header header = method.getResponseHeader("Content-Description");
            if (header != null && (header.getValue().equals("dods-error") || header.getValue().equals("dods_error"))) {
                DAP2Exception ds = new DAP2Exception();
                is = this.dumpStream(is);
                ds.parse(is);
                throw ds;
            }
            this.ver = new ServerVersion(method);
            this.checkHeaders(method);
            Header h = method.getResponseHeader("content-encoding");
            String string = encoding = h == null ? null : h.getValue();
            if (encoding != null && encoding.equals("deflate")) {
                is = new BufferedInputStream(new InflaterInputStream(is), 1000);
            } else if (encoding != null && encoding.equals("gzip")) {
                is = new BufferedInputStream(new GZIPInputStream(is), 1000);
            }
            command.process(is);
        }
        catch (CredentialsNotAvailableException e) {
            throw e;
        }
        catch (HttpException e) {
            throw new DAP2Exception("Fatal protocol violation: " + e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
            method.releaseConnection();
        }
    }

    public void closeSession() {
        try {
            if (allowSessions && this.hasSession) {
                this.openConnection(this.urlString + ".close", new Command(){

                    public void process(InputStream is) throws IOException {
                        byte[] buffer = new byte[4096];
                        while (is.read(buffer) > 0) {
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private InputStream dumpStream(InputStream is) throws IOException {
        return is;
    }

    public final ServerVersion getServerVersion() {
        return this.ver;
    }

    public String getLastModifiedHeader() {
        return this.lastModified;
    }

    public String getLastModifiedInvalidHeader() {
        return this.lastModifiedInvalid;
    }

    public String getLastExtendedHeader() {
        return this.lastExtended;
    }

    private void checkHeaders(GetMethod method) {
        HttpState state;
        Cookie[] cookies;
        if (this.debugHeaders) {
            System.out.println("\nOpenConnection Headers for " + method.getPath());
            System.out.println("Status Line: " + method.getStatusLine());
        }
        Header[] responseHeaders = method.getResponseHeaders();
        for (int i1 = 0; i1 < responseHeaders.length; ++i1) {
            Header responseHeader = responseHeaders[i1];
            if (this.debugHeaders) {
                System.out.print("  " + responseHeader);
            }
            String key = responseHeader.getName();
            String value = responseHeader.getValue();
            if (key.equals("Last-Modified")) {
                this.lastModified = value;
                if (!this.debugHeaders) continue;
                System.out.println(" **found lastModified = " + this.lastModified);
                continue;
            }
            if (key.equals("X-Last-Extended")) {
                this.lastExtended = value;
                if (!this.debugHeaders) continue;
                System.out.println(" **found lastExtended = " + this.lastExtended);
                continue;
            }
            if (!key.equals("X-Last-Modified-Invalid")) continue;
            this.lastModifiedInvalid = value;
            if (!this.debugHeaders) continue;
            System.out.println(" **found lastModifiedInvalid = " + this.lastModifiedInvalid);
        }
        if (this.debugHeaders) {
            System.out.println("OpenConnection Headers for " + method.getPath());
        }
        if ((cookies = (state = _httpClient.getState()).getCookies()).length > 0) {
            if (this.debugHeaders) {
                System.out.println("Cookies= ");
            }
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cooky = cookies[i];
                if (this.debugHeaders) {
                    System.out.println("  " + cooky);
                }
                if (!cooky.getName().equalsIgnoreCase("jsessionid")) continue;
                this.hasSession = true;
            }
        }
    }

    public DAS getDAS() throws IOException, ParseException, DAP2Exception {
        DASCommand command = new DASCommand();
        this.openConnection(this.urlString + ".das" + this.projString + this.selString, command);
        return command.das;
    }

    public DDS getDDS() throws IOException, ParseException, DAP2Exception {
        return this.getDDS("");
    }

    public DDS getDDS(String CE) throws IOException, ParseException, DAP2Exception {
        DDSCommand command = new DDSCommand();
        this.openConnection(this.urlString + ".dds" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    private String getCompleteCE(String CE) {
        String escCE;
        String localSelString;
        String localProjString;
        int selIndex = CE.indexOf(38);
        if (selIndex != -1) {
            localProjString = CE.indexOf(63) == 0 ? CE.substring(1, selIndex) : CE.substring(0, selIndex);
            localSelString = CE.substring(selIndex);
        } else {
            localProjString = CE.indexOf(63) == 0 ? CE.substring(1) : CE;
            localSelString = "";
        }
        String ce = this.projString;
        if (!localProjString.equals("")) {
            if (!ce.equals("") && localProjString.indexOf(44) != 0) {
                ce = ce + ",";
            }
            ce = ce + localProjString;
        }
        if (!this.selString.equals("")) {
            if (this.selString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + this.selString;
        }
        if (!localSelString.equals("")) {
            if (localSelString.indexOf(38) != 0) {
                ce = ce + "&";
            }
            ce = ce + localSelString;
        }
        if (ce.indexOf(63) != 0) {
            ce = "?" + ce;
        }
        try {
            escCE = URIUtil.encodeQuery(ce);
        }
        catch (URIException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return escCE;
    }

    public DDS getDDX() throws IOException, ParseException, DAP2Exception {
        return this.getDDX("");
    }

    public DDS getDDX(String CE) throws IOException, ParseException, DDSException, DAP2Exception {
        DDXCommand command = new DDXCommand();
        this.openConnection(this.urlString + ".ddx" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    public DataDDS getDataDDX() throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX("", new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getDataDDX(CE, new DefaultFactory());
    }

    public DataDDS getDataDDX(String CE, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        DataDDXCommand command = new DataDDXCommand(btf);
        this.openConnection(this.urlString + ".ddx" + this.getCompleteCE(CE), command);
        return command.dds;
    }

    public DataDDS getData(String CE, StatusUI statusUI, BaseTypeFactory btf) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        String urls = this.urlString + ".dods" + this.getCompleteCE(CE);
        DataDDS dds = new DataDDS(this.ver, btf);
        DataDDSCommand command = new DataDDSCommand(dds, statusUI);
        this.openConnection(urls, command);
        return command.dds;
    }

    public DataDDS getData(String CE) throws IOException, ParseException, DAP2Exception {
        return this.getData(CE, null, new DefaultFactory());
    }

    public DataDDS getData(String CE, StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData(CE, statusUI, new DefaultFactory());
    }

    public final DataDDS getData(StatusUI statusUI) throws MalformedURLException, IOException, ParseException, DDSException, DAP2Exception {
        return this.getData("", statusUI, new DefaultFactory());
    }

    public static void main(String[] args) {
        for (String url : args) {
            try {
                System.out.println("");
                System.out.println("");
                System.out.println("########################################################");
                System.out.println("\nConnecting to " + url + "\n");
                DConnect2 dc = new DConnect2(url);
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DDS:\n");
                DDS dds = dc.getDDS();
                dds.print(System.out);
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DAS:\n");
                DAS das = dc.getDAS();
                das.print(System.out);
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DATA:\n");
                dds = dc.getData("");
                dds.printVal(System.out, "");
                System.out.println("\n- - - - - - - - - - - - - - - - - - -");
                System.out.println("Retrieving DDX:\n");
                dds = dc.getDDX();
                dds.printXML(System.out);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    private class DataDDSCommand
    implements Command {
        DataDDS dds;
        StatusUI statusUI;

        DataDDSCommand(DataDDS dds, StatusUI statusUI) {
            this.dds = dds;
            this.statusUI = statusUI;
        }

        public void process(InputStream is) throws DAP2Exception, ParseException, IOException {
            this.dds.parse(new HeaderInputStream(is));
            this.dds.readData(is, this.statusUI);
        }
    }

    private class DataDDXCommand
    implements Command {
        DataDDS dds;

        DataDDXCommand(BaseTypeFactory btf) {
            this.dds = new DataDDS(DConnect2.this.ver, btf);
        }

        public void process(InputStream is) throws DAP2Exception, ParseException {
            this.dds.parseXML(is, false);
        }
    }

    private class DDXCommand
    implements Command {
        DDS dds = new DDS();

        private DDXCommand() {
        }

        public void process(InputStream is) throws DAP2Exception, ParseException {
            this.dds.parseXML(is, false);
        }
    }

    private class DDSCommand
    implements Command {
        DDS dds = new DDS();

        private DDSCommand() {
        }

        public void process(InputStream is) throws DDSException, ParseException {
            this.dds.parse(is);
        }
    }

    private class DASCommand
    implements Command {
        DAS das = new DAS();

        private DASCommand() {
        }

        public void process(InputStream is) throws DASException, ParseException {
            this.das.parse(is);
        }
    }

    private static interface Command {
        public void process(InputStream var1) throws DAP2Exception, ParseException, IOException;
    }
}

