/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.test;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import opendap.dap.DAP2Exception;
import opendap.dap.Server.CEEvaluator;
import opendap.dap.Server.ServerDDS;
import opendap.dap.parser.ExprParserTokenManager;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.SimpleCharStream;
import opendap.dap.parser.Token;
import opendap.servers.test.test_ServerFactory;
import opendap.util.Getopts;

public class expr_test {
    private static final String prompt = "expr-test: ";

    private static void usage() {
        System.err.println("usage: expr_test [-s <file>] [-p <file> -e <ce>]");
        System.err.println(" s: Test the scanner.");
        System.err.println(" p: Test the parser.");
        System.err.println(" e: CE.");
    }

    public static void main(String[] argv) {
        int c;
        boolean parser_test = false;
        boolean scanner_test = false;
        boolean expr_test2 = false;
        String file = "";
        String ce = "";
        Getopts g = new Getopts("expr_test", argv, "s:p:e:");
        block6: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 115: {
                    scanner_test = true;
                    file = g.getOptarg();
                    System.out.print("You picked " + (char)c + " with an argument of " + (file != null ? file : "null") + "\n");
                    continue block6;
                }
                case 112: {
                    parser_test = true;
                    file = g.getOptarg();
                    System.out.print("You picked " + (char)c + " with an argument of " + (file != null ? file : "null") + "\n");
                    continue block6;
                }
                case 101: {
                    expr_test2 = true;
                    ce = g.getOptarg();
                    System.out.print("You picked " + (char)c + " with an argument of " + (ce != null ? ce : "null") + "\n");
                    continue block6;
                }
                case 63: {
                    continue block6;
                }
            }
            System.out.print("getopt() returned " + c + "\n");
        }
        if (parser_test && expr_test2 || scanner_test && !expr_test2) {
            if (scanner_test) {
                System.out.println("File: " + file);
                expr_test.test_scanner();
            }
            if (parser_test) {
                System.out.println("File: " + file + ", ce: " + ce);
                expr_test.test_parser(file, ce);
            }
        } else {
            expr_test.usage();
            System.exit(1);
        }
    }

    private static void test_scanner() {
        SimpleCharStream jj_input_stream = new SimpleCharStream(System.in, 1, 1);
        ExprParserTokenManager token_source = new ExprParserTokenManager(jj_input_stream);
        System.out.print(prompt);
        System.out.flush();
        while (true) {
            Token tok = token_source.getNextToken();
            if (tok.kind == 0) break;
            switch (tok.kind) {
                case 5: {
                    System.out.println("Equal");
                    break;
                }
                case 6: {
                    System.out.println("Not equal");
                    break;
                }
                case 7: {
                    System.out.println("Greater than");
                    break;
                }
                case 8: {
                    System.out.println("Greater than or equal");
                    break;
                }
                case 9: {
                    System.out.println("Less than");
                    break;
                }
                case 10: {
                    System.out.println("Less than or equal");
                    break;
                }
                case 11: {
                    System.out.println("Regular expression");
                    break;
                }
                case 12: {
                    System.out.println("Left Bracket");
                    break;
                }
                case 13: {
                    System.out.println("Right Bracket");
                    break;
                }
                case 14: {
                    System.out.println("Colon");
                    break;
                }
                case 15: {
                    System.out.println("Comma");
                    break;
                }
                case 16: {
                    System.out.println("Ampersand");
                    break;
                }
                case 17: {
                    System.out.println("Left Parenthesis");
                    break;
                }
                case 18: {
                    System.out.println("Right Parenthesis");
                    break;
                }
                case 19: {
                    System.out.println("Left Brace");
                    break;
                }
                case 20: {
                    System.out.println("Right Brace");
                    break;
                }
                case 22: {
                    System.out.println("WORD: " + tok.image);
                    break;
                }
                default: {
                    System.out.println("Error: Unrecognized input");
                }
            }
            System.out.print(prompt);
            System.out.flush();
        }
    }

    private static void test_parser(String file, String ce) {
        try {
            test_ServerFactory factory = new test_ServerFactory();
            ServerDDS dds = new ServerDDS("test", factory);
            FileInputStream in = new FileInputStream(file);
            dds.parse(in);
            dds.print(System.out);
            CEEvaluator ceEval = new CEEvaluator(dds);
            ceEval.parseConstraint(ce);
            dds.printConstrained(System.out);
        }
        catch (FileNotFoundException fe) {
            System.out.println(fe.getMessage());
            System.out.println("Status from parser: 0");
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            System.out.println("Status from parser: 0");
        }
        catch (DAP2Exception de) {
            System.out.println(de.getMessage());
            System.out.println("Status from parser: 0");
        }
    }
}

