/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import ucar.grib.GribGDSVariablesIF;
import ucar.grib.GribIndexName;
import ucar.grib.GribIndexReader;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Pds;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.grid.GridIndex;
import ucar.unidata.io.RandomAccessFile;

public class Grib1WriteIndex {
    private static boolean debugTiming = false;
    private static boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(File grib, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(gribName, "r");
            raf.order(0);
            GridIndex gridIndex = this.writeGribIndex(grib, gbxName, raf, makeIndex);
            return gridIndex;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex writeGribIndex(File grib, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        boolean success;
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName, false)));
            success = this.writeGribIndex(raf, grib.lastModified(), out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (success && makeIndex) {
            try {
                Thread.sleep(2000L);
                return new GribIndexReader().open(gbxName);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean writeGribIndex(RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = new Date();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib1WriteIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(Grib2WriteIndex.indexRafBufferSize);
        try {
            inputRaf.seek(0L);
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 8.0");
            sb.append(" grid_edition 1");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            ArrayList<Grib1Product> products = g1i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                Grib1Pds pdsv = pds.getPdsVars();
                if (i == 0) {
                    sb.append(" center " + pdsv.getCenter());
                    sb.append(" sub_center " + pdsv.getSubCenter());
                    sb.append(" table_version " + pdsv.getParameterTableVersion());
                    sb.append(" basetime " + dateFormat.format(pdsv.getReferenceDate()));
                    sb.append(" ensemble ");
                    sb.append(pdsv.isEnsemble() ? "true" : "false");
                    out.writeUTF(sb.toString());
                    out.writeInt(products.size());
                    if (verbose) {
                        System.out.println("Index created with number records =" + products.size());
                    }
                }
                out.writeInt(product.getDiscipline());
                out.writeLong(pdsv.getReferenceTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getOffset1());
                out.writeLong(product.getOffset2());
                out.writeInt(pdsv.getLength());
                out.write(pdsv.getPDSBytes(), 0, pdsv.getLength());
                ++count;
            }
            HashMap<String, Grib1GridDefinitionSection> gdsHM = g1i.getGDSs();
            Set<String> keys = gdsHM.keySet();
            out.writeInt(keys.size());
            for (String key : keys) {
                Grib1GridDefinitionSection gds = gdsHM.get(key);
                if (gds.getGdsVars() == null) {
                    out.writeInt(4);
                    out.writeInt(Integer.parseInt(key));
                    continue;
                }
                int length = gds.getGdsVars().getGDSBytes().length;
                out.writeInt(length);
                out.write(gds.getGdsVars().getGDSBytes(), 0, length);
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
            boolean bl = false;
            return bl;
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
            boolean bl = false;
            return bl;
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(File grib, File gbx, String gribName, String gbxName, boolean makeIndex) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(gribName, "r");
            raf.order(0);
            GridIndex gridIndex = this.extendGribIndex(grib, gbx, gbxName, raf, makeIndex);
            return gridIndex;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridIndex extendGribIndex(File grib, File gbx, String gbxName, RandomAccessFile raf, boolean makeIndex) throws IOException {
        DataOutputStream out = null;
        boolean success = false;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(gbxName + ".tmp", false)));
            success = this.extendGribIndex(gbxName, raf, grib.lastModified(), out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        if (!success || out.size() == 8) {
            File tidx = new File(gbxName + ".tmp");
            tidx.delete();
            gbx.setLastModified(grib.lastModified() + 1000L);
        } else {
            gbx.delete();
            File tidx = new File(gbxName + ".tmp");
            tidx.renameTo(gbx);
        }
        if (success && makeIndex) {
            try {
                Thread.sleep(2000L);
                return new GribIndexReader().open(gbxName);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extendGribIndex(String gbxName, RandomAccessFile inputRaf, long rafLastModified, DataOutputStream out) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date now = new Date();
        if (debugTiming) {
            System.out.println(now.toString() + " ... Start of Grib2ExtendIndex");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        int rafBufferSize = inputRaf.getBufferSize();
        inputRaf.setBufferSize(Grib2WriteIndex.indexRafBufferSize);
        try {
            ArrayList<Grib2WriteIndex.RawRecord> recordList = new ArrayList<Grib2WriteIndex.RawRecord>();
            HashMap<String, GribGDSVariablesIF> gdsMap = new HashMap<String, GribGDSVariablesIF>();
            boolean newversion = new Grib2WriteIndex().rawGridIndex(gbxName, recordList, gdsMap);
            if (newversion) {
                Grib2WriteIndex.RawRecord rr = (Grib2WriteIndex.RawRecord)recordList.get(recordList.size() - 1);
                inputRaf.seek(rr.offset2);
            } else {
                inputRaf.seek(0L);
            }
            Grib1Input g1i = new Grib1Input(inputRaf);
            g1i.scan(true, false);
            out.writeLong(rafLastModified);
            StringBuilder sb = new StringBuilder();
            sb.append("index_version 8.0");
            sb.append(" grid_edition 1");
            sb.append(" location " + inputRaf.getLocation().replaceAll(" ", "%20"));
            sb.append(" length " + inputRaf.length());
            sb.append(" created " + dateFormat.format(now));
            ArrayList<Grib1Product> products = g1i.getProducts();
            if (products.size() == 0) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < products.size(); ++i) {
                Grib1Product product = (Grib1Product)products.get(i);
                Grib1ProductDefinitionSection pds = product.getPDS();
                Grib1Pds pdsv = pds.getPdsVars();
                if (i == 0) {
                    sb.append(" center " + pdsv.getCenter());
                    sb.append(" sub_center " + pdsv.getSubCenter());
                    sb.append(" table_version " + pdsv.getParameterTableVersion());
                    sb.append(" basetime " + dateFormat.format(pdsv.getReferenceDate()));
                    sb.append(" ensemble ");
                    sb.append(pdsv.isEnsemble() ? "true" : "false");
                    out.writeUTF(sb.toString());
                    out.writeInt(products.size() + recordList.size());
                    if (verbose) {
                        System.out.println("Index extended with old new records " + recordList.size() + "  " + products.size());
                    }
                    for (Grib2WriteIndex.RawRecord raw : recordList) {
                        out.writeInt(raw.discipline);
                        out.writeLong(raw.refTime);
                        out.writeInt(raw.gdsKey);
                        out.writeLong(raw.offset1);
                        out.writeLong(raw.offset2);
                        out.writeInt(raw.pdsSize);
                        out.write(raw.pdsData, 0, raw.pdsSize);
                    }
                    count = recordList.size();
                }
                out.writeInt(product.getDiscipline());
                out.writeLong(pdsv.getReferenceTime());
                out.writeInt(product.getGDSkeyInt());
                out.writeLong(product.getOffset1());
                out.writeLong(product.getOffset2());
                out.writeInt(pdsv.getLength());
                out.write(pdsv.getPDSBytes(), 0, pdsv.getLength());
                ++count;
            }
            HashMap<String, Grib1GridDefinitionSection> gdsHM = g1i.getGDSs();
            Set keysHM = gdsHM.keySet();
            for (String key : keysHM) {
                Grib1GridDefinitionSection gds = (Grib1GridDefinitionSection)gdsHM.get(key);
                if (gdsMap.containsKey(key)) continue;
                gdsMap.put(key, gds.getGdsVars());
            }
            out.writeInt(gdsMap.size());
            Set keyAll = gdsMap.keySet();
            for (String key : keyAll) {
                GribGDSVariablesIF gdsv = (GribGDSVariablesIF)gdsMap.get(key);
                if (gdsv == null) {
                    out.writeInt(4);
                    out.writeInt(Integer.parseInt(key));
                    continue;
                }
                int length = gdsv.getGDSBytes().length;
                out.writeInt(length);
                out.write(gdsv.getGDSBytes(), 0, length);
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
        }
        finally {
            inputRaf.setBufferSize(rafBufferSize);
        }
        if (debugTiming) {
            System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        }
        return true;
    }

    public void setDebug(boolean flag) {
        debugTiming = flag;
    }

    public void setVerbose(boolean flag) {
        verbose = flag;
    }

    private static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> scans for index creation");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib1WriteIndex indexer = new Grib1WriteIndex();
        debugTiming = true;
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib1WriteIndex.usage(cl.getName());
            System.exit(0);
        }
        String gribName = args[0];
        File grib = new File(args[0]);
        long rafLastModified = grib.lastModified();
        String gbxName = GribIndexName.getCurrentSuffix(gribName);
        if (args.length == 2) {
            File gbx = new File(gbxName);
            if (gbx.exists() && gbx.lastModified() > rafLastModified) {
                return;
            }
            if (gbx.exists()) {
                indexer.extendGribIndex(grib, gbx, gribName, gbxName, false);
            } else {
                indexer.writeGribIndex(grib, gribName, gbxName, false);
            }
        } else if (args.length == 1) {
            indexer.writeGribIndex(grib, gribName, gbxName, false);
        }
    }
}

