/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribGridRecord;
import ucar.grib.GribIndexName;
import ucar.grib.GribIndexReader;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib1.Grib1Data;
import ucar.grib.grib1.Grib1GridTableLookup;
import ucar.grib.grib1.Grib1Input;
import ucar.grib.grib1.Grib1Record;
import ucar.grib.grib1.Grib1WriteIndex;
import ucar.grib.grib2.Grib2Data;
import ucar.grib.grib2.Grib2GridTableLookup;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.Grib2WriteIndex;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;

public class GribGridServiceProvider
extends GridServiceProvider {
    private static Logger log = LoggerFactory.getLogger(GribGridServiceProvider.class);
    private long rafLength;
    private long indexLength;
    private int saveEdition = 0;
    private float version = 0.0f;
    private Grib1Data dataReaderGrib1;
    private Grib2Data dataReaderGrib2;
    private GridIndex gridIndexSave = null;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            return Grib2Input.isValidFile(raf);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getFileTypeId() {
        return this.saveEdition == 2 ? "GRIB2" : "GRIB1";
    }

    public String getFileTypeDescription() {
        return this.saveEdition == 2 ? "WMO GRIB Edition 2" : "WMO GRIB Edition 1";
    }

    public Object sendIospMessage(Object special) {
        String s;
        if (special instanceof String && (s = (String)special).equalsIgnoreCase("GridIndex")) {
            if (this.gridIndexSave != null) {
                return this.gridIndexSave;
            }
            try {
                return this.getIndex(this.raf.getLocation());
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.sendIospMessage(special);
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        this.rafLength = raf.length();
        raf.order(0);
        long start = System.currentTimeMillis();
        GridIndex index = this.getIndex(raf.getLocation());
        Map<String, String> attr = index.getGlobalAttributes();
        this.saveEdition = attr.get("grid_edition").equals("2") ? 2 : 1;
        this.version = Float.parseFloat(attr.get("index_version"));
        GridTableLookup lookup = this.saveEdition == 2 ? this.getLookup2() : this.getLookup1();
        GridIndexToNC convert = new GridIndexToNC(raf);
        convert.open(index, lookup, this.saveEdition, ncfile, this.fmrcCoordSys, cancelTask);
        ncfile.finish();
        if (GridServiceProvider.debugOpen) {
            this.gridIndexSave = index;
        }
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" open " + ncfile.getLocation() + " took=" + took + " msec ");
        }
        log.debug(" open() " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
    }

    protected void open(GridIndex index, CancelTask cancelTask) throws IOException {
        long start = System.currentTimeMillis();
        GridTableLookup lookup = this.saveEdition == 2 ? this.getLookup2() : this.getLookup1();
        GridIndexToNC convert = new GridIndexToNC(index.filename);
        convert.open(index, lookup, this.saveEdition, this.ncfile, this.fmrcCoordSys, cancelTask);
        this.ncfile.finish();
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" open() " + this.ncfile.getLocation() + " took=" + took + " msec ");
        }
        log.debug(" open() from sync" + this.ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
    }

    public GridTableLookup getLookup() throws IOException {
        GridTableLookup lookup = this.saveEdition == 2 ? this.getLookup2() : this.getLookup1();
        return lookup;
    }

    protected GridTableLookup getLookup2() throws IOException {
        Grib2Record firstRecord = null;
        try {
            Grib2Input g2i = new Grib2Input(this.raf);
            long start2 = System.currentTimeMillis();
            this.raf.seek(0L);
            g2i.scan(false, true);
            List<Grib2Record> records = g2i.getRecords();
            firstRecord = records.get(0);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start2;
                System.out.println("  read one record took=" + took + " msec ");
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        Grib2GridTableLookup lookup = new Grib2GridTableLookup(firstRecord);
        this.dataReaderGrib2 = new Grib2Data(this.raf);
        return lookup;
    }

    protected GridTableLookup getLookup1() throws IOException {
        Grib1Record firstRecord = null;
        try {
            Grib1Input g1i = new Grib1Input(this.raf);
            long start2 = System.currentTimeMillis();
            this.raf.seek(0L);
            g1i.scan(false, true);
            ArrayList<Grib1Record> records = g1i.getRecords();
            firstRecord = (Grib1Record)records.get(0);
            if (debugTiming) {
                long took = System.currentTimeMillis() - start2;
                System.out.println("  read one record took=" + took + " msec ");
            }
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        catch (NoValidGribException noValid) {
            System.err.println("NoValidGribException : " + noValid);
        }
        Grib1GridTableLookup lookup = new Grib1GridTableLookup(firstRecord);
        this.dataReaderGrib1 = new Grib1Data(this.raf);
        return lookup;
    }

    protected GridIndex getIndex(String dataLocation) throws IOException {
        GridIndex index;
        File indexFile;
        block15: {
            String indexLocation;
            InputStream ios;
            if (dataLocation.startsWith("http:") && (ios = this.indexExistsAsURL(indexLocation = GribIndexName.get(dataLocation))) != null) {
                log.debug(" getIndex() HTTP index = " + indexLocation);
                return new GribIndexReader().open(indexLocation, ios);
            }
            indexFile = this.getIndexFile(dataLocation);
            index = null;
            if (!forceNewIndex && indexFile.exists()) {
                try {
                    long indexRafLength;
                    index = new GribIndexReader().open(indexFile.getPath());
                    log.debug("  opened index = " + indexFile.getPath());
                    if (indexFileModeOnOpen == GridServiceProvider.IndexExtendMode.readonly) break block15;
                    String lengthS = index.getGlobalAttributes().get("length");
                    long l = indexRafLength = lengthS == null ? 0L : Long.parseLong(lengthS);
                    if (indexRafLength != this.rafLength) {
                        if (log.isDebugEnabled()) {
                            log.debug("  dataFile " + dataLocation + " length has changed: indexRafLength= " + indexRafLength + " rafLength= " + this.rafLength);
                        }
                        if (indexFileModeOnOpen == GridServiceProvider.IndexExtendMode.extendwrite) {
                            if (indexRafLength < this.rafLength) {
                                if (log.isDebugEnabled()) {
                                    log.debug("  extend Index = " + indexFile.getPath());
                                }
                                index = this.extendIndex(new File(this.raf.getLocation()), indexFile, this.raf);
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug("  rewrite index = " + indexFile.getPath());
                                }
                                index = this.writeIndex(indexFile, this.raf);
                            }
                        } else if (indexFileModeOnOpen == GridServiceProvider.IndexExtendMode.rewrite) {
                            if (log.isDebugEnabled()) {
                                log.debug("  rewrite index = " + indexFile.getPath());
                            }
                            index = this.writeIndex(indexFile, this.raf);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("GribReadIndex() failed, will try to rewrite at " + indexFile.getPath(), e);
                    index = this.writeIndex(indexFile, this.raf);
                }
            } else {
                log.debug("  write index = " + indexFile.getPath());
                index = this.writeIndex(indexFile, this.raf);
            }
        }
        this.indexLength = indexFile.length();
        return index;
    }

    private File getIndexFile(String dataLocation) throws IOException {
        String indexLocation = GribIndexName.getIndex(dataLocation, false);
        File indexFile = null;
        if (indexLocation.startsWith("http:")) {
            indexFile = DiskCache.getCacheFile(indexLocation);
            log.debug("  HTTP index = " + indexFile.getPath());
        } else {
            indexFile = new File(indexLocation);
            if (!indexFile.exists()) {
                log.debug(" saveIndexFile not exist " + indexFile.getPath() + " ++ " + indexLocation);
                indexFile = DiskCache.getFile(indexLocation, alwaysInCache);
                log.debug(" use " + indexFile.getPath());
            }
        }
        return indexFile;
    }

    private GridIndex writeIndex(File indexFile, RandomAccessFile raf) throws IOException {
        GridIndex index = null;
        if (indexFile.exists()) {
            boolean ok = indexFile.delete();
            log.debug("Deleted old index " + indexFile.getPath() + " = " + ok);
        }
        if (this.saveEdition == 0) {
            raf.seek(0L);
            Grib2Input g2i = new Grib2Input(raf);
            this.saveEdition = g2i.getEdition();
        }
        File gribFile = new File(raf.getLocation());
        if (this.saveEdition == 1) {
            index = new Grib1WriteIndex().writeGribIndex(gribFile, indexFile.getPath(), raf, true);
        } else if (this.saveEdition == 2) {
            index = new Grib2WriteIndex().writeGribIndex(gribFile, indexFile.getPath(), raf, true);
        }
        return index;
    }

    public boolean sync() throws IOException {
        File indexFile = this.getIndexFile(this.raf.getLocation());
        if (this.rafLength != this.raf.length() || this.indexLength != indexFile.length()) {
            GridIndex index;
            if (indexFileModeOnSync == GridServiceProvider.IndexExtendMode.readonly) {
                log.debug("  sync() read Index = " + indexFile.getPath());
                try {
                    index = new GribIndexReader().open(indexFile.getPath());
                }
                catch (Exception e) {
                    log.warn("  sync() return false: GribReadIndex() failed = " + indexFile.getPath());
                    return false;
                }
            } else if (indexFileModeOnSync == GridServiceProvider.IndexExtendMode.extendwrite) {
                if (this.rafLength <= this.raf.length() && this.indexLength <= indexFile.length()) {
                    if (log.isDebugEnabled()) {
                        log.debug("  sync() extend Index = " + indexFile.getPath());
                    }
                    index = this.extendIndex(new File(this.raf.getLocation()), indexFile, this.raf);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("  sync() rewrite index = " + indexFile.getPath());
                    }
                    index = this.writeIndex(indexFile, this.raf);
                }
            } else {
                log.debug("  sync() rewrite index = " + indexFile.getPath());
                index = this.writeIndex(indexFile, this.raf);
            }
            this.rafLength = this.raf.length();
            this.indexLength = indexFile.length();
            this.ncfile.empty();
            this.open(index, null);
            return true;
        }
        return false;
    }

    private GridIndex extendIndex(File gribFile, File indexFile, RandomAccessFile raf) throws IOException {
        GridIndex index = null;
        if (this.saveEdition == 0) {
            raf.seek(0L);
            Grib2Input g2i = new Grib2Input(raf);
            this.saveEdition = g2i.getEdition();
        }
        if (this.saveEdition == 1) {
            index = new Grib1WriteIndex().extendGribIndex(gribFile, indexFile, indexFile.getPath(), raf, true);
        } else if (this.saveEdition == 2) {
            index = new Grib2WriteIndex().extendGribIndex(gribFile, indexFile, indexFile.getPath(), raf, true);
        }
        return index;
    }

    private InputStream indexExistsAsURL(String indexLocation) {
        try {
            URL url = new URL(indexLocation);
            return url.openStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected float[] _readData(GridRecord gr) throws IOException {
        GribGridRecord ggr = (GribGridRecord)gr;
        if (this.saveEdition == 2) {
            return this.dataReaderGrib2.getData(ggr.getGdsOffset(), ggr.getPdsOffset(), ggr.getReferenceTimeInMsecs());
        }
        if (this.version >= 8.0f) {
            return this.dataReaderGrib1.getData(ggr.getGdsOffset(), ggr.getPdsOffset(), ggr.getDecimalScale(), ggr.isBmsExists());
        }
        return this.dataReaderGrib1.getData(ggr.getGdsOffset(), ggr.getDecimalScale(), ggr.isBmsExists());
    }
}

