/*
 * Decompiled with CFR 0.152.
 */
package clear.dep;

import clear.dep.DepNode;
import clear.dep.DepTree;

public class DepEval {
    private int n_las = 0;
    private int n_uas = 0;
    private int n_ls = 0;
    private int n_total = 0;

    public void evaluate(DepTree gold, DepTree sys) {
        int i = 1;
        while (i < gold.size()) {
            DepNode gNode = (DepNode)gold.get(i);
            DepNode sNode = (DepNode)sys.get(i);
            if (gNode.isDeprel(sNode.deprel)) {
                ++this.n_ls;
                if (gNode.headId == sNode.headId) {
                    ++this.n_las;
                }
            }
            if (gNode.headId == sNode.headId) {
                ++this.n_uas;
            }
            ++this.n_total;
            ++i;
        }
    }

    public double getLas() {
        return (double)this.n_las / (double)this.n_total;
    }

    public double getUas() {
        return (double)this.n_uas / (double)this.n_total;
    }

    public double getLs() {
        return (double)this.n_ls / (double)this.n_total;
    }

    public void print() {
        System.out.printf("LAS: %4.2f%", this.getLas() * 100.0);
        System.out.printf("UAS: %4.2f%", this.getUas() * 100.0);
        System.out.printf("LS : %4.2f%", this.getLs() * 100.0);
    }
}

