/*
 * Decompiled with CFR 0.152.
 */
package clear.dep;

import clear.util.tuple.JIntIntTuple;

public class DepNode {
    public int id;
    public String form;
    public String lemma;
    public String pos;
    public int headId;
    public String deprel;
    public double score;
    public boolean hasHead;
    public int leftDepId;
    public int rightDepId;
    public byte nonProj = 0;
    public JIntIntTuple chunkBE = null;
    public String chunkPos;

    public DepNode() {
        this.init(-1, "#$NULL$#", "#$NULL$#", "#$NULL$#", -2, "#$NULL$#");
    }

    public DepNode(boolean isRoot) {
        if (isRoot) {
            this.init(0, "#$ROOT$#", "#$ROOT$#", "#$ROOT$#", -2, "#$ROOT$#");
        } else {
            this.init(-1, "#$NULL$#", "#$NULL$#", "#$NULL$#", -2, "#$NULL$#");
        }
    }

    public DepNode(int id, String form, String lemma, String pos, int headId, String deprel) {
        this.init(id, form, lemma, pos, headId, deprel);
    }

    public void init(int id, String form, String lemma, String pos, int headId, String deprel) {
        this.init(id, form, lemma, pos, headId, deprel, 0.0, false, Integer.MAX_VALUE, -1);
    }

    public void init(int id, String form, String lemma, String pos, int headId, String deprel, double score, boolean hasHead, int leftDepId, int rightDepId) {
        this.id = id;
        this.form = form;
        this.lemma = lemma;
        this.pos = pos;
        this.headId = headId;
        this.deprel = deprel;
        this.score = score;
        this.hasHead = hasHead;
        this.leftDepId = leftDepId;
        this.rightDepId = rightDepId;
    }

    public void setChunkInfo(int beginId, int endId, String pos) {
        this.chunkBE = new JIntIntTuple(beginId, endId);
        this.chunkPos = pos;
    }

    public void setHead(int headId, String deprel, double score) {
        this.headId = headId;
        this.deprel = deprel;
        this.score = score;
        this.hasHead = true;
    }

    public void copy(DepNode node) {
        this.init(node.id, node.form, node.lemma, node.pos, node.headId, node.deprel, node.score, node.hasHead, node.leftDepId, node.rightDepId);
    }

    public DepNode clone() {
        DepNode node = new DepNode();
        node.copy(this);
        return node;
    }

    public int getHeadId() {
        return this.hasHead ? this.headId : -2;
    }

    public String getDeprel() {
        return this.hasHead ? this.deprel : "#$NULL$#";
    }

    public boolean isNull() {
        return this.id == -1;
    }

    public boolean isRoot() {
        return this.id == 0;
    }

    public boolean isForm(String form) {
        return this.form.equals(form);
    }

    public boolean isLemma(String lemma) {
        return this.lemma.equals(lemma);
    }

    public boolean isPos(String pos) {
        return this.pos.equals(pos);
    }

    public boolean isPosx(String posx) {
        return this.pos.startsWith(posx);
    }

    public boolean isDeprel(String deprel) {
        return this.deprel.equals(deprel);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.id);
        buff.append("\t");
        buff.append(this.form);
        buff.append("\t");
        buff.append(this.lemma);
        buff.append("\t");
        buff.append(this.pos);
        buff.append("\t");
        buff.append(this.headId);
        buff.append("\t");
        buff.append(this.deprel);
        return buff.toString();
    }

    public String toStringNonProj() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.id);
        buff.append("\t");
        buff.append(this.form);
        buff.append("\t");
        buff.append(this.lemma);
        buff.append("\t");
        buff.append(this.pos);
        buff.append("\t");
        buff.append(this.headId);
        buff.append("\t");
        buff.append(this.deprel);
        buff.append("\t");
        if (this.chunkBE != null) {
            buff.append(String.valueOf(this.chunkBE.int1) + " " + this.chunkBE.int2);
        }
        return buff.toString();
    }
}

