/*
 * Decompiled with CFR 0.152.
 */
package clear.dep;

import clear.dep.AbstractParser;
import clear.dep.DepNode;
import clear.dep.DepTree;
import clear.dep.ftr.DepFtrToken;
import clear.util.DSUtil;
import clear.util.tuple.JIntDoubleTuple;
import clear.util.tuple.JIntIntTuple;
import clear.util.tuple.JObjectDoubleTuple;
import java.util.ArrayList;

public class DepParser
extends AbstractParser {
    public static final String SHIFT = "SH";
    public static final String NO_ARC = "NA";
    public static final String LEFT_ARC = "LA";
    public static final String RIGHT_ARC = "RA";
    public static final String LB_DELIM = "-";
    private int i_lambda;
    private int i_beta;

    public DepParser(String lexiconDir, String inputFile, String featureXml, byte flag) {
        super(lexiconDir, inputFile, featureXml, flag);
    }

    private void init(DepTree tree) {
        this.d_tree = tree;
        this.i_lambda = 0;
        this.i_beta = 1;
        if (this.i_flag == 2) {
            this.printTransition("", "");
        }
    }

    @Override
    public void parse(DepTree tree) {
        this.init(tree);
        while (this.i_beta < tree.size()) {
            ++this.d_tree.n_trans;
            if (this.i_lambda == -1) {
                this.shift(true);
                continue;
            }
            if (this.i_flag == 3) {
                this.predict();
                continue;
            }
            this.train();
        }
        if (this.i_flag == 2) {
            this.f_out.println();
        } else if (this.i_flag == 3) {
            this.postProcess();
        }
    }

    private void train() {
        DepNode lambda = (DepNode)this.d_tree.get(this.i_lambda);
        DepNode beta = (DepNode)this.d_tree.get(this.i_beta);
        if (lambda.headId == beta.id) {
            this.leftArc(lambda, beta, lambda.deprel, 1.0);
        } else if (lambda.id == beta.headId) {
            this.rightArc(lambda, beta, beta.deprel, 1.0);
        } else if (this.isShift()) {
            this.shift(false);
        } else {
            this.noArc();
        }
    }

    private boolean isShift() {
        DepNode beta = (DepNode)this.d_tree.get(this.i_beta);
        int i = this.i_lambda;
        while (i >= 0) {
            DepNode lambda = (DepNode)this.d_tree.get(i);
            if (lambda.headId == beta.id || lambda.id == beta.headId) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void predict() {
        JIntDoubleTuple res = this.c_decode.predict(this.getFeatureArray());
        String label = res.i < 0 ? NO_ARC : this.t_map.indexToLabel(res.i);
        int index = label.indexOf(LB_DELIM);
        String trans = index > 0 ? label.substring(0, index) : label;
        String deprel = index > 0 ? label.substring(index + 1) : "";
        DepNode lambda = (DepNode)this.d_tree.get(this.i_lambda);
        DepNode beta = (DepNode)this.d_tree.get(this.i_beta);
        if (trans.equals(LEFT_ARC) && !this.d_tree.isAncestor(lambda, beta) && lambda.id != 0) {
            this.leftArc(lambda, beta, deprel, res.d);
        } else if (trans.equals(RIGHT_ARC) && !this.d_tree.isAncestor(beta, lambda)) {
            this.rightArc(lambda, beta, deprel, res.d);
        } else if (trans.equals(SHIFT)) {
            this.shift(false);
        } else {
            this.noArc();
        }
    }

    private void postProcess() {
        int currId = 1;
        while (currId < this.d_tree.size()) {
            DepNode curr = (DepNode)this.d_tree.get(currId);
            if (!curr.hasHead) {
                JObjectDoubleTuple<Object> max = new JObjectDoubleTuple<Object>(null, -1000.0);
                int maxId = -1;
                int leftId = currId - 1;
                while (leftId >= 0) {
                    DepNode left = (DepNode)this.d_tree.get(leftId);
                    if (!this.d_tree.isAncestor(curr, left)) {
                        maxId = this.getMaxHeadId(curr, left, maxId, max, RIGHT_ARC);
                    }
                    --leftId;
                }
                int rightId = currId + 1;
                while (rightId < this.d_tree.size()) {
                    DepNode right = (DepNode)this.d_tree.get(rightId);
                    if (!this.d_tree.isAncestor(curr, right)) {
                        maxId = this.getMaxHeadId(curr, right, maxId, max, LEFT_ARC);
                    }
                    ++rightId;
                }
                if (maxId != -1) {
                    curr.setHead(maxId, (String)max.object, max.value);
                }
            }
            ++currId;
        }
    }

    private int getMaxHeadId(DepNode curr, DepNode head, int maxId, JObjectDoubleTuple<String> max, String sTrans) {
        if (curr.id < head.id) {
            this.i_lambda = curr.id;
            this.i_beta = head.id;
        } else {
            this.i_lambda = head.id;
            this.i_beta = curr.id;
        }
        ArrayList<JIntDoubleTuple> aRes = this.c_decode.predictAll(this.getFeatureArray());
        int i = 0;
        while (i < aRes.size()) {
            String trans;
            JIntDoubleTuple res = aRes.get(i);
            String label = this.t_map.indexToLabel(res.i);
            int index = label.indexOf(LB_DELIM);
            if (index != -1 && (trans = label.substring(0, index)).equals(sTrans)) {
                if (!(max.value < res.d)) break;
                String deprel = label.substring(index + 1);
                max.set(deprel, res.d);
                maxId = head.id;
                break;
            }
            ++i;
        }
        return maxId;
    }

    private void shift(boolean isDeterministic) {
        if (!isDeterministic) {
            if (this.i_flag == 0) {
                this.addTag(SHIFT);
            } else if (this.i_flag == 1) {
                this.printInstance(SHIFT);
            }
        }
        this.i_lambda = this.i_beta++;
        if (this.i_flag == 2) {
            this.printTransition("SHIFT", "");
        }
    }

    private void noArc() {
        if (this.i_flag == 0) {
            this.addTag(NO_ARC);
        } else if (this.i_flag == 1) {
            this.printInstance(NO_ARC);
        }
        --this.i_lambda;
        if (this.i_flag == 2) {
            this.printTransition("NO-ARC", "");
        }
    }

    private void leftArc(DepNode lambda, DepNode beta, String deprel, double score) {
        String label = "LA-" + deprel;
        if (this.i_flag == 0) {
            this.addTag(label);
        } else if (this.i_flag == 1) {
            this.printInstance(label);
        }
        lambda.setHead(beta.id, deprel, score);
        if (lambda.id < beta.leftDepId) {
            beta.leftDepId = lambda.id;
        }
        --this.i_lambda;
        if (this.i_flag == 2) {
            this.printTransition("LEFT-ARC", String.valueOf(lambda.id) + " <-" + beta.deprel + "- " + beta.id);
        }
    }

    private void rightArc(DepNode lambda, DepNode beta, String deprel, double score) {
        String label = "RA-" + deprel;
        if (this.i_flag == 0) {
            this.addTag(label);
        } else if (this.i_flag == 1) {
            this.printInstance(label);
        }
        beta.setHead(lambda.id, deprel, score);
        if (lambda.rightDepId < beta.id) {
            lambda.rightDepId = beta.id;
        }
        --this.i_lambda;
        if (this.i_flag == 2) {
            this.printTransition("RIGHT-ARC", String.valueOf(lambda.id) + " -" + beta.deprel + "-> " + beta.id);
        }
    }

    private void addTag(String label) {
        this.t_map.addLabel(label);
        if (label.startsWith(LEFT_ARC)) {
            this.t_map.addPosPosDepRule((DepNode)this.d_tree.get(this.i_lambda), (DepNode)this.d_tree.get(this.i_beta), 1);
        } else if (label.startsWith(RIGHT_ARC)) {
            this.t_map.addPosPosDepRule((DepNode)this.d_tree.get(this.i_lambda), (DepNode)this.d_tree.get(this.i_beta), -1);
        }
        this.getFeatureArray();
    }

    private void printInstance(String label) {
        this.f_out.println(this.getInstance(label));
    }

    private void printTransition(String trans, String arc) {
        String str = String.valueOf(trans) + "\t";
        str = String.valueOf(str) + "[";
        if (this.i_lambda >= 0) {
            str = String.valueOf(str) + "0";
        }
        if (this.i_lambda >= 1) {
            str = String.valueOf(str) + ":" + this.i_lambda;
        }
        str = String.valueOf(str) + "]\t";
        str = String.valueOf(str) + "[";
        if (this.getLambda2Count() > 0) {
            str = String.valueOf(str) + (this.i_lambda + 1);
        }
        if (this.getLambda2Count() > 1) {
            str = String.valueOf(str) + ":" + (this.i_beta - 1);
        }
        str = String.valueOf(str) + "]\t";
        str = String.valueOf(str) + "[";
        if (this.i_beta < this.d_tree.size()) {
            str = String.valueOf(str) + this.i_beta;
        }
        if (this.i_beta <= this.d_tree.size()) {
            str = String.valueOf(str) + ":" + (this.d_tree.size() - 1);
        }
        str = String.valueOf(str) + "]\t";
        str = String.valueOf(str) + arc;
        this.f_out.println(str);
    }

    private int getLambda2Count() {
        return this.i_beta - (this.i_lambda + 1);
    }

    private String getInstance(String label) {
        return String.valueOf(this.t_map.labelToIndex(label)) + " " + DSUtil.toString(this.getFeatureArray(), ":1 ");
    }

    private ArrayList<Integer> getFeatureArray() {
        DepNode node1;
        DepNode node0;
        DepNode l0 = (DepNode)this.d_tree.get(this.i_lambda);
        DepNode b0 = (DepNode)this.d_tree.get(this.i_beta);
        ArrayList<String> s_form_1gram = new ArrayList<String>();
        ArrayList<String> s_lemma_1gram = new ArrayList<String>();
        ArrayList<String> s_pos_1gram = new ArrayList<String>();
        ArrayList<String> s_deprel_1gram = new ArrayList<String>();
        ArrayList<String> s_pos_lemma_1gram = new ArrayList<String>();
        ArrayList<String> s_pos_pos_2gram = new ArrayList<String>();
        ArrayList<String> s_pos_lemma_2gram = new ArrayList<String>();
        ArrayList<String> s_lemma_pos_2gram = new ArrayList<String>();
        ArrayList<String> s_lemma_lemma_2gram = new ArrayList<String>();
        ArrayList<String> s_pos_pos_pos_3gram = new ArrayList<String>();
        for (DepFtrToken[] tokens : this.t_xml.form_1gram) {
            s_form_1gram.add(this.getNode((DepFtrToken)tokens[0]).form);
        }
        for (DepFtrToken[] tokens : this.t_xml.lemma_1gram) {
            s_lemma_1gram.add(this.getNode((DepFtrToken)tokens[0]).lemma);
        }
        for (DepFtrToken[] tokens : this.t_xml.pos_1gram) {
            s_pos_1gram.add(this.getNode((DepFtrToken)tokens[0]).pos);
        }
        for (DepFtrToken[] tokens : this.t_xml.deprel_1gram) {
            s_deprel_1gram.add(this.getNode(tokens[0]).getDeprel());
        }
        for (DepFtrToken[] tokens : this.t_xml.pos_lemma_1gram) {
            DepNode node = this.getNode(tokens[0]);
            if (node.isNull()) {
                s_pos_lemma_1gram.add("#$NULL$#");
                continue;
            }
            s_pos_lemma_1gram.add(String.valueOf(node.pos) + "_" + node.lemma);
        }
        for (DepFtrToken[] tokens : this.t_xml.pos_pos_2gram) {
            node0 = this.getNode(tokens[0]);
            node1 = this.getNode(tokens[1]);
            if (node0.isNull() || node1.isNull()) {
                s_pos_pos_2gram.add("#$NULL$#");
                continue;
            }
            s_pos_pos_2gram.add(String.valueOf(node0.pos) + "_" + node1.pos);
        }
        for (DepFtrToken[] tokens : this.t_xml.pos_lemma_2gram) {
            node0 = this.getNode(tokens[0]);
            node1 = this.getNode(tokens[1]);
            if (node0.isNull() || node1.isNull()) {
                s_pos_lemma_2gram.add("#$NULL$#");
                continue;
            }
            s_pos_lemma_2gram.add(String.valueOf(node0.pos) + "_" + node1.lemma);
        }
        for (DepFtrToken[] tokens : this.t_xml.lemma_pos_2gram) {
            node0 = this.getNode(tokens[0]);
            node1 = this.getNode(tokens[1]);
            if (node0.isNull() || node1.isNull()) {
                s_lemma_pos_2gram.add("#$NULL$#");
                continue;
            }
            s_lemma_pos_2gram.add(String.valueOf(node0.lemma) + "_" + node1.pos);
        }
        for (DepFtrToken[] tokens : this.t_xml.lemma_lemma_2gram) {
            node0 = this.getNode(tokens[0]);
            node1 = this.getNode(tokens[1]);
            if (node0.isNull() || node1.isNull()) {
                s_lemma_lemma_2gram.add("#$NULL$#");
                continue;
            }
            s_lemma_lemma_2gram.add(String.valueOf(node0.lemma) + "_" + node1.lemma);
        }
        for (DepFtrToken[] tokens : this.t_xml.pos_pos_pos_3gram) {
            node0 = this.getNode(tokens[0]);
            node1 = this.getNode(tokens[1]);
            DepNode node2 = this.getNode(tokens[2]);
            if (node0.isNull() || node1.isNull() || node2.isNull()) {
                s_pos_pos_pos_3gram.add("#$NULL$#");
                continue;
            }
            s_pos_pos_pos_3gram.add(String.valueOf(node0.pos) + "_" + node1.pos + "_" + node2.pos);
        }
        if (this.i_flag == 0) {
            this.t_map.addForm(b0.form);
            this.t_map.addLemma(b0.lemma);
            this.t_map.addPos(b0.pos);
            this.t_map.addDeprel(b0.deprel);
            for (String pos_lemma_1gram : s_pos_lemma_1gram) {
                if (pos_lemma_1gram.equals("#$NULL$#")) continue;
                this.t_map.addPosLemma1gram(pos_lemma_1gram);
            }
            for (String pos_pos_2gram : s_pos_pos_2gram) {
                if (pos_pos_2gram.equals("#$NULL$#")) continue;
                this.t_map.addPosPos2gram(pos_pos_2gram);
            }
            for (String pos_lemma_2gram : s_pos_lemma_2gram) {
                if (pos_lemma_2gram.equals("#$NULL$#")) continue;
                this.t_map.addPosLemma2gram(pos_lemma_2gram);
            }
            for (String lemma_pos_2gram : s_lemma_pos_2gram) {
                if (lemma_pos_2gram.equals("#$NULL$#")) continue;
                this.t_map.addLemmaPos2gram(lemma_pos_2gram);
            }
            for (String lemma_lemma_2gram : s_lemma_lemma_2gram) {
                if (lemma_lemma_2gram.equals("#$NULL$#")) continue;
                this.t_map.addLemmaLemma2gram(lemma_lemma_2gram);
            }
            for (String pos_pos_pos_3gram : s_pos_pos_pos_3gram) {
                if (pos_pos_pos_3gram.equals("#$NULL$#")) continue;
                this.t_map.addPosPosPos3gram(pos_pos_pos_3gram);
            }
            if (b0.isDeprel("P")) {
                this.t_map.addPunctuation(b0.form);
            }
            if (l0.chunkBE != null) {
                this.t_map.addChunkPos(l0.chunkPos);
            }
            if (b0.chunkBE != null) {
                this.t_map.addChunkPos(b0.chunkPos);
            }
            return null;
        }
        ArrayList<Integer> arr = new ArrayList<Integer>();
        int[] idx = new int[]{1};
        for (String form : s_form_1gram) {
            this.addNgramFeature(arr, form, idx, 0);
        }
        for (String lemma : s_lemma_1gram) {
            this.addNgramFeature(arr, lemma, idx, 1);
        }
        for (String pos : s_pos_1gram) {
            this.addNgramFeature(arr, pos, idx, 2);
        }
        for (String deprel : s_deprel_1gram) {
            this.addNgramFeature(arr, deprel, idx, 3);
        }
        for (String posLemma : s_pos_lemma_1gram) {
            this.addNgramFeature(arr, posLemma, idx, 4);
        }
        for (String posPos : s_pos_pos_2gram) {
            this.addNgramFeature(arr, posPos, idx, 5);
        }
        for (String posLemma : s_pos_lemma_2gram) {
            this.addNgramFeature(arr, posLemma, idx, 6);
        }
        for (String lemmaPos : s_lemma_pos_2gram) {
            this.addNgramFeature(arr, lemmaPos, idx, 7);
        }
        for (String lemmaLemma : s_lemma_lemma_2gram) {
            this.addNgramFeature(arr, lemmaLemma, idx, 8);
        }
        for (String posPosPos : s_pos_pos_pos_3gram) {
            this.addNgramFeature(arr, posPosPos, idx, 9);
        }
        this.addPunctuationFeatures(arr, l0.id, b0.id, idx);
        this.addUnlabeledRuleFeatures(arr, l0, b0, idx);
        return arr;
    }

    private void addNgramFeature(ArrayList<Integer> arr, String feature, int[] beginIndex, int flag) {
        int index = -1;
        int begin = beginIndex[0];
        switch (flag) {
            case 0: {
                index = this.t_map.formToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_form;
                break;
            }
            case 1: {
                index = this.t_map.lemmaToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_lemma;
                break;
            }
            case 2: {
                index = this.t_map.posToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_pos;
                break;
            }
            case 3: {
                index = this.t_map.deprelToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_deprel;
                break;
            }
            case 4: {
                index = this.t_map.posLemma1gramToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_pos_lemma_1gram;
                break;
            }
            case 5: {
                index = this.t_map.posPos2gramToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_pos_pos_2gram;
                break;
            }
            case 6: {
                index = this.t_map.posLemma2gramToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_pos_lemma_2gram;
                break;
            }
            case 7: {
                index = this.t_map.lemmaPos2gramToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_lemma_pos_2gram;
                break;
            }
            case 8: {
                index = this.t_map.lemmaLemma2gramToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_lemma_lemma_2gram;
                break;
            }
            case 9: {
                index = this.t_map.posPosPos3gramToIndex(feature);
                beginIndex[0] = beginIndex[0] + this.t_map.n_pos_pos_pos_3gram;
            }
        }
        if (!feature.equals("#$NULL$#") && index > 0) {
            arr.add(begin + index);
        }
    }

    private void addPunctuationFeatures(ArrayList<Integer> arr, int leftId, int rightId, int[] beginIndex) {
        int index = this.d_tree.getRightNearestPunctuation(leftId, rightId - 1, this.t_map);
        if (index != -1) {
            arr.add(beginIndex[0] + index);
        }
        beginIndex[0] = beginIndex[0] + this.t_map.n_punctuation;
        index = this.d_tree.getLeftNearestPunctuation(rightId, leftId + 1, this.t_map);
        if (index != -1) {
            arr.add(beginIndex[0] + index);
        }
        beginIndex[0] = beginIndex[0] + this.t_map.n_punctuation;
        index = this.d_tree.getRightNearestPunctuation(rightId, this.d_tree.size() - 1, this.t_map);
        if (index != -1) {
            arr.add(beginIndex[0] + index);
        }
        beginIndex[0] = beginIndex[0] + this.t_map.n_punctuation;
    }

    private void addUnlabeledRuleFeatures(ArrayList<Integer> arr, DepNode lambda, DepNode beta, int[] beginIndex) {
        String rule = String.valueOf(lambda.pos) + "_" + beta.pos;
        int value = this.t_map.getPosPosDepRule(rule);
        if (value < 0) {
            arr.add(beginIndex[0]);
        } else if (value > 0) {
            arr.add(beginIndex[0] + 1);
        }
        beginIndex[0] = beginIndex[0] + 2;
    }

    private void addChunkBoundaryFeatures(ArrayList<Integer> arr, DepNode lambda, DepNode beta, int[] beginIndex) {
        JIntIntTuple lTup = lambda.chunkBE;
        JIntIntTuple bTup = beta.chunkBE;
        if (lTup != null && bTup != null && lTup.int1 == bTup.int1 && lTup.int2 == bTup.int2) {
            int index = this.t_map.chunkPosToIndex(lambda.chunkPos);
            arr.add(beginIndex[0] + index);
        } else {
            arr.add(beginIndex[0] + this.t_map.n_chunk_pos);
        }
        beginIndex[0] = beginIndex[0] + (this.t_map.n_chunk_pos + 1);
    }

    protected DepNode getNode(DepFtrToken token) {
        int index;
        int n = index = token.token == 'l' ? this.i_lambda : this.i_beta;
        if (!this.d_tree.isRange(index += token.offset) || token.token == 'l' && index == this.i_beta || token.token == 'b' && index == this.i_lambda) {
            return new DepNode();
        }
        if (token.relation == null) {
            return (DepNode)this.d_tree.get(index);
        }
        if (token.relation.equals("hd")) {
            return this.d_tree.getHead(index);
        }
        if (token.relation.equals("lm")) {
            return this.d_tree.getLeftMostDependent(index);
        }
        if (token.relation.equals("rm")) {
            return this.d_tree.getRightMostDependent(index);
        }
        return null;
    }
}

