/*
 * Decompiled with CFR 0.152.
 */
package clear.dep;

import clear.dep.AbstractTree;
import clear.dep.DepNode;
import clear.ftr.FtrMap;
import java.util.ArrayList;

public class DepTree
extends AbstractTree<DepNode> {
    public int n_trans;
    public double d_score;

    public DepTree() {
        this.add(new DepNode(true));
        this.init(0, 0.0);
    }

    public void init(int nTrans, double score) {
        this.n_trans = nTrans;
        this.d_score = score;
    }

    public boolean isAncestor(int nodeId1, int nodeId2) {
        DepNode node2 = (DepNode)this.get(nodeId2);
        if (!node2.hasHead) {
            return false;
        }
        if (node2.headId == nodeId1) {
            return true;
        }
        return this.isAncestor(nodeId1, node2.headId);
    }

    public boolean isAncestor(DepNode node1, DepNode node2) {
        if (!node2.hasHead) {
            return false;
        }
        if (node2.headId == node1.id) {
            return true;
        }
        return this.isAncestor(node1, (DepNode)this.get(node2.headId));
    }

    public void setHead(int currId, int headId, String deprel, double score) {
        DepNode curr = (DepNode)this.get(currId);
        curr.setHead(headId, deprel, score);
    }

    public void copy(DepTree tree) {
        int i = 1;
        while (i < this.size()) {
            ((DepNode)this.get(i)).copy((DepNode)tree.get(i));
            ++i;
        }
        this.init(tree.n_trans, tree.d_score);
    }

    @Override
    public DepTree clone() {
        DepTree tree = new DepTree();
        int i = 1;
        while (i < this.size()) {
            tree.add(((DepNode)this.get(i)).clone());
            ++i;
        }
        tree.init(this.n_trans, this.d_score);
        return tree;
    }

    public DepNode getHead(int currId) {
        DepNode curr = (DepNode)this.get(currId);
        return curr.hasHead ? (DepNode)this.get(curr.headId) : new DepNode();
    }

    public DepNode getLeftMostDependent(int currId) {
        DepNode curr = (DepNode)this.get(currId);
        return this.isRange(curr.leftDepId) ? (DepNode)this.get(curr.leftDepId) : new DepNode();
    }

    public int getLeftNearestPunctuation(int currId, int leftBoundId, FtrMap map) {
        int i = currId - 1;
        while (i >= leftBoundId) {
            int puncIndex = map.punctuationToIndex(((DepNode)this.get((int)i)).form);
            if (puncIndex > 0) {
                return puncIndex;
            }
            --i;
        }
        return -1;
    }

    public DepNode getRightMostDependent(int currId) {
        DepNode curr = (DepNode)this.get(currId);
        return this.isRange(curr.rightDepId) ? (DepNode)this.get(curr.rightDepId) : new DepNode();
    }

    public int getRightNearestPunctuation(int currId, int rightBoundId, FtrMap map) {
        int i = currId + 1;
        while (i <= rightBoundId) {
            int puncIndex = map.punctuationToIndex(((DepNode)this.get((int)i)).form);
            if (puncIndex > 0) {
                return puncIndex;
            }
            ++i;
        }
        return -1;
    }

    public ArrayList<DepNode> getDependents(int currId) {
        ArrayList<DepNode> list = new ArrayList<DepNode>();
        int i = 1;
        while (i < this.size()) {
            DepNode node = (DepNode)this.get(i);
            if (node.headId == currId) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    public double getScore() {
        double score = this.d_score;
        int i = 1;
        while (i < this.size()) {
            score += ((DepNode)this.get((int)i)).score;
            ++i;
        }
        return score;
    }

    public boolean checkTree() {
        int countRoot = 0;
        int i = 1;
        while (i < this.size()) {
            DepNode node = (DepNode)this.get(i);
            if (node.headId == 0) {
                ++countRoot;
            }
            if (!this.isRange(node.headId)) {
                System.err.println("Not connected: " + node.id + " <- " + node.headId);
                return false;
            }
            if (this.isAncestor(node.id, node.headId)) {
                System.err.println("Cycle exists: " + node.id + " <-*-> " + node.headId);
                return false;
            }
            ++i;
        }
        if (countRoot != 1) {
            System.err.println("Not single-rooted: " + countRoot);
            return false;
        }
        return true;
    }

    public String toStringNonProj() {
        StringBuilder buff = new StringBuilder();
        int i = 1;
        while (i < this.size()) {
            buff.append(((DepNode)this.get(i)).toStringNonProj());
            buff.append("\n");
            ++i;
        }
        return buff.toString().trim();
    }

    public void projectizePunc() {
        int i = 1;
        while (i < this.size()) {
            DepNode curr = (DepNode)this.get(i);
            if (!curr.isDeprel("P")) {
                int eId;
                int sId;
                DepNode head = (DepNode)this.get(curr.headId);
                if (curr.id < head.id) {
                    sId = curr.id;
                    eId = head.id;
                } else {
                    sId = head.id;
                    eId = curr.id;
                }
                int j = sId + 1;
                while (j < eId) {
                    DepNode node = (DepNode)this.get(j);
                    if (node.isDeprel("P") && (sId > node.headId || node.headId > eId)) {
                        node.headId = curr.headId != 0 ? curr.headId : curr.id;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

