/*
 * Decompiled with CFR 0.152.
 */
package clear.engine;

import clear.dep.DepParser;
import clear.dep.DepTree;
import clear.engine.AbstractEngine;
import clear.reader.AbstractReader;
import clear.reader.CoNLLReader;
import clear.reader.DepReader;
import org.w3c.dom.Element;

public class DepTrain
extends AbstractEngine {
    final String TAG_LIBLINEAR = "liblinear";
    final String TAG_LIBLINEAR_TRAINER = "trainer";
    final String TAG_LIBLINEAR_S = "s";
    final String TAG_LIBLINEAR_C = "c";
    final String TAG_LIBLINEAR_E = "e";
    final String TAG_LIBLINEAR_B = "B";
    private String s_trainFile = null;
    private String s_configFile = null;
    private String s_featureFile = null;
    protected String s_trainer = null;
    protected int i_s = 3;
    protected double d_c = 0.1;
    protected double d_e = 0.1;
    protected double d_b = -1.0;
    private byte i_flag = 0;

    public DepTrain(String[] args) {
        if (!this.initArgs(args)) {
            return;
        }
        if (!this.initConfigElement(this.s_configFile)) {
            return;
        }
        if (!this.initCommonElements()) {
            return;
        }
        if (!this.initTrainElements()) {
            return;
        }
        this.s_featureFile = String.valueOf(this.s_modelFile) + ".ftr";
        if (this.i_flag == 0) {
            this.printCommonConfig();
            System.out.println("- train_file : " + this.s_trainFile);
            System.out.println("\nPrint lexicon files: [" + this.s_lexiconDir + "]");
            this.trainDepParser((byte)0);
            System.out.println("\nPrint training instances: " + this.s_featureFile);
            this.trainDepParser((byte)1);
            System.out.println("\nTrain liblinear model: " + this.s_modelFile);
            this.trainLibLinear();
        } else {
            this.trainDepParser((byte)2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            this.printUsage();
            return false;
        }
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-t")) {
                    this.s_trainFile = args[i + 1];
                } else if (args[i].equals("-c")) {
                    this.s_configFile = args[i + 1];
                } else {
                    if (!args[i].equals("-f")) {
                        this.printUsage();
                        return false;
                    }
                    this.i_flag = Byte.parseByte(args[i + 1]);
                }
                i += 2;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        if (this.s_trainFile == null) {
            System.err.println("Error: <training file> must be specified.");
            return false;
        }
        if (this.i_flag != 2 && this.s_configFile == null) {
            System.err.println("Error: <configuration file> must be specified.");
            return false;
        }
        if (this.i_flag != 0 && this.i_flag != 2) {
            System.err.println("Error: invalid <flag = " + this.i_flag + ">.");
            return false;
        }
        return true;
    }

    protected boolean initTrainElements() {
        if (this.s_format.equals("raw") || this.s_format.equals("pos")) {
            System.err.println("Error: invalid <format = " + this.s_format + "> for training.");
            return false;
        }
        Element eLiblinear = this.getElement(this.e_config, "liblinear");
        if (eLiblinear == null) {
            System.err.println("Error: <liblinear> must be specified.");
            return false;
        }
        Element eTrainExc = this.getElement(eLiblinear, "trainer");
        if (eTrainExc == null) {
            System.err.println("Error: <liblinear.trainer> must be specified.");
            return false;
        }
        this.s_trainer = eTrainExc.getTextContent().trim();
        try {
            String tmp = eLiblinear.getAttribute("s").trim();
            if (tmp.length() > 0) {
                this.i_s = Integer.parseInt(tmp);
            }
            if ((tmp = eLiblinear.getAttribute("c").trim()).length() > 0) {
                this.d_c = Double.parseDouble(tmp);
            }
            if ((tmp = eLiblinear.getAttribute("e").trim()).length() > 0) {
                this.d_e = Double.parseDouble(tmp);
            }
            if ((tmp = eLiblinear.getAttribute("B").trim()).length() > 0) {
                this.d_b = Double.parseDouble(tmp);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void trainDepParser(byte flag) {
        DepTree tree;
        AbstractReader reader = null;
        reader = this.s_format.equals("dep") ? new DepReader(this.s_trainFile, true) : new CoNLLReader(this.s_trainFile, true);
        DepParser parser = new DepParser(this.s_lexiconDir, this.s_featureFile, this.s_featureXml, flag);
        System.out.print("Parsing: ");
        int n = 0;
        while ((tree = (DepTree)reader.nextTree()) != null) {
            parser.parse(tree);
            if (n % 1000 == 0) {
                System.out.printf("%s%dK", "\r- Parsing: ", n / 1000);
            }
            ++n;
        }
        System.out.println("\r- Parsing: " + n);
        if (flag == 0) {
            parser.saveTags(this.s_lexiconDir);
        }
    }

    private void trainLibLinear() {
        StringBuilder build = new StringBuilder();
        build.append(this.s_trainer);
        build.append(" -s " + this.i_s);
        build.append(" -c " + this.d_c);
        build.append(" -e " + this.d_e);
        build.append(" -B " + this.d_b);
        build.append(" " + this.s_featureFile);
        build.append(" " + this.s_modelFile);
        String cmd = build.toString();
        System.out.println("- Command : " + cmd);
        try {
            Runtime rt = Runtime.getRuntime();
            long st = System.currentTimeMillis();
            Process ps = rt.exec(cmd);
            ps.waitFor();
            long time = System.currentTimeMillis() - st;
            System.out.printf("- Duration: %d hours, %d minutes\n", time / 3600000L, time / 60000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printUsage() {
        String usage = "Usage: java clear.engine.DepTrain -t <training file> -c <configuration file> [-f <flag = " + this.i_flag + ">]";
        System.err.println(usage);
        System.err.println("<flag> ::= 0: train a model using LibLinear");
        System.err.println("           2: print transitions to the standard I/O");
    }

    public static void main(String[] args) {
        new DepTrain(args);
    }
}

