/*
 * Decompiled with CFR 0.152.
 */
package clear.engine;

import clear.dep.DepTree;
import clear.morph.MorphEnAnalyzer;
import clear.treebank.TBEnConvert;
import clear.treebank.TBHeadRules;
import clear.treebank.TBReader;
import clear.treebank.TBTree;
import clear.util.IOUtil;
import java.io.File;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class PhraseToDep {
    @Option(name="-i", usage="name of a file containing phrase structure tree", required=true, metaVar="REQUIRED")
    String inputFile;
    @Option(name="-o", usage="name of a file containing dependency trees", required=true, metaVar="REQUIRED")
    String outputFile;
    @Option(name="-h", usage="name of a file containing head-percolation rules", required=true, metaVar="REQUIRED")
    String headruleFile;
    @Option(name="-m", usage="path of a directory containing dictionaries for morphological analyzer", metaVar="OPTIONAL")
    String dictDir = null;
    @Option(name="-l", usage="language ::= ch | en (default)", metaVar="OPTIONAL")
    String language = "en";
    @Option(name="-n", usage="minimum sentence length (inclusive; default = 0)", metaVar="OPTIONAL")
    int length = 0;

    public static void main(String[] args) {
        new PhraseToDep().convert(args);
    }

    public void convert(String[] args) {
        CmdLineParser cmd = new CmdLineParser(this);
        try {
            TBTree tree;
            cmd.parseArgument(args);
            TBReader reader = new TBReader(this.inputFile);
            TBHeadRules headrules = new TBHeadRules(this.headruleFile);
            MorphEnAnalyzer morph = this.dictDir != null ? new MorphEnAnalyzer(this.dictDir) : null;
            PrintStream fout = IOUtil.createPrintFileStream(this.outputFile);
            TBEnConvert converter = new TBEnConvert();
            String filename = this.inputFile.substring(this.inputFile.lastIndexOf(File.separator) + 1);
            int i = 0;
            System.out.print("\r" + filename + ": 0");
            while ((tree = reader.nextTree()) != null) {
                DepTree dTree = converter.toDepTree(tree, headrules, morph);
                if (dTree.size() > this.length) {
                    fout.println(dTree + "\n");
                    ++i;
                }
                if (i % 1000 != 0) continue;
                System.out.print("\r" + filename + ": " + i);
            }
            System.out.println("\r" + filename + ": " + i);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            cmd.printUsage(System.err);
        }
    }
}

