/*
 * Decompiled with CFR 0.152.
 */
package clear.ftr;

import clear.dep.DepNode;
import clear.util.DSUtil;
import clear.util.IOUtil;
import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;

public class FtrMap {
    protected ArrayList<String> a_label;
    protected ObjectIntOpenHashMap<String> m_label;
    protected ObjectIntOpenHashMap<String> m_form;
    protected ObjectIntOpenHashMap<String> m_lemma;
    protected ObjectIntOpenHashMap<String> m_pos;
    protected ObjectIntOpenHashMap<String> m_deprel;
    protected ObjectIntOpenHashMap<String> m_pos_lemma_1gram;
    protected ObjectIntOpenHashMap<String> m_pos_pos_2gram;
    protected ObjectIntOpenHashMap<String> m_pos_lemma_2gram;
    protected ObjectIntOpenHashMap<String> m_lemma_pos_2gram;
    protected ObjectIntOpenHashMap<String> m_lemma_lemma_2gram;
    protected ObjectIntOpenHashMap<String> m_pos_pos_pos_3gram;
    protected ObjectIntOpenHashMap<String> m_punctuation;
    private ObjectIntOpenHashMap<String> m_pos_pos_dep_rule;
    private ObjectIntOpenHashMap<String> m_chunk_pos;
    public int n_label;
    public int n_form;
    public int n_lemma;
    public int n_pos;
    public int n_deprel;
    public int n_pos_lemma_1gram;
    public int n_pos_pos_2gram;
    public int n_pos_lemma_2gram;
    public int n_lemma_pos_2gram;
    public int n_lemma_lemma_2gram;
    public int n_pos_pos_pos_3gram;
    public int n_punctuation;
    public int n_chunk_pos;

    public FtrMap() {
        this.m_label = new ObjectIntOpenHashMap();
        this.m_form = new ObjectIntOpenHashMap();
        this.m_lemma = new ObjectIntOpenHashMap();
        this.m_pos = new ObjectIntOpenHashMap();
        this.m_deprel = new ObjectIntOpenHashMap();
        this.m_pos_lemma_1gram = new ObjectIntOpenHashMap();
        this.m_pos_pos_2gram = new ObjectIntOpenHashMap();
        this.m_pos_lemma_2gram = new ObjectIntOpenHashMap();
        this.m_lemma_pos_2gram = new ObjectIntOpenHashMap();
        this.m_lemma_lemma_2gram = new ObjectIntOpenHashMap();
        this.m_pos_pos_pos_3gram = new ObjectIntOpenHashMap();
        this.m_punctuation = new ObjectIntOpenHashMap();
        this.m_pos_pos_dep_rule = new ObjectIntOpenHashMap();
        this.m_chunk_pos = new ObjectIntOpenHashMap();
    }

    protected ObjectIntOpenHashMap<String> getPunctuation() {
        ObjectIntOpenHashMap<String> map = new ObjectIntOpenHashMap<String>();
        map.put(".", 1);
        map.put("..", 1);
        map.put("...", 1);
        map.put("....", 1);
        map.put(".-", 1);
        map.put("!", 1);
        map.put("!!", 1);
        map.put("!!!", 1);
        map.put("!!!!", 1);
        map.put("?", 1);
        map.put(".?", 1);
        map.put("!?", 1);
        map.put("?!", 1);
        map.put("??", 1);
        map.put("???", 1);
        map.put(",", 1);
        map.put(":", 1);
        map.put(";", 1);
        map.put("/", 1);
        map.put("-", 1);
        map.put("--", 1);
        map.put("---", 1);
        map.put("`", 1);
        map.put("'", 1);
        map.put("\"", 1);
        map.put("``", 1);
        map.put("''", 1);
        map.put("\"\"", 1);
        map.put("(", 1);
        map.put(")", 1);
        map.put("{", 1);
        map.put("}", 1);
        map.put("[", 1);
        map.put("]", 1);
        return map;
    }

    public FtrMap(String lexiconDir) {
        this.load(lexiconDir);
    }

    public void load(String lexiconDir) {
        HashSet<String> fileset = DSUtil.toHashSet(new File(lexiconDir).list());
        if (fileset.contains("label.txt")) {
            this.a_label = IOUtil.getArrayList(String.valueOf(lexiconDir) + File.separator + "label.txt");
            this.m_label = DSUtil.toHashMap(this.a_label, 1);
            this.n_label = this.m_label.size();
            System.out.print(".");
        }
        if (fileset.contains("form.txt")) {
            this.m_form = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "form.txt", 1);
            this.n_form = this.m_form.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("lemma.txt")) {
            this.m_lemma = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "lemma.txt", 1);
            this.n_lemma = this.m_lemma.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("pos.txt")) {
            this.m_pos = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "pos.txt", 1);
            this.n_pos = this.m_pos.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("deprel.txt")) {
            this.m_deprel = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "deprel.txt", 1);
            this.n_deprel = this.m_deprel.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("pos_lemma_1gram.txt")) {
            this.m_pos_lemma_1gram = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "pos_lemma_1gram.txt", 1);
            this.n_pos_lemma_1gram = this.m_pos_lemma_1gram.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("pos_pos_2gram.txt")) {
            this.m_pos_pos_2gram = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "pos_pos_2gram.txt", 1);
            this.n_pos_pos_2gram = this.m_pos_pos_2gram.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("pos_lemma_2gram.txt")) {
            this.m_pos_lemma_2gram = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "pos_lemma_2gram.txt", 1);
            this.n_pos_lemma_2gram = this.m_pos_lemma_2gram.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("lemma_pos_2gram.txt")) {
            this.m_lemma_pos_2gram = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "lemma_pos_2gram.txt", 1);
            this.n_lemma_pos_2gram = this.m_lemma_pos_2gram.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("lemma_lemma_2gram.txt")) {
            this.m_lemma_lemma_2gram = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "lemma_lemma_2gram.txt", 1);
            this.n_lemma_lemma_2gram = this.m_lemma_lemma_2gram.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("pos_pos_pos_3gram.txt")) {
            this.m_pos_pos_pos_3gram = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "pos_pos_pos_3gram.txt", 1);
            this.n_pos_pos_pos_3gram = this.m_pos_pos_pos_3gram.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("punctuation.txt")) {
            this.m_punctuation = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "punctuation.txt", 1);
            this.n_punctuation = this.m_punctuation.size() + 1;
            System.out.print(".");
        }
        if (fileset.contains("pos_pos_rule.txt")) {
            this.m_pos_pos_dep_rule = IOUtil.getTStringIntHashMap(String.valueOf(lexiconDir) + File.separator + "pos_pos_rule.txt", " ");
            System.out.print(".");
        }
        if (fileset.contains("chunk_pos.txt")) {
            this.m_chunk_pos = IOUtil.getHashMap(String.valueOf(lexiconDir) + File.separator + "chunk_pos.txt", 1);
            this.n_chunk_pos = this.m_chunk_pos.size() + 1;
            System.out.print(".");
        }
    }

    public void save(String lexiconDir) {
        if (!this.m_label.isEmpty()) {
            IOUtil.printFile(this.m_label, String.valueOf(lexiconDir) + File.separator + "label.txt");
            System.out.print(".");
        }
        if (!this.m_form.isEmpty()) {
            IOUtil.printFile(this.m_form, String.valueOf(lexiconDir) + File.separator + "form.txt");
            System.out.print(".");
        }
        if (!this.m_lemma.isEmpty()) {
            IOUtil.printFile(this.m_lemma, String.valueOf(lexiconDir) + File.separator + "lemma.txt");
            System.out.print(".");
        }
        if (!this.m_pos.isEmpty()) {
            IOUtil.printFile(this.m_pos, String.valueOf(lexiconDir) + File.separator + "pos.txt");
            System.out.print(".");
        }
        if (!this.m_deprel.isEmpty()) {
            IOUtil.printFile(this.m_deprel, String.valueOf(lexiconDir) + File.separator + "deprel.txt");
            System.out.print(".");
        }
        if (!this.m_pos_lemma_1gram.isEmpty()) {
            IOUtil.printFile(this.m_pos_lemma_1gram, String.valueOf(lexiconDir) + File.separator + "pos_lemma_1gram.txt");
            System.out.print(".");
        }
        if (!this.m_pos_pos_2gram.isEmpty()) {
            IOUtil.printFile(this.m_pos_pos_2gram, String.valueOf(lexiconDir) + File.separator + "pos_pos_2gram.txt");
            System.out.print(".");
        }
        if (!this.m_pos_lemma_2gram.isEmpty()) {
            IOUtil.printFile(this.m_pos_lemma_2gram, String.valueOf(lexiconDir) + File.separator + "pos_lemma_2gram.txt");
            System.out.print(".");
        }
        if (!this.m_lemma_pos_2gram.isEmpty()) {
            IOUtil.printFile(this.m_lemma_pos_2gram, String.valueOf(lexiconDir) + File.separator + "lemma_pos_2gram.txt");
            System.out.print(".");
        }
        if (!this.m_lemma_lemma_2gram.isEmpty()) {
            IOUtil.printFile(this.m_lemma_lemma_2gram, String.valueOf(lexiconDir) + File.separator + "lemma_lemma_2gram.txt");
            System.out.print(".");
        }
        if (!this.m_pos_pos_pos_3gram.isEmpty()) {
            IOUtil.printFile(this.m_pos_pos_pos_3gram, String.valueOf(lexiconDir) + File.separator + "pos_pos_pos_3gram.txt");
            System.out.print(".");
        }
        if (!this.m_punctuation.isEmpty()) {
            IOUtil.printFile(this.m_punctuation, String.valueOf(lexiconDir) + File.separator + "punctuation.txt");
            System.out.print(".");
        }
        if (!this.m_pos_pos_dep_rule.isEmpty()) {
            this.saveRules(this.m_pos_pos_dep_rule, String.valueOf(lexiconDir) + File.separator + "pos_pos_rule.txt", 1);
            System.out.print(".");
        }
        if (!this.m_chunk_pos.isEmpty()) {
            IOUtil.printFile(this.m_chunk_pos, String.valueOf(lexiconDir) + File.separator + "chunk_pos.txt");
            System.out.print(".");
        }
    }

    private void saveRules(ObjectIntOpenHashMap<String> map, String filename, int cutoff) {
        PrintStream fout = IOUtil.createPrintFileStream(filename);
        for (ObjectCursor key : map.keySet()) {
            int value = map.get((String)key.value);
            if (Math.abs(value) <= cutoff) continue;
            if (value < 0) {
                fout.println(String.valueOf((String)key.value) + " " + "-1");
                continue;
            }
            if (value <= 0) continue;
            fout.println(String.valueOf((String)key.value) + " " + "1");
        }
        fout.close();
    }

    public void addLabel(String label) {
        this.m_label.put(label, 1);
    }

    public void addForm(String form) {
        this.m_form.put(form, 1);
    }

    public void addLemma(String lemma) {
        this.m_lemma.put(lemma, 1);
    }

    public void addPos(String pos) {
        this.m_pos.put(pos, 1);
    }

    public void addDeprel(String deprel) {
        this.m_deprel.put(deprel, 1);
    }

    public void addPosLemma1gram(String posLemma) {
        this.m_pos_lemma_1gram.put(posLemma, 1);
    }

    public void addPosPos2gram(String posPos) {
        this.m_pos_pos_2gram.put(posPos, 1);
    }

    public void addPosLemma2gram(String posLemma) {
        this.m_pos_lemma_2gram.put(posLemma, 1);
    }

    public void addLemmaPos2gram(String lemmaPos) {
        this.m_lemma_pos_2gram.put(lemmaPos, 1);
    }

    public void addLemmaLemma2gram(String lemmaLemma) {
        this.m_lemma_lemma_2gram.put(lemmaLemma, 1);
    }

    public void addPosPosPos3gram(String posPosPos) {
        this.m_pos_pos_pos_3gram.put(posPosPos, 1);
    }

    public void addPunctuation(String punctuation) {
        this.m_punctuation.put(punctuation, 1);
    }

    public void addChunkPos(String pos) {
        this.m_chunk_pos.put(pos, 1);
    }

    public void addPosPosDepRule(DepNode left, DepNode right, int dir) {
        String rule = String.valueOf(left.pos) + "_" + right.pos;
        int value = this.m_pos_pos_dep_rule.get(rule) + dir;
        this.m_pos_pos_dep_rule.put(rule, value);
    }

    public String indexToLabel(int index) {
        return this.a_label.get(index);
    }

    public int labelToIndex(String label) {
        return this.m_label.get(label) - 1;
    }

    public int formToIndex(String form) {
        return this.m_form.get(form);
    }

    public int lemmaToIndex(String lemma) {
        return this.m_lemma.get(lemma);
    }

    public int posToIndex(String pos) {
        return this.m_pos.get(pos);
    }

    public int deprelToIndex(String deprel) {
        return this.m_deprel.get(deprel);
    }

    public int posLemma1gramToIndex(String posLemma) {
        return this.m_pos_lemma_1gram.get(posLemma);
    }

    public int posPos2gramToIndex(String posPos) {
        return this.m_pos_pos_2gram.get(posPos);
    }

    public int posLemma2gramToIndex(String posLemma) {
        return this.m_pos_lemma_2gram.get(posLemma);
    }

    public int lemmaPos2gramToIndex(String lemmaPos) {
        return this.m_lemma_pos_2gram.get(lemmaPos);
    }

    public int lemmaLemma2gramToIndex(String lemmaLemma) {
        return this.m_lemma_lemma_2gram.get(lemmaLemma);
    }

    public int posPosPos3gramToIndex(String posPosPos) {
        return this.m_pos_pos_pos_3gram.get(posPosPos);
    }

    public int punctuationToIndex(String punctuation) {
        return this.m_punctuation.get(punctuation);
    }

    public int getPosPosDepRule(String posPos) {
        return this.m_pos_pos_dep_rule.get(posPos);
    }

    public int chunkPosToIndex(String pos) {
        return this.m_chunk_pos.get(pos);
    }

    protected int getFreq(ObjectIntOpenHashMap<String> map, String key) {
        return map.containsKey(key) ? map.get(key) + 1 : 1;
    }
}

