/*
 * Decompiled with CFR 0.152.
 */
package clear.reader;

import clear.dep.AbstractTree;
import clear.util.IOUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;

public abstract class AbstractReader<NodeType, TreeType> {
    public static final String LANG_CH = "ch";
    public static final String LANG_EN = "en";
    public static final String LANG_HI = "hi";
    public static final String FORMAT_RAW = "raw";
    public static final String FORMAT_POS = "pos";
    public static final String FORMAT_DEP = "dep";
    public static final String FORMAT_SRL = "srl";
    public static final String FORMAT_CONLL = "conll";
    public static final String FIELD_DELIM = "\t";
    public static final String EMPTY_FIELD = "_";
    protected BufferedReader f_in;

    public AbstractReader(String filename) {
        this.open(filename);
    }

    public void open(String filename) {
        this.f_in = IOUtil.createBufferedFileReader(filename);
    }

    public void close() {
        try {
            this.f_in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean isSkip(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        return !tok.hasMoreTokens();
    }

    protected boolean appendNextTree(AbstractTree<NodeType> tree) throws IOException {
        String line;
        while ((line = this.f_in.readLine()) != null) {
            if (!this.isSkip(line)) break;
        }
        if (line == null) {
            this.close();
            return false;
        }
        int id = tree.size();
        tree.add(this.toNode(line, id++));
        while ((line = this.f_in.readLine()) != null) {
            if (this.isSkip(line)) {
                tree.trimToSize();
                return true;
            }
            tree.add(this.toNode(line, id++));
        }
        tree.trimToSize();
        return true;
    }

    public abstract TreeType nextTree();

    protected abstract NodeType toNode(String var1, int var2);
}

