/*
 * Decompiled with CFR 0.152.
 */
package clear.reader;

import clear.dep.DepNode;
import clear.dep.DepTree;
import clear.morph.MorphEnAnalyzer;
import clear.reader.AbstractReader;
import java.io.IOException;

public class PosReader
extends AbstractReader<DepNode, DepTree> {
    private MorphEnAnalyzer morph_analyzer = null;

    public PosReader(String filename, String language, String morphDictDir) {
        super(filename);
        if (language.equals("en")) {
            this.morph_analyzer = new MorphEnAnalyzer(morphDictDir);
        }
    }

    @Override
    public DepTree nextTree() {
        DepTree tree = new DepTree();
        boolean isNext = false;
        try {
            isNext = this.appendNextTree(tree);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isNext ? tree : null;
    }

    @Override
    protected DepNode toNode(String line, int id) {
        DepNode node = new DepNode();
        String[] str = line.split("\t");
        node.id = id;
        node.form = str[0];
        node.pos = str[1];
        node.lemma = this.morph_analyzer != null ? this.morph_analyzer.getLemma(node.form, node.pos) : node.form;
        return node;
    }
}

