/*
 * Decompiled with CFR 0.152.
 */
package clear.treebank;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.StringTokenizer;

public class TBNode {
    public String form = null;
    public String pos;
    public HashSet<String> tags = null;
    public int coIndex = -1;
    public int gapIndex = -1;
    public int terminalId = -1;
    public int tokenId = -1;
    public int headId = -1;
    public int childId = -1;
    protected TBNode nd_parent;
    protected ArrayList<TBNode> ls_children;

    public TBNode(TBNode parent, String postag) {
        this.nd_parent = parent;
        this.ls_children = null;
        this.init(postag);
    }

    private void init(String postag) {
        if (postag.matches("-([A-Z])+-")) {
            this.pos = postag;
            return;
        }
        StringTokenizer tok = new StringTokenizer(postag, "-=", true);
        this.pos = tok.nextToken();
        while (tok.hasMoreTokens()) {
            String op = tok.nextToken();
            if (op.equals("=")) {
                if (!tok.hasMoreTokens()) break;
                this.gapIndex = Integer.parseInt(tok.nextToken());
                continue;
            }
            if (!op.equals("-")) continue;
            if (!tok.hasMoreTokens()) break;
            String tag = tok.nextToken();
            if (tag.matches("\\d*")) {
                this.coIndex = Integer.parseInt(tag);
                continue;
            }
            if (this.tags == null) {
                this.tags = new HashSet();
            }
            this.tags.add(tag);
        }
    }

    public boolean isForm(String form) {
        return this.form != null && this.form.equals(form);
    }

    public boolean isRule(String rule) {
        if (rule.charAt(0) == '-') {
            return this.isTag(rule.substring(1));
        }
        return this.isPos(rule);
    }

    public boolean isPos(String rule) {
        return this.pos.matches(rule);
    }

    public boolean isTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public boolean isEmptyCategory() {
        return this.pos.equals("-NONE-");
    }

    public boolean isEmptyCategoryRec() {
        return this.isEmptyCategoryRec(this);
    }

    private boolean isEmptyCategoryRec(TBNode curr) {
        if (!curr.isPhrase()) {
            return curr.isEmptyCategory();
        }
        for (TBNode child : curr.getChildren()) {
            if (this.isEmptyCategoryRec(child)) continue;
            return false;
        }
        return true;
    }

    public boolean isPhrase() {
        return this.ls_children != null;
    }

    public boolean containsPos(String pos) {
        if (!this.isPhrase()) {
            return false;
        }
        for (TBNode child : this.ls_children) {
            if (!child.isPos(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTag(String tag) {
        if (!this.isPhrase()) {
            return false;
        }
        for (TBNode child : this.ls_children) {
            if (!child.isTag(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean containsGap() {
        if (!this.isPhrase()) {
            return false;
        }
        for (TBNode child : this.ls_children) {
            if (child.gapIndex == -1) continue;
            return true;
        }
        return false;
    }

    public TBNode getGapNode(int index) {
        return this.getGapNodeAux(index, this);
    }

    private TBNode getGapNodeAux(int index, TBNode curr) {
        if (!curr.isPhrase()) {
            return null;
        }
        for (TBNode child : curr.getChildren()) {
            if (child.coIndex == index || child.gapIndex == index) {
                return curr;
            }
            TBNode node = this.getGapNodeAux(index, child);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public int countsPos(String pos) {
        if (!this.isPhrase()) {
            return 0;
        }
        int count = 0;
        for (TBNode child : this.ls_children) {
            if (!child.isPos(pos)) continue;
            ++count;
        }
        return count;
    }

    public TBNode getParent() {
        return this.nd_parent;
    }

    public ArrayList<TBNode> getChildren() {
        return this.ls_children;
    }

    public void setForm(String form) {
        form = form.replaceAll("-LRB-", "(");
        form = form.replaceAll("-LSB-", "[");
        form = form.replaceAll("-LCB-", "{");
        form = form.replaceAll("-RRB-", ")");
        form = form.replaceAll("-RSB-", "]");
        this.form = form = form.replaceAll("-RCB-", "}");
    }

    public void setParent(TBNode parent) {
        this.nd_parent = parent;
    }

    public void addChild(TBNode child) {
        if (this.ls_children == null) {
            this.ls_children = new ArrayList();
        }
        child.childId = this.ls_children.size();
        this.ls_children.add(child);
    }

    public String toWords() {
        return this.toWordsAux(this);
    }

    private String toWordsAux(TBNode curr) {
        if (curr.isPhrase()) {
            StringBuilder build = new StringBuilder();
            for (TBNode child : curr.getChildren()) {
                build.append(this.toWordsAux(child));
                build.append(" ");
            }
            return build.toString().trim();
        }
        return curr.form;
    }

    public String toPosTags() {
        StringBuilder build = new StringBuilder();
        for (TBNode child : this.ls_children) {
            build.append(child.pos);
            build.append(" ");
        }
        return build.toString();
    }

    public BitSet getSubTerminalBitSet() {
        BitSet set = new BitSet();
        this.getSubTerminalBitSetAux(this, set);
        return set;
    }

    private void getSubTerminalBitSetAux(TBNode node, BitSet set) {
        if (node.getChildren() == null) {
            set.set(node.terminalId);
        } else {
            for (TBNode child : node.getChildren()) {
                this.getSubTerminalBitSetAux(child, set);
            }
        }
    }

    public BitSet getSubTokenBitSet(int offset) {
        BitSet set = new BitSet();
        this.getSubTokenBitSetAux(this, set, offset);
        return set;
    }

    private void getSubTokenBitSetAux(TBNode node, BitSet set, int offset) {
        if (node.getChildren() == null) {
            int tokenIndex = node.tokenId + offset;
            if (tokenIndex >= offset) {
                set.set(tokenIndex);
            }
        } else {
            for (TBNode child : node.getChildren()) {
                this.getSubTokenBitSetAux(child, set, offset);
            }
        }
    }
}

