/*
 * Decompiled with CFR 0.152.
 */
package clear.treebank;

import clear.treebank.TBNode;
import clear.treebank.TBTree;
import clear.util.JFileTokenizer;

public class TBReader {
    public static final String LRB = "(";
    public static final String RRB = ")";
    private JFileTokenizer f_tree;

    public TBReader(String treeFile) {
        String delim = "() \t\n\r\f";
        this.f_tree = new JFileTokenizer(treeFile, delim, true);
    }

    public TBTree nextTree() {
        TBNode head;
        String str;
        do {
            if ((str = this.nextToken()) != null) continue;
            this.f_tree.close();
            return null;
        } while (!str.equals(LRB));
        int numBracket = 1;
        int terminalIndex = 0;
        int tokenIndex = 0;
        TBTree tree = new TBTree();
        TBNode curr = head = new TBNode(null, "DUMMY");
        while (true) {
            TBNode node;
            if ((str = this.nextToken()) == null) {
                this.errorMsg("more token needed");
            }
            if (numBracket == 1 && str.equals("TOP")) {
                node = new TBNode(curr, str);
                curr.addChild(node);
                curr = node;
                continue;
            }
            if (str.equals(LRB)) {
                ++numBracket;
                str = this.nextToken();
                if (str == null) {
                    this.errorMsg("POS-tag is missing");
                }
                node = new TBNode(curr, str);
                curr.addChild(node);
                curr = node;
                continue;
            }
            if (str.equals(RRB)) {
                curr = curr.getParent();
                if (--numBracket != 0) continue;
                break;
            }
            curr.setForm(str);
            curr.headId = terminalIndex++;
            curr.terminalId = curr.headId;
            if (!curr.isEmptyCategory()) {
                curr.tokenId = tokenIndex++;
            }
            tree.addTerminal(curr);
        }
        TBNode root = head.getChildren().get(0);
        root.setParent(null);
        tree.setRoot(root);
        return tree;
    }

    private String nextToken() {
        while (this.f_tree.hasMoreTokens()) {
            String str = this.f_tree.nextToken();
            if (" \t\n\r\f".indexOf(str) != -1) continue;
            return str;
        }
        return null;
    }

    private void errorMsg(String msg) {
        System.err.println("error: " + msg + " (line: " + this.f_tree.getLineNumber() + RRB);
        System.exit(1);
    }
}

