/*
 * Decompiled with CFR 0.152.
 */
package clear.treebank;

import clear.treebank.TBNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

public class TBTree {
    private TBNode nd_root;
    private TBNode nd_curr;
    private ArrayList<TBNode> ls_terminal = new ArrayList();

    public void setRoot(TBNode root) {
        this.nd_root = this.nd_curr = root;
    }

    public void addTerminal(TBNode node) {
        this.ls_terminal.add(node);
    }

    public TBNode getRootNode() {
        return this.nd_root;
    }

    public TBNode getCurrNode() {
        return this.nd_curr;
    }

    public TBNode getAntecedent(int coIndex) {
        return this.getAntecedentAux(this.nd_root, coIndex);
    }

    public TBNode getAntecedentAux(TBNode curr, int coIndex) {
        if (curr.coIndex == coIndex) {
            return curr;
        }
        if (!curr.isPhrase()) {
            return null;
        }
        for (TBNode child : curr.getChildren()) {
            TBNode node = this.getAntecedentAux(child, coIndex);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public ArrayList<TBNode> getTerminalNodes() {
        return this.ls_terminal;
    }

    public BitSet getSubTerminalIndices() {
        return this.nd_curr.getSubTerminalBitSet();
    }

    public BitSet getSubTokenIndiced(int offset) {
        return this.nd_curr.getSubTokenBitSet(offset);
    }

    public HashSet<String> getAllPos() {
        HashSet<String> set = new HashSet<String>();
        this.getAllPosAux(this.nd_root, set);
        return set;
    }

    private void getAllPosAux(TBNode curr, HashSet<String> set) {
        set.add(curr.pos);
        if (curr.isPhrase()) {
            for (TBNode child : curr.getChildren()) {
                this.getAllPosAux(child, set);
            }
        }
    }

    public boolean moveTo(int terminalIndex, int height) {
        if (this.moveToTerminal(terminalIndex)) {
            return this.moveToAncestor(height);
        }
        return false;
    }

    public boolean moveToTerminal(int terminalIndex) {
        for (TBNode node : this.ls_terminal) {
            if (node.terminalId != terminalIndex) continue;
            this.nd_curr = node;
            return true;
        }
        return false;
    }

    public boolean moveToAncestor(int height) {
        TBNode tmp = this.nd_curr;
        while (height > 0) {
            if (tmp.getParent() == null) {
                return false;
            }
            tmp = tmp.getParent();
            --height;
        }
        this.nd_curr = tmp;
        return true;
    }
}

