/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIndexedContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.hash.ObjectHashFunction;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType> {
    public static final int DEFAULT_CAPACITY = 5;
    private static final Object EMPTY = Intrinsics.newKTypeArray(0);
    public KType[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;
    public final ObjectHashFunction<? super KType> hashFunction;

    public ObjectArrayList() {
        this(5);
    }

    public ObjectArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        this(initialCapacity, resizer, new ObjectHashFunction());
    }

    public ObjectArrayList(int initialCapacity, ArraySizingStrategy resizer, ObjectHashFunction<? super KType> hashFunction) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        assert (hashFunction != null);
        this.hashFunction = hashFunction;
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public ObjectArrayList(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public final void add(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public final void add(KType[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    @Override
    public final void add(KType ... elements) {
        this.add(elements, 0, elements.length);
    }

    public final int addAll(ObjectContainer<? extends KType> container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (ObjectCursor<KType> objectCursor : container) {
            this.add((KType)objectCursor.value);
        }
        return size;
    }

    @Override
    public final void insert(int index, KType e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public final KType get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public final KType set(int index, KType e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        KType v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public final KType remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        KType v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = Intrinsics.defaultKTypeValue();
        return v;
    }

    @Override
    public final void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count, Intrinsics.defaultKTypeValue());
    }

    @Override
    public final int removeFirstOccurrence(KType e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public final int removeLastOccurrence(KType e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public final int removeAllOccurrences(KType e1) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (Intrinsics.equals(e1, this.buffer[from])) {
                this.buffer[from] = Intrinsics.defaultKTypeValue();
                continue;
            }
            if (to != from) {
                this.buffer[to] = this.buffer[from];
                this.buffer[from] = Intrinsics.defaultKTypeValue();
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public final boolean contains(KType e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public final int indexOf(KType e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (!Intrinsics.equals(e1, this.buffer[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(KType e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (!Intrinsics.equals(e1, this.buffer[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            Object[] newBuffer = (Object[])Intrinsics.newKTypeArray(newSize);
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                Arrays.fill(this.buffer, null);
            }
            this.buffer = newBuffer;
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, Intrinsics.defaultKTypeValue());
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, Intrinsics.defaultKTypeValue());
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public final int size() {
        return this.elementsCount;
    }

    public final void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public final void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, null);
        this.elementsCount = 0;
    }

    public final void release() {
        this.clear();
        Arrays.fill(this.buffer, null);
        this.buffer = (Object[])EMPTY;
    }

    @Override
    public final KType[] toArray() {
        Object[] cloned = (Object[])Intrinsics.newKTypeArray(this.elementsCount);
        System.arraycopy(this.buffer, 0, cloned, 0, this.elementsCount);
        return cloned;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + this.hashFunction.hash(this.buffer[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ObjectArrayList) {
                ObjectArrayList other = (ObjectArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof ObjectIndexedContainer) {
                ObjectIndexedContainer other = (ObjectIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(KType[] b1, KType[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (Intrinsics.equals(b1[i], b2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(ObjectIndexedContainer<KType> b1, ObjectIndexedContainer<KType> b2, int length) {
        for (int i = 0; i < length; ++i) {
            KType o2;
            KType o1 = b1.get(i);
            if (Intrinsics.equals(o1, o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator<KType>(this.buffer, 0, this.size() - 1);
    }

    @Override
    public void forEach(ObjectProcedure<? super KType> procedure) {
        this.forEach(procedure, 0, this.size());
    }

    public void forEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        KType[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = Intrinsics.defaultKTypeValue();
                    continue;
                }
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = Intrinsics.defaultKTypeValue();
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = Intrinsics.defaultKTypeValue();
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public void forEach(ObjectPredicate<? super KType> predicate) {
        this.forEach(predicate, 0, this.size());
    }

    public void forEach(ObjectPredicate<? super KType> predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        KType[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
    }

    public static <KType> ObjectArrayList<KType> from(KType ... elements) {
        ObjectArrayList<KType> list = new ObjectArrayList<KType>(elements.length);
        list.add(elements);
        return list;
    }

    public static <KType> ObjectArrayList<KType> from(ObjectContainer<KType> container) {
        return new ObjectArrayList<KType>(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ValueIterator<KType>
    implements Iterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int lastIndex;
        private final KType[] buffer;

        public ValueIterator(KType[] buffer, int startIndex, int endIndex) {
            this.buffer = buffer;
            this.cursor = new ObjectCursor();
            this.cursor.index = startIndex - 1;
            this.lastIndex = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.index < this.lastIndex;
        }

        @Override
        public ObjectCursor<KType> next() {
            assert (this.cursor.index <= this.lastIndex);
            ++this.cursor.index;
            this.cursor.value = this.buffer[this.cursor.index];
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

