/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.Intrinsics;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.ObjectSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.hash.ObjectHashFunction;
import com.carrotsearch.hppc.hash.ObjectMurmurHash;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOpenHashSet<KType>
extends AbstractObjectCollection<KType>
implements ObjectLookupContainer<KType>,
ObjectSet<KType> {
    private static final Comparator<Object> EQUALS_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return Intrinsics.equals(o1, o2) ? 0 : 1;
        }
    };
    public static final int DEFAULT_CAPACITY = 16;
    public static final int MIN_CAPACITY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final byte EMPTY = 0;
    public static final byte DELETED = 1;
    public static final byte ASSIGNED = 2;
    public KType[] keys;
    public byte[] states;
    public int deleted;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;
    public final ObjectHashFunction<? super KType> hashFunction;
    public final Comparator<? super KType> keyComparator;

    public ObjectOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjectOpenHashSet(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, new ObjectMurmurHash(), EQUALS_COMPARATOR);
    }

    public ObjectOpenHashSet(ObjectContainer<KType> container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    public ObjectOpenHashSet(int initialCapacity, float loadFactor, ObjectHashFunction<? super KType> hashFunction, Comparator<? super KType> keyComparator) {
        initialCapacity = Math.max(4, initialCapacity);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor < 1.0f) : "Load factor must be between (0, 1).";
        assert (hashFunction != null) : "Hash function must not be null.";
        assert (keyComparator != null) : "Key comparator must not be null.";
        this.keyComparator = keyComparator;
        this.hashFunction = hashFunction;
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    @Override
    public boolean add(KType e) {
        int slot;
        byte state;
        if (this.assigned + this.deleted >= this.resizeThreshold) {
            this.expandAndRehash();
        }
        if ((state = this.states[slot = this.slotFor(e)]) != 2) {
            ++this.assigned;
        }
        if (state == 1) {
            --this.deleted;
        }
        this.keys[slot] = e;
        this.states[slot] = 2;
        return state != 2;
    }

    public int add(KType e1, KType e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(KType ... elements) {
        int count = 0;
        for (KType e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public final int addAll(ObjectContainer<? extends KType> container) {
        int count = 0;
        for (ObjectCursor<KType> objectCursor : container) {
            if (!this.add((KType)objectCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndRehash() {
        KType[] oldKeys = this.keys;
        byte[] oldStates = this.states;
        if (this.assigned >= this.resizeThreshold) {
            this.allocateBuffers(this.nextCapacity(this.keys.length));
        } else {
            this.allocateBuffers(this.keys.length);
        }
        for (int i = 0; i < oldStates.length; ++i) {
            if (oldStates[i] != 2) continue;
            int slot = this.slotFor(oldKeys[i]);
            this.keys[slot] = oldKeys[i];
            this.states[slot] = 2;
            oldKeys[i] = null;
        }
        this.deleted = 0;
        this.lastSlot = -1;
    }

    private void allocateBuffers(int capacity) {
        this.keys = (Object[])Intrinsics.newKTypeArray(capacity);
        this.states = new byte[capacity];
        this.resizeThreshold = (int)((float)capacity * 0.75f);
    }

    @Override
    public int removeAllOccurrences(KType key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(KType key) {
        int slot = this.slotFor(key);
        boolean hadEntry = false;
        if (this.states[slot] == 2) {
            ++this.deleted;
            --this.assigned;
            this.keys[slot] = Intrinsics.defaultKTypeValue();
            this.states[slot] = 1;
            hadEntry = true;
        }
        return hadEntry;
    }

    public KType lget() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        assert (this.states[this.lastSlot] == 2) : "Last call to exists did not have any associated value.";
        return this.keys[this.lastSlot];
    }

    @Override
    public boolean contains(KType key) {
        this.lastSlot = this.slotFor(key);
        int slot = this.lastSlot;
        return this.states[slot] == 2;
    }

    protected int roundCapacity(int requestedCapacity) {
        int capacity;
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        for (capacity = 4; capacity < requestedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    protected int nextCapacity(int current) {
        assert (current > 0 && Long.bitCount(current) == 1) : "Capacity must be a power of two.";
        assert (current << 1 > 0) : "Maximum capacity exceeded (1073741824).";
        if (current < 2) {
            current = 2;
        }
        return current << 1;
    }

    public int slotFor(KType key) {
        int slots = this.states.length;
        int bucketMask = slots - 1;
        int slot = this.hashFunction.hash(key) & bucketMask;
        int i = 0;
        int deletedSlot = -1;
        byte state;
        while ((state = this.states[slot]) != 0) {
            if (state == 2 && this.keyComparator.compare(this.keys[slot], key) == 0) {
                return slot;
            }
            if (state == 1 && deletedSlot < 0) {
                deletedSlot = slot;
            }
            slot = slot + ++i & bucketMask;
        }
        return deletedSlot != -1 ? deletedSlot : slot;
    }

    @Override
    public void clear() {
        this.deleted = 0;
        this.assigned = 0;
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.keys, Intrinsics.defaultKTypeValue());
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        KType[] keys = this.keys;
        byte[] states = this.states;
        int i = states.length;
        while (--i >= 0) {
            if (states[i] != 2) continue;
            h += this.hashFunction.hash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            ObjectSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof ObjectSet && (other = (ObjectSet)obj).size() == this.size()) {
                for (ObjectCursor<KType> c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public void forEach(ObjectProcedure<? super KType> procedure) {
        KType[] keys = this.keys;
        byte[] states = this.states;
        for (int i = 0; i < states.length; ++i) {
            if (states[i] != 2) continue;
            procedure.apply(keys[i]);
        }
    }

    @Override
    public final KType[] toArray() {
        Object[] cloned = (Object[])Intrinsics.newKTypeArray(this.assigned);
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.states[i] != 2) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    @Override
    public void forEach(ObjectPredicate<? super KType> predicate) {
        KType[] keys = this.keys;
        byte[] states = this.states;
        for (int i = 0; i < states.length && (states[i] != 2 || predicate.apply(keys[i])); ++i) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        KType[] keys = this.keys;
        byte[] states = this.states;
        int deleted = 0;
        try {
            for (int i = 0; i < states.length; ++i) {
                if (states[i] != 2 || !predicate.apply(keys[i])) continue;
                states[i] = 1;
                ++deleted;
            }
            int n = deleted;
            return n;
        }
        finally {
            this.assigned -= deleted;
            this.deleted += deleted;
        }
    }

    public static <KType> ObjectOpenHashSet<KType> from(KType ... elements) {
        ObjectOpenHashSet<KType> set = new ObjectOpenHashSet<KType>((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static <KType> ObjectOpenHashSet<KType> from(ObjectContainer<KType> container) {
        return new ObjectOpenHashSet<KType>(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<ObjectCursor<KType>> {
        private static final int NOT_CACHED = -1;
        private static final int AT_END = -2;
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int nextIndex = -1;

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex == -1) {
                int i;
                for (i = this.cursor.index + 1; i < ObjectOpenHashSet.this.keys.length && ObjectOpenHashSet.this.states[i] != 2; ++i) {
                }
                this.nextIndex = i != ObjectOpenHashSet.this.keys.length ? i : -2;
            }
            return this.nextIndex != -2;
        }

        @Override
        public ObjectCursor<KType> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor.index = this.nextIndex;
            this.cursor.value = ObjectOpenHashSet.this.keys[this.nextIndex];
            this.nextIndex = -1;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

