/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.ctakes.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.uima.tools.cpm.CpmPanel;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.util.gui.AboutDialog;
import org.apache.uima.tools.util.gui.FileChooserBugWorkarounds;

public class cTAKESCPEGUI
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -8629700163984805288L;
    private CpmPanel cpmPanel;
    private JMenuBar menuBar;
    private JMenuItem exitMenuItem;
    private JMenuItem aboutMenuItem;
    private JMenuItem helpMenuItem;
    private JDialog aboutDialog;

    public cTAKESCPEGUI() {
        super("cTAKES Collection Processing Engine Configurator");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not set look and feel: " + e.getMessage());
        }
        FileChooserBugWorkarounds.fix();
        try {
            this.setIconImage(Images.getImage("/org/apache/uima/tools/images/Micro_16.gif"));
        }
        catch (IOException e) {
            System.err.println("Image could not be loaded: " + e.getMessage());
        }
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().setLayout(new BorderLayout());
        JLabel banner = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_banner.png"));
        this.getContentPane().add((Component)banner, "North");
        this.cpmPanel = new CpmPanel();
        this.getContentPane().add((Component)this.cpmPanel, "Center");
        this.setJMenuBar(this.createMenuBar());
        this.aboutDialog = new AboutDialog(this, "About cTAKES Collection Processing Engine Configurator");
        this.setSize(800, 600);
        this.pack();
    }

    private JMenuBar createMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        List fileMenuItems = this.cpmPanel.createFileMenuItems();
        Iterator iter = fileMenuItems.iterator();
        while (iter.hasNext()) {
            fileMenu.add((JMenuItem)iter.next());
        }
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(this);
        fileMenu.add(this.exitMenuItem);
        JMenu viewMenu = new JMenu("View");
        List viewMenuItems = this.cpmPanel.createViewMenuItems();
        iter = viewMenuItems.iterator();
        while (iter.hasNext()) {
            viewMenu.add((JMenuItem)iter.next());
        }
        JMenu helpMenu = new JMenu("Help");
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.addActionListener(this);
        this.helpMenuItem = new JMenuItem("Help");
        this.helpMenuItem.addActionListener(this);
        helpMenu.add(this.aboutMenuItem);
        helpMenu.add(this.helpMenuItem);
        this.menuBar.add(fileMenu);
        this.menuBar.add(viewMenu);
        this.menuBar.add(helpMenu);
        return this.menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.aboutMenuItem) {
            this.aboutDialog.setVisible(true);
        } else if (source == this.helpMenuItem) {
            JOptionPane.showMessageDialog(this, "Instructions for using UIMA Collection Processing Engine Configurator:\n\nSelect a Collection Reader descriptor using the Browse button in the topmost panel.\n\nOn the Analyis Engines panel and the CAS Consumers panel, use the Add button to select Analysis Engine (AE) \nand CAS Consumer descriptors.\n\nPress the Play button to start collection processing.\nA progress bar in the lower left corner of the window will indicate the processing progress.\nWhen running, you may use the Pause or Stop button to pause or stop the processing.\n\nThe File menu contains options for opening and saving CPE descriptors.\n\nThe View menu contains an option to display the CAS Initializer panel.  CAS Initializers are deprecated \nsince UIMA version 2.0, but are still supported by this tool.", "Collection Processing Engine Configurator Help", -1);
        } else if (source == this.exitMenuItem) {
            this.processWindowEvent(new WindowEvent(this, 201));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(screenSize.width, screenSize.height - 65);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                cTAKESCPEGUI.initGUI();
            }
        });
    }

    private static void initGUI() {
        try {
            cTAKESCPEGUI frame = new cTAKESCPEGUI();
            frame.setDefaultCloseOperation(0);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (cTAKESCPEGUI.this.cpmPanel.confirmExit()) {
                        System.exit(0);
                    }
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    cTAKESCPEGUI.this.cpmPanel.checkForOutOfSyncFiles();
                }
            });
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

