/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.dictionary;

import edu.mayo.bmi.dictionary.Dictionary;
import edu.mayo.bmi.dictionary.DictionaryException;
import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.dictionary.filter.CollectionFilter;
import edu.mayo.bmi.dictionary.filter.FilterException;
import edu.mayo.bmi.dictionary.filter.PostLookupFilter;
import edu.mayo.bmi.dictionary.filter.PreLookupFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DictionaryEngine {
    private Dictionary iv_dict;
    private List iv_preLookupFilterList = new ArrayList();
    private List iv_postLookupFilterList = new ArrayList();
    private List iv_collectionFilterList = new ArrayList();
    private Map iv_binaryLookupCacheMap = new HashMap();
    private Map iv_metaLookupCacheMap = new HashMap();
    private boolean iv_keepCase = false;

    public DictionaryEngine(Dictionary dict, boolean keepCase) {
        this.iv_dict = dict;
        this.iv_keepCase = keepCase;
    }

    public void addPreLookupFilter(PreLookupFilter plf) {
        this.iv_preLookupFilterList.add(plf);
    }

    public void addPostLookupFilter(PostLookupFilter plf) {
        this.iv_postLookupFilterList.add(plf);
    }

    public void addCollectionFilter(CollectionFilter cf) {
        this.iv_collectionFilterList.add(cf);
    }

    public void addCacheEntry(String text) throws DictionaryException, FilterException {
        if (!this.iv_keepCase) {
            text = text.toLowerCase();
        }
        boolean isHit = this.binaryLookup(text);
        this.iv_binaryLookupCacheMap.put(text, new Boolean(isHit));
        Collection c = this.metaLookup(text);
        this.iv_metaLookupCacheMap.put(text, c);
    }

    public Collection metaLookup(String text) throws DictionaryException, FilterException {
        if (!this.iv_keepCase) {
            text = text.toLowerCase();
        }
        if (this.isFilteredByPreLookup(text)) {
            return new HashSet();
        }
        Collection metaDataHitCol = null;
        boolean isCached = this.iv_metaLookupCacheMap.containsKey(text);
        metaDataHitCol = isCached ? (Collection)this.iv_metaLookupCacheMap.get(text) : this.iv_dict.getEntries(text);
        if (this.iv_postLookupFilterList.size() > 0) {
            HashSet<MetaDataHit> mdhRemovalSet = new HashSet<MetaDataHit>();
            for (MetaDataHit mdh : metaDataHitCol) {
                for (PostLookupFilter plf : this.iv_postLookupFilterList) {
                    if (!plf.contains(mdh)) continue;
                    mdhRemovalSet.add(mdh);
                }
            }
            metaDataHitCol.removeAll(mdhRemovalSet);
        }
        if (this.iv_collectionFilterList.size() > 0) {
            for (CollectionFilter cf : this.iv_collectionFilterList) {
                metaDataHitCol = cf.applyFilter(metaDataHitCol);
            }
        }
        return metaDataHitCol;
    }

    public boolean binaryLookup(String text) throws DictionaryException, FilterException {
        if (!this.iv_keepCase) {
            text = text.toLowerCase();
        }
        if (this.isFilteredByPreLookup(text)) {
            return false;
        }
        Boolean isHit = null;
        boolean isCached = this.iv_binaryLookupCacheMap.containsKey(text);
        isHit = isCached ? (Boolean)this.iv_binaryLookupCacheMap.get(text) : new Boolean(this.iv_dict.contains(text));
        return isHit;
    }

    private boolean isFilteredByPreLookup(String text) throws FilterException {
        if (this.iv_preLookupFilterList.size() > 0) {
            for (PreLookupFilter plf : this.iv_preLookupFilterList) {
                if (!plf.contains(text)) continue;
                return true;
            }
        }
        return false;
    }
}

