/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.dictionary.filter;

import edu.mayo.bmi.dictionary.DictionaryEngine;
import edu.mayo.bmi.dictionary.DictionaryException;
import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.dictionary.filter.FilterException;
import edu.mayo.bmi.dictionary.filter.PostLookupFilter;

public class MetaDataPostLookupFilterImpl
implements PostLookupFilter {
    private String[] iv_metaFieldNames;
    private DictionaryEngine iv_dictEngine;
    private boolean iv_excludeMatches = false;

    public MetaDataPostLookupFilterImpl(DictionaryEngine dictEngine, String[] metaFieldNames, boolean excludeMatches) {
        this.iv_dictEngine = dictEngine;
        this.iv_metaFieldNames = metaFieldNames;
        this.iv_excludeMatches = excludeMatches;
    }

    @Override
    public boolean contains(MetaDataHit mdh) throws FilterException {
        String mdVal = this.getMetaDataValue(mdh);
        try {
            boolean isContained = this.iv_dictEngine.binaryLookup(mdVal);
            if (this.iv_excludeMatches) {
                return isContained;
            }
            return !isContained;
        }
        catch (DictionaryException ge) {
            throw new FilterException(ge);
        }
    }

    private String getMetaDataValue(MetaDataHit mdh) throws FilterException {
        int i = 0;
        while (i < this.iv_metaFieldNames.length) {
            String mdVal = mdh.getMetaFieldValue(this.iv_metaFieldNames[i]);
            if (mdVal != null) {
                return mdVal;
            }
            ++i;
        }
        throw new FilterException(new Exception("Unable to extract meta data from MetaDataHit object."));
    }
}

