/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.dictionary.filter;

import edu.mayo.bmi.dictionary.MetaDataHit;
import edu.mayo.bmi.dictionary.MetaDataHitConst;
import edu.mayo.bmi.dictionary.filter.FilterException;
import edu.mayo.bmi.dictionary.filter.PostLookupFilter;

public class SetValuePostLookupFilterImpl
implements PostLookupFilter,
MetaDataHitConst {
    private Object iv_value;
    private String iv_metaFieldName;
    private int iv_metaFieldType;
    private int iv_metaFieldOp;
    private boolean iv_excludeMatches = false;

    public SetValuePostLookupFilterImpl(String metaFieldName, int metaFieldType, int metaFieldOp, boolean excludeMatches) {
        this.iv_metaFieldName = metaFieldName;
        this.iv_metaFieldType = metaFieldType;
        this.iv_metaFieldOp = metaFieldOp;
        this.iv_excludeMatches = excludeMatches;
    }

    public void setValue(String value) {
        this.iv_value = this.iv_metaFieldType == 0 ? new Integer(value) : (this.iv_metaFieldType == 1 ? new Float(value) : value);
    }

    @Override
    public boolean contains(MetaDataHit mdh) throws FilterException {
        if (this.iv_value == null) {
            throw new FilterException(new Exception("Value has not been set for PostLookupFilter."));
        }
        String mdVal = this.getMetaDataValue(mdh);
        boolean isContained = this.isContained(mdVal);
        if (this.iv_excludeMatches) {
            return isContained;
        }
        return !isContained;
    }

    private boolean isContained(String mdVal) {
        if (this.iv_metaFieldType == 0) {
            Integer mdValInteger = new Integer(mdVal);
            Integer refValInteger = (Integer)this.iv_value;
            int comparison = refValInteger.compareTo(mdValInteger);
            return this.applyOp(comparison);
        }
        if (this.iv_metaFieldType == 1) {
            Float mdValFloat = new Float(mdVal);
            Float refValFloat = (Float)this.iv_value;
            int comparison = refValFloat.compareTo(mdValFloat);
            return this.applyOp(comparison);
        }
        if (this.iv_metaFieldType == 2) {
            String refValStr = (String)this.iv_value;
            int comparison = refValStr.compareTo(mdVal);
            return this.applyOp(comparison);
        }
        return false;
    }

    private boolean applyOp(int comparisonVal) {
        if ((this.iv_metaFieldOp == 0 || this.iv_metaFieldOp == 2 || this.iv_metaFieldOp == 4) && comparisonVal == 0) {
            return true;
        }
        if ((this.iv_metaFieldOp == 1 || this.iv_metaFieldOp == 2) && comparisonVal > 0) {
            return true;
        }
        return (this.iv_metaFieldOp == 3 || this.iv_metaFieldOp == 4) && comparisonVal < 0;
    }

    private String getMetaDataValue(MetaDataHit mdh) throws FilterException {
        String mdVal = mdh.getMetaFieldValue(this.iv_metaFieldName);
        if (mdVal != null) {
            return mdVal;
        }
        throw new FilterException(new Exception("Unable to extract meta data from MetaDataHit object."));
    }
}

