/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.dictionary.jdbc;

import edu.mayo.bmi.dictionary.BaseDictionaryImpl;
import edu.mayo.bmi.dictionary.Dictionary;
import edu.mayo.bmi.dictionary.DictionaryException;
import edu.mayo.bmi.dictionary.GenericMetaDataHitImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class JdbcDictionaryImpl
extends BaseDictionaryImpl
implements Dictionary {
    private Connection iv_dbConn;
    private String iv_tableName;
    private String iv_lookupFieldName;
    private PreparedStatement iv_mdPrepStmt;
    private PreparedStatement iv_cntPrepStmt;

    public JdbcDictionaryImpl(Connection conn, String tableName, String lookupFieldName) {
        this.iv_dbConn = conn;
        this.iv_tableName = tableName;
        this.iv_lookupFieldName = lookupFieldName;
    }

    private PreparedStatement initCountPrepStmt(String text) throws SQLException {
        if (this.iv_cntPrepStmt == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT COUNT(*) ");
            sb.append(" FROM ");
            sb.append(this.iv_tableName);
            sb.append(" WHERE ");
            sb.append(this.iv_lookupFieldName);
            sb.append(" = ?");
            this.iv_cntPrepStmt = this.iv_dbConn.prepareStatement(sb.toString());
        }
        this.iv_cntPrepStmt.clearParameters();
        this.iv_cntPrepStmt.setString(1, text);
        return this.iv_cntPrepStmt;
    }

    private PreparedStatement initMetaDataPrepStmt(String text) throws SQLException {
        if (this.iv_mdPrepStmt == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT ");
            Iterator metaFieldNameItr = this.getMetaFieldNames();
            while (metaFieldNameItr.hasNext()) {
                String mdFieldName = (String)metaFieldNameItr.next();
                sb.append(mdFieldName);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(" FROM ");
            sb.append(this.iv_tableName);
            sb.append(" WHERE ");
            sb.append(this.iv_lookupFieldName);
            sb.append(" = ?");
            this.iv_mdPrepStmt = this.iv_dbConn.prepareStatement(sb.toString());
        }
        this.iv_mdPrepStmt.clearParameters();
        this.iv_mdPrepStmt.setString(1, text);
        return this.iv_mdPrepStmt;
    }

    @Override
    public boolean contains(String text) throws DictionaryException {
        try {
            PreparedStatement prepStmt = this.initCountPrepStmt(text);
            ResultSet rs = prepStmt.executeQuery();
            rs.next();
            int count = rs.getInt(1);
            return count > 0;
        }
        catch (SQLException e) {
            throw new DictionaryException(e);
        }
    }

    @Override
    public Collection getEntries(String str) throws DictionaryException {
        HashSet<GenericMetaDataHitImpl> metaDataHitSet = new HashSet<GenericMetaDataHitImpl>();
        try {
            PreparedStatement prepStmt = this.initMetaDataPrepStmt(str);
            ResultSet rs = prepStmt.executeQuery();
            while (rs.next()) {
                HashMap<String, String> nameValMap = new HashMap<String, String>();
                Iterator metaFieldNameItr = this.getMetaFieldNames();
                while (metaFieldNameItr.hasNext()) {
                    String metaFieldName = (String)metaFieldNameItr.next();
                    String metaFieldValue = rs.getString(metaFieldName);
                    nameValMap.put(metaFieldName, metaFieldValue);
                }
                GenericMetaDataHitImpl mdh = new GenericMetaDataHitImpl(nameValMap);
                metaDataHitSet.add(mdh);
            }
            return metaDataHitSet;
        }
        catch (SQLException e) {
            throw new DictionaryException(e);
        }
    }
}

