/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.dictionary.strtable;

import edu.mayo.bmi.dictionary.strtable.FieldConstraint;
import edu.mayo.bmi.dictionary.strtable.StringTable;
import edu.mayo.bmi.dictionary.strtable.StringTableRow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class StringTableFactory {
    public static StringTable build(Reader charReader, String delimiter, String indexedFieldName, boolean ignoreCase) throws IOException {
        return StringTableFactory.build(charReader, delimiter, indexedFieldName, null, ignoreCase);
    }

    public static StringTable build(Reader charReader, String delimiter, String indexedFieldName, FieldConstraint constraint, boolean ignoreCase) throws IOException {
        String[] indexedFieldNames = new String[]{indexedFieldName};
        return StringTableFactory.build(charReader, delimiter, indexedFieldNames, constraint, ignoreCase);
    }

    public static StringTable build(Reader charReader, String delimiter, String[] indexedFieldNames, boolean ignoreCase) throws IOException {
        return StringTableFactory.build(charReader, delimiter, indexedFieldNames, null, ignoreCase);
    }

    public static StringTable build(Reader charReader, String delimiter, String[] indexedFieldNames, FieldConstraint constraint, boolean ignoreCase) throws IOException {
        StringTable strTable = new StringTable(indexedFieldNames);
        BufferedReader br = new BufferedReader(charReader);
        String line = br.readLine();
        while (line != null) {
            StringTableRow strTableRow = new StringTableRow();
            StringTokenizer st = new StringTokenizer(line, delimiter);
            int fieldCnt = 0;
            boolean isConstrained = false;
            while (st.hasMoreTokens()) {
                String fieldName = String.valueOf(fieldCnt);
                String fieldValue = st.nextToken();
                if (ignoreCase) {
                    fieldValue = fieldValue.toLowerCase();
                }
                strTableRow.addField(fieldName, fieldValue);
                ++fieldCnt;
                if (constraint == null || !constraint.isConstrained(fieldName, fieldValue)) continue;
                isConstrained = true;
            }
            if (!isConstrained) {
                strTable.addRow(strTableRow);
            }
            line = br.readLine();
        }
        br.close();
        return strTable;
    }
}

