/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.elements;

import edu.mayo.bmi.fsm.condition.DecimalCondition;
import edu.mayo.bmi.fsm.condition.IntegerCondition;
import edu.mayo.bmi.fsm.condition.NumberCondition;
import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.SymbolValueCondition;
import edu.mayo.bmi.fsm.condition.WordSetCondition;
import edu.mayo.bmi.fsm.drugner.elements.conditions.ContainsSetTextValueCondition;
import edu.mayo.bmi.fsm.drugner.elements.conditions.RangeStrengthCondition;
import edu.mayo.bmi.fsm.drugner.output.elements.StrengthToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class StrengthFSM {
    Set iv_fullTextSet = new HashSet();
    Set iv_numberTextSet = new HashSet();
    Set iv_oneOfTwoTextSet = new HashSet();
    Set iv_twoOfTwoTextSet = new HashSet();
    private Machine iv_strengthMachine;
    private Set iv_machineSet = new HashSet();

    public StrengthFSM() {
        this.iv_numberTextSet.add("one");
        this.iv_numberTextSet.add("two");
        this.iv_numberTextSet.add("three");
        this.iv_numberTextSet.add("four");
        this.iv_numberTextSet.add("five");
        this.iv_numberTextSet.add("six");
        this.iv_numberTextSet.add("seven");
        this.iv_numberTextSet.add("eight");
        this.iv_numberTextSet.add("nine");
        this.iv_oneOfTwoTextSet.add("international");
        this.iv_twoOfTwoTextSet.add("units");
        this.iv_fullTextSet.add("micrograms");
        this.iv_fullTextSet.add("microgram");
        this.iv_fullTextSet.add("teaspoon");
        this.iv_fullTextSet.add("teaspoons");
        this.iv_fullTextSet.add("tablespoon");
        this.iv_fullTextSet.add("tablespoons");
        this.iv_fullTextSet.add("gram");
        this.iv_fullTextSet.add("grams");
        this.iv_fullTextSet.add("centigram");
        this.iv_fullTextSet.add("centigrams");
        this.iv_fullTextSet.add("milligram");
        this.iv_fullTextSet.add("milligrams");
        this.iv_fullTextSet.add("liter");
        this.iv_fullTextSet.add("liters");
        this.iv_fullTextSet.add("centiliter");
        this.iv_fullTextSet.add("centiliters");
        this.iv_fullTextSet.add("milliliter");
        this.iv_fullTextSet.add("milliliters");
        this.iv_fullTextSet.add("drop");
        this.iv_fullTextSet.add("drops");
        this.iv_fullTextSet.add("grain");
        this.iv_fullTextSet.add("grains");
        this.iv_fullTextSet.add("puffs");
        this.iv_fullTextSet.add("puff");
        this.iv_fullTextSet.add("unit");
        this.iv_fullTextSet.add("units");
        this.iv_fullTextSet.add("gtts");
        this.iv_fullTextSet.add("ui");
        this.iv_fullTextSet.add("iu");
        this.iv_fullTextSet.add("meq");
        this.iv_fullTextSet.add("mcg");
        this.iv_fullTextSet.add("gr");
        this.iv_fullTextSet.add("gm");
        this.iv_fullTextSet.add("tsp");
        this.iv_fullTextSet.add("tbsp");
        this.iv_fullTextSet.add("g");
        this.iv_fullTextSet.add("mg");
        this.iv_fullTextSet.add("dl");
        this.iv_fullTextSet.add("cl");
        this.iv_fullTextSet.add("cc");
        this.iv_fullTextSet.add("ou");
        this.iv_strengthMachine = this.getStrengthMachine();
        this.iv_machineSet.add(this.iv_strengthMachine);
    }

    private Machine getStrengthMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState connectState = new NamedState("CONNECT");
        NamedState unitState = new NamedState("UNIT");
        NamedState decimalState = new NamedState("DOT");
        NamedState complexState = new NamedState("COMPLEX");
        NamedState hyphenState = new NamedState("HYPHEN");
        endState.setEndStateFlag(true);
        startState.addTransition(new NumberCondition(), connectState);
        startState.addTransition(new IntegerCondition(), connectState);
        startState.addTransition(new DecimalCondition(), connectState);
        startState.addTransition(new RangeStrengthCondition(), connectState);
        startState.addTransition(new ContainsSetTextValueCondition(this.iv_fullTextSet, false), endState);
        startState.addTransition(new WordSetCondition(this.iv_numberTextSet, false), hyphenState);
        startState.addTransition(new AnyCondition(), startState);
        connectState.addTransition(new WordSetCondition(this.iv_fullTextSet, false), endState);
        connectState.addTransition(new PunctuationValueCondition('-'), unitState);
        connectState.addTransition(new PunctuationValueCondition('.'), decimalState);
        connectState.addTransition(new SymbolValueCondition('%'), endState);
        connectState.addTransition(new WordSetCondition(this.iv_oneOfTwoTextSet, false), complexState);
        connectState.addTransition(new ContainsSetTextValueCondition(this.iv_fullTextSet, false), endState);
        connectState.addTransition(new AnyCondition(), startState);
        decimalState.addTransition(new ContainsSetTextValueCondition(this.iv_fullTextSet, false), endState);
        decimalState.addTransition(new SymbolValueCondition('%'), endState);
        decimalState.addTransition(new NumberCondition(), complexState);
        decimalState.addTransition(new AnyCondition(), startState);
        unitState.addTransition(new WordSetCondition(this.iv_fullTextSet, false), endState);
        unitState.addTransition(new SymbolValueCondition('%'), endState);
        unitState.addTransition(new AnyCondition(), startState);
        complexState.addTransition(new PunctuationValueCondition('-'), hyphenState);
        complexState.addTransition(new WordSetCondition(this.iv_twoOfTwoTextSet, false), endState);
        complexState.addTransition(new AnyCondition(), startState);
        hyphenState.addTransition(new ContainsSetTextValueCondition(this.iv_fullTextSet, false), endState);
        hyphenState.addTransition(new WordSetCondition(this.iv_fullTextSet, false), endState);
        hyphenState.addTransition(new SymbolValueCondition('%'), endState);
        hyphenState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        Machine m = new Machine(startState);
        return m;
    }

    public Set execute(List tokens, Set overrideSet1, Set overrideSet2) throws Exception {
        Integer key;
        BaseToken t;
        HashSet<StrengthToken> measurementSet = new HashSet<StrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator overrideTokenItr1 = overrideSet1.iterator();
        Iterator overrideTokenItr2 = overrideSet2.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap1 = new HashMap<Integer, BaseToken>();
        HashMap<Integer, BaseToken> overrideTokenMap2 = new HashMap<Integer, BaseToken>();
        HashMap<Integer, Integer> overrideBeginTokenMap1 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> overrideBeginTokenMap2 = new HashMap<Integer, Integer>();
        while (overrideTokenItr1.hasNext()) {
            t = (BaseToken)overrideTokenItr1.next();
            key = new Integer(t.getStartOffset());
            overrideTokenMap1.put(key, t);
        }
        while (overrideTokenItr2.hasNext()) {
            t = (BaseToken)overrideTokenItr2.next();
            key = new Integer(t.getStartOffset());
            overrideTokenMap2.put(key, t);
        }
        boolean overrideOn1 = false;
        boolean overrideOn2 = false;
        int overrideEndOffset1 = -1;
        int overrideEndOffset2 = -1;
        int tokenOffset1 = 0;
        int tokenOffset2 = 0;
        int anchorKey1 = 0;
        int anchorKey2 = 0;
        int i = 0;
        while (i < tokens.size()) {
            block18: {
                BaseToken token;
                block17: {
                    Integer key2;
                    block19: {
                        block20: {
                            block15: {
                                block16: {
                                    token = (BaseToken)tokens.get(i);
                                    key2 = new Integer(token.getStartOffset());
                                    if (overrideOn1 && overrideOn2) {
                                        if (overrideEndOffset1 >= overrideEndOffset2) {
                                            overrideOn1 = false;
                                        } else {
                                            overrideOn2 = false;
                                        }
                                    }
                                    if (!overrideOn1) break block15;
                                    if (token.getStartOffset() < overrideEndOffset1) break block16;
                                    overrideBeginTokenMap1.put(new Integer(anchorKey1), new Integer(tokenOffset1));
                                    overrideOn1 = false;
                                    overrideEndOffset1 = -1;
                                    break block17;
                                }
                                ++tokenOffset1;
                                break block18;
                            }
                            if (!overrideOn2) break block19;
                            if (token.getStartOffset() < overrideEndOffset2) break block20;
                            overrideBeginTokenMap2.put(new Integer(anchorKey2), new Integer(tokenOffset2));
                            overrideOn2 = false;
                            overrideEndOffset2 = -1;
                            break block17;
                        }
                        ++tokenOffset2;
                        break block18;
                    }
                    if (overrideTokenMap1.containsKey(key2)) {
                        anchorKey1 = key2;
                        token = (BaseToken)overrideTokenMap1.get(key2);
                        overrideOn1 = true;
                        overrideEndOffset1 = token.getEndOffset();
                        tokenOffset1 = 0;
                    }
                    if (overrideTokenMap2.containsKey(key2)) {
                        anchorKey2 = key2;
                        token = (BaseToken)overrideTokenMap2.get(key2);
                        overrideOn2 = true;
                        overrideEndOffset2 = token.getEndOffset();
                        tokenOffset2 = 0;
                    }
                }
                for (Machine fsm : this.iv_machineSet) {
                    int tokenStartIndex;
                    fsm.input(token);
                    State currentState = fsm.getCurrentState();
                    if (currentState.getStartStateFlag()) {
                        tokenStartMap.put(fsm, new Integer(i));
                        tokenOffset1 = 0;
                        tokenOffset2 = 0;
                    }
                    if (!currentState.getEndStateFlag()) continue;
                    Object o = tokenStartMap.get(fsm);
                    int globalOffset = 0;
                    if (o == null) {
                        tokenStartIndex = 0;
                    } else {
                        Integer offSet;
                        Integer tokenMap1 = new Integer(0);
                        Integer tokenMap2 = new Integer(0);
                        BaseToken lookUpOffset = (BaseToken)tokens.get((Integer)o);
                        if (overrideBeginTokenMap1.get(new Integer(lookUpOffset.getStartOffset())) != null) {
                            offSet = (Integer)overrideBeginTokenMap1.get(new Integer(lookUpOffset.getStartOffset()));
                            tokenMap1 = new Integer(offSet + tokenMap1);
                        }
                        if (overrideBeginTokenMap2.get(new Integer(lookUpOffset.getStartOffset())) != null) {
                            offSet = (Integer)overrideBeginTokenMap2.get(new Integer(lookUpOffset.getStartOffset()));
                            tokenMap2 = new Integer(offSet + tokenMap2);
                        }
                        globalOffset = tokenMap1 + tokenMap2;
                        tokenStartIndex = (Integer)o + globalOffset;
                        ++tokenStartIndex;
                    }
                    BaseToken startToken = null;
                    BaseToken endToken = token;
                    startToken = (BaseToken)tokens.get(tokenStartIndex);
                    StrengthToken measurementToken = new StrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                    measurementSet.add(measurementToken);
                    fsm.reset();
                }
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return measurementSet;
    }

    public Set execute(List tokens, Set overrideSet) throws Exception {
        HashSet<StrengthToken> measurementSet = new HashSet<StrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator overrideTokenItr = overrideSet.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap = new HashMap<Integer, BaseToken>();
        HashMap<Integer, Integer> overrideBeginTokenMap = new HashMap<Integer, Integer>();
        while (overrideTokenItr.hasNext()) {
            BaseToken t = (BaseToken)overrideTokenItr.next();
            Integer key = new Integer(t.getStartOffset());
            overrideTokenMap.put(key, t);
        }
        boolean overrideOn = false;
        int overrideEndOffset = -1;
        int tokenOffset = 0;
        int anchorKey = 0;
        int i = 0;
        while (i < tokens.size()) {
            block13: {
                BaseToken token;
                block12: {
                    Integer key;
                    block10: {
                        block11: {
                            token = (BaseToken)tokens.get(i);
                            key = new Integer(token.getStartOffset());
                            if (!overrideOn) break block10;
                            if (token.getStartOffset() < overrideEndOffset) break block11;
                            if (tokenOffset > 0) {
                                overrideBeginTokenMap.put(new Integer(anchorKey), new Integer(tokenOffset));
                            }
                            overrideOn = false;
                            overrideEndOffset = -1;
                            break block12;
                        }
                        ++tokenOffset;
                        break block13;
                    }
                    if (overrideTokenMap.containsKey(key)) {
                        anchorKey = key;
                        token = (BaseToken)overrideTokenMap.get(key);
                        overrideOn = true;
                        overrideEndOffset = token.getEndOffset();
                        tokenOffset = 0;
                    }
                }
                for (Machine fsm : this.iv_machineSet) {
                    int tokenStartIndex;
                    fsm.input(token);
                    State currentState = fsm.getCurrentState();
                    if (currentState.getStartStateFlag()) {
                        tokenStartMap.put(fsm, new Integer(i));
                        tokenOffset = 0;
                    }
                    if (!currentState.getEndStateFlag()) continue;
                    Object o = tokenStartMap.get(fsm);
                    if (o == null) {
                        tokenStartIndex = 0;
                    } else {
                        Integer tokenMap = new Integer(0);
                        BaseToken lookUpOffset = (BaseToken)tokens.get((Integer)o);
                        if (overrideBeginTokenMap.get(new Integer(lookUpOffset.getStartOffset())) != null) {
                            Integer offSet = (Integer)overrideBeginTokenMap.get(new Integer(lookUpOffset.getStartOffset()));
                            tokenMap = new Integer(offSet + tokenMap);
                        }
                        tokenStartIndex = (Integer)o + tokenMap;
                        ++tokenStartIndex;
                    }
                    BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                    BaseToken endToken = token;
                    startToken = (BaseToken)tokens.get(tokenStartIndex);
                    StrengthToken measurementToken = new StrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                    measurementSet.add(measurementToken);
                    fsm.reset();
                }
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return measurementSet;
    }
}

