/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.util;

import edu.mayo.bmi.fsm.condition.WordSetCondition;
import edu.mayo.bmi.fsm.drugner.output.util.HyphenatedDrugToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class HyphenatedDrugFSM {
    Set iv_hyphenDrugSet = new HashSet();
    private Set iv_machineSet = new HashSet();

    public HyphenatedDrugFSM() {
        this.iv_hyphenDrugSet.add("alka-seltzer");
        this.iv_hyphenDrugSet.add("abilify");
        this.iv_hyphenDrugSet.add("actiq");
        this.iv_hyphenDrugSet.add("ambi-1000");
        this.iv_hyphenDrugSet.add("almacone-2");
        this.iv_hyphenDrugSet.add("alexan-100");
        this.iv_hyphenDrugSet.add("azo-100");
        this.iv_hyphenDrugSet.add("allerhist-1");
        this.iv_hyphenDrugSet.add("acne-5");
        this.iv_hyphenDrugSet.add("andriod-10");
        this.iv_hyphenDrugSet.add("andriod-25");
        this.iv_hyphenDrugSet.add("andriod-50");
        this.iv_hyphenDrugSet.add("acys-5");
        this.iv_hyphenDrugSet.add("aldoclor-250");
        this.iv_hyphenDrugSet.add("aerolin-400");
        this.iv_hyphenDrugSet.add("alka-seltzer plus");
        this.iv_hyphenDrugSet.add("allegra-d");
        this.iv_hyphenDrugSet.add("b-complex");
        this.iv_hyphenDrugSet.add("bactroban");
        this.iv_hyphenDrugSet.add("chlor-trimeton");
        this.iv_hyphenDrugSet.add("claritin-d");
        this.iv_hyphenDrugSet.add("cleocin-t");
        this.iv_hyphenDrugSet.add("daranide");
        this.iv_hyphenDrugSet.add("depo-medrol");
        this.iv_hyphenDrugSet.add("depo-provera");
        this.iv_hyphenDrugSet.add("effexor-xr");
        this.iv_hyphenDrugSet.add("glucosamine-chondroitin");
        this.iv_hyphenDrugSet.add("fml-s");
        this.iv_hyphenDrugSet.add("hep-lock");
        this.iv_hyphenDrugSet.add("l-arginine");
        this.iv_hyphenDrugSet.add("l-thyroxine");
        this.iv_hyphenDrugSet.add("lupron-depot");
        this.iv_hyphenDrugSet.add("metro cream");
        this.iv_hyphenDrugSet.add("micro-k");
        this.iv_hyphenDrugSet.add("multi-vitamin");
        this.iv_hyphenDrugSet.add("muro-128");
        this.iv_hyphenDrugSet.add("naphcon-a");
        this.iv_hyphenDrugSet.add("neo-synephrine");
        this.iv_hyphenDrugSet.add("no-doz");
        this.iv_hyphenDrugSet.add("noctec");
        this.iv_hyphenDrugSet.add("nor-qd");
        this.iv_hyphenDrugSet.add("ocuflox");
        this.iv_hyphenDrugSet.add("ortho tri-cyclen");
        this.iv_hyphenDrugSet.add("ortho tri-cyclen lo");
        this.iv_hyphenDrugSet.add("ortho-cept");
        this.iv_hyphenDrugSet.add("ortho-novum");
        this.iv_hyphenDrugSet.add("os-cal D");
        this.iv_hyphenDrugSet.add("os-cal 500");
        this.iv_hyphenDrugSet.add("os-cal");
        this.iv_hyphenDrugSet.add("peg-intron");
        this.iv_hyphenDrugSet.add("phospho-soda");
        this.iv_hyphenDrugSet.add("pred-g");
        this.iv_hyphenDrugSet.add("retin-a");
        this.iv_hyphenDrugSet.add("robitussin-dm");
        this.iv_hyphenDrugSet.add("senokot-s");
        this.iv_hyphenDrugSet.add("serentil");
        this.iv_hyphenDrugSet.add("sleep-eze");
        this.iv_hyphenDrugSet.add("tegretol-xr");
        this.iv_hyphenDrugSet.add("theo-dur");
        this.iv_hyphenDrugSet.add("tilade");
        this.iv_hyphenDrugSet.add("tri-sprintec");
        this.iv_hyphenDrugSet.add("vasocon-a");
        this.iv_hyphenDrugSet.add("vivelle-dot");
        this.iv_hyphenDrugSet.add("vira-a");
        this.iv_hyphenDrugSet.add("vitamin-a");
        this.iv_hyphenDrugSet.add("vitamin-b6");
        this.iv_hyphenDrugSet.add("vitamin-b complex");
        this.iv_hyphenDrugSet.add("vitamin-b");
        this.iv_hyphenDrugSet.add("vitamin-b1");
        this.iv_hyphenDrugSet.add("vitamin-c");
        this.iv_hyphenDrugSet.add("vitamin-d");
        this.iv_hyphenDrugSet.add("vitamin-d2");
        this.iv_hyphenDrugSet.add("vitamin-e");
        this.iv_machineSet.add(this.getDashMachine());
    }

    private Machine getDashMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState hyphenatedDrugState = new NamedState("HYPH_DRUG");
        WordSetCondition hyphenatedDrugCondition = new WordSetCondition(this.iv_hyphenDrugSet, false);
        startState.addTransition(hyphenatedDrugCondition, endState);
        startState.addTransition(new AnyCondition(), startState);
        hyphenatedDrugState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<HyphenatedDrugToken> fractionSet = new HashSet<HyphenatedDrugToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                HyphenatedDrugToken fractionToken = new HyphenatedDrugToken(startToken.getStartOffset(), endToken.getEndOffset());
                fractionSet.add(fractionToken);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

