/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.util;

import edu.mayo.bmi.fsm.condition.TextSetCondition;
import edu.mayo.bmi.fsm.condition.TextValueCondition;
import edu.mayo.bmi.fsm.output.StatusIndicator;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.state.NonTerminalEndState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class StatusIndicatorFSM {
    private Set iv_probableSet = new HashSet();
    private Set iv_historySet = new HashSet();
    private Set iv_histColPartSet = new HashSet();
    private Set iv_histCollocSet = new HashSet();
    private Set iv_probableColPartSet = new HashSet();
    private Set iv_probableCollocSet = new HashSet();
    private Set iv_familyHistorySet = new HashSet();
    private Machine iv_probableMachine;
    private Machine iv_probableMachineNoTerm;
    private Machine iv_historyMachine;
    private Machine iv_familyHistoryMachine;
    private Set iv_machineSet = new HashSet();

    private Machine getProbableMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState dualState = new NamedState("DUALSTATE");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition probableC = new TextSetCondition(this.iv_probableSet, false);
        startState.addTransition(probableC, endState);
        startState.addTransition(new AnyCondition(), startState);
        dualState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public StatusIndicatorFSM() {
        this.iv_probableSet.add("possible");
        this.iv_probableSet.add("possibly");
        this.iv_probableSet.add("possibility");
        this.iv_probableSet.add("probable");
        this.iv_probableSet.add("likely");
        this.iv_probableSet.add("questionable");
        this.iv_probableSet.add("question");
        this.iv_probableSet.add("probability");
        this.iv_probableSet.add("differential");
        this.iv_probableSet.add("may");
        this.iv_probableSet.add("consider");
        this.iv_probableSet.add("evaluate");
        this.iv_probableSet.add("evaluation");
        this.iv_probableSet.add("might");
        this.iv_probableSet.add("?");
        this.iv_probableSet.add("vs");
        this.iv_probableSet.add("considered");
        this.iv_probableCollocSet.add("questionable");
        this.iv_probableColPartSet.add("history");
        this.iv_probableColPartSet.add("hx");
        this.iv_histColPartSet.add("status");
        this.iv_histCollocSet.add("post");
        this.iv_historySet.add("hx");
        this.iv_historySet.add("h/o");
        this.iv_historySet.add("s/p");
        this.iv_historySet.add("history");
        this.iv_familyHistorySet.add("fx");
        this.iv_familyHistorySet.add("fh");
        this.iv_familyHistorySet.add("mother");
        this.iv_familyHistorySet.add("father");
        this.iv_familyHistorySet.add("sister");
        this.iv_familyHistorySet.add("brother");
        this.iv_familyHistorySet.add("son");
        this.iv_familyHistorySet.add("daugher");
        this.iv_familyHistorySet.add("grandfather");
        this.iv_familyHistorySet.add("grandmother");
        this.iv_historyMachine = this.getHistoryMachine();
        this.iv_probableMachine = this.getProbableMachine();
        this.iv_probableMachineNoTerm = this.getProbableMachineNonTerm();
        this.iv_familyHistoryMachine = this.getFamilyHistoryMachine();
        this.iv_machineSet.add(this.iv_historyMachine);
        this.iv_machineSet.add(this.iv_probableMachineNoTerm);
        this.iv_machineSet.add(this.iv_probableMachine);
        this.iv_machineSet.add(this.iv_familyHistoryMachine);
    }

    private Machine getProbableMachineNonTerm() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState anyState = new NamedState("ANY");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        NamedState hAbbrState = new NamedState("HISTORY_ABBR");
        NamedState oAbbrState = new NamedState("OF_ABBR");
        Machine m = new Machine(startState);
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        NamedState probCollocState = new NamedState("PROB_COLLOC");
        NamedState probFamilyPartState = new NamedState("PROB_FAMC");
        NamedState probColPartState = new NamedState("PROB_COLPART");
        TextSetCondition probCollecC = new TextSetCondition(this.iv_probableCollocSet, false);
        TextSetCondition probColPartC = new TextSetCondition(this.iv_probableColPartSet, false);
        startState.addTransition(probCollecC, probCollocState);
        startState.addTransition(new AnyCondition(), startState);
        probCollocState.addTransition(probColPartC, probColPartState);
        probCollocState.addTransition(new TextValueCondition("h", false), hAbbrState);
        probCollocState.addTransition(new AnyCondition(), anyState);
        hAbbrState.addTransition(new TextValueCondition("/", false), fslashState);
        hAbbrState.addTransition(new AnyCondition(), startState);
        probFamilyPartState.addTransition(new AnyCondition(), ntEndState);
        anyState.addTransition(new TextValueCondition("h", false), hAbbrState);
        anyState.addTransition(new AnyCondition(), anyState);
        fslashState.addTransition(new TextValueCondition("o", false), oAbbrState);
        fslashState.addTransition(new AnyCondition(), startState);
        oAbbrState.addTransition(new AnyCondition(), ntEndState);
        oAbbrState.addTransition(new AnyCondition(), startState);
        probColPartState.addTransition(new AnyCondition(), ntEndState);
        ntEndState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getHistoryMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState hAbbrState = new NamedState("HISTORY_ABBR");
        NamedState sAbbrState = new NamedState("STATUS_ABBR");
        NamedState fslashState = new NamedState("FORWARD_SLASH");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition historyC = new TextSetCondition(this.iv_historySet, false);
        startState.addTransition(historyC, endState);
        startState.addTransition(new TextValueCondition("h", false), hAbbrState);
        startState.addTransition(new TextValueCondition("s", false), hAbbrState);
        startState.addTransition(new AnyCondition(), startState);
        hAbbrState.addTransition(new TextValueCondition("/", false), fslashState);
        hAbbrState.addTransition(new AnyCondition(), startState);
        sAbbrState.addTransition(new TextValueCondition("/", false), fslashState);
        sAbbrState.addTransition(new AnyCondition(), startState);
        fslashState.addTransition(new TextValueCondition("o", false), endState);
        fslashState.addTransition(new TextValueCondition("p", false), endState);
        fslashState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getFamilyHistoryMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState familyState = new NamedState("FAMILY");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition familyHistoryC = new TextSetCondition(this.iv_familyHistorySet, false);
        startState.addTransition(familyHistoryC, endState);
        startState.addTransition(new TextValueCondition("family", false), familyState);
        startState.addTransition(new AnyCondition(), startState);
        familyState.addTransition(new TextValueCondition("history", false), endState);
        familyState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<StatusIndicator> outSet = new HashSet<StatusIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine m : this.iv_machineSet) {
                int tokenStartIndex;
                m.input(token);
                State currentState = m.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(m, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(m);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                StatusIndicator si = null;
                if (m.equals(this.iv_historyMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 1);
                } else if (m.equals(this.iv_probableMachine) || m.equals(this.iv_probableMachineNoTerm)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 3);
                } else if (m.equals(this.iv_familyHistoryMachine)) {
                    si = new StatusIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 2);
                }
                outSet.add(si);
                m.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine m : this.iv_machineSet) {
            m.reset();
        }
        return outSet;
    }
}

