/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.drugner.machines.util;

import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.TextSetCondition;
import edu.mayo.bmi.fsm.condition.TextValueCondition;
import edu.mayo.bmi.fsm.drugner.output.util.SubSectionIndicator;
import edu.mayo.bmi.fsm.machine.FSM;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.state.NonTerminalEndState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class SubSectionIndicatorFSM
implements FSM {
    private Set iv_machineSet = new HashSet();
    private Set iv_probableSubBeginSet = new HashSet();
    private Set iv_probableSubNextSet = new HashSet();
    private Set iv_confirmedSubBeginSet = new HashSet();
    private Set iv_confirmedSubNextSet = new HashSet();
    private Set iv_historySubBeginSet = new HashSet();
    private Set iv_historySubNextSet = new HashSet();
    private Set iv_historySubMidSet = new HashSet();
    private Set iv_middleWordSet = new HashSet();
    private Set iv_probableSubEndSet = new HashSet();
    private Machine iv_subSectionIDProbableMachine = new Machine();
    private Machine iv_subSectionIDHistoryMachine = new Machine();
    private Machine iv_subSectionIDConfirmMachine = new Machine();

    public SubSectionIndicatorFSM() {
        this.iv_probableSubBeginSet.add("taper");
        this.iv_probableSubBeginSet.add("tapered");
        this.iv_probableSubBeginSet.add("changed");
        this.iv_probableSubBeginSet.add("altered");
        this.iv_probableSubBeginSet.add("alter");
        this.iv_probableSubBeginSet.add("patient");
        this.iv_probableSubNextSet.add("medication");
        this.iv_probableSubNextSet.add("medications");
        this.iv_probableSubNextSet.add("take");
        this.iv_probableSubEndSet.add("discontinued");
        this.iv_probableSubEndSet.add("discontinue");
        this.iv_historySubBeginSet.add("discontinued");
        this.iv_historySubBeginSet.add("discontinue");
        this.iv_historySubBeginSet.add("past");
        this.iv_historySubBeginSet.add("recently");
        this.iv_historySubBeginSet.add("medication");
        this.iv_historySubBeginSet.add("radiology");
        this.iv_historySubBeginSet.add("food");
        this.iv_historySubNextSet.add("medication");
        this.iv_historySubNextSet.add("medications");
        this.iv_historySubNextSet.add("hold");
        this.iv_historySubMidSet.add("psychotropic");
        this.iv_historySubMidSet.add("discontinued");
        this.iv_historySubMidSet.add("on");
        this.iv_confirmedSubBeginSet.add("new");
        this.iv_confirmedSubBeginSet.add("dose");
        this.iv_confirmedSubBeginSet.add("reinstituted");
        this.iv_confirmedSubBeginSet.add("continue");
        this.iv_confirmedSubBeginSet.add("prn");
        this.iv_confirmedSubBeginSet.add("continued");
        this.iv_confirmedSubNextSet.add("adjustment");
        this.iv_confirmedSubNextSet.add("dose");
        this.iv_confirmedSubNextSet.add("dosage");
        this.iv_confirmedSubNextSet.add("dosages");
        this.iv_confirmedSubNextSet.add("adjustments");
        this.iv_confirmedSubNextSet.add("medication");
        this.iv_confirmedSubNextSet.add("medications");
        this.iv_middleWordSet.add("and");
        this.iv_middleWordSet.add("may");
        this.iv_subSectionIDProbableMachine = this.getProbableSubSectionMachine();
        this.iv_subSectionIDHistoryMachine = this.getHistorySubSectionMachine();
        this.iv_subSectionIDConfirmMachine = this.getConfirmSubSectionMachine();
        this.iv_machineSet.add(this.iv_subSectionIDProbableMachine);
        this.iv_machineSet.add(this.iv_subSectionIDHistoryMachine);
        this.iv_machineSet.add(this.iv_subSectionIDConfirmMachine);
    }

    private Machine getHistorySubSectionMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState medState = new NamedState("MEDHIST");
        NamedState midWordState = new NamedState("MIDDLE");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition subFirstBegin = new TextSetCondition(this.iv_historySubBeginSet, false);
        TextSetCondition subFirstMid = new TextSetCondition(this.iv_historySubMidSet, false);
        TextSetCondition subFirstNext = new TextSetCondition(this.iv_historySubNextSet, false);
        startState.addTransition(subFirstBegin, medState);
        startState.addTransition(new AnyCondition(), startState);
        medState.addTransition(subFirstNext, endState);
        medState.addTransition(subFirstMid, midWordState);
        medState.addTransition(new PunctuationValueCondition(':'), endState);
        medState.addTransition(new AnyCondition(), startState);
        midWordState.addTransition(subFirstNext, endState);
        midWordState.addTransition(new PunctuationValueCondition(':'), endState);
        midWordState.addTransition(new AnyCondition(), startState);
        ntEndState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    @Override
    public Set execute(List tokens) throws Exception {
        HashSet<SubSectionIndicator> outSet = new HashSet<SubSectionIndicator>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? (BaseToken)tokens.get(i - 1) : token;
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                SubSectionIndicator subs = null;
                subs = fsm.equals(this.iv_subSectionIDProbableMachine) ? new SubSectionIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 3) : (fsm.equals(this.iv_subSectionIDHistoryMachine) ? new SubSectionIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 1) : (fsm.equals(this.iv_subSectionIDConfirmMachine) ? new SubSectionIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 0) : new SubSectionIndicator(startToken.getStartOffset(), endToken.getEndOffset(), 2)));
                outSet.add(subs);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return outSet;
    }

    private Machine getProbableSubSectionMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState medState = new NamedState("PROBHIST");
        NamedState endWordState = new NamedState("ENDWORD");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition subFirstBegin = new TextSetCondition(this.iv_probableSubBeginSet, false);
        TextSetCondition subFirstNext = new TextSetCondition(this.iv_probableSubNextSet, false);
        startState.addTransition(subFirstBegin, medState);
        startState.addTransition(new AnyCondition(), startState);
        medState.addTransition(subFirstNext, endState);
        medState.addTransition(new TextSetCondition(this.iv_middleWordSet, false), endWordState);
        medState.addTransition(new AnyCondition(), startState);
        endWordState.addTransition(new TextSetCondition(this.iv_probableSubEndSet, false), endState);
        endWordState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    private Machine getConfirmSubSectionMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NamedState medState = new NamedState("MEDHIST");
        NamedState firstDotState = new NamedState("FIRSTDOT");
        NamedState rState = new NamedState("RSTATE");
        NamedState secondDotState = new NamedState("SECONDDOT");
        NamedState nState = new NamedState("NSTATE");
        NamedState thirdDotState = new NamedState("THIRDDOT");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        TextSetCondition subFirstBegin = new TextSetCondition(this.iv_confirmedSubBeginSet, false);
        TextSetCondition subFirstNext = new TextSetCondition(this.iv_confirmedSubNextSet, false);
        startState.addTransition(subFirstBegin, medState);
        startState.addTransition(new TextValueCondition("p", false), firstDotState);
        startState.addTransition(new AnyCondition(), startState);
        firstDotState.addTransition(new PunctuationValueCondition('.'), rState);
        firstDotState.addTransition(new AnyCondition(), startState);
        rState.addTransition(new TextValueCondition("r", false), secondDotState);
        rState.addTransition(new AnyCondition(), startState);
        secondDotState.addTransition(new PunctuationValueCondition('.'), nState);
        secondDotState.addTransition(new AnyCondition(), startState);
        nState.addTransition(new TextValueCondition("n", false), thirdDotState);
        nState.addTransition(new AnyCondition(), startState);
        thirdDotState.addTransition(new PunctuationValueCondition('.'), medState);
        thirdDotState.addTransition(new AnyCondition(), startState);
        medState.addTransition(subFirstNext, endState);
        medState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }
}

