/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.machine;

import edu.mayo.bmi.fsm.condition.PunctuationValueCondition;
import edu.mayo.bmi.fsm.condition.WordSetCondition;
import edu.mayo.bmi.fsm.output.PersonTitleToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class PersonTitleFSM {
    Set<String> iv_fullTextSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public PersonTitleFSM() {
        this.iv_fullTextSet.add("mr");
        this.iv_fullTextSet.add("ms");
        this.iv_fullTextSet.add("mrs");
        this.iv_fullTextSet.add("dr");
        this.iv_machineSet.add(this.getTitleMachine());
    }

    private Machine getTitleMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        NamedState titleNameState = new NamedState("TITLENAME");
        WordSetCondition titleNameCondition = new WordSetCondition(this.iv_fullTextSet, false);
        PunctuationValueCondition periodCondition = new PunctuationValueCondition('.');
        startState.addTransition(titleNameCondition, titleNameState);
        startState.addTransition(new AnyCondition(), startState);
        titleNameState.addTransition(periodCondition, endState);
        titleNameState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set<PersonTitleToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<PersonTitleToken> personTitleSet = new HashSet<PersonTitleToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                PersonTitleToken ptToken = new PersonTitleToken(startToken.getStartOffset(), endToken.getEndOffset());
                personTitleSet.add(ptToken);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return personTitleSet;
    }
}

