/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bmi.fsm.machine;

import edu.mayo.bmi.fsm.output.RomanNumeralToken;
import edu.mayo.bmi.fsm.state.NamedState;
import edu.mayo.bmi.fsm.token.BaseToken;
import edu.mayo.bmi.fsm.token.WordToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;

public class RomanNumeralFSM {
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public RomanNumeralFSM() {
        this.iv_machineSet.add(this.getMachine());
    }

    private Machine getMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine(startState);
        startState.addTransition(new RomanNumeralCondition(), endState);
        startState.addTransition(new AnyCondition(), startState);
        endState.addTransition(new AnyCondition(), startState);
        return m;
    }

    public Set<RomanNumeralToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<RomanNumeralToken> romanNumeralSet = new HashSet<RomanNumeralToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        int i = 0;
        while (i < tokens.size()) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input(token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                RomanNumeralToken rnToken = new RomanNumeralToken(startToken.getStartOffset(), endToken.getEndOffset());
                romanNumeralSet.add(rnToken);
                fsm.reset();
            }
            ++i;
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return romanNumeralSet;
    }

    class RomanNumeralCondition
    extends Condition {
        RomanNumeralCondition() {
        }

        @Override
        public boolean satisfiedBy(Object conditional) {
            if (conditional instanceof WordToken) {
                WordToken wt = (WordToken)conditional;
                return this.isRomanNumeral(wt.getText());
            }
            return false;
        }

        private boolean isRomanNumeral(String str) {
            str = str.toUpperCase();
            int i = 0;
            while (i < str.length()) {
                char currentChar = str.charAt(i);
                if (currentChar != 'I' && currentChar != 'V' && currentChar != 'X' && currentChar != 'L' && currentChar != 'C' && currentChar != 'D' && currentChar != 'M') {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

